/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;

public class TorchBlockExporter
extends BaseBlockExporter {
    public static void registerTorchBlockFromDefinition(class_4910 generator, class_2248 standingTorch, BlockDefinition definition) {
        String texturePath = TorchBlockExporter.getTextureFromDefinition(definition);
        class_2248 wallTorch = (class_2248)class_7923.field_41175.method_10223(WesterosBlocks.id("wall_" + definition.getBlockName()));
        if (wallTorch != null) {
            TorchBlockExporter.registerStandingTorch(generator, standingTorch, texturePath);
            TorchBlockExporter.registerWallTorch(generator, wallTorch, standingTorch, texturePath);
            TorchBlockExporter.registerSimpleItemModel(generator, standingTorch, TorchBlockExporter.createBlockIdentifier(texturePath));
        } else {
            WesterosBlocks.LOGGER.warn("Could not find wall torch for: {}", (Object)definition.getBlockName());
        }
    }

    private static String getTextureFromDefinition(BlockDefinition definition) {
        if (definition.getTextures() != null && !definition.getTextures().isEmpty()) {
            return definition.getTextures().get(0);
        }
        return "lighting/" + definition.getBlockName();
    }

    private static class_4944 createTorchTextureMap(String texturePath) {
        return new class_4944().method_25868(class_4945.field_23005, TorchBlockExporter.createBlockIdentifier(texturePath));
    }

    private static void registerStandingTorch(class_4910 generator, class_2248 block, String texturePath) {
        class_4944 textureMap = TorchBlockExporter.createTorchTextureMap(texturePath);
        class_2960 modelId = ModModels.TORCH.method_25852(TorchBlockExporter.createNestedModelId(block, "base"), textureMap, generator.field_22831);
        generator.field_22830.accept(TorchBlockExporter.createSimpleBlockState(block, modelId));
    }

    private static void registerWallTorch(class_4910 generator, class_2248 wallTorch, class_2248 standingTorch, String texturePath) {
        class_4944 textureMap = TorchBlockExporter.createTorchTextureMap(texturePath);
        class_2960 modelId = ModModels.TORCH_WALL.method_25852(TorchBlockExporter.createNestedModelId(standingTorch, "wall"), textureMap, generator.field_22831);
        class_4926 variants = TorchBlockExporter.createWallTorchVariants(modelId);
        generator.field_22830.accept(class_4925.method_25769((class_2248)wallTorch).method_25775(variants));
    }

    private static class_4926 createWallTorchVariants(class_2960 modelId) {
        return class_4926.method_25783((class_2769)class_2741.field_12481).method_25793((Comparable)class_2350.field_11034, TorchBlockExporter.createVariant(modelId)).method_25793((Comparable)class_2350.field_11035, TorchBlockExporter.createVariant(modelId, 90)).method_25793((Comparable)class_2350.field_11039, TorchBlockExporter.createVariant(modelId, 180)).method_25793((Comparable)class_2350.field_11043, TorchBlockExporter.createVariant(modelId, 270));
    }
}

