/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.providers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.data.BlockDefinitionRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public class ModPolytoneProvider
implements class_2405 {
    private final class_7784.class_7489 blockModifiersPathResolver;
    private final class_7784.class_7489 itemModifiersPathResolver;

    public ModPolytoneProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        this.blockModifiersPathResolver = output.method_45973(class_7784.class_7490.field_39368, "polytone/block_modifiers");
        this.itemModifiersPathResolver = output.method_45973(class_7784.class_7490.field_39368, "polytone/item_modifiers");
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        String colormapId;
        HashMap<String, List> blocksByColormap = new HashMap<String, List>();
        BlockDefinitionRegistry registry = BlockDefinitionRegistry.getInstance();
        if (!registry.isInitialized()) {
            WesterosBlocks.LOGGER.warn("BlockDefinitionRegistry not initialized - skipping Polytone generation");
            return CompletableFuture.completedFuture(null);
        }
        for (BlockDefinition definition : registry.getAllDefinitions()) {
            String colorMult = definition.getColorMult();
            if (colorMult == null || colorMult.isEmpty()) continue;
            colormapId = this.extractColormapId(colorMult);
            String blockId = "westerosblocks:" + definition.getBlockName();
            blocksByColormap.computeIfAbsent(colormapId, k -> new ArrayList()).add(blockId);
        }
        if (blocksByColormap.isEmpty()) {
            WesterosBlocks.LOGGER.info("No blocks with colorMult property found - skipping Polytone generation");
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Map.Entry entry : blocksByColormap.entrySet()) {
            colormapId = (String)entry.getKey();
            List blockIds = (List)entry.getValue();
            Collections.sort(blockIds);
            JsonObject json = new JsonObject();
            JsonArray targetsArray = new JsonArray();
            blockIds.forEach(arg_0 -> ((JsonArray)targetsArray).add(arg_0));
            json.add("targets", (JsonElement)targetsArray);
            json.addProperty("colormap", "westerosblocks:" + colormapId);
            class_2960 blockFileId = class_2960.method_60655((String)"westerosblocks", (String)(colormapId + "_tinted_blocks"));
            Path blockOutputPath = this.blockModifiersPathResolver.method_44107(blockFileId);
            CompletableFuture blockFuture = class_2405.method_10320((class_7403)writer, (JsonElement)json, (Path)blockOutputPath);
            futures.add(blockFuture);
            class_2960 itemFileId = class_2960.method_60655((String)"westerosblocks", (String)(colormapId + "_tinted_blocks"));
            Path itemOutputPath = this.itemModifiersPathResolver.method_44107(itemFileId);
            CompletableFuture itemFuture = class_2405.method_10320((class_7403)writer, (JsonElement)json, (Path)itemOutputPath);
            futures.add(itemFuture);
            WesterosBlocks.LOGGER.info("Generated Polytone modifier: {} with {} blocks (block_modifiers + item_modifiers)", (Object)(colormapId + "_tinted_blocks.json"), (Object)blockIds.size());
        }
        WesterosBlocks.LOGGER.info("Successfully generated {} Polytone modifier files ({} in block_modifiers, {} in item_modifiers)", new Object[]{blocksByColormap.size() * 2, blocksByColormap.size(), blocksByColormap.size()});
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private String extractColormapId(String colorMult) {
        if (colorMult.contains("/")) {
            String[] parts = colorMult.split("/");
            return parts[parts.length - 1];
        }
        return colorMult;
    }

    public String method_10321() {
        return "Polytone Block & Item Modifiers";
    }
}

