/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.google.common.collect.ImmutableMap;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinition;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class WCBranchBlock
extends class_2248
implements class_3737 {
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 BRANCH_CENTER = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 BRANCH_NORTH = class_2248.method_9541((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0);
    private static final class_265 BRANCH_EAST = class_2248.method_9541((double)8.0, (double)8.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final class_265 BRANCH_SOUTH = class_2248.method_9541((double)4.0, (double)8.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0);
    private static final class_265 BRANCH_WEST = class_2248.method_9541((double)0.0, (double)8.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0);
    private static final class_265 BRANCH_UP = class_2248.method_9541((double)4.0, (double)16.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private final Map<class_2680, class_265> shapeByIndex;
    private final String woodType;
    private final String branchType;

    public WCBranchBlock(class_4970.class_2251 settings, String woodType, String branchType) {
        super(settings);
        this.woodType = woodType;
        this.branchType = branchType;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes();
    }

    private Map<class_2680, class_265> makeShapes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (boolean north : new boolean[]{false, true}) {
            for (boolean east : new boolean[]{false, true}) {
                for (boolean south : new boolean[]{false, true}) {
                    for (boolean west : new boolean[]{false, true}) {
                        for (boolean up : new boolean[]{false, true}) {
                            class_265 shape = this.getShapeForConnections(north, east, south, west, up);
                            class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(north))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(east))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(south))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(west))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(up));
                            builder.put((Object)((class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)shape);
                            builder.put((Object)((class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)shape);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    private class_265 getShapeForConnections(boolean north, boolean east, boolean south, boolean west, boolean up) {
        if (!(north || east || south || west || up)) {
            return BRANCH_CENTER;
        }
        if (!up) {
            return class_2248.method_9541((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
        }
        class_265 shape = BRANCH_CENTER;
        if (north) {
            shape = class_259.method_1084((class_265)shape, (class_265)BRANCH_NORTH);
        }
        if (east) {
            shape = class_259.method_1084((class_265)shape, (class_265)BRANCH_EAST);
        }
        if (south) {
            shape = class_259.method_1084((class_265)shape, (class_265)BRANCH_SOUTH);
        }
        if (west) {
            shape = class_259.method_1084((class_265)shape, (class_265)BRANCH_WEST);
        }
        if (up) {
            shape = class_259.method_1084((class_265)shape, (class_265)BRANCH_UP);
        }
        return shape;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getShapeForConnections((Boolean)state.method_11654((class_2769)NORTH), (Boolean)state.method_11654((class_2769)EAST), (Boolean)state.method_11654((class_2769)SOUTH), (Boolean)state.method_11654((class_2769)WEST), (Boolean)state.method_11654((class_2769)UP));
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.method_9530(state, world, pos, context);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST, UP, WATERLOGGED});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidstate = ctx.method_8045().method_8316(ctx.method_8037());
        class_2338 pos = ctx.method_8037();
        boolean hasSolidBlockBelow = !ctx.method_8045().method_8320(pos.method_10074()).method_26215();
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.method_15767(class_3486.field_15517)))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(hasSolidBlockBelow));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (direction.method_10166().method_10179()) {
            boolean isConnected = this.canConnect(neighborState, neighborState.method_26206((class_1922)world, neighborPos, direction.method_10153()), direction.method_10153());
            return (class_2680)state.method_11657((class_2769)this.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(isConnected));
        }
        if (direction == class_2350.field_11033) {
            boolean hasSolidBlockBelow = !neighborState.method_26215();
            return (class_2680)state.method_11657((class_2769)UP, (Comparable)Boolean.valueOf(hasSolidBlockBelow));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    private boolean canConnect(class_2680 state, boolean neighborIsFullSquare, class_2350 dir) {
        class_2248 block = state.method_26204();
        if (block instanceof WCBranchBlock) {
            return true;
        }
        if (!class_2248.method_9581((class_2680)state) && neighborIsFullSquare) {
            return true;
        }
        return state.method_26164(class_3481.field_15475);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    private class_2746 getPropertyForDirection(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
            case class_2350.field_11036 -> UP;
            default -> throw new IllegalArgumentException("Invalid direction: " + String.valueOf(direction));
        };
    }

    private boolean canConnect(class_2680 state) {
        return state.method_26164(class_3481.field_15475);
    }

    public String getBranchType() {
        return this.branchType;
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(class_4970.class_2251 settings, BlockDefinition definition) {
            String woodType = definition != null ? definition.getWoodType() : "oak";
            String branchType = definition != null && definition.getBlockType() != null ? definition.getBlockType() : "large_branch";
            return new WCBranchBlock(settings, woodType, branchType);
        }
    }
}

