/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.utils.ModProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class WCCuboid16WayBlock
extends WCCuboidBlock {
    public static final class_2758 ROTATION = class_2741.field_12532;
    private static final int ROTATIONS = 16;
    protected class_265[] boundingBoxesByRotation = new class_265[16];
    protected class_265[][] stateSpecificBoundingBoxes = null;

    public WCCuboid16WayBlock(class_4970.class_2251 settings, boolean doToggleOnUse, boolean addStates, class_265 customBoundingBox, BlockDefinition definition) {
        super(settings, doToggleOnUse, addStates, customBoundingBox);
        if (definition != null && definition.hasStates()) {
            List<BlockDefinition.StateVariant> states = definition.getStates();
            boolean hasStateSpecificBoundingBoxes = false;
            for (BlockDefinition.StateVariant state : states) {
                if (state.getBoundingBox() == null) continue;
                hasStateSpecificBoundingBoxes = true;
                break;
            }
            if (hasStateSpecificBoundingBoxes) {
                this.calculateStateSpecificBoundingBoxes(definition, states);
            }
        }
        class_265 defaultBoundingBox = customBoundingBox != null ? customBoundingBox : class_259.method_1077();
        this.calculateRotatedBoundingBoxes(defaultBoundingBox);
        class_2680 defbs = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        if (this.STATE != null) {
            defbs = (class_2680)defbs.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        this.method_9590(defbs);
    }

    private void calculateStateSpecificBoundingBoxes(BlockDefinition definition, List<BlockDefinition.StateVariant> states) {
        int stateCount = states.size();
        this.stateSpecificBoundingBoxes = new class_265[stateCount][16];
        for (int i = 0; i < stateCount; ++i) {
            class_265 stateShape;
            BlockDefinition.StateVariant state = states.get(i);
            if (state.getBoundingBox() != null) {
                BlockDefinition.BoundingBox bbox = state.getBoundingBox();
                stateShape = class_259.method_1081((double)bbox.getXMin(), (double)bbox.getYMin(), (double)bbox.getZMin(), (double)bbox.getXMax(), (double)bbox.getYMax(), (double)bbox.getZMax());
            } else {
                stateShape = this.boundingBox;
            }
            for (int rot = 0; rot < 16; ++rot) {
                this.stateSpecificBoundingBoxes[i][rot] = this.applyYRotationToBoundingBox(stateShape, (float)rot * 22.5f);
            }
        }
    }

    private void calculateRotatedBoundingBoxes(class_265 baseBoundingBox) {
        for (int i = 0; i < 16; ++i) {
            float angleDegrees = (float)i * 22.5f;
            this.boundingBoxesByRotation[i] = this.applyYRotationToBoundingBox(baseBoundingBox, angleDegrees);
        }
    }

    private class_265 applyYRotationToBoundingBox(class_265 shape, float angleDegrees) {
        if (Math.abs(angleDegrees) < 0.01f || shape == class_259.method_1077()) {
            return shape;
        }
        double angleRadians = Math.toRadians(angleDegrees);
        double cos = Math.cos(angleRadians);
        double sin = Math.sin(angleRadians);
        double minX = shape.method_1091(class_2350.class_2351.field_11048);
        double minY = shape.method_1091(class_2350.class_2351.field_11052);
        double minZ = shape.method_1091(class_2350.class_2351.field_11051);
        double maxX = shape.method_1105(class_2350.class_2351.field_11048);
        double maxY = shape.method_1105(class_2350.class_2351.field_11052);
        double maxZ = shape.method_1105(class_2350.class_2351.field_11051);
        double cx = 0.5;
        double cz = 0.5;
        double[][] corners = new double[][]{{minX - cx, minZ - cz}, {maxX - cx, minZ - cz}, {minX - cx, maxZ - cz}, {maxX - cx, maxZ - cz}};
        double newMinX = Double.MAX_VALUE;
        double newMaxX = Double.MIN_VALUE;
        double newMinZ = Double.MAX_VALUE;
        double newMaxZ = Double.MIN_VALUE;
        for (double[] corner : corners) {
            double x = corner[0];
            double z = corner[1];
            double rotatedX = x * cos - z * sin;
            double rotatedZ = x * sin + z * cos;
            newMinX = Math.min(newMinX, rotatedX += cx);
            newMaxX = Math.max(newMaxX, rotatedX);
            newMinZ = Math.min(newMinZ, rotatedZ += cz);
            newMaxZ = Math.max(newMaxZ, rotatedZ);
        }
        newMinX = class_3532.method_15350((double)newMinX, (double)0.0, (double)1.0);
        newMaxX = class_3532.method_15350((double)newMaxX, (double)0.0, (double)1.0);
        newMinZ = class_3532.method_15350((double)newMinZ, (double)0.0, (double)1.0);
        newMaxZ = class_3532.method_15350((double)newMaxZ, (double)0.0, (double)1.0);
        return class_259.method_1081((double)newMinX, (double)minY, (double)newMinZ, (double)newMaxX, (double)maxY, (double)newMaxZ);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ROTATION});
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (this.stateSpecificBoundingBoxes != null && this.STATE != null) {
            int stateIndex = this.STATE.getIndex((String)((Object)state.method_11654((class_2769)this.STATE)));
            int rotation = (Integer)state.method_11654((class_2769)ROTATION);
            return this.stateSpecificBoundingBoxes[stateIndex][rotation];
        }
        int rotation = (Integer)state.method_11654((class_2769)ROTATION);
        return this.boundingBoxesByRotation[rotation];
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        int rotation = class_3532.method_15357((double)((double)(ctx.method_8044() * 16.0f / 360.0f) + 0.5)) & 0xF;
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        if (this.STATE != null) {
            state = (class_2680)state.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        return state;
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1268 hand = player.method_6058();
        if (this.toggleOnUse && player.method_7337() && player.method_5998(hand).method_7960()) {
            if (this.STATE != null && state.method_28498((class_2769)this.STATE)) {
                state = (class_2680)state.method_28493((class_2769)this.STATE);
                world.method_8652(pos, state, 3);
                world.method_8444(player, 1006, pos, 0);
                return class_1269.method_29236((boolean)world.field_9236);
            }
            if (state.method_28498((class_2769)ROTATION)) {
                int currentRotation = (Integer)state.method_11654((class_2769)ROTATION);
                int newRotation = currentRotation + 1 & 0xF;
                state = (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(newRotation));
                world.method_8652(pos, state, 3);
                world.method_8444(player, 1006, pos, 0);
                return class_1269.method_29236((boolean)world.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        int currentRotation = (Integer)state.method_11654((class_2769)ROTATION);
        int rotationSteps = switch (rotation) {
            case class_2470.field_11463 -> 4;
            case class_2470.field_11464 -> 8;
            case class_2470.field_11465 -> 12;
            default -> 0;
        };
        int newRotation = currentRotation + rotationSteps & 0xF;
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(newRotation));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        int rotation = (Integer)state.method_11654((class_2769)ROTATION);
        int mirroredRotation = switch (mirror) {
            case class_2415.field_11301 -> 16 - rotation & 0xF;
            case class_2415.field_11300 -> 32 - rotation & 0xF;
            default -> rotation;
        };
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(mirroredRotation));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(class_4970.class_2251 settings, BlockDefinition definition) {
            boolean doToggleOnUse = definition != null && definition.toggleOnUse();
            int numStates = definition != null ? definition.getStateCount() : 0;
            boolean doAddStates = numStates > 0;
            class_265 customBoundingBox = null;
            if (definition != null && definition.hasBoundingBox()) {
                BlockDefinition.BoundingBox bbox = definition.getBoundingBox();
                customBoundingBox = class_259.method_1081((double)bbox.getXMin(), (double)bbox.getYMin(), (double)bbox.getZMin(), (double)bbox.getXMax(), (double)bbox.getYMax(), (double)bbox.getZMax());
            }
            if (doAddStates) {
                List<String> stateValues;
                List<String> list = stateValues = definition != null ? definition.getStateValues() : null;
                if (stateValues != null && !stateValues.isEmpty()) {
                    WCCuboidBlock.tempSTATE = new ModProperties.StateProperty(stateValues);
                } else {
                    ArrayList<String> stateIds = new ArrayList<String>();
                    for (int i = 0; i < numStates; ++i) {
                        stateIds.add("state" + i);
                    }
                    WCCuboidBlock.tempSTATE = new ModProperties.StateProperty(stateIds);
                }
            }
            return new WCCuboid16WayBlock(settings, doToggleOnUse, doAddStates, customBoundingBox, definition);
        }
    }
}

