/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.utils.ModProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public class WCCuboidNSEWBlock
extends WCCuboidBlock {
    public static final class_2753 FACING = class_2383.field_11177;
    protected class_265[] boundingBoxesByFacing = new class_265[4];
    protected class_265[][] stateSpecificBoundingBoxes = null;

    public WCCuboidNSEWBlock(class_4970.class_2251 settings, boolean doToggleOnUse, boolean addStates, class_265 customBoundingBox, BlockDefinition definition) {
        super(settings, doToggleOnUse, addStates, customBoundingBox);
        if (definition != null && definition.hasStates()) {
            List<BlockDefinition.StateVariant> states = definition.getStates();
            boolean hasStateSpecificBoundingBoxes = false;
            for (BlockDefinition.StateVariant state : states) {
                if (state.getBoundingBox() == null) continue;
                hasStateSpecificBoundingBoxes = true;
                break;
            }
            if (hasStateSpecificBoundingBoxes) {
                this.calculateStateSpecificBoundingBoxes(definition, states);
            }
        }
        class_265 defaultBoundingBox = customBoundingBox != null ? customBoundingBox : class_259.method_1077();
        this.calculateRotatedBoundingBoxes(defaultBoundingBox);
        class_2680 defbs = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11034)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        if (this.STATE != null) {
            defbs = (class_2680)defbs.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        this.method_9590(defbs);
    }

    private void calculateStateSpecificBoundingBoxes(BlockDefinition definition, List<BlockDefinition.StateVariant> states) {
        int stateCount = states.size();
        this.stateSpecificBoundingBoxes = new class_265[stateCount][4];
        for (int i = 0; i < stateCount; ++i) {
            class_265 stateShape;
            BlockDefinition.StateVariant state = states.get(i);
            if (state.getBoundingBox() != null) {
                BlockDefinition.BoundingBox bbox = state.getBoundingBox();
                class_265 baseBBox = class_259.method_1081((double)bbox.getXMin(), (double)bbox.getYMin(), (double)bbox.getZMin(), (double)bbox.getXMax(), (double)bbox.getYMax(), (double)bbox.getZMax());
                Integer rotYOffset = state.getRotYOffset();
                if (rotYOffset != null && rotYOffset != 0) {
                    int inverseRotation = rotYOffset % 360;
                    stateShape = this.applyYRotationToBoundingBox(baseBBox, inverseRotation);
                } else {
                    stateShape = baseBBox;
                }
            } else {
                stateShape = this.boundingBox;
            }
            this.stateSpecificBoundingBoxes[i][0] = stateShape;
            this.stateSpecificBoundingBoxes[i][1] = this.rotateShapeY90(stateShape);
            this.stateSpecificBoundingBoxes[i][2] = this.rotateShapeY180(stateShape);
            this.stateSpecificBoundingBoxes[i][3] = this.rotateShapeY270(stateShape);
        }
    }

    private void calculateRotatedBoundingBoxes(class_265 originalShape) {
        this.boundingBoxesByFacing[0] = originalShape;
        this.boundingBoxesByFacing[1] = this.rotateShapeY90(originalShape);
        this.boundingBoxesByFacing[2] = this.rotateShapeY180(originalShape);
        this.boundingBoxesByFacing[3] = this.rotateShapeY270(originalShape);
    }

    private class_265 rotateShapeY90(class_265 shape) {
        return shape.method_1110() ? class_259.method_1073() : class_259.method_1081((double)(1.0 - shape.method_1107().field_1324), (double)shape.method_1107().field_1322, (double)shape.method_1107().field_1323, (double)(1.0 - shape.method_1107().field_1321), (double)shape.method_1107().field_1325, (double)shape.method_1107().field_1320);
    }

    private class_265 rotateShapeY180(class_265 shape) {
        return shape.method_1110() ? class_259.method_1073() : class_259.method_1081((double)(1.0 - shape.method_1107().field_1320), (double)shape.method_1107().field_1322, (double)(1.0 - shape.method_1107().field_1324), (double)(1.0 - shape.method_1107().field_1323), (double)shape.method_1107().field_1325, (double)(1.0 - shape.method_1107().field_1321));
    }

    private class_265 rotateShapeY270(class_265 shape) {
        return shape.method_1110() ? class_259.method_1073() : class_259.method_1081((double)shape.method_1107().field_1321, (double)shape.method_1107().field_1322, (double)(1.0 - shape.method_1107().field_1320), (double)shape.method_1107().field_1324, (double)shape.method_1107().field_1325, (double)(1.0 - shape.method_1107().field_1323));
    }

    private class_265 applyYRotationToBoundingBox(class_265 shape, int degrees) {
        int normalizedDegrees = degrees % 360;
        return switch (normalizedDegrees) {
            case 0 -> shape;
            case 90 -> this.rotateShapeY90(shape);
            case 180 -> this.rotateShapeY180(shape);
            case 270 -> this.rotateShapeY270(shape);
            default -> shape;
        };
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        class_2350[] placementDirections = ctx.method_7718();
        class_2350 facing = class_2350.field_11034;
        for (class_2350 direction : placementDirections) {
            if (direction != class_2350.field_11034 && direction != class_2350.field_11039 && direction != class_2350.field_11043 && direction != class_2350.field_11035) continue;
            facing = direction.method_10153();
            break;
        }
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        if (this.STATE != null) {
            state = (class_2680)state.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        return state;
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getBoundingBoxForState(state);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getBoundingBoxForState(state);
    }

    @Override
    public class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return this.getBoundingBoxForState(state);
    }

    private class_265 getBoundingBoxForFacing(class_2350 facing) {
        return switch (facing) {
            case class_2350.field_11034 -> this.boundingBoxesByFacing[0];
            case class_2350.field_11035 -> this.boundingBoxesByFacing[1];
            case class_2350.field_11039 -> this.boundingBoxesByFacing[2];
            case class_2350.field_11043 -> this.boundingBoxesByFacing[3];
            default -> this.boundingBox;
        };
    }

    private class_265 getBoundingBoxForState(class_2680 state) {
        if (this.stateSpecificBoundingBoxes != null && this.STATE != null && state.method_28498((class_2769)this.STATE)) {
            String currentStateValue = (String)((Object)state.method_11654((class_2769)this.STATE));
            Collection<String> stateValues = this.STATE.method_11898();
            ArrayList<String> stateValuesList = new ArrayList<String>(stateValues);
            int stateIndex = stateValuesList.indexOf(currentStateValue);
            if (stateIndex >= 0 && stateIndex < this.stateSpecificBoundingBoxes.length) {
                class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
                int facingIndex = switch (facing) {
                    case class_2350.field_11035 -> 0;
                    case class_2350.field_11039 -> 1;
                    case class_2350.field_11043 -> 2;
                    case class_2350.field_11034 -> 3;
                    default -> 0;
                };
                return this.stateSpecificBoundingBoxes[stateIndex][facingIndex];
            }
        }
        return this.getBoundingBoxForFacing((class_2350)state.method_11654((class_2769)FACING));
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(class_4970.class_2251 settings, BlockDefinition definition) {
            boolean doToggleOnUse = definition != null && definition.toggleOnUse();
            int numStates = definition != null ? definition.getStateCount() : 0;
            boolean doAddStates = numStates > 0;
            class_265 customBoundingBox = null;
            if (definition != null && definition.hasBoundingBox()) {
                BlockDefinition.BoundingBox bbox = definition.getBoundingBox();
                customBoundingBox = class_259.method_1081((double)bbox.getXMin(), (double)bbox.getYMin(), (double)bbox.getZMin(), (double)bbox.getXMax(), (double)bbox.getYMax(), (double)bbox.getZMax());
            }
            if (doAddStates) {
                List<String> stateValues = definition.getStateValues();
                if (stateValues != null && !stateValues.isEmpty()) {
                    WCCuboidBlock.tempSTATE = new ModProperties.StateProperty(stateValues);
                } else {
                    ArrayList<String> stateIds = new ArrayList<String>();
                    for (int i = 0; i < numStates; ++i) {
                        stateIds.add("state" + i);
                    }
                    WCCuboidBlock.tempSTATE = new ModProperties.StateProperty(stateIds);
                }
            }
            return new WCCuboidNSEWBlock(settings, doToggleOnUse, doAddStates, customBoundingBox, definition);
        }
    }
}

