/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinition;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class WCParticleEmitterBlock
extends class_2248
implements class_3737 {
    protected static final class_265 OFF_SHAPE = class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final class_265 ON_SHAPE = class_2248.method_9541((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final class_2394 particleType;
    private final String particleName;

    public WCParticleEmitterBlock(class_4970.class_2251 settings, String particleName) {
        super(settings);
        this.particleName = particleName;
        this.particleType = particleName != null ? this.getParticleFromName(particleName) : null;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    private class_2394 getParticleFromName(String name) {
        return switch (name.toLowerCase()) {
            case "flame" -> class_2398.field_11240;
            case "smoke" -> class_2398.field_11251;
            case "large_smoke" -> class_2398.field_11237;
            case "cloud" -> class_2398.field_11204;
            case "white_ash" -> class_2398.field_23956;
            case "dripping_water" -> class_2398.field_11232;
            case "dripping_lava" -> class_2398.field_11223;
            case "falling_water" -> class_2398.field_18306;
            case "falling_lava" -> class_2398.field_18304;
            case "soul_fire_flame" -> class_2398.field_22246;
            case "crimson_spore" -> class_2398.field_22248;
            case "warped_spore" -> class_2398.field_22249;
            case "ash" -> class_2398.field_22247;
            case "campfire_cosy_smoke" -> class_2398.field_17430;
            case "campfire_signal_smoke" -> class_2398.field_17431;
            default -> class_2398.field_11240;
        };
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue() && this.particleType != null && this.particleName != null) {
            if (this.particleName.contains("smoke") || this.particleName.contains("cosy") || this.particleName.contains("signal")) {
                if (random.method_43048(3) > 0) {
                    double x = (double)pos.method_10263() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1);
                    double y = (double)pos.method_10264() + random.method_43058() + random.method_43058();
                    double z = (double)pos.method_10260() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1);
                    world.method_8406(this.particleType, x, y, z, 0.0, 0.07, 0.0);
                }
            } else if (this.particleName.contains("spore")) {
                if (random.method_43048(4) == 0) {
                    double x = (double)pos.method_10263() + 0.5 + ((double)random.method_43057() - 0.5) * 0.8;
                    double y = (double)pos.method_10264() + 0.2;
                    double z = (double)pos.method_10260() + 0.5 + ((double)random.method_43057() - 0.5) * 0.8;
                    float vx = (random.method_43057() - 0.5f) * 0.05f;
                    float vy = random.method_43057() * 0.02f;
                    float vz = (random.method_43057() - 0.5f) * 0.05f;
                    world.method_8406(this.particleType, x, y, z, (double)vx, (double)vy, (double)vz);
                }
            } else if (this.particleName.contains("dripping") || this.particleName.contains("falling")) {
                if (random.method_43048(2) == 0) {
                    double x = (double)pos.method_10263() + 0.5 + ((double)random.method_43057() - 0.5) * 0.2;
                    double y = (double)pos.method_10264() + 0.8;
                    double z = (double)pos.method_10260() + 0.5 + ((double)random.method_43057() - 0.5) * 0.2;
                    float vx = (random.method_43057() - 0.5f) * 0.1f;
                    float vy = random.method_43057() * 0.1f;
                    float vz = (random.method_43057() - 0.5f) * 0.1f;
                    world.method_8406(this.particleType, x, y, z, (double)vx, (double)vy, (double)vz);
                }
            } else {
                double x = (double)pos.method_10263() + 0.5 + ((double)random.method_43057() - 0.5) * 0.2;
                double y = (double)pos.method_10264() + 0.5;
                double z = (double)pos.method_10260() + 0.5 + ((double)random.method_43057() - 0.5) * 0.2;
                world.method_8406(this.particleType, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (Boolean)state.method_11654((class_2769)POWERED) != false ? ON_SHAPE : OFF_SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (Boolean)state.method_11654((class_2769)POWERED) != false ? class_259.method_1073() : OFF_SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, POWERED});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15767(class_3486.field_15517)));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1268 hand = player.method_6058();
        if (player.method_7337() && player.method_5998(hand).method_7960()) {
            state = (class_2680)state.method_28493((class_2769)POWERED);
            world.method_8652(pos, state, 3);
            world.method_8444(player, 1006, pos, 0);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(class_4970.class_2251 settings, BlockDefinition definition) {
            String particleName = definition != null ? definition.getParticle() : "flame";
            return new WCParticleEmitterBlock(settings, particleName);
        }
    }
}

