/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.google.common.collect.ImmutableMap;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinition;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_10;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2541;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class WCVinesBlock
extends class_2541 {
    public static final class_2746 DOWN = class_2741.field_12546;
    private static final class_265 UP_AABB = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 DOWN_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final class_265 WEST_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final class_265 EAST_AABB = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 NORTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 SOUTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<class_2680, class_265> shapesCache;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final boolean allowUnsupported;
    private final boolean noClimb;
    private final boolean canGrowDownward;

    public WCVinesBlock(class_4970.class_2251 settings) {
        this(settings, false, false, false);
    }

    public WCVinesBlock(class_4970.class_2251 settings, boolean allowUnsupported, boolean noClimb, boolean canGrowDownward) {
        super(settings);
        this.allowUnsupported = allowUnsupported;
        this.noClimb = noClimb;
        this.canGrowDownward = canGrowDownward;
        this.shapesCache = ImmutableMap.copyOf(this.method_9595().method_11662().stream().collect(Collectors.toMap(Function.identity(), WCVinesBlock::calculateShape)));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11703, (Comparable)Boolean.FALSE)).method_11657((class_2769)field_11706, (Comparable)Boolean.FALSE)).method_11657((class_2769)field_11702, (Comparable)Boolean.FALSE)).method_11657((class_2769)field_11699, (Comparable)Boolean.FALSE)).method_11657((class_2769)field_11696, (Comparable)Boolean.FALSE)).method_11657((class_2769)DOWN, (Comparable)Boolean.FALSE)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public boolean isAllowUnsupported() {
        return this.allowUnsupported;
    }

    public boolean isNoClimb() {
        return this.noClimb;
    }

    public boolean isCanGrowDownward() {
        return this.canGrowDownward;
    }

    private static class_265 calculateShape(class_2680 state) {
        class_265 voxelshape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)field_11703)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)DOWN_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)field_11706)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)NORTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)field_11699)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)SOUTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)field_11702)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)EAST_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)field_11696)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)WEST_AABB);
        }
        return voxelshape;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapesCache.get(state);
    }

    public class_265 method_25959(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1073();
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return this.allowUnsupported || this.hasFaces(this.getUpdatedState(state, (class_1922)world, pos));
    }

    private boolean hasFaces(class_2680 state) {
        return this.countFaces(state) > 0;
    }

    private int countFaces(class_2680 state) {
        int i = 0;
        for (class_2746 booleanproperty : field_11697.values()) {
            if (!((Boolean)state.method_11654((class_2769)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        if (this.canGrowDownward && ((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(class_1922 world, class_2338 pos, class_2350 direction) {
        if (!this.canGrowDownward && direction == class_2350.field_11033) {
            return false;
        }
        class_2338 blockpos = pos.method_10093(direction);
        if (this.allowUnsupported) {
            return true;
        }
        if (WCVinesBlock.isAcceptableNeighbour(world, blockpos, direction)) {
            return true;
        }
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return false;
        }
        class_2746 booleanproperty = (class_2746)field_11697.get(direction);
        class_2680 blockstate = world.method_8320(pos.method_10084());
        return blockstate.method_27852((class_2248)this) && (Boolean)blockstate.method_11654((class_2769)booleanproperty) != false;
    }

    public static boolean isAcceptableNeighbour(class_1922 world, class_2338 pos, class_2350 direction) {
        class_2680 neighborState = world.method_8320(pos);
        return class_2248.method_9501((class_265)neighborState.method_26220(world, pos), (class_2350)direction.method_10153());
    }

    private class_2680 getUpdatedState(class_2680 currentState, class_1922 world, class_2338 pos) {
        class_2338 abovePos = pos.method_10084();
        if (((Boolean)currentState.method_11654((class_2769)field_11703)).booleanValue()) {
            currentState = (class_2680)currentState.method_11657((class_2769)field_11703, (Comparable)Boolean.valueOf(this.allowUnsupported || WCVinesBlock.isAcceptableNeighbour(world, abovePos, class_2350.field_11033)));
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            boolean canSupport;
            class_2746 directionProperty = (class_2746)field_11697.get(direction);
            if (!((Boolean)currentState.method_11654((class_2769)directionProperty)).booleanValue()) continue;
            boolean bl = canSupport = this.allowUnsupported || this.canSupportAtFace(world, pos, direction);
            if (!canSupport) {
                class_2680 aboveState = world.method_8320(abovePos);
                canSupport = aboveState.method_27852((class_2248)this) && (Boolean)aboveState.method_11654((class_2769)directionProperty) != false;
            }
            currentState = (class_2680)currentState.method_11657((class_2769)directionProperty, (Comparable)Boolean.valueOf(canSupport));
        }
        if (this.canGrowDownward && ((Boolean)currentState.method_11654((class_2769)DOWN)).booleanValue()) {
            boolean canSupportDown = this.allowUnsupported || this.canSupportAtFace(world, pos, class_2350.field_11033);
            currentState = (class_2680)currentState.method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(canSupportDown));
        }
        return currentState;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (!this.canGrowDownward && direction == class_2350.field_11033) {
            return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        }
        class_2680 blockstate = this.getUpdatedState(state, (class_1922)world, pos);
        return !this.hasFaces(blockstate) ? class_2246.field_10124.method_9564() : blockstate;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockstate = ctx.method_8045().method_8320(ctx.method_8037());
        boolean flag = blockstate.method_27852((class_2248)this);
        class_2680 blockstate1 = flag ? blockstate : this.method_9564();
        class_3610 fluidstate = ctx.method_8045().method_8316(ctx.method_8037());
        blockstate1 = (class_2680)blockstate1.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.method_15767(class_3486.field_15517)));
        for (class_2350 direction : ctx.method_7718()) {
            boolean flag1;
            class_2746 booleanproperty;
            if (!this.canGrowDownward && direction == class_2350.field_11033) continue;
            class_2746 class_27462 = booleanproperty = direction == class_2350.field_11033 ? DOWN : (class_2746)field_11697.get(direction);
            if (booleanproperty == null) continue;
            boolean bl = flag1 = flag && (Boolean)blockstate.method_11654((class_2769)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((class_1922)ctx.method_8045(), ctx.method_8037(), direction)) continue;
            return (class_2680)blockstate1.method_11657((class_2769)booleanproperty, (Comparable)Boolean.TRUE);
        }
        return flag ? blockstate1 : null;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case class_10.field_50 -> false;
            case class_10.field_48 -> state.method_26227().method_15767(class_3486.field_15517);
            case class_10.field_51 -> false;
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11703, field_11706, field_11702, field_11699, field_11696, DOWN, WATERLOGGED});
    }

    public static class Factory
    extends BlockFactory {
        public WCVinesBlock buildBlockClass(class_4970.class_2251 settings, BlockDefinition definition) {
            boolean allowUnsupported = definition != null && definition.isAllowUnsupported();
            boolean noClimb = definition != null && definition.isNoClimb();
            boolean canGrowDownward = definition != null && definition.canGrowDownward();
            return new WCVinesBlock(settings, allowUnsupported, noClimb, canGrowDownward);
        }

        public WCVinesBlock buildBlockClass(class_4970.class_2251 settings) {
            return new WCVinesBlock(settings);
        }

        public WCVinesBlock buildBlockClass(class_4970.class_2251 settings, boolean allowUnsupported, boolean noClimb, boolean canGrowDownward) {
            return new WCVinesBlock(settings, allowUnsupported, noClimb, canGrowDownward);
        }
    }
}

