/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BlockDefinition {
    @SerializedName(value="blockName")
    private String blockName;
    @SerializedName(value="blockType")
    private String blockType;
    @SerializedName(value="soundGroup")
    private String soundGroup;
    @SerializedName(value="resistance")
    private float resistance;
    @SerializedName(value="hardness")
    private float hardness;
    @SerializedName(value="strength")
    private Float strength;
    @Deprecated
    @SerializedName(value="material")
    private String material;
    @SerializedName(value="creativeTab")
    private String creativeTab;
    @SerializedName(value="label")
    private String label;
    @SerializedName(value="textures")
    private List<String> textures;
    @SerializedName(value="type")
    private String type;
    @SerializedName(value="renderLayer")
    private String renderLayer;
    @SerializedName(value="randomTextures")
    private List<RandomTextureVariant> randomTextures;
    @SerializedName(value="states")
    private List<StateVariant> states;
    @SerializedName(value="overlayTextures")
    private List<String> overlayTextures;
    @SerializedName(value="colorMult")
    private String colorMult;
    @SerializedName(value="colorMults")
    private List<String> colorMults;
    @SerializedName(value="itemTexture")
    private String itemTexture;
    @SerializedName(value="itemTextureIndex")
    private Integer itemTextureIndex;
    @SerializedName(value="display")
    private DisplaySettings display;
    @SerializedName(value="tooltips")
    private List<String> tooltips;
    @SerializedName(value="luminance")
    private Integer luminance;
    @SerializedName(value="harvestLevel")
    private List<HarvestLevel> harvestLevel;
    @SerializedName(value="requiresTool")
    private Boolean requiresTool;
    @SerializedName(value="lightOpacity")
    private Integer lightOpacity;
    @SerializedName(value="collisionBoxes")
    private List<BoundingBox> collisionBoxes;
    @SerializedName(value="nonOpaque")
    private Boolean nonOpaque;
    @SerializedName(value="noCollision")
    private Boolean noCollision;
    @SerializedName(value="layerSensitive")
    private Boolean layerSensitive;
    @SerializedName(value="allowUnsupported")
    private Boolean allowUnsupported;
    @SerializedName(value="allowHalfBreak")
    private Boolean allowHalfBreak;
    @SerializedName(value="toggleOnUse")
    private Boolean toggleOnUse;
    @SerializedName(value="locked")
    private Boolean locked;
    @SerializedName(value="noParticle")
    private Boolean noParticle;
    @SerializedName(value="alwaysOn")
    private Boolean alwaysOn;
    @SerializedName(value="hasClimb")
    private Boolean hasClimb;
    @SerializedName(value="hasDown")
    private Boolean hasDown;
    @SerializedName(value="connectTo")
    private String connectTo;
    @SerializedName(value="symmetrical")
    private Boolean symmetrical;
    @SerializedName(value="isCustomModel")
    private Boolean isCustomModel;
    @SerializedName(value="isTinted")
    private Boolean isTinted;
    @SerializedName(value="hasOverlay")
    private Boolean hasOverlay;
    @SerializedName(value="hasBetterFoliage")
    private Boolean hasBetterFoliage;
    @SerializedName(value="betterFoliage")
    private Boolean betterFoliage;
    @SerializedName(value="noDecay")
    private Boolean noDecay;
    @SerializedName(value="hasRotateRandom")
    private Boolean hasRotateRandom;
    @SerializedName(value="rotateRandom")
    private Boolean rotateRandom;
    @SerializedName(value="alphaRender")
    private Boolean alphaRender;
    @SerializedName(value="isLegacyModel")
    private String isLegacyModel;
    @SerializedName(value="bedType")
    private String bedType;
    @SerializedName(value="wallSize")
    private String wallSize;
    @SerializedName(value="connectState")
    private Boolean connectState;
    @SerializedName(value="unconnect")
    private Boolean unconnect;
    @SerializedName(value="stack")
    private List<StackElement> stack;
    @SerializedName(value="boundingBox")
    private BoundingBox boundingBox;
    @SerializedName(value="cuboids")
    private List<CuboidElement> cuboids;
    @SerializedName(value="woodType")
    private String woodType;
    @SerializedName(value="particle")
    private String particle;

    public String getBlockName() {
        return this.blockName;
    }

    public String getBlockType() {
        return this.blockType;
    }

    public String getSoundGroup() {
        return this.soundGroup;
    }

    public float getResistance() {
        return this.resistance;
    }

    public Boolean isLegacyModel() {
        return Boolean.TRUE.equals(this.isLegacyModel);
    }

    public float getHardness() {
        return this.hardness;
    }

    public Float getStrength() {
        return this.strength;
    }

    public boolean hasStrength() {
        return this.strength != null;
    }

    public String getMaterial() {
        return this.material;
    }

    public boolean hasMaterial() {
        return this.material != null && !this.material.isEmpty();
    }

    public String getCreativeTab() {
        return this.creativeTab;
    }

    public boolean toggleOnUse() {
        return Boolean.TRUE.equals(this.toggleOnUse);
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getTextures() {
        return this.textures;
    }

    public String getType() {
        return this.type;
    }

    public List<HarvestLevel> getHarvestLevel() {
        return this.harvestLevel;
    }

    public boolean isRequiresTool() {
        return Boolean.TRUE.equals(this.requiresTool);
    }

    public Integer getLightOpacity() {
        return this.lightOpacity;
    }

    public boolean hasLightOpacity() {
        return this.lightOpacity != null;
    }

    public List<BoundingBox> getCollisionBoxes() {
        return this.collisionBoxes;
    }

    public boolean hasCollisionBoxes() {
        return this.collisionBoxes != null && !this.collisionBoxes.isEmpty();
    }

    public String getRenderLayer() {
        return this.renderLayer;
    }

    public boolean hasRenderLayer() {
        return this.renderLayer != null && !this.renderLayer.isEmpty();
    }

    public boolean isNonOpaque() {
        return Boolean.TRUE.equals(this.nonOpaque);
    }

    public boolean isLayerSensitive() {
        return Boolean.TRUE.equals(this.layerSensitive);
    }

    public boolean hasNoCollision() {
        return Boolean.TRUE.equals(this.noCollision);
    }

    public List<RandomTextureVariant> getRandomTextures() {
        return this.randomTextures;
    }

    public boolean hasRandomTextures() {
        return this.randomTextures != null && !this.randomTextures.isEmpty();
    }

    public List<StateVariant> getStates() {
        return this.states;
    }

    public boolean hasStates() {
        return this.states != null && !this.states.isEmpty();
    }

    public int getStateCount() {
        if (this.hasStates()) {
            return this.states.size();
        }
        return 0;
    }

    public List<String> getOverlayTextures() {
        return this.overlayTextures;
    }

    public boolean hasOverlayTextures() {
        return this.overlayTextures != null && !this.overlayTextures.isEmpty();
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public boolean isLocked() {
        return Boolean.TRUE.equals(this.locked);
    }

    public boolean isAllowUnsupported() {
        return Boolean.TRUE.equals(this.allowUnsupported);
    }

    public boolean isAllowHalfBreak() {
        return Boolean.TRUE.equals(this.allowHalfBreak);
    }

    public String getColorMult() {
        return this.colorMult;
    }

    public boolean hasColorMult() {
        return this.colorMult != null && !this.colorMult.isEmpty();
    }

    public List<String> getColorMults() {
        return this.colorMults;
    }

    public boolean hasColorMults() {
        return this.colorMults != null && !this.colorMults.isEmpty();
    }

    public String getItemTexture() {
        return this.itemTexture;
    }

    public boolean hasItemTexture() {
        return this.itemTexture != null && !this.itemTexture.isEmpty();
    }

    public Integer getItemTextureIndex() {
        return this.itemTextureIndex;
    }

    public boolean hasItemTextureIndex() {
        return this.itemTextureIndex != null;
    }

    public DisplaySettings getDisplay() {
        return this.display;
    }

    public boolean hasDisplay() {
        return this.display != null;
    }

    public List<String> getTooltips() {
        return this.tooltips;
    }

    public boolean hasTooltips() {
        return this.tooltips != null && !this.tooltips.isEmpty();
    }

    public int getLuminance() {
        return this.luminance != null ? this.luminance : 0;
    }

    public boolean hasCustomModel() {
        return Boolean.TRUE.equals(this.isCustomModel);
    }

    public boolean isTinted() {
        return Boolean.TRUE.equals(this.isTinted);
    }

    public boolean hasOverlay() {
        return Boolean.TRUE.equals(this.hasOverlay);
    }

    public boolean hasBetterFoliage() {
        return Boolean.TRUE.equals(this.hasBetterFoliage) || Boolean.TRUE.equals(this.betterFoliage);
    }

    public boolean hasRotateRandom() {
        return Boolean.TRUE.equals(this.hasRotateRandom);
    }

    public boolean isRotateRandom() {
        return Boolean.TRUE.equals(this.rotateRandom);
    }

    public boolean isNoDecay() {
        return Boolean.TRUE.equals(this.noDecay);
    }

    public boolean isAlphaRender() {
        return Boolean.TRUE.equals(this.alphaRender);
    }

    public boolean isNoParticle() {
        return Boolean.TRUE.equals(this.noParticle);
    }

    public String getBedType() {
        return this.bedType;
    }

    public boolean hasBedType() {
        return this.bedType != null && !this.bedType.isEmpty();
    }

    public boolean isAlwaysOn() {
        return Boolean.TRUE.equals(this.alwaysOn);
    }

    public boolean hasClimb() {
        return Boolean.TRUE.equals(this.hasClimb);
    }

    public boolean hasDown() {
        return Boolean.TRUE.equals(this.hasDown);
    }

    public String getConnectTo() {
        return this.connectTo;
    }

    public boolean hasConnectTo() {
        return this.connectTo != null && !this.connectTo.isEmpty();
    }

    public boolean isSymmetrical() {
        return Boolean.TRUE.equals(this.symmetrical);
    }

    public String getWallSize() {
        return this.wallSize != null ? this.wallSize : "normal";
    }

    public boolean isConnectState() {
        return Boolean.TRUE.equals(this.connectState);
    }

    public boolean isUnconnect() {
        return Boolean.TRUE.equals(this.unconnect);
    }

    public List<StackElement> getStack() {
        return this.stack;
    }

    public List<StackElement> getStackElements() {
        return this.stack;
    }

    public boolean hasStackElements() {
        return this.stack != null && !this.stack.isEmpty();
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public boolean hasBoundingBox() {
        return this.boundingBox != null;
    }

    public List<CuboidElement> getCuboids() {
        return this.cuboids;
    }

    public String getWoodType() {
        if (this.woodType != null && !this.woodType.isEmpty()) {
            return this.woodType;
        }
        if (this.type != null && !this.type.isEmpty()) {
            return this.type;
        }
        return "oak";
    }

    public boolean hasWoodType() {
        return this.woodType != null && !this.woodType.isEmpty();
    }

    public List<String> getStateValues() {
        if (this.hasStates()) {
            ArrayList<String> stateIds = new ArrayList<String>();
            for (StateVariant state : this.states) {
                if (state == null || state.getStateID() == null || state.getStateID().isEmpty()) continue;
                stateIds.add(state.getStateID());
            }
            return stateIds.isEmpty() ? null : stateIds;
        }
        return null;
    }

    public boolean isNoClimb() {
        return this.type != null && this.type.contains("no-climb");
    }

    public boolean canGrowDownward() {
        return this.hasDown();
    }

    public boolean isNoInWeb() {
        return this.type != null && this.type.contains("no-in-web");
    }

    public boolean isBarsModel() {
        return this.type != null && (this.type.contains("bars-model") || "bars".equals(this.type));
    }

    public String getParticle() {
        return this.particle != null ? this.particle : "flame";
    }

    public boolean hasParticle() {
        return this.particle != null && !this.particle.isEmpty();
    }

    public List<TextureVariantSet> getRandomTextureVariantSets() {
        if (!this.hasRandomTextures()) {
            return new ArrayList<TextureVariantSet>();
        }
        ArrayList<TextureVariantSet> variants = new ArrayList<TextureVariantSet>();
        for (RandomTextureVariant rtv : this.randomTextures) {
            variants.add(new TextureVariantSet(rtv.getTextures(), rtv.getWeight()));
        }
        return variants;
    }

    public String[][] getRandomTextureArrays() {
        List<TextureVariantSet> variants = this.getRandomTextureVariantSets();
        String[][] arrays = new String[variants.size()][];
        for (int i = 0; i < variants.size(); ++i) {
            List<String> textures = variants.get((int)i).textures;
            arrays[i] = textures.toArray(new String[0]);
        }
        return arrays;
    }

    public boolean hasActualRandomTextures() {
        if (!this.hasRandomTextures()) {
            return false;
        }
        for (RandomTextureVariant rtv : this.randomTextures) {
            if (rtv.getTextures() == null || rtv.getTextures().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String[][] getStateTextureArrays() {
        if (!this.hasStates()) {
            return new String[0][];
        }
        List<StateVariant> stateList = this.getStates();
        String[][] arrays = new String[stateList.size()][];
        for (int i = 0; i < stateList.size(); ++i) {
            StateVariant state = stateList.get(i);
            List<String> stateTextures = state.getTextures();
            arrays[i] = stateTextures != null ? stateTextures.toArray(new String[0]) : new String[]{};
        }
        return arrays;
    }

    public static List<TextureVariantSet> getRandomTextureVariantSetsFromState(StateVariant stateVariant) {
        if (!stateVariant.hasRandomTextures()) {
            return new ArrayList<TextureVariantSet>();
        }
        ArrayList<TextureVariantSet> variants = new ArrayList<TextureVariantSet>();
        for (RandomTextureVariant rtv : stateVariant.getRandomTextures()) {
            variants.add(new TextureVariantSet(rtv.getTextures(), rtv.getWeight()));
        }
        return variants;
    }

    public String[] getTexturesAsArray() {
        if (this.textures == null || this.textures.isEmpty()) {
            return new String[0];
        }
        return this.textures.toArray(new String[0]);
    }

    public String getFirstTexture(String fallback) {
        if (this.textures != null && !this.textures.isEmpty()) {
            return this.textures.getFirst();
        }
        return fallback;
    }

    public int getTextureCount() {
        return this.textures != null ? this.textures.size() : 0;
    }

    public TextureSource getPrimaryTextureSource() {
        if (this.hasStates()) {
            return TextureSource.STATES;
        }
        if (this.hasActualRandomTextures()) {
            return TextureSource.RANDOM_TEXTURES;
        }
        if (this.textures != null && !this.textures.isEmpty()) {
            return TextureSource.TEXTURES;
        }
        if (this.hasCustomModel()) {
            return TextureSource.CUSTOM_MODEL;
        }
        return TextureSource.NONE;
    }

    public Object extractTextures() {
        TextureSource source = this.getPrimaryTextureSource();
        return switch (source.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.getStateTextureArrays();
            case 1 -> this.getRandomTextureArrays();
            case 2 -> this.getTexturesAsArray();
            case 3, 4 -> new String[]{};
        };
    }

    public void validateTextureData() {
        TextureSource source = this.getPrimaryTextureSource();
        if (source == TextureSource.NONE && !this.hasCustomModel()) {
            throw new IllegalArgumentException("Block definition '" + this.blockName + "' must have at least one texture source (textures, randomTextures, states, or isCustomModel)");
        }
    }

    public void validateTextureCount(int expected) {
        int actual = this.getTextureCount();
        if (actual < expected) {
            throw new IllegalArgumentException("Block definition '" + this.blockName + "' requires at least " + expected + " texture(s), but only " + actual + " provided");
        }
    }

    public boolean shouldUseTintedModel() {
        return this.isTinted() || this.hasColorMult() || this.hasOverlay();
    }

    public String toString() {
        return String.format("BlockDefinition{blockName='%s', blockType='%s', label='%s'}", this.blockName, this.blockType, this.label);
    }

    public static class DisplaySettings {
        @SerializedName(value="gui")
        private GuiTransform gui;

        public GuiTransform getGui() {
            return this.gui;
        }

        public boolean hasGui() {
            return this.gui != null;
        }
    }

    public static class BoundingBox {
        @SerializedName(value="xMin")
        private double xMin;
        @SerializedName(value="xMax")
        private double xMax;
        @SerializedName(value="yMin")
        private double yMin;
        @SerializedName(value="yMax")
        private double yMax;
        @SerializedName(value="zMin")
        private double zMin;
        @SerializedName(value="zMax")
        private double zMax;

        public double getXMin() {
            return this.xMin;
        }

        public double getXMax() {
            return this.xMax;
        }

        public double getYMin() {
            return this.yMin;
        }

        public double getYMax() {
            return this.yMax;
        }

        public double getZMin() {
            return this.zMin;
        }

        public double getZMax() {
            return this.zMax;
        }
    }

    public static class StateVariant {
        @SerializedName(value="stateID")
        private String stateID;
        @SerializedName(value="textures")
        private List<String> textures;
        @SerializedName(value="randomTextures")
        private List<RandomTextureVariant> randomTextures;
        @SerializedName(value="overlayTextures")
        private List<String> overlayTextures;
        @SerializedName(value="boundingBox")
        private BoundingBox boundingBox;
        @SerializedName(value="cuboids")
        private List<CuboidElement> cuboids;
        @SerializedName(value="rotYOffset")
        private Integer rotYOffset;
        @SerializedName(value="isCustomModel")
        private Boolean isCustomModel;

        public String getStateID() {
            return this.stateID;
        }

        public List<String> getTextures() {
            return this.textures;
        }

        public List<RandomTextureVariant> getRandomTextures() {
            return this.randomTextures;
        }

        public boolean hasRandomTextures() {
            return this.randomTextures != null && !this.randomTextures.isEmpty();
        }

        public List<String> getOverlayTextures() {
            return this.overlayTextures;
        }

        public boolean hasOverlayTextures() {
            return this.overlayTextures != null && !this.overlayTextures.isEmpty();
        }

        public BoundingBox getBoundingBox() {
            return this.boundingBox;
        }

        public List<CuboidElement> getCuboids() {
            return this.cuboids;
        }

        public boolean hasCuboids() {
            return this.cuboids != null && !this.cuboids.isEmpty();
        }

        public Integer getRotYOffset() {
            return this.rotYOffset;
        }

        public boolean isCustomModel() {
            return Boolean.TRUE.equals(this.isCustomModel);
        }
    }

    public static class RandomTextureVariant {
        @SerializedName(value="textures")
        private List<String> textures;
        @SerializedName(value="weight")
        private Integer weight;

        public List<String> getTextures() {
            return this.textures;
        }

        public int getWeight() {
            return this.weight != null ? this.weight : 1;
        }
    }

    public static class TextureVariantSet {
        public final List<String> textures;
        public final List<String> overlayTextures;
        public final int weight;

        public TextureVariantSet(List<String> textures, int weight, List<String> overlayTextures) {
            this.textures = textures != null ? textures : new ArrayList();
            this.weight = Math.max(1, weight);
            this.overlayTextures = overlayTextures != null ? overlayTextures : new ArrayList();
        }

        public TextureVariantSet(List<String> textures, int weight) {
            this(textures, weight, null);
        }

        public TextureVariantSet(String[] textures, int weight, String[] overlayTextures) {
            this(textures != null ? Arrays.asList(textures) : new ArrayList<String>(), weight, overlayTextures != null ? Arrays.asList(overlayTextures) : null);
        }

        public TextureVariantSet(String[] textures, int weight) {
            this(textures, weight, (String[])null);
        }

        public TextureVariantSet(String texture, int weight) {
            this(texture != null ? Collections.singletonList(texture) : new ArrayList<String>(), weight, null);
        }

        public boolean hasOverlay() {
            return this.overlayTextures != null && !this.overlayTextures.isEmpty();
        }

        public String[] getTexturesAsArray() {
            return this.textures.toArray(new String[0]);
        }

        public String[] getOverlayTexturesAsArray() {
            return this.overlayTextures != null ? this.overlayTextures.toArray(new String[0]) : new String[]{};
        }

        public String getFirstTexture() {
            return this.textures.isEmpty() ? "missingno" : this.textures.get(0);
        }
    }

    public static enum TextureSource {
        STATES,
        RANDOM_TEXTURES,
        TEXTURES,
        CUSTOM_MODEL,
        NONE;

    }

    public static class CuboidElement {
        @SerializedName(value="xMin")
        private double xMin;
        @SerializedName(value="xMax")
        private double xMax;
        @SerializedName(value="yMin")
        private double yMin;
        @SerializedName(value="yMax")
        private double yMax;
        @SerializedName(value="zMin")
        private double zMin;
        @SerializedName(value="zMax")
        private double zMax;
        @SerializedName(value="sideTextures")
        private int[] sideTextures;
        @SerializedName(value="sideRotations")
        private int[] sideRotations;
        @SerializedName(value="noTint")
        private boolean[] noTint;
        @SerializedName(value="shape")
        private String shape;

        public double getXMin() {
            return this.xMin;
        }

        public double getXMax() {
            return this.xMax;
        }

        public double getYMin() {
            return this.yMin;
        }

        public double getYMax() {
            return this.yMax;
        }

        public double getZMin() {
            return this.zMin;
        }

        public double getZMax() {
            return this.zMax;
        }

        public int[] getSideTextures() {
            return this.sideTextures;
        }

        public int[] getSideRotations() {
            return this.sideRotations;
        }

        public boolean[] getNoTint() {
            return this.noTint;
        }

        public String getShape() {
            return this.shape;
        }
    }

    public static class StackElement {
        @SerializedName(value="textures")
        private List<String> textures;
        @SerializedName(value="boundingBox")
        private BoundingBox boundingBox;

        public List<String> getTextures() {
            return this.textures;
        }

        public BoundingBox getBoundingBox() {
            return this.boundingBox;
        }

        public boolean hasBoundingBox() {
            return this.boundingBox != null;
        }
    }

    public static class HarvestLevel {
        @SerializedName(value="tool")
        private String tool;
        @SerializedName(value="level")
        private int level;

        public String getTool() {
            return this.tool;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public static class GuiTransform {
        @SerializedName(value="rotation")
        private double[] rotation;
        @SerializedName(value="translation")
        private double[] translation;
        @SerializedName(value="scale")
        private double[] scale;

        public double[] getRotation() {
            return this.rotation;
        }

        public double[] getTranslation() {
            return this.translation;
        }

        public double[] getScale() {
            return this.scale;
        }
    }
}

