/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class BlockDefinitionLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String blockDefinitionsPath;

    public BlockDefinitionLoader(String blockDefinitionsPath) {
        this.blockDefinitionsPath = blockDefinitionsPath;
    }

    public Map<String, BlockDefinition> loadAllDefinitions() {
        HashMap<String, BlockDefinition> definitions = new HashMap<String, BlockDefinition>();
        WesterosBlocks.LOGGER.info("Loading block definitions from resources: {}", (Object)this.blockDefinitionsPath);
        try {
            this.loadDefinitionsFromResources(definitions);
            WesterosBlocks.LOGGER.info("Successfully loaded {} block definitions", (Object)definitions.size());
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Failed to load block definitions from resources", (Throwable)e);
        }
        return definitions;
    }

    private void loadDefinitionsFromResources(Map<String, BlockDefinition> definitions) throws Exception {
        ModContainer container = FabricLoader.getInstance().getModContainer("westerosblocks").orElse(null);
        if (container == null) {
            WesterosBlocks.LOGGER.error("Could not find mod container for {}", (Object)"westerosblocks");
            return;
        }
        for (Path rootPath : container.getRootPaths()) {
            String pathWithoutSlash;
            Path dirPath = rootPath.resolve(pathWithoutSlash = this.blockDefinitionsPath.startsWith("/") ? this.blockDefinitionsPath.substring(1) : this.blockDefinitionsPath);
            if (Files.exists(dirPath, new LinkOption[0]) && Files.isDirectory(dirPath, new LinkOption[0])) {
                WesterosBlocks.LOGGER.debug("Loading block definitions from: {}", (Object)dirPath);
                this.loadDefinitionsRecursively(dirPath, definitions);
                continue;
            }
            WesterosBlocks.LOGGER.debug("Block definitions directory not found at: {}", (Object)dirPath);
        }
        if (definitions.isEmpty()) {
            WesterosBlocks.LOGGER.warn("No individual block definitions were loaded!");
        }
    }

    private void loadDefinitionsRecursively(Path directory, Map<String, BlockDefinition> definitions) throws IOException {
        try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(path -> this.loadDefinitionFile((Path)path, definitions));
        }
    }

    private void loadDefinitionFile(Path filePath, Map<String, BlockDefinition> definitions) {
        try {
            String content = Files.readString(filePath);
            try {
                BlockDefinition[] definitionArray = (BlockDefinition[])GSON.fromJson(content, BlockDefinition[].class);
                if (definitionArray != null && definitionArray.length > 0) {
                    WesterosBlocks.LOGGER.debug("Loading {} block definitions from consolidated file: {}", (Object)definitionArray.length, (Object)filePath);
                    for (BlockDefinition definition : definitionArray) {
                        if (this.addDefinition(definition, definitions, filePath)) continue;
                    }
                    return;
                }
            }
            catch (JsonSyntaxException definitionArray) {
                // empty catch block
            }
            BlockDefinition definition = (BlockDefinition)GSON.fromJson(content, BlockDefinition.class);
            this.addDefinition(definition, definitions, filePath);
        }
        catch (IOException e) {
            WesterosBlocks.LOGGER.error("Failed to read block definition file: {}", (Object)filePath, (Object)e);
        }
        catch (JsonSyntaxException e) {
            WesterosBlocks.LOGGER.error("Invalid JSON syntax in block definition file: {}", (Object)filePath, (Object)e);
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Unexpected error loading block definition file: {}", (Object)filePath, (Object)e);
        }
    }

    private boolean addDefinition(BlockDefinition definition, Map<String, BlockDefinition> definitions, Path filePath) {
        if (definition == null) {
            WesterosBlocks.LOGGER.warn("Failed to parse block definition in file: {}", (Object)filePath);
            return false;
        }
        if (definition.getBlockName() == null || definition.getBlockName().isEmpty()) {
            WesterosBlocks.LOGGER.warn("Block definition missing blockName in file: {}", (Object)filePath);
            return false;
        }
        if (definition.getBlockType() == null || definition.getBlockType().isEmpty()) {
            WesterosBlocks.LOGGER.warn("Block definition missing blockType in file: {}", (Object)filePath);
            return false;
        }
        if (definitions.containsKey(definition.getBlockName())) {
            WesterosBlocks.LOGGER.warn("Duplicate block definition found for '{}' in file: {}", (Object)definition.getBlockName(), (Object)filePath);
        }
        definitions.put(definition.getBlockName(), definition);
        WesterosBlocks.LOGGER.debug("Loaded block definition: {} ({})", (Object)definition.getBlockName(), (Object)definition.getBlockType());
        return true;
    }

    public Map<String, List<BlockDefinition>> groupByType(Map<String, BlockDefinition> definitions) {
        HashMap<String, List<BlockDefinition>> groupedDefinitions = new HashMap<String, List<BlockDefinition>>();
        for (BlockDefinition definition : definitions.values()) {
            String blockType = definition.getBlockType();
            groupedDefinitions.computeIfAbsent(blockType, k -> new ArrayList()).add(definition);
        }
        return groupedDefinitions;
    }

    public void validateDefinitions(Map<String, BlockDefinition> definitions) {
        int validCount = 0;
        int warningCount = 0;
        for (BlockDefinition definition : definitions.values()) {
            boolean isValid = true;
            if (!definition.hasCustomModel()) {
                boolean hasTextures = false;
                if (definition.getTextures() != null && !definition.getTextures().isEmpty()) {
                    hasTextures = true;
                }
                if (definition.getRandomTextures() != null && !definition.getRandomTextures().isEmpty()) {
                    hasTextures = true;
                }
                if (definition.getStates() != null && !definition.getStates().isEmpty()) {
                    for (BlockDefinition.StateVariant state : definition.getStates()) {
                        if ((state.getTextures() == null || state.getTextures().isEmpty()) && (state.getRandomTextures() == null || state.getRandomTextures().isEmpty())) continue;
                        hasTextures = true;
                        break;
                    }
                }
                if (definition.getStack() != null && !definition.getStack().isEmpty()) {
                    for (BlockDefinition.StackElement stackElement : definition.getStack()) {
                        if (stackElement.getTextures() == null || stackElement.getTextures().isEmpty()) continue;
                        hasTextures = true;
                        break;
                    }
                }
                if (!hasTextures) {
                    WesterosBlocks.LOGGER.warn("Block '{}' has no textures defined", (Object)definition.getBlockName());
                    ++warningCount;
                    isValid = false;
                }
            }
            if (definition.getLabel() == null || definition.getLabel().isEmpty()) {
                WesterosBlocks.LOGGER.warn("Block '{}' has no label defined", (Object)definition.getBlockName());
                ++warningCount;
                isValid = false;
            }
            if (!isValid) continue;
            ++validCount;
        }
        WesterosBlocks.LOGGER.info("Validation complete: {} valid, {} with warnings", (Object)validCount, (Object)warningCount);
    }
}

