/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCBranchBlock;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class BranchBlockExporter
extends BaseBlockExporter {
    public static void registerBranchBlock(class_4910 generator, class_2248 block, String texturePath) {
        BranchBlockExporter.registerBranchBlock(generator, block, new String[]{texturePath});
    }

    public static void registerBranchBlock(class_4910 generator, class_2248 block, String ... texturePaths) {
        if (texturePaths.length == 0) {
            throw new IllegalArgumentException("At least one texture path is required");
        }
        String branchType = "large_branch";
        if (block instanceof WCBranchBlock) {
            branchType = ((WCBranchBlock)block).getBranchType();
        }
        class_2960 baseModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "base");
        class_2960 horizontalModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "horizontal");
        class_2960 connectedModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "connected");
        class_2960 horizontalConnectedModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "horizontal_connected");
        class_2960 horizontalConnectedTwoCornerModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "horizontal_connected_two_corner");
        class_2960 horizontalConnectedThreeModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "horizontal_connected_three");
        class_2960 horizontalConnectedFourModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "horizontal_connected_four");
        class_2960 horizontalConnectedUpCornerModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "horizontal_connected_up_corner");
        class_2960 connectedTwoModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "connected_two");
        class_2960 connectedTwoCornerModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "connected_two_corner");
        class_2960 connectedThreeModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "connected_three");
        class_2960 connectedFourModelId = BranchBlockExporter.createBranchModel(generator, block, branchType, texturePaths, "connected_four");
        class_4922 stateSupplier = class_4922.method_25758((class_2248)block);
        class_4918.class_4921 singleCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)singleCondition, BranchBlockExporter.createVariant(baseModelId));
        class_4918.class_4921 northHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)northHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedModelId, 0));
        class_4918.class_4921 southHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)southHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedUpCornerModelId, 180));
        class_4918.class_4921 eastHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)eastHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedModelId, 90));
        class_4918.class_4921 westHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)westHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedModelId, 270));
        class_4918.class_4921 northWestHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)northWestHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedTwoCornerModelId, 270));
        class_4918.class_4921 northEastHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)northEastHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedTwoCornerModelId, 0));
        class_4918.class_4921 southWestHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)southWestHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedTwoCornerModelId, 180));
        class_4918.class_4921 southEastHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)southEastHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedTwoCornerModelId, 90));
        class_4918.class_4921 northSouthHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)northSouthHorizontalCondition, BranchBlockExporter.createVariant(horizontalModelId, 0));
        class_4918.class_4921 eastWestHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)eastWestHorizontalCondition, BranchBlockExporter.createVariant(horizontalModelId, 90));
        class_4918.class_4921 northEastWestHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)northEastWestHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedThreeModelId, 270));
        class_4918.class_4921 northEastSouthHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)northEastSouthHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedThreeModelId, 0));
        class_4918.class_4921 northSouthWestHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)northSouthWestHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedThreeModelId, 180));
        class_4918.class_4921 eastSouthWestHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)eastSouthWestHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedThreeModelId, 90));
        class_4918.class_4921 allHorizontalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(false));
        stateSupplier.method_25760((class_4918)allHorizontalCondition, BranchBlockExporter.createVariant(horizontalConnectedFourModelId, 0));
        class_4918.class_4921 singleVerticalCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)singleVerticalCondition, BranchBlockExporter.createVariant(baseModelId));
        class_4918.class_4921 northCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)northCondition, BranchBlockExporter.createVariant(connectedModelId));
        class_4918.class_4921 southCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)southCondition, BranchBlockExporter.createVariant(connectedModelId, 180));
        class_4918.class_4921 eastCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)eastCondition, BranchBlockExporter.createVariant(connectedModelId, 90));
        class_4918.class_4921 westCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)westCondition, BranchBlockExporter.createVariant(connectedModelId, 270));
        class_4918.class_4921 northWestCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)northWestCondition, BranchBlockExporter.createVariant(connectedTwoCornerModelId, 270));
        class_4918.class_4921 northEastCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)northEastCondition, BranchBlockExporter.createVariant(connectedTwoCornerModelId, 0));
        class_4918.class_4921 southWestCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)southWestCondition, BranchBlockExporter.createVariant(connectedTwoCornerModelId, 180));
        class_4918.class_4921 southEastCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)southEastCondition, BranchBlockExporter.createVariant(connectedTwoCornerModelId, 90));
        class_4918.class_4921 northSouthCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)northSouthCondition, BranchBlockExporter.createVariant(connectedTwoModelId, 0));
        class_4918.class_4921 eastWestCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)eastWestCondition, BranchBlockExporter.createVariant(connectedTwoModelId, 90));
        class_4918.class_4921 northEastWestCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)northEastWestCondition, BranchBlockExporter.createVariant(connectedThreeModelId, 270));
        class_4918.class_4921 northEastSouthCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)northEastSouthCondition, BranchBlockExporter.createVariant(connectedThreeModelId, 0));
        class_4918.class_4921 northSouthWestCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)northSouthWestCondition, BranchBlockExporter.createVariant(connectedThreeModelId, 180));
        class_4918.class_4921 eastSouthWestCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)eastSouthWestCondition, BranchBlockExporter.createVariant(connectedThreeModelId, 90));
        class_4918.class_4921 allConnectionsCondition = class_4918.method_25744().method_25751((class_2769)WCBranchBlock.NORTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.EAST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.SOUTH, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.WEST, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)WCBranchBlock.UP, (Comparable)Boolean.valueOf(true));
        stateSupplier.method_25760((class_4918)allConnectionsCondition, BranchBlockExporter.createVariant(connectedFourModelId, 0));
        generator.field_22830.accept(stateSupplier);
        generator.method_25623(block, baseModelId);
    }

    private static class_2960 createBranchModel(class_4910 generator, class_2248 block, String branchType, String[] texturePaths, String connectionType) {
        String texturePath = texturePaths[0];
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23010, BranchBlockExporter.createBlockIdentifier(texturePath)).method_25868(class_4945.field_23012, BranchBlockExporter.createBlockIdentifier(texturePath));
        Optional<Object> parentModel = Optional.empty();
        if ("large_branch".equals(branchType)) {
            parentModel = switch (connectionType) {
                case "base" -> Optional.of(WesterosBlocks.id("block/branches/large_branch"));
                case "horizontal" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_horizontal"));
                case "connected" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_connected"));
                case "horizontal_connected" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_horizontal_connected"));
                case "horizontal_connected_two_corner" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_horizontal_connected_two_corner"));
                case "horizontal_connected_three" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_horizontal_connected_three"));
                case "horizontal_connected_four" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_horizontal_connected_four"));
                case "horizontal_connected_up_corner" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_horizontal_connected_up_corner"));
                case "connected_two" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_connected_two"));
                case "connected_two_corner" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_connected_two_corner"));
                case "connected_three" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_connected_three"));
                case "connected_four" -> Optional.of(WesterosBlocks.id("block/branches/large_branch_connected_four"));
                default -> Optional.of(WesterosBlocks.id("block/branches/large_branch"));
            };
        } else {
            parentModel = Optional.of(WesterosBlocks.id("block/custom/branches/large_branch"));
        }
        String blockName = BranchBlockExporter.getBlockName(block);
        class_2960 modelId = class_2960.method_60655((String)"westerosblocks", (String)("block/" + blockName + "/" + connectionType));
        class_4942 model = new class_4942(parentModel, Optional.empty(), new class_4945[]{class_4945.field_23010, class_4945.field_23012});
        model.method_25852(modelId, textureMap, generator.field_22831);
        return modelId;
    }
}

