/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import com.westerosblocks.utils.ModProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class CropBlockExporter
extends BaseBlockExporter {
    private static class_4942 createCropStageModel(boolean tinted) {
        return CropBlockExporter.createTintedModel(tinted, "crop", class_4945.field_22999);
    }

    private static class_4944 createCropTextureMap(String texture) {
        return new class_4944().method_25868(class_4945.field_22999, CropBlockExporter.createBlockIdentifier(texture));
    }

    public static void registerCropBlock(class_4910 generator, class_2248 block, boolean tinted, List<StateTexture> stateTextures) {
        Object blockStateProperty = null;
        for (class_2769 property : block.method_9595().method_11659()) {
            if (!(property instanceof ModProperties.StateProperty)) continue;
            ModProperties.StateProperty stateProperty = (ModProperties.StateProperty)property;
            if (!"state".equals(property.method_11899())) continue;
            blockStateProperty = stateProperty;
            break;
        }
        if (blockStateProperty == null) {
            throw new IllegalStateException("Block " + String.valueOf(block) + " does not have a STATE property defined");
        }
        List<String> stateIDs = stateTextures.stream().map(st -> st.stateID).toList();
        Collection<String> blockStateValues = blockStateProperty.method_11898();
        for (String stateID : stateIDs) {
            if (blockStateValues.contains(stateID)) continue;
            throw new IllegalStateException("State '" + stateID + "' is not defined in block's STATE property");
        }
        class_4926.class_4927 variantMap = class_4926.method_25783((class_2769)blockStateProperty);
        ArrayList modelIds = new ArrayList();
        for (StateTexture stateTexture : stateTextures) {
            if (stateTexture.randomTextures.size() > 1) {
                ArrayList<class_2960> stateModelIds = new ArrayList<class_2960>();
                for (int j = 0; j < stateTexture.randomTextures.size(); ++j) {
                    String texture = stateTexture.randomTextures.get(j);
                    class_4944 textureMap = CropBlockExporter.createCropTextureMap(texture);
                    class_2960 modelId2 = CropBlockExporter.uploadModel(CropBlockExporter.createCropStageModel(tinted), block, stateTexture.stateID + "_v" + (j + 1), textureMap, generator.field_22831);
                    stateModelIds.add(modelId2);
                }
                List variants = stateModelIds.stream().map(modelId -> class_4935.method_25824().method_25828(class_4936.field_22887, modelId)).collect(Collectors.toList());
                variantMap.method_25794((Comparable)((Object)stateTexture.stateID), variants);
                modelIds.addAll(stateModelIds);
                continue;
            }
            String texture = stateTexture.randomTextures.get(0);
            class_4944 textureMap = CropBlockExporter.createCropTextureMap(texture);
            class_2960 modelId3 = CropBlockExporter.uploadModel(CropBlockExporter.createCropStageModel(tinted), block, stateTexture.stateID, textureMap, generator.field_22831);
            modelIds.add(modelId3);
            variantMap.method_25793((Comparable)((Object)stateTexture.stateID), CropBlockExporter.createVariant(modelId3));
        }
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variantMap));
        CropBlockExporter.registerParentedItemModel(generator, block, (class_2960)modelIds.get(0));
    }

    public static void registerCropBlockSimple(class_4910 generator, class_2248 block, boolean tinted, List<String> textures) {
        ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
        for (int i = 0; i < textures.size(); ++i) {
            class_4944 textureMap = CropBlockExporter.createCropTextureMap(textures.get(i));
            class_2960 modelId = CropBlockExporter.uploadModel(CropBlockExporter.createCropStageModel(tinted), block, "v" + (i + 1), textureMap, generator.field_22831);
            modelIds.add(modelId);
        }
        List<class_4935> variants = modelIds.stream().map(BaseBlockExporter::createVariant).collect(Collectors.toList());
        generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0])));
        CropBlockExporter.registerParentedItemModel(generator, block, (class_2960)modelIds.get(0));
    }

    public static void registerCustomCropBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        boolean tinted;
        boolean bl = tinted = definition.isTinted() || definition.hasColorMult();
        if (definition.hasStates()) {
            ArrayList<StateTexture> stateTextures = new ArrayList<StateTexture>();
            for (BlockDefinition.StateVariant stateDefinition : definition.getStates()) {
                String stateID = stateDefinition.getStateID();
                ArrayList<String> textures = new ArrayList<String>();
                if ((stateDefinition.getTextures() == null || stateDefinition.getTextures().isEmpty()) && stateDefinition.hasRandomTextures()) {
                    for (BlockDefinition.RandomTextureVariant randomVariant : stateDefinition.getRandomTextures()) {
                        if (randomVariant.getTextures() == null || randomVariant.getTextures().isEmpty()) continue;
                        textures.addAll(randomVariant.getTextures());
                    }
                } else if (stateDefinition.getTextures() != null && !stateDefinition.getTextures().isEmpty()) {
                    textures.addAll(stateDefinition.getTextures());
                }
                if (!textures.isEmpty()) {
                    stateTextures.add(new StateTexture(stateID, textures));
                    continue;
                }
                WesterosBlocks.LOGGER.warn("Crop block '{}' state '{}' has no textures", (Object)definition.getBlockName(), (Object)stateID);
            }
            if (!stateTextures.isEmpty()) {
                CropBlockExporter.registerCropBlock(generator, block, tinted, stateTextures);
            }
        } else {
            ArrayList<String> textures = new ArrayList<String>();
            if (definition.getTextures() != null && !definition.getTextures().isEmpty()) {
                textures.addAll(definition.getTextures());
            }
            if (textures.isEmpty() && definition.hasRandomTextures()) {
                for (BlockDefinition.RandomTextureVariant randomVariant : definition.getRandomTextures()) {
                    if (randomVariant.getTextures() == null || randomVariant.getTextures().isEmpty()) continue;
                    textures.addAll(randomVariant.getTextures());
                }
            }
            if (!textures.isEmpty()) {
                CropBlockExporter.registerCropBlockSimple(generator, block, tinted, textures);
            } else {
                WesterosBlocks.LOGGER.warn("Crop block '{}' has no states, textures, or random textures defined", (Object)definition.getBlockName());
            }
        }
    }

    public static class StateTexture {
        public final String stateID;
        public final List<String> randomTextures;

        public StateTexture(String stateID, List<String> randomTextures) {
            this.stateID = stateID;
            this.randomTextures = randomTextures;
        }
    }
}

