/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCPlantBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class CrossBlockExporter
extends BaseBlockExporter {
    public static void generateCross(class_4910 generator, class_2248 block, String texturePath, boolean isTinted, int rotationCount) {
        class_2960 modelId = CrossBlockExporter.createCrossModel(generator, block, texturePath, isTinted);
        if (rotationCount == 1) {
            class_4935 variant = CrossBlockExporter.createVariant(modelId);
            generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)variant));
        } else {
            class_4935[] variants = new class_4935[rotationCount];
            for (int rotation = 0; rotation < rotationCount; ++rotation) {
                variants[rotation] = CrossBlockExporter.createVariant(modelId, rotation * 90);
            }
            generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])variants));
        }
        generator.method_25623(block, modelId);
    }

    public static void generateCrossWithRandomTextures(class_4910 generator, class_2248 block, String[] texturePaths, boolean isTinted, int rotationCount) {
        if (texturePaths.length == 0) {
            throw new IllegalArgumentException("At least one texture path is required");
        }
        String blockName = CrossBlockExporter.getBlockName(block);
        class_4935[] allVariants = new class_4935[texturePaths.length * rotationCount];
        int variantIndex = 0;
        class_2960 firstModelId = null;
        for (int textureIndex = 0; textureIndex < texturePaths.length; ++textureIndex) {
            String texturePath = texturePaths[textureIndex];
            class_2960 nestedModelId = WesterosBlocks.id("block/" + blockName + "/" + blockName + "_v" + (textureIndex + 1));
            class_2960 modelId = CrossBlockExporter.createCrossModelWithId(generator, nestedModelId, texturePath, isTinted);
            if (firstModelId == null) {
                firstModelId = modelId;
            }
            for (int rotation = 0; rotation < rotationCount; ++rotation) {
                allVariants[variantIndex] = rotation == 0 ? CrossBlockExporter.createVariant(modelId) : CrossBlockExporter.createVariant(modelId, rotation * 90);
                ++variantIndex;
            }
        }
        generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])allVariants));
        generator.method_25623(block, firstModelId);
    }

    private static class_2960 createCrossModel(class_4910 generator, class_2248 block, String texturePath, boolean isTinted) {
        class_2960 modelId = CrossBlockExporter.createModelId(block);
        return CrossBlockExporter.createCrossModelWithId(generator, modelId, texturePath, isTinted);
    }

    private static class_2960 createCrossModelWithId(class_4910 generator, class_2960 modelId, String texturePath, boolean isTinted) {
        String parentPath = isTinted ? "block/tinted/cross" : "block/untinted/cross";
        class_2960 textureId = CrossBlockExporter.createBlockIdentifier(texturePath);
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23025, textureId);
        class_4942 model = new class_4942(Optional.of(WesterosBlocks.id(parentPath)), Optional.empty(), new class_4945[]{class_4945.field_23025});
        model.method_25852(modelId, textureMap, generator.field_22831);
        return modelId;
    }

    public static void generateLayerSensitiveCrossWithRandomTextures(class_4910 generator, class_2248 block, String[] texturePaths, boolean isTinted, int rotationCount) {
        class_2960 modelId;
        if (texturePaths.length == 0) {
            throw new IllegalArgumentException("At least one texture path is required");
        }
        if (!(block instanceof WCPlantBlock) || !((WCPlantBlock)block).isLayerSensitive()) {
            CrossBlockExporter.generateCrossWithRandomTextures(generator, block, texturePaths, isTinted, rotationCount);
            return;
        }
        String blockName = CrossBlockExporter.getBlockName(block);
        class_2960[][] layerTextureModels = new class_2960[9][texturePaths.length];
        for (int layer = 1; layer <= 8; ++layer) {
            for (int textureIndex = 0; textureIndex < texturePaths.length; ++textureIndex) {
                Object layerSuffix = layer == 8 ? "" : "_layer" + layer;
                String textureSuffix = "_v" + (textureIndex + 1);
                Object parentPath = layer == 8 ? (isTinted ? "block/tinted/cross" : "block/untinted/cross") : (isTinted ? "block/tinted/cross_layer" + layer : "block/untinted/cross_layer" + layer);
                modelId = WesterosBlocks.id("block/" + blockName + "/base" + (String)layerSuffix + textureSuffix);
                class_2960 textureId = CrossBlockExporter.createBlockIdentifier(texturePaths[textureIndex]);
                class_4944 textureMap = new class_4944().method_25868(class_4945.field_23025, textureId);
                class_4942 model = new class_4942(Optional.of(WesterosBlocks.id((String)parentPath)), Optional.empty(), new class_4945[]{class_4945.field_23025});
                model.method_25852(modelId, textureMap, generator.field_22831);
                layerTextureModels[layer][textureIndex] = modelId;
            }
        }
        class_4926.class_4927 layerMap = class_4926.method_25783((class_2769)class_2741.field_12536);
        for (int layer = 1; layer <= 8; ++layer) {
            class_4935[] allVariantsForLayer = new class_4935[texturePaths.length * rotationCount];
            int variantIndex = 0;
            for (int textureIndex = 0; textureIndex < texturePaths.length; ++textureIndex) {
                modelId = layerTextureModels[layer][textureIndex];
                for (int rotation = 0; rotation < rotationCount; ++rotation) {
                    class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId);
                    if (rotation > 0) {
                        variant = variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.valueOf((String)("R" + rotation * 90)));
                    }
                    allVariantsForLayer[variantIndex] = variant;
                    ++variantIndex;
                }
            }
            layerMap.method_25794((Comparable)Integer.valueOf(layer), Arrays.asList(allVariantsForLayer));
        }
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)layerMap));
        generator.method_25623(block, layerTextureModels[8][0]);
    }

    public static void generateLayerSensitiveCross(class_4910 generator, class_2248 block, String texturePath, boolean isTinted, int rotationCount) {
        if (!(block instanceof WCPlantBlock) || !((WCPlantBlock)block).isLayerSensitive()) {
            CrossBlockExporter.generateCross(generator, block, texturePath, isTinted, rotationCount);
            return;
        }
        String blockName = CrossBlockExporter.getBlockName(block);
        class_2960[] layerModels = new class_2960[9];
        for (int layer = 1; layer <= 8; ++layer) {
            String layerSuffix = "_layer" + layer;
            Object parentPath = layer == 8 ? (isTinted ? "block/tinted/cross" : "block/untinted/cross") : (isTinted ? "block/tinted/cross_layer" + layer : "block/untinted/cross_layer" + layer);
            class_2960 modelId = WesterosBlocks.id("block/" + blockName + "/" + blockName + layerSuffix);
            class_2960 textureId = CrossBlockExporter.createBlockIdentifier(texturePath);
            class_4944 textureMap = new class_4944().method_25868(class_4945.field_23025, textureId);
            class_4942 model = new class_4942(Optional.of(WesterosBlocks.id((String)parentPath)), Optional.empty(), new class_4945[]{class_4945.field_23025});
            model.method_25852(modelId, textureMap, generator.field_22831);
            layerModels[layer] = modelId;
        }
        class_4926.class_4927 layerMap = class_4926.method_25783((class_2769)class_2741.field_12536);
        for (int layer = 1; layer <= 8; ++layer) {
            if (rotationCount == 1) {
                layerMap.method_25793((Comparable)Integer.valueOf(layer), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)layerModels[layer]));
                continue;
            }
            class_4935[] rotationVariants = new class_4935[rotationCount];
            for (int rotation = 0; rotation < rotationCount; ++rotation) {
                class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)layerModels[layer]);
                if (rotation > 0) {
                    variant = variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.valueOf((String)("R" + rotation * 90)));
                }
                rotationVariants[rotation] = variant;
            }
            layerMap.method_25794((Comparable)Integer.valueOf(layer), Arrays.asList(rotationVariants));
        }
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)layerMap));
        generator.method_25623(block, layerModels[8]);
    }

    public static void registerCrossBlockFromDefinition(class_4910 generator, class_2248 block, BlockDefinition definition) {
        boolean isLayerSensitive;
        if (!(definition.getTextures() != null && !definition.getTextures().isEmpty() || definition.getStates() != null && !definition.getStates().isEmpty() || definition.getRandomTextures() != null && !definition.getRandomTextures().isEmpty())) {
            throw new IllegalArgumentException("Cross blocks require textures, states, or randomTextures");
        }
        boolean isTinted = definition.hasColorMult();
        boolean bl = isLayerSensitive = "layerSensitive".equals(definition.getType()) || definition.getType() != null && definition.getType().contains("layerSensitive");
        if (definition.hasStates()) {
            CrossBlockExporter.handleStatesBasedCrossBlock(generator, block, definition, isTinted, isLayerSensitive);
        } else if (definition.getRandomTextures() != null && !definition.getRandomTextures().isEmpty()) {
            String[] texturePaths = (String[])definition.getRandomTextures().stream().flatMap(randomTexture -> randomTexture.getTextures().stream()).toArray(String[]::new);
            if (isLayerSensitive) {
                CrossBlockExporter.generateLayerSensitiveCrossWithRandomTextures(generator, block, texturePaths, isTinted, 4);
            } else {
                CrossBlockExporter.generateCrossWithRandomTextures(generator, block, texturePaths, isTinted, 4);
            }
        } else {
            String texturePath = definition.getTextures().get(0);
            if (isLayerSensitive) {
                CrossBlockExporter.generateLayerSensitiveCross(generator, block, texturePath, isTinted, 1);
            } else {
                CrossBlockExporter.generateCross(generator, block, texturePath, isTinted, 1);
            }
        }
    }

    private static void handleStatesBasedCrossBlock(class_4910 generator, class_2248 block, BlockDefinition definition, boolean isTinted, boolean isLayerSensitive) {
        for (BlockDefinition.StateVariant state : definition.getStates()) {
            if ("random".equals(state.getStateID()) && state.hasRandomTextures()) {
                String[] texturePaths = (String[])state.getRandomTextures().stream().flatMap(randomTexture -> randomTexture.getTextures().stream()).toArray(String[]::new);
                if (isLayerSensitive) {
                    CrossBlockExporter.generateLayerSensitiveCrossWithRandomTextures(generator, block, texturePaths, isTinted, 4);
                } else {
                    CrossBlockExporter.generateCrossWithRandomTextures(generator, block, texturePaths, isTinted, 4);
                }
                return;
            }
            if (state.getTextures() == null || state.getTextures().isEmpty()) continue;
            String texturePath = state.getTextures().get(0);
            if (isLayerSensitive) {
                CrossBlockExporter.generateLayerSensitiveCross(generator, block, texturePath, isTinted, 1);
            } else {
                CrossBlockExporter.generateCross(generator, block, texturePath, isTinted, 1);
            }
            return;
        }
        if (definition.getTextures() != null && !definition.getTextures().isEmpty()) {
            String texturePath = definition.getTextures().get(0);
            if (isLayerSensitive) {
                CrossBlockExporter.generateLayerSensitiveCross(generator, block, texturePath, isTinted, 1);
            } else {
                CrossBlockExporter.generateCross(generator, block, texturePath, isTinted, 1);
            }
        }
    }
}

