/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCCuboidNEBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import com.westerosblocks.datagen.custom.CuboidBlockExporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4943;
import net.minecraft.class_4944;

public class CuboidNEBlockExporter
extends BaseBlockExporter {
    public static void registerCustomCuboidNEBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        if (!(block instanceof WCCuboidNEBlock)) {
            throw new IllegalArgumentException("Block must be a WCCuboidNEBlock instance");
        }
        WCCuboidNEBlock cuboidBlock = (WCCuboidNEBlock)block;
        BlockDefinition.TextureSource source = definition.getPrimaryTextureSource();
        switch (source) {
            case STATES: {
                CuboidNEBlockExporter.registerCuboidNEBlockWithStates(generator, block, definition, cuboidBlock);
                break;
            }
            case RANDOM_TEXTURES: {
                CuboidNEBlockExporter.registerCuboidNEBlockWithRandomTextures(generator, block, definition, cuboidBlock);
                break;
            }
            case TEXTURES: {
                CuboidNEBlockExporter.registerSimpleCuboidNEBlock(generator, block, definition, cuboidBlock);
                break;
            }
            case CUSTOM_MODEL: {
                CuboidNEBlockExporter.registerCustomModelCuboidNEBlock(generator, block, definition, cuboidBlock);
                break;
            }
            case NONE: {
                CuboidNEBlockExporter.registerFallbackCuboidNEBlock(generator, block, definition, cuboidBlock);
            }
        }
    }

    private static void registerSimpleCuboidNEBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidNEBlock cuboidBlock) {
        class_2960 modelId;
        List<String> textures = definition.getTextures();
        if (definition.hasCustomModel()) {
            modelId = CuboidNEBlockExporter.createCustomModelId(block, "base_v1");
        } else if (CuboidNEBlockExporter.hasCuboids(definition) && textures != null && !textures.isEmpty()) {
            modelId = CuboidNEBlockExporter.createCuboidModel(generator, block, definition, textures, 0, "base_v1");
        } else if (textures != null && !textures.isEmpty()) {
            textureMap = CuboidNEBlockExporter.createCuboidTextureMap(textures);
            modelId = textures.size() == 1 ? class_4943.field_22972.method_25852(CuboidNEBlockExporter.createGeneratedModelId(block, "base_v1"), textureMap, generator.field_22831) : class_4943.field_22942.method_25852(CuboidNEBlockExporter.createGeneratedModelId(block, "base_v1"), textureMap, generator.field_22831);
        } else {
            textureMap = class_4944.method_25875((class_2960)CuboidNEBlockExporter.createBlockIdentifier("missing"));
            modelId = class_4943.field_22972.method_25852(CuboidNEBlockExporter.createGeneratedModelId(block, "base_v1"), textureMap, generator.field_22831);
        }
        class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNEBlock.FACING).method_25793((Comparable)class_2350.field_11034, CuboidNEBlockExporter.createVariant(modelId, 0)).method_25793((Comparable)class_2350.field_11043, CuboidNEBlockExporter.createVariant(modelId, 90));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        CuboidNEBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    private static void registerCuboidNEBlockWithRandomTextures(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidNEBlock cuboidBlock) {
        List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
        ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
        for (int i = 0; i < randomTextures.size(); ++i) {
            class_2960 modelId;
            BlockDefinition.RandomTextureVariant variant = randomTextures.get(i);
            List<String> textures = variant.getTextures();
            if (definition.hasCustomModel()) {
                modelId = CuboidNEBlockExporter.createCustomModelId(block, "base_v" + (i + 1));
            } else if (CuboidNEBlockExporter.hasCuboids(definition)) {
                modelId = CuboidNEBlockExporter.createCuboidModel(generator, block, definition, textures, i, "base_v" + (i + 1));
            } else {
                class_4944 textureMap = CuboidNEBlockExporter.createCuboidTextureMap(textures);
                modelId = textures.size() == 1 ? class_4943.field_22972.method_25852(CuboidNEBlockExporter.createGeneratedModelId(block, "base_v" + (i + 1)), textureMap, generator.field_22831) : class_4943.field_22942.method_25852(CuboidNEBlockExporter.createGeneratedModelId(block, "base_v" + (i + 1)), textureMap, generator.field_22831);
            }
            modelIds.add(modelId);
        }
        ArrayList<class_4935> eastVariants = new ArrayList<class_4935>();
        for (int i = 0; i < modelIds.size(); ++i) {
            BlockDefinition.RandomTextureVariant rtv = randomTextures.get(i);
            int weight = rtv.getWeight();
            for (int w = 0; w < weight; ++w) {
                eastVariants.add(CuboidNEBlockExporter.createVariant((class_2960)modelIds.get(i), 0));
            }
        }
        ArrayList<class_4935> northVariants = new ArrayList<class_4935>();
        for (int i = 0; i < modelIds.size(); ++i) {
            BlockDefinition.RandomTextureVariant rtv = randomTextures.get(i);
            int weight = rtv.getWeight();
            for (int w = 0; w < weight; ++w) {
                northVariants.add(CuboidNEBlockExporter.createVariant((class_2960)modelIds.get(i), 90));
            }
        }
        class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNEBlock.FACING).method_25794((Comparable)class_2350.field_11034, eastVariants).method_25794((Comparable)class_2350.field_11043, northVariants);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        CuboidNEBlockExporter.registerParentedItemModel(generator, block, (class_2960)modelIds.get(0));
    }

    private static void registerCuboidNEBlockWithStates(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidNEBlock cuboidBlock) {
        List<BlockDefinition.StateVariant> states = definition.getStates();
        ArrayList allModelIds = new ArrayList();
        HashMap<String, List<class_2960>> stateModelMap = new HashMap<String, List<class_2960>>();
        class_2960 firstModelId = null;
        for (int stateIdx = 0; stateIdx < states.size(); ++stateIdx) {
            class_2960 modelId;
            String stateId;
            BlockDefinition.StateVariant state = states.get(stateIdx);
            String string = stateId = state.getStateID() != null ? state.getStateID() : "base";
            if (state.hasRandomTextures()) {
                List<BlockDefinition.RandomTextureVariant> randomTextures = state.getRandomTextures();
                ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
                for (int i = 0; i < randomTextures.size(); ++i) {
                    List<String> textures = randomTextures.get(i).getTextures();
                    class_2960 modelId2 = CuboidNEBlockExporter.createCuboidModel(generator, block, definition, textures, i, stateId + "_v" + (i + 1));
                    modelIds.add(modelId2);
                    if (firstModelId != null) continue;
                    firstModelId = modelId2;
                }
                stateModelMap.put(stateId, modelIds);
                allModelIds.addAll(modelIds);
                continue;
            }
            if (state.isCustomModel() || definition.hasCustomModel()) {
                modelId = CuboidNEBlockExporter.createCustomModelId(block, stateId + "_v1");
            } else {
                List<String> textures = state.getTextures() != null ? state.getTextures() : definition.getTextures();
                modelId = textures != null && !textures.isEmpty() ? CuboidNEBlockExporter.createCuboidModel(generator, block, definition, textures, 0, stateId + "_v1") : CuboidNEBlockExporter.createCustomModelId(block, stateId + "_v1");
            }
            if (firstModelId == null) {
                firstModelId = modelId;
            }
            stateModelMap.put(stateId, List.of(modelId));
            allModelIds.add(modelId);
        }
        generator.field_22830.accept(CuboidNEBlockExporter.createAdvancedNEStatesBlockState(block, definition, stateModelMap, states));
        CuboidNEBlockExporter.registerParentedItemModel(generator, block, firstModelId);
    }

    private static void registerCustomModelCuboidNEBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidNEBlock cuboidBlock) {
        class_2960 modelId = CuboidNEBlockExporter.createCustomModelId(block, "base_v1");
        class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNEBlock.FACING).method_25793((Comparable)class_2350.field_11034, CuboidNEBlockExporter.createVariant(modelId, 0)).method_25793((Comparable)class_2350.field_11043, CuboidNEBlockExporter.createVariant(modelId, 90));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        CuboidNEBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    private static void registerFallbackCuboidNEBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidNEBlock cuboidBlock) {
        class_2960 modelId = CuboidNEBlockExporter.createGeneratedModelId(block, "base_v1");
        class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNEBlock.FACING).method_25793((Comparable)class_2350.field_11034, CuboidNEBlockExporter.createVariant(modelId, 0)).method_25793((Comparable)class_2350.field_11043, CuboidNEBlockExporter.createVariant(modelId, 90));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        CuboidNEBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    private static boolean hasCuboids(BlockDefinition definition) {
        return CuboidBlockExporter.hasCuboids(definition);
    }

    private static class_2960 createCuboidModel(class_4910 generator, class_2248 block, BlockDefinition definition, List<String> textures, int index, String variant) {
        return CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, index, variant);
    }

    private static class_4944 createCuboidTextureMap(List<String> textures) {
        return CuboidBlockExporter.createCuboidTextureMap(textures);
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = CuboidNEBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/custom/" + blockName + "/" + variant);
    }

    private static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = CuboidNEBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/generated/" + blockName + "/" + variant);
    }

    private static class_4917 createAdvancedNEStatesBlockState(final class_2248 block, BlockDefinition definition, final Map<String, List<class_2960>> stateModelMap, final List<BlockDefinition.StateVariant> states) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (int i = 0; i < states.size(); ++i) {
                    BlockDefinition.StateVariant state = (BlockDefinition.StateVariant)states.get(i);
                    String stateId = state.getStateID() != null ? state.getStateID() : "base";
                    List modelIds = (List)stateModelMap.get(stateId);
                    if (modelIds == null || modelIds.isEmpty()) continue;
                    if (state.hasRandomTextures()) {
                        List<BlockDefinition.RandomTextureVariant> randomTextures = state.getRandomTextures();
                        JsonArray eastVariants = new JsonArray();
                        for (int j = 0; j < modelIds.size() && j < randomTextures.size(); ++j) {
                            int weight = randomTextures.get(j).getWeight();
                            for (int w = 0; w < weight; ++w) {
                                JsonObject variant = new JsonObject();
                                variant.addProperty("model", ((class_2960)modelIds.get(j)).toString());
                                eastVariants.add((JsonElement)variant);
                            }
                        }
                        variants.add("facing=east,state=" + stateId, (JsonElement)eastVariants);
                        JsonArray northVariants = new JsonArray();
                        for (int j = 0; j < modelIds.size() && j < randomTextures.size(); ++j) {
                            int weight = randomTextures.get(j).getWeight();
                            for (int w = 0; w < weight; ++w) {
                                JsonObject variant = new JsonObject();
                                variant.addProperty("model", ((class_2960)modelIds.get(j)).toString());
                                variant.addProperty("y", (Number)90);
                                northVariants.add((JsonElement)variant);
                            }
                        }
                        variants.add("facing=north,state=" + stateId, (JsonElement)northVariants);
                        continue;
                    }
                    class_2960 modelId = (class_2960)modelIds.get(0);
                    JsonObject eastVariant = new JsonObject();
                    eastVariant.addProperty("model", modelId.toString());
                    variants.add("facing=east,state=" + stateId, (JsonElement)eastVariant);
                    JsonObject northVariant = new JsonObject();
                    northVariant.addProperty("model", modelId.toString());
                    northVariant.addProperty("y", (Number)90);
                    variants.add("facing=north,state=" + stateId, (JsonElement)northVariant);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }
}

