/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCCuboidNSEWBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import com.westerosblocks.datagen.custom.CuboidBlockExporter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class CuboidNSEWBlockExporter
extends BaseBlockExporter {
    private static final String[] FACING_DIRECTIONS = new String[]{"north", "east", "south", "west"};
    private static final int[] ROTATIONS = new int[]{0, 90, 180, 270};

    public static void registerCustomCuboidNSEWBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        if (!(block instanceof WCCuboidNSEWBlock)) {
            throw new IllegalArgumentException("Block must be a WCCuboidNSEWBlock instance");
        }
        WCCuboidNSEWBlock cuboidBlock = (WCCuboidNSEWBlock)block;
        BlockDefinition.TextureSource source = definition.getPrimaryTextureSource();
        switch (source) {
            case STATES: {
                CuboidNSEWBlockExporter.registerCuboidNSEWBlockWithStates(generator, block, definition, cuboidBlock);
                break;
            }
            case RANDOM_TEXTURES: {
                CuboidNSEWBlockExporter.registerCuboidNSEWBlockWithRandomTextures(generator, block, definition, cuboidBlock);
                break;
            }
            case TEXTURES: {
                CuboidNSEWBlockExporter.registerSimpleCuboidNSEWBlock(generator, block, definition, cuboidBlock);
                break;
            }
            case CUSTOM_MODEL: {
                CuboidNSEWBlockExporter.registerCustomModelCuboidNSEWBlock(generator, block, definition, cuboidBlock);
                break;
            }
            case NONE: {
                CuboidNSEWBlockExporter.registerFallbackCuboidNSEWBlock(generator, block, definition, cuboidBlock);
            }
        }
    }

    private static void registerSimpleCuboidNSEWBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidNSEWBlock cuboidBlock) {
        class_2960 modelId;
        List<String> textures = definition.getTextures();
        if (definition.hasCustomModel()) {
            modelId = CuboidNSEWBlockExporter.createCustomModelId(block, "base_v1");
        } else if (CuboidNSEWBlockExporter.hasCuboids(definition)) {
            modelId = CuboidNSEWBlockExporter.createCuboidModel(generator, block, definition, textures, 0, "base_v1");
        } else {
            class_4944 textureMap = CuboidNSEWBlockExporter.createCuboidTextureMap(textures);
            modelId = textures != null && textures.size() == 1 ? class_4943.field_22972.method_25852(CuboidNSEWBlockExporter.createGeneratedModelId(block, "base_v1"), textureMap, generator.field_22831) : class_4943.field_22942.method_25852(CuboidNSEWBlockExporter.createGeneratedModelId(block, "base_v1"), textureMap, generator.field_22831);
        }
        class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNSEWBlock.FACING).method_25793((Comparable)class_2350.field_11043, CuboidNSEWBlockExporter.createVariant(modelId, 0)).method_25793((Comparable)class_2350.field_11034, CuboidNSEWBlockExporter.createVariant(modelId, 90)).method_25793((Comparable)class_2350.field_11035, CuboidNSEWBlockExporter.createVariant(modelId, 180)).method_25793((Comparable)class_2350.field_11039, CuboidNSEWBlockExporter.createVariant(modelId, 270));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        CuboidNSEWBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    private static void registerCuboidNSEWBlockWithRandomTextures(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidNSEWBlock cuboidBlock) {
        List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
        ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
        for (int i = 0; i < randomTextures.size(); ++i) {
            class_2960 modelId;
            BlockDefinition.RandomTextureVariant variant = randomTextures.get(i);
            List<String> textures = variant.getTextures();
            if (definition.hasCustomModel()) {
                modelId = CuboidNSEWBlockExporter.createCustomModelId(block, "base_v" + (i + 1));
            } else if (CuboidNSEWBlockExporter.hasCuboids(definition)) {
                modelId = CuboidNSEWBlockExporter.createCuboidModel(generator, block, definition, textures, i, "base_v" + (i + 1));
            } else {
                class_4944 textureMap = CuboidNSEWBlockExporter.createCuboidTextureMap(textures);
                modelId = class_4943.field_22942.method_25852(CuboidNSEWBlockExporter.createGeneratedModelId(block, "base_v" + (i + 1)), textureMap, generator.field_22831);
            }
            modelIds.add(modelId);
        }
        List<class_4935> northVariants = modelIds.stream().map(id -> CuboidNSEWBlockExporter.createVariant(id, 0)).toList();
        List<class_4935> eastVariants = modelIds.stream().map(id -> CuboidNSEWBlockExporter.createVariant(id, 90)).toList();
        List<class_4935> southVariants = modelIds.stream().map(id -> CuboidNSEWBlockExporter.createVariant(id, 180)).toList();
        List<class_4935> westVariants = modelIds.stream().map(id -> CuboidNSEWBlockExporter.createVariant(id, 270)).toList();
        class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNSEWBlock.FACING).method_25794((Comparable)class_2350.field_11043, northVariants).method_25794((Comparable)class_2350.field_11034, eastVariants).method_25794((Comparable)class_2350.field_11035, southVariants).method_25794((Comparable)class_2350.field_11039, westVariants);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        if (!modelIds.isEmpty()) {
            CuboidNSEWBlockExporter.registerParentedItemModel(generator, block, (class_2960)modelIds.get(0));
        }
    }

    private static void registerCuboidNSEWBlockWithStates(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidNSEWBlock cuboidBlock) {
        List<BlockDefinition.StateVariant> states = definition.getStates();
        ArrayList<class_2960> allModelIds = new ArrayList<class_2960>();
        for (int i = 0; i < states.size(); ++i) {
            class_2960 modelId;
            Object stateId;
            BlockDefinition.StateVariant state = states.get(i);
            Object object = stateId = state.getStateID() != null ? state.getStateID() : "state" + i;
            if (state.getRandomTextures() != null && !state.getRandomTextures().isEmpty()) {
                List<BlockDefinition.RandomTextureVariant> randomTextures = state.getRandomTextures();
                for (int j = 0; j < randomTextures.size(); ++j) {
                    class_2960 modelId2;
                    BlockDefinition.RandomTextureVariant variant = randomTextures.get(j);
                    List<String> textures = variant.getTextures();
                    String variantName = (String)stateId + "_v" + (j + 1);
                    if (definition.hasCustomModel()) {
                        modelId2 = CuboidNSEWBlockExporter.createCustomModelId(block, variantName);
                    } else if (CuboidNSEWBlockExporter.hasCuboids(definition)) {
                        modelId2 = textures != null && !textures.isEmpty() ? CuboidNSEWBlockExporter.createCuboidModel(generator, block, definition, textures, j, variantName) : CuboidNSEWBlockExporter.createGeneratedModelId(block, variantName);
                    } else {
                        class_4944 textureMap = CuboidNSEWBlockExporter.createCuboidTextureMap(textures);
                        modelId2 = class_4943.field_22942.method_25852(CuboidNSEWBlockExporter.createGeneratedModelId(block, variantName), textureMap, generator.field_22831);
                    }
                    allModelIds.add(modelId2);
                }
                continue;
            }
            List<String> textures = state.getTextures();
            String variantName = (String)stateId + "_v1";
            if (definition.hasCustomModel()) {
                modelId = CuboidNSEWBlockExporter.createCustomModelId(block, variantName);
            } else if (CuboidNSEWBlockExporter.hasCuboids(definition)) {
                modelId = textures != null && !textures.isEmpty() ? CuboidNSEWBlockExporter.createCuboidModel(generator, block, definition, textures, i, variantName) : CuboidNSEWBlockExporter.createGeneratedModelId(block, variantName);
            } else {
                class_4944 textureMap = CuboidNSEWBlockExporter.createCuboidTextureMap(textures);
                modelId = class_4943.field_22942.method_25852(CuboidNSEWBlockExporter.createGeneratedModelId(block, variantName), textureMap, generator.field_22831);
            }
            allModelIds.add(modelId);
        }
        generator.field_22830.accept(CuboidNSEWBlockExporter.createAdvancedNSEWStatesBlockState(block, definition, allModelIds));
        if (!allModelIds.isEmpty()) {
            CuboidNSEWBlockExporter.registerParentedItemModel(generator, block, (class_2960)allModelIds.get(0));
        }
    }

    private static void registerCustomModelCuboidNSEWBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidNSEWBlock cuboidBlock) {
        if (definition.hasRandomTextures()) {
            List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
            ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
            for (int i = 0; i < randomTextures.size(); ++i) {
                if (definition.hasCustomModel()) {
                    class_2960 modelId = CuboidNSEWBlockExporter.createCustomModelId(block, "base_v" + (i + 1));
                    modelIds.add(modelId);
                    continue;
                }
                BlockDefinition.RandomTextureVariant variant = randomTextures.get(i);
                List<String> textures = variant.getTextures();
                if (textures == null || textures.isEmpty()) {
                    textures = List.of("missing");
                }
                class_2960 modelId = CuboidNSEWBlockExporter.createCuboidModel(generator, block, definition, textures, i, "base_v" + (i + 1));
                modelIds.add(modelId);
            }
            if (definition.hasRotateRandom()) {
                ArrayList<class_4935> allVariants = new ArrayList<class_4935>();
                for (class_2960 modelId : modelIds) {
                    allVariants.add(CuboidNSEWBlockExporter.createVariant(modelId, 0));
                    allVariants.add(CuboidNSEWBlockExporter.createVariant(modelId, 90));
                    allVariants.add(CuboidNSEWBlockExporter.createVariant(modelId, 180));
                    allVariants.add(CuboidNSEWBlockExporter.createVariant(modelId, 270));
                }
                class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNSEWBlock.FACING).method_25794((Comparable)class_2350.field_11043, allVariants).method_25794((Comparable)class_2350.field_11034, allVariants).method_25794((Comparable)class_2350.field_11035, allVariants).method_25794((Comparable)class_2350.field_11039, allVariants);
                generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
            } else {
                List<class_4935> northVariants = modelIds.stream().map(id -> CuboidNSEWBlockExporter.createVariant(id, 0)).toList();
                List<class_4935> eastVariants = modelIds.stream().map(id -> CuboidNSEWBlockExporter.createVariant(id, 90)).toList();
                List<class_4935> southVariants = modelIds.stream().map(id -> CuboidNSEWBlockExporter.createVariant(id, 180)).toList();
                List<class_4935> westVariants = modelIds.stream().map(id -> CuboidNSEWBlockExporter.createVariant(id, 270)).toList();
                class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNSEWBlock.FACING).method_25794((Comparable)class_2350.field_11043, northVariants).method_25794((Comparable)class_2350.field_11034, eastVariants).method_25794((Comparable)class_2350.field_11035, southVariants).method_25794((Comparable)class_2350.field_11039, westVariants);
                generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
            }
            if (!modelIds.isEmpty()) {
                CuboidNSEWBlockExporter.registerParentedItemModel(generator, block, (class_2960)modelIds.get(0));
            }
        } else {
            class_2960 modelId;
            if (definition.hasCustomModel()) {
                modelId = CuboidNSEWBlockExporter.createCustomModelId(block, "base_v1");
            } else {
                List<String> fallbackTextures = List.of("missing");
                modelId = CuboidNSEWBlockExporter.createCuboidModel(generator, block, definition, fallbackTextures, 0, "base_v1");
            }
            class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNSEWBlock.FACING).method_25793((Comparable)class_2350.field_11043, CuboidNSEWBlockExporter.createVariant(modelId, 0)).method_25793((Comparable)class_2350.field_11034, CuboidNSEWBlockExporter.createVariant(modelId, 90)).method_25793((Comparable)class_2350.field_11035, CuboidNSEWBlockExporter.createVariant(modelId, 180)).method_25793((Comparable)class_2350.field_11039, CuboidNSEWBlockExporter.createVariant(modelId, 270));
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
            CuboidNSEWBlockExporter.registerParentedItemModel(generator, block, modelId);
        }
    }

    private static void registerFallbackCuboidNSEWBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidNSEWBlock cuboidBlock) {
        String defaultTexture = "missing";
        List<String> fallbackTextures = List.of(defaultTexture);
        class_4944 textureMap = CuboidNSEWBlockExporter.createCuboidTextureMap(fallbackTextures);
        class_2960 modelId = class_4943.field_22972.method_25852(CuboidNSEWBlockExporter.createGeneratedModelId(block, "base_v1"), textureMap, generator.field_22831);
        class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNSEWBlock.FACING).method_25793((Comparable)class_2350.field_11043, CuboidNSEWBlockExporter.createVariant(modelId, 0)).method_25793((Comparable)class_2350.field_11034, CuboidNSEWBlockExporter.createVariant(modelId, 90)).method_25793((Comparable)class_2350.field_11035, CuboidNSEWBlockExporter.createVariant(modelId, 180)).method_25793((Comparable)class_2350.field_11039, CuboidNSEWBlockExporter.createVariant(modelId, 270));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        CuboidNSEWBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    private static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = CuboidNSEWBlockExporter.getBlockName(block);
        String modelPath = "block/" + blockName + "/" + variant;
        return WesterosBlocks.id(modelPath);
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = CuboidNSEWBlockExporter.getBlockName(block);
        String modelPath = "block/custom/" + blockName + "/" + variant;
        return WesterosBlocks.id(modelPath);
    }

    private static boolean hasCuboids(BlockDefinition definition) {
        return definition.getCuboids() != null && !definition.getCuboids().isEmpty() || definition.hasBoundingBox();
    }

    private static class_4944 createCuboidTextureMap(List<String> textures) {
        class_4944 textureMap = new class_4944();
        if (textures == null || textures.isEmpty()) {
            String fallbackTexture = "missing";
            class_2960 fallbackId = CuboidNSEWBlockExporter.createBlockIdentifier(fallbackTexture);
            textureMap.method_25868(class_4945.field_23024, fallbackId);
            textureMap.method_25868(class_4945.field_23023, fallbackId);
            textureMap.method_25868(class_4945.field_23019, fallbackId);
            textureMap.method_25868(class_4945.field_23020, fallbackId);
            textureMap.method_25868(class_4945.field_23022, fallbackId);
            textureMap.method_25868(class_4945.field_23021, fallbackId);
            textureMap.method_25868(class_4945.field_23012, fallbackId);
            return textureMap;
        }
        int textureCount = textures.size();
        class_4945[] faceKeys = new class_4945[]{class_4945.field_23024, class_4945.field_23023, class_4945.field_23019, class_4945.field_23020, class_4945.field_23022, class_4945.field_23021};
        for (int i = 0; i < 6; ++i) {
            String texture = i < textureCount ? textures.get(i) : textures.get(textureCount - 1);
            textureMap.method_25868(faceKeys[i], CuboidNSEWBlockExporter.createBlockIdentifier(texture));
        }
        textureMap.method_25868(class_4945.field_23012, CuboidNSEWBlockExporter.createBlockIdentifier(textures.get(0)));
        return textureMap;
    }

    private static class_2960 createCuboidModel(class_4910 generator, class_2248 block, BlockDefinition definition, List<String> textures, int stateIndex, String variant) {
        return CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, stateIndex, variant);
    }

    private static class_4917 createAdvancedNSEWStatesBlockState(class_2248 block, BlockDefinition definition, List<class_2960> modelIds) {
        if (modelIds.isEmpty()) {
            return CuboidNSEWBlockExporter.createSimpleBlockState(block, WesterosBlocks.id("block/missing"));
        }
        if (!definition.hasStates()) {
            class_2960 modelId = modelIds.get(0);
            class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCCuboidNSEWBlock.FACING).method_25793((Comparable)class_2350.field_11043, CuboidNSEWBlockExporter.createVariant(modelId, 0)).method_25793((Comparable)class_2350.field_11034, CuboidNSEWBlockExporter.createVariant(modelId, 90)).method_25793((Comparable)class_2350.field_11035, CuboidNSEWBlockExporter.createVariant(modelId, 180)).method_25793((Comparable)class_2350.field_11039, CuboidNSEWBlockExporter.createVariant(modelId, 270));
            return class_4925.method_25769((class_2248)block).method_25775((class_4926)variants);
        }
        List<BlockDefinition.StateVariant> states = definition.getStates();
        return CuboidNSEWBlockExporter.createAdvancedNSEWStatesBlockStateCustom(block, definition, modelIds);
    }

    private static class_4917 createAdvancedNSEWStatesBlockStateCustom(final class_2248 block, final BlockDefinition definition, final List<class_2960> modelIds) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                List<BlockDefinition.StateVariant> states = definition.getStates();
                for (int i = 0; i < states.size() && i < modelIds.size(); ++i) {
                    BlockDefinition.StateVariant state = states.get(i);
                    Object stateValue = state.getStateID() != null ? state.getStateID() : "state" + i;
                    class_2960 modelId = (class_2960)modelIds.get(i);
                    JsonObject northVariant = new JsonObject();
                    northVariant.addProperty("model", modelId.toString());
                    variants.add("facing=north,state=" + (String)stateValue, (JsonElement)northVariant);
                    JsonObject eastVariant = new JsonObject();
                    eastVariant.addProperty("model", modelId.toString());
                    eastVariant.addProperty("y", (Number)90);
                    variants.add("facing=east,state=" + (String)stateValue, (JsonElement)eastVariant);
                    JsonObject southVariant = new JsonObject();
                    southVariant.addProperty("model", modelId.toString());
                    southVariant.addProperty("y", (Number)180);
                    variants.add("facing=south,state=" + (String)stateValue, (JsonElement)southVariant);
                    JsonObject westVariant = new JsonObject();
                    westVariant.addProperty("model", modelId.toString());
                    westVariant.addProperty("y", (Number)270);
                    variants.add("facing=west,state=" + (String)stateValue, (JsonElement)westVariant);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }
}

