/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class FenceGateBlockExporter
extends BaseBlockExporter {
    private static class_4942 createFenceGateModel(boolean tinted) {
        return FenceGateBlockExporter.createTintedModel(tinted, "template_fence_gate", class_4945.field_23011, class_4945.field_23012);
    }

    private static class_4942 createFenceGateOpenModel(boolean tinted) {
        return FenceGateBlockExporter.createTintedModel(tinted, "template_fence_gate_open", class_4945.field_23011, class_4945.field_23012);
    }

    private static class_4942 createFenceGateWallModel(boolean tinted) {
        return FenceGateBlockExporter.createTintedModel(tinted, "template_fence_gate_wall", class_4945.field_23011, class_4945.field_23012);
    }

    private static class_4942 createFenceGateWallOpenModel(boolean tinted) {
        return FenceGateBlockExporter.createTintedModel(tinted, "template_fence_gate_wall_open", class_4945.field_23011, class_4945.field_23012);
    }

    private static class_4944 createFenceGateTextureMap(String texture) {
        return new class_4944().method_25868(class_4945.field_23011, FenceGateBlockExporter.createBlockIdentifier(texture)).method_25868(class_4945.field_23012, FenceGateBlockExporter.createBlockIdentifier(texture));
    }

    private static class_4926 createFenceGateVariants(class_2960 gateModelId, class_2960 gateOpenModelId, class_2960 gateWallModelId, class_2960 gateWallOpenModelId) {
        return class_4926.method_25785((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12537, (class_2769)class_2741.field_12491).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createVariant(gateModelId, 270)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createVariant(gateWallModelId, 270)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createVariant(gateOpenModelId, 270)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createVariant(gateWallOpenModelId, 270)).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createVariant(gateModelId, 180)).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createVariant(gateWallModelId, 180)).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createVariant(gateOpenModelId, 180)).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createVariant(gateWallOpenModelId, 180)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createVariant(gateModelId, 0)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createVariant(gateWallModelId, 0)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createVariant(gateOpenModelId, 0)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createVariant(gateWallOpenModelId, 0)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createVariant(gateModelId, 90)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createVariant(gateWallModelId, 90)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createVariant(gateOpenModelId, 90)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createVariant(gateWallOpenModelId, 90));
    }

    public static void registerFenceGateBlock(class_4910 generator, class_2248 block, boolean tinted, String texture) {
        class_4944 textureMap = FenceGateBlockExporter.createFenceGateTextureMap(texture);
        class_2960 gateModelId = FenceGateBlockExporter.uploadModel(FenceGateBlockExporter.createFenceGateModel(tinted), block, "gate", textureMap, generator.field_22831);
        class_2960 gateOpenModelId = FenceGateBlockExporter.uploadModel(FenceGateBlockExporter.createFenceGateOpenModel(tinted), block, "gate_open", textureMap, generator.field_22831);
        class_2960 gateWallModelId = FenceGateBlockExporter.uploadModel(FenceGateBlockExporter.createFenceGateWallModel(tinted), block, "gate_wall", textureMap, generator.field_22831);
        class_2960 gateWallOpenModelId = FenceGateBlockExporter.uploadModel(FenceGateBlockExporter.createFenceGateWallOpenModel(tinted), block, "gate_wall_open", textureMap, generator.field_22831);
        class_4926 variants = FenceGateBlockExporter.createFenceGateVariants(gateModelId, gateOpenModelId, gateWallModelId, gateWallOpenModelId);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(variants));
        class_2960 itemModelId = class_2960.method_60655((String)"westerosblocks", (String)("item/" + FenceGateBlockExporter.getBlockName(block)));
        FenceGateBlockExporter.createFenceGateModel(tinted).method_25852(itemModelId, textureMap, generator.field_22831);
    }

    public static void registerFenceGateBlockWithRandomTextures(class_4910 generator, class_2248 block, boolean tinted, List<TextureVariant> textureVariants) {
        BaseBlockExporter.ModelRegistry gateRegistry = new BaseBlockExporter.ModelRegistry();
        BaseBlockExporter.ModelRegistry gateOpenRegistry = new BaseBlockExporter.ModelRegistry();
        BaseBlockExporter.ModelRegistry gateWallRegistry = new BaseBlockExporter.ModelRegistry();
        BaseBlockExporter.ModelRegistry gateWallOpenRegistry = new BaseBlockExporter.ModelRegistry();
        for (int i = 0; i < textureVariants.size(); ++i) {
            TextureVariant variant = textureVariants.get(i);
            class_4944 textureMap = FenceGateBlockExporter.createFenceGateTextureMap(variant.texture);
            gateRegistry.add(FenceGateBlockExporter.uploadModel(FenceGateBlockExporter.createFenceGateModel(tinted), block, "gate_v" + (i + 1), textureMap, generator.field_22831), variant.weight);
            gateOpenRegistry.add(FenceGateBlockExporter.uploadModel(FenceGateBlockExporter.createFenceGateOpenModel(tinted), block, "gate_open_v" + (i + 1), textureMap, generator.field_22831), variant.weight);
            gateWallRegistry.add(FenceGateBlockExporter.uploadModel(FenceGateBlockExporter.createFenceGateWallModel(tinted), block, "gate_wall_v" + (i + 1), textureMap, generator.field_22831), variant.weight);
            gateWallOpenRegistry.add(FenceGateBlockExporter.uploadModel(FenceGateBlockExporter.createFenceGateWallOpenModel(tinted), block, "gate_wall_open_v" + (i + 1), textureMap, generator.field_22831), variant.weight);
        }
        generator.field_22830.accept(FenceGateBlockExporter.createFenceGateBlockstateWithRandomTextures(block, gateRegistry.getModelIds(), gateOpenRegistry.getModelIds(), gateWallRegistry.getModelIds(), gateWallOpenRegistry.getModelIds(), gateRegistry.getWeights()));
        class_4944 itemTextureMap = FenceGateBlockExporter.createFenceGateTextureMap(textureVariants.get((int)0).texture);
        class_2960 itemModelId = class_2960.method_60655((String)"westerosblocks", (String)("item/" + FenceGateBlockExporter.getBlockName(block)));
        FenceGateBlockExporter.createFenceGateModel(tinted).method_25852(itemModelId, itemTextureMap, generator.field_22831);
    }

    private static class_4925 createFenceGateBlockstateWithRandomTextures(class_2248 block, List<class_2960> gateIds, List<class_2960> gateOpenIds, List<class_2960> gateWallIds, List<class_2960> gateWallOpenIds, List<Integer> weights) {
        return class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25785((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12537, (class_2769)class_2741.field_12491).method_25807((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createWeightedVariants(gateIds, weights, 270)).method_25807((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createWeightedVariants(gateWallIds, weights, 270)).method_25807((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createWeightedVariants(gateOpenIds, weights, 270)).method_25807((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createWeightedVariants(gateWallOpenIds, weights, 270)).method_25807((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createWeightedVariants(gateIds, weights, 180)).method_25807((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createWeightedVariants(gateWallIds, weights, 180)).method_25807((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createWeightedVariants(gateOpenIds, weights, 180)).method_25807((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createWeightedVariants(gateWallOpenIds, weights, 180)).method_25807((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createWeightedVariants(gateIds, weights, 0)).method_25807((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createWeightedVariants(gateWallIds, weights, 0)).method_25807((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createWeightedVariants(gateOpenIds, weights, 0)).method_25807((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createWeightedVariants(gateWallOpenIds, weights, 0)).method_25807((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createWeightedVariants(gateIds, weights, 90)).method_25807((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createWeightedVariants(gateWallIds, weights, 90)).method_25807((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), FenceGateBlockExporter.createWeightedVariants(gateOpenIds, weights, 90)).method_25807((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), FenceGateBlockExporter.createWeightedVariants(gateWallOpenIds, weights, 90)));
    }

    public static void registerCustomFenceGateBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        List<String> textureList = definition.getTextures();
        if (definition.hasRandomTextures()) {
            ArrayList<TextureVariant> textureVariants = new ArrayList<TextureVariant>();
            List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
            for (BlockDefinition.RandomTextureVariant randomTexture : randomTextures) {
                List<String> textures = randomTexture.getTextures();
                int weight = randomTexture.getWeight();
                if (textures != null && !textures.isEmpty()) {
                    textureVariants.add(new TextureVariant(weight, textures.get(0)));
                    continue;
                }
                textureVariants.add(new TextureVariant(weight, "missingno"));
            }
            FenceGateBlockExporter.registerFenceGateBlockWithRandomTextures(generator, block, tinted, textureVariants);
        } else if (textureList != null && !textureList.isEmpty()) {
            FenceGateBlockExporter.registerFenceGateBlock(generator, block, tinted, textureList.get(0));
        } else {
            FenceGateBlockExporter.registerFenceGateBlock(generator, block, tinted, "missingno");
        }
    }

    public static class TextureVariant {
        public final int weight;
        public final String texture;

        public TextureVariant(int weight, String texture) {
            this.weight = weight;
            this.texture = texture;
        }
    }
}

