/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCLayerBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;

public class LayerBlockExporter
extends BaseBlockExporter {
    public static void registerCustomLayerBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        if (!(block instanceof WCLayerBlock)) {
            throw new IllegalArgumentException("Block must be a WCLayerBlock instance");
        }
        WCLayerBlock layerBlock = (WCLayerBlock)block;
        BlockDefinition.TextureSource source = definition.getPrimaryTextureSource();
        switch (source) {
            case RANDOM_TEXTURES: {
                LayerBlockExporter.registerLayerBlockWithRandomTextures(generator, block, definition, layerBlock);
                break;
            }
            case TEXTURES: {
                LayerBlockExporter.registerSimpleLayerBlock(generator, block, definition, layerBlock);
                break;
            }
            case CUSTOM_MODEL: {
                LayerBlockExporter.registerCustomModelLayerBlock(generator, block, definition, layerBlock);
                break;
            }
            case NONE: 
            case STATES: {
                LayerBlockExporter.registerFallbackLayerBlock(generator, block, definition, layerBlock);
            }
        }
    }

    private static void registerSimpleLayerBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCLayerBlock layerBlock) {
        List<String> textures = definition.getTextures();
        HashMap<Integer, class_2960> layerModels = new HashMap<Integer, class_2960>();
        for (int layer = 1; layer <= layerBlock.layerCount; ++layer) {
            class_2960 modelId = definition.hasCustomModel() ? LayerBlockExporter.createCustomModelId(block, "layer" + layer + "_v1") : LayerBlockExporter.generateLayerModel(generator, block, definition, textures, layer, 0, layerBlock);
            layerModels.put(layer, modelId);
        }
        generator.field_22830.accept(LayerBlockExporter.createLayerBlockState(block, layerModels, null));
        LayerBlockExporter.registerParentedItemModel(generator, block, (class_2960)layerModels.get(1));
    }

    private static void registerLayerBlockWithRandomTextures(class_4910 generator, class_2248 block, BlockDefinition definition, WCLayerBlock layerBlock) {
        List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
        HashMap<Integer, List<LayerModelSet>> layerModelSets = new HashMap<Integer, List<LayerModelSet>>();
        for (int layer = 1; layer <= layerBlock.layerCount; ++layer) {
            ArrayList<LayerModelSet> modelSets = new ArrayList<LayerModelSet>();
            for (int i = 0; i < randomTextures.size(); ++i) {
                BlockDefinition.RandomTextureVariant variant = randomTextures.get(i);
                List<String> textures = variant.getTextures();
                class_2960 modelId = definition.hasCustomModel() ? LayerBlockExporter.createCustomModelId(block, "layer" + layer + "_v" + (i + 1)) : LayerBlockExporter.generateLayerModel(generator, block, definition, textures, layer, i, layerBlock);
                modelSets.add(new LayerModelSet(modelId, variant.getWeight()));
            }
            layerModelSets.put(layer, modelSets);
        }
        generator.field_22830.accept(LayerBlockExporter.createLayerBlockStateWithRandomTextures(block, layerModelSets));
        LayerBlockExporter.registerParentedItemModel(generator, block, ((LayerModelSet)((List)layerModelSets.get((Object)Integer.valueOf((int)1))).get((int)0)).model);
    }

    private static void registerCustomModelLayerBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCLayerBlock layerBlock) {
        HashMap<Integer, class_2960> layerModels = new HashMap<Integer, class_2960>();
        for (int layer = 1; layer <= layerBlock.layerCount; ++layer) {
            layerModels.put(layer, LayerBlockExporter.createCustomModelId(block, "layer" + layer + "_v1"));
        }
        generator.field_22830.accept(LayerBlockExporter.createLayerBlockState(block, layerModels, null));
        LayerBlockExporter.registerParentedItemModel(generator, block, (class_2960)layerModels.get(1));
    }

    private static void registerFallbackLayerBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCLayerBlock layerBlock) {
        List<String> fallbackTextures = List.of("missing", "missing", "missing", "missing", "missing", "missing");
        HashMap<Integer, class_2960> layerModels = new HashMap<Integer, class_2960>();
        for (int layer = 1; layer <= layerBlock.layerCount; ++layer) {
            class_2960 modelId = LayerBlockExporter.generateLayerModel(generator, block, definition, fallbackTextures, layer, 0, layerBlock);
            layerModels.put(layer, modelId);
        }
        generator.field_22830.accept(LayerBlockExporter.createLayerBlockState(block, layerModels, null));
        LayerBlockExporter.registerParentedItemModel(generator, block, (class_2960)layerModels.get(1));
    }

    private static class_2960 generateLayerModel(class_4910 generator, class_2248 block, BlockDefinition definition, List<String> textures, int layer, int variantIndex, WCLayerBlock layerBlock) {
        String variantName = "layer" + layer + "_v" + (variantIndex + 1);
        class_2960 modelId = LayerBlockExporter.createGeneratedModelId(block, variantName);
        JsonObject modelJson = new JsonObject();
        modelJson.addProperty("parent", "minecraft:block/thin_block");
        JsonObject texturesJson = new JsonObject();
        int cnt = Math.max(6, textures.size());
        for (int j = 0; j < cnt; ++j) {
            String texture = j < textures.size() ? textures.get(j) : textures.get(textures.size() - 1);
            texturesJson.addProperty("txt" + j, "westerosblocks:block/" + texture);
        }
        texturesJson.addProperty("particle", "westerosblocks:block/" + textures.get(0));
        modelJson.add("textures", (JsonElement)texturesJson);
        float ymax = 16.0f / (float)layerBlock.layerCount * (float)layer;
        JsonArray elements = new JsonArray();
        JsonObject element = new JsonObject();
        JsonArray from = new JsonArray();
        from.add((Number)0);
        from.add((Number)0);
        from.add((Number)0);
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        to.add((Number)16);
        to.add((Number)Float.valueOf(ymax));
        to.add((Number)16);
        element.add("to", (JsonElement)to);
        JsonObject faces = new JsonObject();
        boolean isTinted = definition.isTinted();
        LayerBlockExporter.addLayerFace(faces, "down", 0.0f, 0.0f, 16.0f, 16.0f, "#txt0", "down", isTinted);
        String upCullface = layer >= layerBlock.layerCount ? "up" : null;
        LayerBlockExporter.addLayerFace(faces, "up", 0.0f, 0.0f, 16.0f, 16.0f, "#txt1", upCullface, isTinted);
        LayerBlockExporter.addLayerFace(faces, "north", 0.0f, 16.0f - ymax, 16.0f, 16.0f, "#txt2", "north", isTinted);
        LayerBlockExporter.addLayerFace(faces, "south", 0.0f, 16.0f - ymax, 16.0f, 16.0f, "#txt3", "south", isTinted);
        LayerBlockExporter.addLayerFace(faces, "west", 0.0f, 16.0f - ymax, 16.0f, 16.0f, "#txt4", "west", isTinted);
        LayerBlockExporter.addLayerFace(faces, "east", 0.0f, 16.0f - ymax, 16.0f, 16.0f, "#txt5", "east", isTinted);
        element.add("faces", (JsonElement)faces);
        elements.add((JsonElement)element);
        modelJson.add("elements", (JsonElement)elements);
        generator.field_22831.accept(modelId, () -> modelJson);
        return modelId;
    }

    private static void addLayerFace(JsonObject faces, String direction, float u0, float v0, float u1, float v1, String texture, String cullface, boolean tinted) {
        JsonObject face = new JsonObject();
        JsonArray uv = new JsonArray();
        uv.add((Number)Float.valueOf(u0));
        uv.add((Number)Float.valueOf(v0));
        uv.add((Number)Float.valueOf(u1));
        uv.add((Number)Float.valueOf(v1));
        face.add("uv", (JsonElement)uv);
        face.addProperty("texture", texture);
        if (cullface != null) {
            face.addProperty("cullface", cullface);
        }
        if (tinted) {
            face.addProperty("tintindex", (Number)0);
        }
        faces.add(direction, (JsonElement)face);
    }

    private static class_4917 createLayerBlockState(final class_2248 block, final Map<Integer, class_2960> layerModels, final Map<Integer, Integer> weights) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (Map.Entry entry : layerModels.entrySet()) {
                    int layer = (Integer)entry.getKey();
                    class_2960 modelId = (class_2960)entry.getValue();
                    JsonObject variant = new JsonObject();
                    variant.addProperty("model", modelId.toString());
                    if (weights != null && weights.containsKey(layer)) {
                        variant.addProperty("weight", (Number)weights.get(layer));
                    }
                    variants.add("layers=" + layer, (JsonElement)variant);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createLayerBlockStateWithRandomTextures(final class_2248 block, final Map<Integer, List<LayerModelSet>> layerModelSets) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (Map.Entry entry : layerModelSets.entrySet()) {
                    int layer = (Integer)entry.getKey();
                    List modelSets = (List)entry.getValue();
                    if (modelSets.size() == 1) {
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", ((LayerModelSet)modelSets.get((int)0)).model.toString());
                        variants.add("layers=" + layer, (JsonElement)variant);
                        continue;
                    }
                    JsonArray variantArray = new JsonArray();
                    for (LayerModelSet modelSet : modelSets) {
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", modelSet.model.toString());
                        if (modelSet.weight > 1) {
                            variant.addProperty("weight", (Number)modelSet.weight);
                        }
                        variantArray.add((JsonElement)variant);
                    }
                    variants.add("layers=" + layer, (JsonElement)variantArray);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = LayerBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/custom/" + blockName + "/" + variant);
    }

    private static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = LayerBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/" + blockName + "/" + variant);
    }

    private static class LayerModelSet {
        final class_2960 model;
        final int weight;

        LayerModelSet(class_2960 model, int weight) {
            this.model = model;
            this.weight = weight;
        }
    }
}

