/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCStairBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;

public class StairBlockExporter
extends BaseBlockExporter {
    public static void registerCustomStairBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        if (!(block instanceof WCStairBlock)) {
            throw new IllegalArgumentException("Block must be a WCStairBlock instance");
        }
        WCStairBlock stairBlock = (WCStairBlock)block;
        BlockDefinition.TextureSource source = definition.getPrimaryTextureSource();
        switch (source) {
            case STATES: {
                StairBlockExporter.registerStairBlockWithStates(generator, block, definition, stairBlock);
                break;
            }
            case RANDOM_TEXTURES: {
                StairBlockExporter.registerStairBlockWithRandomTextures(generator, block, definition, stairBlock);
                break;
            }
            case TEXTURES: {
                StairBlockExporter.registerSimpleStairBlock(generator, block, definition, stairBlock);
                break;
            }
            case CUSTOM_MODEL: {
                StairBlockExporter.registerCustomModelStairBlock(generator, block, definition, stairBlock);
                break;
            }
            case NONE: {
                StairBlockExporter.registerFallbackStairBlock(generator, block, definition, stairBlock);
            }
        }
    }

    private static void registerSimpleStairBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCStairBlock stairBlock) {
        class_2960 outerModel;
        class_2960 innerModel;
        class_2960 baseModel;
        List<String> textures = definition.getTextures();
        if (definition.hasCustomModel()) {
            baseModel = StairBlockExporter.createCustomModelId(block, "base_v1");
            innerModel = StairBlockExporter.createCustomModelId(block, "inner_v1");
            outerModel = StairBlockExporter.createCustomModelId(block, "outer_v1");
        } else {
            baseModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "base", 0, null, stairBlock);
            innerModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "inner", 0, null, stairBlock);
            outerModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "outer", 0, null, stairBlock);
        }
        generator.field_22830.accept(StairBlockExporter.createStairBlockState(block, baseModel, innerModel, outerModel, stairBlock.no_uvlock));
        StairBlockExporter.registerParentedItemModel(generator, block, baseModel);
    }

    private static void registerStairBlockWithRandomTextures(class_4910 generator, class_2248 block, BlockDefinition definition, WCStairBlock stairBlock) {
        List<BlockDefinition.TextureVariantSet> variants = definition.getRandomTextureVariantSets();
        ArrayList<StairModelSet> modelSets = new ArrayList<StairModelSet>();
        for (int i = 0; i < variants.size(); ++i) {
            StairModelSet modelSet;
            BlockDefinition.TextureVariantSet variant = variants.get(i);
            List<String> textures = variant.textures;
            if (definition.hasCustomModel()) {
                modelSet = new StairModelSet(StairBlockExporter.createCustomModelId(block, "base_v" + (i + 1)), StairBlockExporter.createCustomModelId(block, "inner_v" + (i + 1)), StairBlockExporter.createCustomModelId(block, "outer_v" + (i + 1)), variant.weight);
            } else {
                class_2960 baseModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "base", i, null, stairBlock);
                class_2960 innerModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "inner", i, null, stairBlock);
                class_2960 outerModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "outer", i, null, stairBlock);
                modelSet = new StairModelSet(baseModel, innerModel, outerModel, variant.weight);
            }
            modelSets.add(modelSet);
        }
        generator.field_22830.accept(StairBlockExporter.createStairBlockStateWithRandomTextures(block, modelSets, stairBlock.no_uvlock));
        StairBlockExporter.registerParentedItemModel(generator, block, ((StairModelSet)modelSets.get((int)0)).base);
    }

    private static void registerStairBlockWithStates(class_4910 generator, class_2248 block, BlockDefinition definition, WCStairBlock stairBlock) {
        List<BlockDefinition.StateVariant> states = definition.getStates();
        HashMap<String, List<StairModelSet>> stateModelMap = new HashMap<String, List<StairModelSet>>();
        class_2960 firstModel = null;
        for (BlockDefinition.StateVariant state : states) {
            String stateId = state.getStateID() != null ? state.getStateID() : "base";
            ArrayList<StairModelSet> modelSets = new ArrayList<StairModelSet>();
            if (state.hasRandomTextures()) {
                List<BlockDefinition.TextureVariantSet> variants = BlockDefinition.getRandomTextureVariantSetsFromState(state);
                for (int i = 0; i < variants.size(); ++i) {
                    BlockDefinition.TextureVariantSet variant = variants.get(i);
                    List<String> textures = variant.textures;
                    class_2960 baseModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "base", i, stateId, stairBlock);
                    class_2960 innerModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "inner", i, stateId, stairBlock);
                    class_2960 outerModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "outer", i, stateId, stairBlock);
                    modelSets.add(new StairModelSet(baseModel, innerModel, outerModel, variant.weight));
                    if (firstModel != null) continue;
                    firstModel = baseModel;
                }
            } else if (state.isCustomModel() || definition.hasCustomModel()) {
                class_2960 baseModel = StairBlockExporter.createCustomModelId(block, stateId + "_base_v1");
                class_2960 innerModel = StairBlockExporter.createCustomModelId(block, stateId + "_inner_v1");
                class_2960 outerModel = StairBlockExporter.createCustomModelId(block, stateId + "_outer_v1");
                modelSets.add(new StairModelSet(baseModel, innerModel, outerModel, 1));
                if (firstModel == null) {
                    firstModel = baseModel;
                }
            } else {
                List<String> textures;
                List<String> list = textures = state.getTextures() != null ? state.getTextures() : definition.getTextures();
                if (textures != null && !textures.isEmpty()) {
                    class_2960 baseModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "base", 0, stateId, stairBlock);
                    class_2960 innerModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "inner", 0, stateId, stairBlock);
                    class_2960 outerModel = StairBlockExporter.generateStairModel(generator, block, definition, textures, "outer", 0, stateId, stairBlock);
                    modelSets.add(new StairModelSet(baseModel, innerModel, outerModel, 1));
                    if (firstModel == null) {
                        firstModel = baseModel;
                    }
                }
            }
            stateModelMap.put(stateId, modelSets);
        }
        generator.field_22830.accept(StairBlockExporter.createStairBlockStateWithStates(block, definition, stateModelMap, states, stairBlock));
        if (firstModel != null) {
            StairBlockExporter.registerParentedItemModel(generator, block, firstModel);
        }
    }

    private static void registerCustomModelStairBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCStairBlock stairBlock) {
        class_2960 baseModel = StairBlockExporter.createCustomModelId(block, "base_v1");
        class_2960 innerModel = StairBlockExporter.createCustomModelId(block, "inner_v1");
        class_2960 outerModel = StairBlockExporter.createCustomModelId(block, "outer_v1");
        generator.field_22830.accept(StairBlockExporter.createStairBlockState(block, baseModel, innerModel, outerModel, stairBlock.no_uvlock));
        StairBlockExporter.registerParentedItemModel(generator, block, baseModel);
    }

    private static void registerFallbackStairBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCStairBlock stairBlock) {
        List<String> fallbackTextures = List.of("missing", "missing", "missing");
        class_2960 baseModel = StairBlockExporter.generateStairModel(generator, block, definition, fallbackTextures, "base", 0, null, stairBlock);
        class_2960 innerModel = StairBlockExporter.generateStairModel(generator, block, definition, fallbackTextures, "inner", 0, null, stairBlock);
        class_2960 outerModel = StairBlockExporter.generateStairModel(generator, block, definition, fallbackTextures, "outer", 0, null, stairBlock);
        generator.field_22830.accept(StairBlockExporter.createStairBlockState(block, baseModel, innerModel, outerModel, stairBlock.no_uvlock));
        StairBlockExporter.registerParentedItemModel(generator, block, baseModel);
    }

    private static class_2960 generateStairModel(class_4910 generator, class_2248 block, BlockDefinition definition, List<String> textures, String type, int variantIndex, String stateId, WCStairBlock stairBlock) {
        String variantName = (String)(stateId != null ? stateId + "_" : "") + type + "_v" + (variantIndex + 1);
        class_2960 modelId = StairBlockExporter.createGeneratedModelId(block, variantName);
        JsonObject modelJson = new JsonObject();
        boolean isOccluded = true;
        boolean isTinted = definition.isTinted();
        boolean hasOverlay = definition.hasOverlay();
        String parentPath = StairBlockExporter.buildStairParentPath(type, isOccluded, isTinted, hasOverlay);
        modelJson.addProperty("parent", parentPath);
        JsonObject texturesJson = new JsonObject();
        String bottomTex = textures.size() > 0 ? textures.get(0) : "missing";
        String topTex = textures.size() > 1 ? textures.get(1) : bottomTex;
        String sideTex = textures.size() > 2 ? textures.get(2) : topTex;
        texturesJson.addProperty("bottom", "westerosblocks:block/" + bottomTex);
        texturesJson.addProperty("top", "westerosblocks:block/" + topTex);
        texturesJson.addProperty("side", "westerosblocks:block/" + sideTex);
        texturesJson.addProperty("particle", "westerosblocks:block/" + sideTex);
        if (hasOverlay && definition.getOverlayTextures() != null) {
            List<String> overlayTextures = definition.getOverlayTextures();
            if (overlayTextures.size() > 0) {
                texturesJson.addProperty("bottom_ov", "westerosblocks:block/" + overlayTextures.get(0));
            }
            if (overlayTextures.size() > 1) {
                texturesJson.addProperty("top_ov", "westerosblocks:block/" + overlayTextures.get(1));
            }
            if (overlayTextures.size() > 2) {
                texturesJson.addProperty("side_ov", "westerosblocks:block/" + overlayTextures.get(2));
            }
        }
        modelJson.add("textures", (JsonElement)texturesJson);
        generator.field_22831.accept(modelId, () -> modelJson);
        return modelId;
    }

    private static String buildStairParentPath(String type, boolean isOccluded, boolean isTinted, boolean hasOverlay) {
        StringBuilder path = new StringBuilder("westerosblocks:block/");
        if (isOccluded) {
            path.append(isTinted ? "tinted/" : "untinted/");
        } else {
            path.append(isTinted ? "tintednoocclusion/" : "noocclusion/");
        }
        switch (type) {
            case "inner": {
                path.append("inner_stairs");
                break;
            }
            case "outer": {
                path.append("outer_stairs");
                break;
            }
            default: {
                path.append("stairs");
            }
        }
        if (hasOverlay) {
            path.append("_overlay");
        }
        return path.toString();
    }

    private static class_4917 createStairBlockState(final class_2248 block, final class_2960 baseModel, final class_2960 innerModel, final class_2960 outerModel, final boolean noUvlock) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                StairBlockExporter.addStairVariants(variants, baseModel, innerModel, outerModel, noUvlock);
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createStairBlockStateWithRandomTextures(final class_2248 block, final List<StairModelSet> modelSets, final boolean noUvlock) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                StairBlockExporter.addStairVariantsWithWeights(variants, modelSets, noUvlock);
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createStairBlockStateWithStates(final class_2248 block, BlockDefinition definition, final Map<String, List<StairModelSet>> stateModelMap, final List<BlockDefinition.StateVariant> states, final WCStairBlock stairBlock) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (BlockDefinition.StateVariant state : states) {
                    String stateId = state.getStateID() != null ? state.getStateID() : "base";
                    List modelSets = (List)stateModelMap.get(stateId);
                    if (modelSets == null || modelSets.isEmpty()) continue;
                    StairBlockExporter.addStairVariantsWithState(variants, modelSets, stateId, stairBlock.no_uvlock);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static void addStairVariants(JsonObject variants, class_2960 baseModel, class_2960 innerModel, class_2960 outerModel, boolean noUvlock) {
        StairBlockExporter.addVariant(variants, "facing=east,half=bottom,shape=straight", baseModel, 0, 0, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=west,half=bottom,shape=straight", baseModel, 0, 180, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=south,half=bottom,shape=straight", baseModel, 0, 90, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=north,half=bottom,shape=straight", baseModel, 0, 270, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=east,half=bottom,shape=outer_right", outerModel, 0, 0, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=west,half=bottom,shape=outer_right", outerModel, 0, 180, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=south,half=bottom,shape=outer_right", outerModel, 0, 90, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=north,half=bottom,shape=outer_right", outerModel, 0, 270, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=east,half=bottom,shape=outer_left", outerModel, 0, 270, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=west,half=bottom,shape=outer_left", outerModel, 0, 90, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=south,half=bottom,shape=outer_left", outerModel, 0, 0, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=north,half=bottom,shape=outer_left", outerModel, 0, 180, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=east,half=bottom,shape=inner_right", innerModel, 0, 0, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=west,half=bottom,shape=inner_right", innerModel, 0, 180, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=south,half=bottom,shape=inner_right", innerModel, 0, 90, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=north,half=bottom,shape=inner_right", innerModel, 0, 270, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=east,half=bottom,shape=inner_left", innerModel, 0, 270, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=west,half=bottom,shape=inner_left", innerModel, 0, 90, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=south,half=bottom,shape=inner_left", innerModel, 0, 0, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=north,half=bottom,shape=inner_left", innerModel, 0, 180, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=east,half=top,shape=straight", baseModel, 180, 0, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=west,half=top,shape=straight", baseModel, 180, 180, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=south,half=top,shape=straight", baseModel, 180, 90, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=north,half=top,shape=straight", baseModel, 180, 270, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=east,half=top,shape=outer_right", outerModel, 180, 90, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=west,half=top,shape=outer_right", outerModel, 180, 270, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=south,half=top,shape=outer_right", outerModel, 180, 180, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=north,half=top,shape=outer_right", outerModel, 180, 0, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=east,half=top,shape=outer_left", outerModel, 180, 0, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=west,half=top,shape=outer_left", outerModel, 180, 180, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=south,half=top,shape=outer_left", outerModel, 180, 90, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=north,half=top,shape=outer_left", outerModel, 180, 270, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=east,half=top,shape=inner_right", innerModel, 180, 90, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=west,half=top,shape=inner_right", innerModel, 180, 270, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=south,half=top,shape=inner_right", innerModel, 180, 180, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=north,half=top,shape=inner_right", innerModel, 180, 0, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=east,half=top,shape=inner_left", innerModel, 180, 0, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=west,half=top,shape=inner_left", innerModel, 180, 180, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=south,half=top,shape=inner_left", innerModel, 180, 90, noUvlock);
        StairBlockExporter.addVariant(variants, "facing=north,half=top,shape=inner_left", innerModel, 180, 270, noUvlock);
    }

    private static void addVariant(JsonObject variants, String condition, class_2960 model, int x, int y, boolean noUvlock) {
        JsonObject variant = new JsonObject();
        variant.addProperty("model", model.toString());
        if (x != 0) {
            variant.addProperty("x", (Number)x);
        }
        if (y != 0) {
            variant.addProperty("y", (Number)y);
        }
        if (!(noUvlock || x == 0 && y == 0)) {
            variant.addProperty("uvlock", Boolean.valueOf(true));
        }
        variants.add(condition, (JsonElement)variant);
    }

    private static void addStairVariantsWithWeights(JsonObject variants, List<StairModelSet> modelSets, boolean noUvlock) {
        StairBlockExporter.addWeightedVariant(variants, "facing=east,half=bottom,shape=straight", modelSets, "base", 0, 0, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=west,half=bottom,shape=straight", modelSets, "base", 0, 180, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=south,half=bottom,shape=straight", modelSets, "base", 0, 90, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=north,half=bottom,shape=straight", modelSets, "base", 0, 270, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=east,half=bottom,shape=outer_right", modelSets, "outer", 0, 0, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=west,half=bottom,shape=outer_right", modelSets, "outer", 0, 180, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=south,half=bottom,shape=outer_right", modelSets, "outer", 0, 90, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=north,half=bottom,shape=outer_right", modelSets, "outer", 0, 270, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=east,half=bottom,shape=outer_left", modelSets, "outer", 0, 270, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=west,half=bottom,shape=outer_left", modelSets, "outer", 0, 90, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=south,half=bottom,shape=outer_left", modelSets, "outer", 0, 0, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=north,half=bottom,shape=outer_left", modelSets, "outer", 0, 180, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=east,half=bottom,shape=inner_right", modelSets, "inner", 0, 0, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=west,half=bottom,shape=inner_right", modelSets, "inner", 0, 180, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=south,half=bottom,shape=inner_right", modelSets, "inner", 0, 90, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=north,half=bottom,shape=inner_right", modelSets, "inner", 0, 270, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=east,half=bottom,shape=inner_left", modelSets, "inner", 0, 270, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=west,half=bottom,shape=inner_left", modelSets, "inner", 0, 90, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=south,half=bottom,shape=inner_left", modelSets, "inner", 0, 0, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=north,half=bottom,shape=inner_left", modelSets, "inner", 0, 180, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=east,half=top,shape=straight", modelSets, "base", 180, 0, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=west,half=top,shape=straight", modelSets, "base", 180, 180, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=south,half=top,shape=straight", modelSets, "base", 180, 90, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=north,half=top,shape=straight", modelSets, "base", 180, 270, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=east,half=top,shape=outer_right", modelSets, "outer", 180, 90, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=west,half=top,shape=outer_right", modelSets, "outer", 180, 270, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=south,half=top,shape=outer_right", modelSets, "outer", 180, 180, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=north,half=top,shape=outer_right", modelSets, "outer", 180, 0, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=east,half=top,shape=outer_left", modelSets, "outer", 180, 0, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=west,half=top,shape=outer_left", modelSets, "outer", 180, 180, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=south,half=top,shape=outer_left", modelSets, "outer", 180, 90, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=north,half=top,shape=outer_left", modelSets, "outer", 180, 270, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=east,half=top,shape=inner_right", modelSets, "inner", 180, 90, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=west,half=top,shape=inner_right", modelSets, "inner", 180, 270, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=south,half=top,shape=inner_right", modelSets, "inner", 180, 180, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=north,half=top,shape=inner_right", modelSets, "inner", 180, 0, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=east,half=top,shape=inner_left", modelSets, "inner", 180, 0, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=west,half=top,shape=inner_left", modelSets, "inner", 180, 180, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=south,half=top,shape=inner_left", modelSets, "inner", 180, 90, noUvlock);
        StairBlockExporter.addWeightedVariant(variants, "facing=north,half=top,shape=inner_left", modelSets, "inner", 180, 270, noUvlock);
    }

    private static void addWeightedVariant(JsonObject variants, String condition, List<StairModelSet> modelSets, String modelType, int x, int y, boolean noUvlock) {
        JsonArray variantArray = new JsonArray();
        for (StairModelSet modelSet : modelSets) {
            JsonObject variant = new JsonObject();
            class_2960 model = switch (modelType) {
                case "inner" -> modelSet.inner;
                case "outer" -> modelSet.outer;
                default -> modelSet.base;
            };
            variant.addProperty("model", model.toString());
            if (x != 0) {
                variant.addProperty("x", (Number)x);
            }
            if (y != 0) {
                variant.addProperty("y", (Number)y);
            }
            if (!(noUvlock || x == 0 && y == 0)) {
                variant.addProperty("uvlock", Boolean.valueOf(true));
            }
            if (modelSet.weight > 1) {
                variant.addProperty("weight", (Number)modelSet.weight);
            }
            variantArray.add((JsonElement)variant);
        }
        variants.add(condition, (JsonElement)variantArray);
    }

    private static void addStairVariantsWithState(JsonObject variants, List<StairModelSet> modelSets, String stateId, boolean noUvlock) {
        StairBlockExporter.addStateVariant(variants, stateId, "facing=east,half=bottom,shape=straight", modelSets, "base", 0, 0, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=west,half=bottom,shape=straight", modelSets, "base", 0, 180, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=south,half=bottom,shape=straight", modelSets, "base", 0, 90, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=north,half=bottom,shape=straight", modelSets, "base", 0, 270, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=east,half=bottom,shape=outer_right", modelSets, "outer", 0, 0, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=west,half=bottom,shape=outer_right", modelSets, "outer", 0, 180, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=south,half=bottom,shape=outer_right", modelSets, "outer", 0, 90, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=north,half=bottom,shape=outer_right", modelSets, "outer", 0, 270, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=east,half=bottom,shape=outer_left", modelSets, "outer", 0, 270, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=west,half=bottom,shape=outer_left", modelSets, "outer", 0, 90, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=south,half=bottom,shape=outer_left", modelSets, "outer", 0, 0, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=north,half=bottom,shape=outer_left", modelSets, "outer", 0, 180, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=east,half=bottom,shape=inner_right", modelSets, "inner", 0, 0, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=west,half=bottom,shape=inner_right", modelSets, "inner", 0, 180, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=south,half=bottom,shape=inner_right", modelSets, "inner", 0, 90, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=north,half=bottom,shape=inner_right", modelSets, "inner", 0, 270, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=east,half=bottom,shape=inner_left", modelSets, "inner", 0, 270, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=west,half=bottom,shape=inner_left", modelSets, "inner", 0, 90, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=south,half=bottom,shape=inner_left", modelSets, "inner", 0, 0, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=north,half=bottom,shape=inner_left", modelSets, "inner", 0, 180, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=east,half=top,shape=straight", modelSets, "base", 180, 0, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=west,half=top,shape=straight", modelSets, "base", 180, 180, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=south,half=top,shape=straight", modelSets, "base", 180, 90, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=north,half=top,shape=straight", modelSets, "base", 180, 270, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=east,half=top,shape=outer_right", modelSets, "outer", 180, 90, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=west,half=top,shape=outer_right", modelSets, "outer", 180, 270, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=south,half=top,shape=outer_right", modelSets, "outer", 180, 180, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=north,half=top,shape=outer_right", modelSets, "outer", 180, 0, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=east,half=top,shape=outer_left", modelSets, "outer", 180, 0, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=west,half=top,shape=outer_left", modelSets, "outer", 180, 180, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=south,half=top,shape=outer_left", modelSets, "outer", 180, 90, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=north,half=top,shape=outer_left", modelSets, "outer", 180, 270, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=east,half=top,shape=inner_right", modelSets, "inner", 180, 90, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=west,half=top,shape=inner_right", modelSets, "inner", 180, 270, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=south,half=top,shape=inner_right", modelSets, "inner", 180, 180, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=north,half=top,shape=inner_right", modelSets, "inner", 180, 0, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=east,half=top,shape=inner_left", modelSets, "inner", 180, 0, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=west,half=top,shape=inner_left", modelSets, "inner", 180, 180, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=south,half=top,shape=inner_left", modelSets, "inner", 180, 90, noUvlock);
        StairBlockExporter.addStateVariant(variants, stateId, "facing=north,half=top,shape=inner_left", modelSets, "inner", 180, 270, noUvlock);
    }

    private static void addStateVariant(JsonObject variants, String stateId, String condition, List<StairModelSet> modelSets, String modelType, int x, int y, boolean noUvlock) {
        String fullCondition = "state=" + stateId + "," + condition;
        if (modelSets.size() == 1) {
            StairModelSet modelSet = modelSets.get(0);
            class_2960 model = switch (modelType) {
                case "inner" -> modelSet.inner;
                case "outer" -> modelSet.outer;
                default -> modelSet.base;
            };
            JsonObject variant = new JsonObject();
            variant.addProperty("model", model.toString());
            if (x != 0) {
                variant.addProperty("x", (Number)x);
            }
            if (y != 0) {
                variant.addProperty("y", (Number)y);
            }
            if (!(noUvlock || x == 0 && y == 0)) {
                variant.addProperty("uvlock", Boolean.valueOf(true));
            }
            variants.add(fullCondition, (JsonElement)variant);
        } else {
            StairBlockExporter.addWeightedVariant(variants, fullCondition, modelSets, modelType, x, y, noUvlock);
        }
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = StairBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/custom/" + blockName + "/" + variant);
    }

    private static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = StairBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/" + blockName + "/" + variant);
    }

    private static class StairModelSet {
        final class_2960 base;
        final class_2960 inner;
        final class_2960 outer;
        final int weight;

        StairModelSet(class_2960 base, class_2960 inner, class_2960 outer, int weight) {
            this.base = base;
            this.inner = inner;
            this.outer = outer;
            this.weight = weight;
        }
    }
}

