/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.providers;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.ModBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.data.BlockDefinitionRegistry;
import com.westerosblocks.datagen.ModBlockStateModelGenerator;
import com.westerosblocks.datagen.custom.BedBlockExporter;
import com.westerosblocks.datagen.custom.CropBlockExporter;
import com.westerosblocks.datagen.custom.CrossBlockExporter;
import com.westerosblocks.datagen.custom.Cuboid16WayBlockExporter;
import com.westerosblocks.datagen.custom.CuboidBlockExporter;
import com.westerosblocks.datagen.custom.CuboidNEBlockExporter;
import com.westerosblocks.datagen.custom.CuboidNSEWBlockExporter;
import com.westerosblocks.datagen.custom.CuboidNSEWStackBlockExporter;
import com.westerosblocks.datagen.custom.CuboidNSEWUDBlockExporter;
import com.westerosblocks.datagen.custom.DoorBlockExporter;
import com.westerosblocks.datagen.custom.FanBlockExporter;
import com.westerosblocks.datagen.custom.FenceBlockExporter;
import com.westerosblocks.datagen.custom.FenceGateBlockExporter;
import com.westerosblocks.datagen.custom.FireBlockExporter;
import com.westerosblocks.datagen.custom.FlowerPotBlockExporter;
import com.westerosblocks.datagen.custom.FurnaceBlockExporter;
import com.westerosblocks.datagen.custom.HalfDoorBlockExporter;
import com.westerosblocks.datagen.custom.LadderBlockExporter;
import com.westerosblocks.datagen.custom.LayerBlockExporter;
import com.westerosblocks.datagen.custom.LeavesBlockExporter;
import com.westerosblocks.datagen.custom.LogBlockExporter;
import com.westerosblocks.datagen.custom.PaneBlockExporter;
import com.westerosblocks.datagen.custom.ParticleEmitterExporter;
import com.westerosblocks.datagen.custom.PlantBlockExporter;
import com.westerosblocks.datagen.custom.RailBlockExporter;
import com.westerosblocks.datagen.custom.SlabBlockExporter;
import com.westerosblocks.datagen.custom.SolidBlockExporter;
import com.westerosblocks.datagen.custom.StairBlockExporter;
import com.westerosblocks.datagen.custom.TorchBlockExporter;
import com.westerosblocks.datagen.custom.TrapDoorBlockExporter;
import com.westerosblocks.datagen.custom.VinesBlockExporter;
import com.westerosblocks.datagen.custom.WallBlockExporter;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_2248;
import net.minecraft.class_4910;
import net.minecraft.class_4915;

public class ModModelProvider
extends FabricModelProvider {
    private final FabricDataOutput output;

    public ModModelProvider(FabricDataOutput output) {
        super(output);
        this.output = output;
    }

    public void generateBlockStateModels(class_4910 bsmg) {
        this.generateModelsFromDefinitions(bsmg);
        ModBlockStateModelGenerator.registerCustomTableBlock(bsmg, ModBlocks.OAK_TABLE).texture("wood/oak/all").build();
        ModBlockStateModelGenerator.registerCustomBranchBlock(bsmg, ModBlocks.OAK_BRANCH).texture("bark/oak/side").build();
        ModBlockStateModelGenerator.registerCustomBranchBlock(bsmg, ModBlocks.BIRCH_BRANCH).texture("bark/birch/side").build();
        ModBlockStateModelGenerator.registerCustomChairBlock(bsmg, ModBlocks.OAK_CHAIR).texture("bark/oak/side").build();
        ModBlockStateModelGenerator.registerCustomArrowSlitBlock(bsmg, ModBlocks.ARBOR_BRICK_ARROW_SLIT).texture("ashlar_third/arbor/all").build();
        ModBlockStateModelGenerator.registerCustomFlowerbedBlock(bsmg, ModBlocks.CLOVER).stemTexture("flowerbed/clover_stem").flowerTexture("flowerbed/clover").build();
        ParticleEmitterExporter.registerCustomParticleEmitterBlock(bsmg, ModBlocks.CASCADE_PARTICLE_EMITTER, "cascade_particle_emitter");
        ParticleEmitterExporter.registerCustomParticleEmitterBlock(bsmg, ModBlocks.COSY_SMOKE_PARTICLE_EMITTER, "cosy_smoke_particle_emitter");
        ParticleEmitterExporter.registerCustomParticleEmitterBlock(bsmg, ModBlocks.SIGNAL_SMOKE_PARTICLE_EMITTER, "signal_smoke_particle_emitter");
    }

    private void generateModelsFromDefinitions(class_4910 bsmg) {
        BlockDefinitionRegistry registry = BlockDefinitionRegistry.getInstance();
        if (!registry.isInitialized()) {
            return;
        }
        for (BlockDefinition definition : registry.getAllDefinitions()) {
            class_2248 block = ModBlocks.getAutoRegisteredBlock(definition.getBlockName());
            if (block == null) continue;
            this.generateModelFromDefinition(bsmg, block, definition);
        }
    }

    private void generateModelFromDefinition(class_4910 bsmg, class_2248 block, BlockDefinition definition) {
        String blockType = definition.getBlockType();
        try {
            switch (blockType.toLowerCase()) {
                case "solid": 
                case "sand": {
                    SolidBlockExporter.registerCustomSolidBlock(bsmg, block, definition);
                    break;
                }
                case "door": {
                    DoorBlockExporter.registerCustomDoorBlock(bsmg, block, definition);
                    break;
                }
                case "trapdoor": {
                    TrapDoorBlockExporter.registerCustomTrapDoorBlock(bsmg, block, definition);
                    break;
                }
                case "log": {
                    LogBlockExporter.registerCustomLogBlock(bsmg, block, definition);
                    break;
                }
                case "plant": {
                    PlantBlockExporter.registerCustomPlantBlock(bsmg, block, definition);
                    break;
                }
                case "flowerpot": {
                    FlowerPotBlockExporter.registerCustomFlowerPotBlock(bsmg, block, definition);
                    break;
                }
                case "web": {
                    CrossBlockExporter.registerCrossBlockFromDefinition(bsmg, block, definition);
                    break;
                }
                case "slab": {
                    SlabBlockExporter.registerCustomSlabBlock(bsmg, block, definition);
                    break;
                }
                case "halfdoor": {
                    HalfDoorBlockExporter.registerCustomHalfDoorBlock(bsmg, block, definition);
                    break;
                }
                case "fire": {
                    FireBlockExporter.registerCustomFireBlock(bsmg, block, definition);
                    break;
                }
                case "ladder": {
                    LadderBlockExporter.registerCustomLadderBlock(bsmg, block, definition);
                    break;
                }
                case "vines": {
                    VinesBlockExporter.registerCustomVinesBlock(bsmg, block, definition);
                    break;
                }
                case "pane": {
                    PaneBlockExporter.registerCustomPaneBlock(bsmg, block, definition);
                    break;
                }
                case "fence": {
                    FenceBlockExporter.registerCustomFenceBlock(bsmg, block, definition);
                    break;
                }
                case "fencegate": {
                    FenceGateBlockExporter.registerCustomFenceGateBlock(bsmg, block, definition);
                    break;
                }
                case "leaves": {
                    LeavesBlockExporter.registerCustomLeavesBlock(bsmg, block, definition);
                    break;
                }
                case "bed": {
                    BedBlockExporter.registerCustomBedBlock(bsmg, block, definition);
                    break;
                }
                case "crop": {
                    CropBlockExporter.registerCustomCropBlock(bsmg, block, definition);
                    break;
                }
                case "torch": {
                    TorchBlockExporter.registerTorchBlockFromDefinition(bsmg, block, definition);
                    break;
                }
                case "fan": {
                    FanBlockExporter.registerFanBlockFromDefinition(bsmg, block, definition);
                    break;
                }
                case "rail": {
                    RailBlockExporter.registerRailBlockFromDefinition(bsmg, block, definition);
                    break;
                }
                case "furnace": {
                    FurnaceBlockExporter.registerCustomFurnaceBlock(bsmg, block, definition);
                    break;
                }
                case "wall": {
                    WallBlockExporter.registerCustomWallBlock(bsmg, block, definition);
                    break;
                }
                case "cuboid": 
                case "beacon": {
                    CuboidBlockExporter.registerCustomCuboidBlock(bsmg, block, definition);
                    break;
                }
                case "cuboid-nsew": {
                    CuboidNSEWBlockExporter.registerCustomCuboidNSEWBlock(bsmg, block, definition);
                    break;
                }
                case "cuboid-nsew-stack": {
                    CuboidNSEWStackBlockExporter.registerCustomCuboidNSEWStackBlock(bsmg, block, definition);
                    break;
                }
                case "cuboid-ne": {
                    CuboidNEBlockExporter.registerCustomCuboidNEBlock(bsmg, block, definition);
                    break;
                }
                case "cuboid-nsewud": {
                    CuboidNSEWUDBlockExporter.registerCustomCuboidNSEWUDBlock(bsmg, block, definition);
                    break;
                }
                case "cuboid-16way": {
                    Cuboid16WayBlockExporter.registerCustomCuboid16WayBlock(bsmg, block, definition);
                    break;
                }
                case "stair": {
                    StairBlockExporter.registerCustomStairBlock(bsmg, block, definition);
                    break;
                }
                case "layer": {
                    LayerBlockExporter.registerCustomLayerBlock(bsmg, block, definition);
                    break;
                }
                default: {
                    WesterosBlocks.LOGGER.warn("Unsupported block type '{}' for model generation: {}", (Object)blockType, (Object)definition.getBlockName());
                    break;
                }
            }
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Error generating model for block '{}': {}", (Object)definition.getBlockName(), (Object)e.getMessage());
        }
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
    }
}

