/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionRegistry;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.entity.ModEntities;
import com.westerosblocks.entity.client.ChairRenderer;
import com.westerosblocks.item.ModItems;
import com.westerosblocks.item.client.ModShieldRenderer;
import mod.azure.azurelib.common.render.item.AzItemRendererRegistry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_7923;

public class WesterosBlocksClient
implements ClientModInitializer {
    public void onInitializeClient() {
        this.applyRenderLayersFromDefinitions();
        EntityRendererRegistry.register(ModEntities.CHAIR, ChairRenderer::new);
        AzItemRendererRegistry.register((class_1792)ModItems.TARGARYEN_HEATER_SHIELD, () -> new ModShieldRenderer(ModItems.TARGARYEN_HEATER_SHIELD.getGeoPath(), ModItems.TARGARYEN_HEATER_SHIELD.getTexPath()));
        AzItemRendererRegistry.register((class_1792)ModItems.BLACKFYRE_HEATER_SHIELD, () -> new ModShieldRenderer(ModItems.BLACKFYRE_HEATER_SHIELD.getGeoPath(), ModItems.BLACKFYRE_HEATER_SHIELD.getTexPath()));
        AzItemRendererRegistry.register((class_1792)ModItems.BLACKWOOD_HEATER_SHIELD, () -> new ModShieldRenderer(ModItems.BLACKWOOD_HEATER_SHIELD.getGeoPath(), ModItems.BLACKWOOD_HEATER_SHIELD.getTexPath()));
        AzItemRendererRegistry.register((class_1792)ModItems.BRACKEN_HEATER_SHIELD, () -> new ModShieldRenderer(ModItems.BRACKEN_HEATER_SHIELD.getGeoPath(), ModItems.BRACKEN_HEATER_SHIELD.getTexPath()));
        AzItemRendererRegistry.register((class_1792)ModItems.TULLY_HEATER_SHIELD, () -> new ModShieldRenderer(ModItems.TULLY_HEATER_SHIELD.getGeoPath(), ModItems.TULLY_HEATER_SHIELD.getTexPath()));
        AzItemRendererRegistry.register((class_1792)ModItems.HEDGE_KNIGHT_HEATER_SHIELD, () -> new ModShieldRenderer(ModItems.HEDGE_KNIGHT_HEATER_SHIELD.getGeoPath(), ModItems.HEDGE_KNIGHT_HEATER_SHIELD.getTexPath()));
        AzItemRendererRegistry.register((class_1792)ModItems.LAUGHING_TREE_HEATER_SHIELD, () -> new ModShieldRenderer(ModItems.LAUGHING_TREE_HEATER_SHIELD.getGeoPath(), ModItems.LAUGHING_TREE_HEATER_SHIELD.getTexPath()));
        AzItemRendererRegistry.register((class_1792)ModItems.GREYJOY_ROUND_SHIELD, () -> new ModShieldRenderer(ModItems.GREYJOY_ROUND_SHIELD.getGeoPath(), ModItems.GREYJOY_ROUND_SHIELD.getTexPath()));
    }

    private void applyRenderLayersFromDefinitions() {
        BlockDefinitionRegistry registry = BlockDefinitionRegistry.getInstance();
        if (!registry.isInitialized()) {
            return;
        }
        for (BlockDefinitionV2 definition : registry.getAllDefinitions()) {
            class_2248 wallBlock;
            class_1921 renderLayer = null;
            if (definition.hasRenderLayer()) {
                renderLayer = this.getRenderLayerFromString(definition.getRenderLayer());
            } else if (definition.isAlphaRender()) {
                renderLayer = class_1921.method_23583();
            }
            if (renderLayer == null) continue;
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(WesterosBlocks.id(definition.getBlockName()));
            BlockRenderLayerMap.INSTANCE.putBlock(block, renderLayer);
            if ("torch".equals(definition.getBlockType())) {
                wallBlock = (class_2248)class_7923.field_41175.method_10223(WesterosBlocks.id("wall_" + definition.getBlockName()));
                BlockRenderLayerMap.INSTANCE.putBlock(wallBlock, renderLayer);
            }
            if (!"fan".equals(definition.getBlockType())) continue;
            wallBlock = (class_2248)class_7923.field_41175.method_10223(WesterosBlocks.id("wall_" + definition.getBlockName()));
            BlockRenderLayerMap.INSTANCE.putBlock(wallBlock, renderLayer);
        }
    }

    private class_1921 getRenderLayerFromString(String renderLayerName) {
        return switch (renderLayerName.toLowerCase()) {
            case "cutout" -> class_1921.method_23581();
            case "translucent" -> class_1921.method_23583();
            case "cutout_mipped" -> class_1921.method_23579();
            default -> null;
        };
    }
}

