/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.WesterosCreativeModeTabs;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.WCArrowSlitBlock;
import com.westerosblocks.block.custom.WCBeaconBlock;
import com.westerosblocks.block.custom.WCBedBlock;
import com.westerosblocks.block.custom.WCBenchBlock;
import com.westerosblocks.block.custom.WCBranchBlock;
import com.westerosblocks.block.custom.WCChairBlock;
import com.westerosblocks.block.custom.WCCropBlock;
import com.westerosblocks.block.custom.WCCuboid16WayBlock;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.block.custom.WCCuboidNEBlock;
import com.westerosblocks.block.custom.WCCuboidNSEWBlock;
import com.westerosblocks.block.custom.WCCuboidNSEWStackBlock;
import com.westerosblocks.block.custom.WCCuboidNSEWUDBlock;
import com.westerosblocks.block.custom.WCDoorBlock;
import com.westerosblocks.block.custom.WCFanBlock;
import com.westerosblocks.block.custom.WCFenceBlock;
import com.westerosblocks.block.custom.WCFenceGateBlock;
import com.westerosblocks.block.custom.WCFireBlock;
import com.westerosblocks.block.custom.WCFlowerPotBlock;
import com.westerosblocks.block.custom.WCFlowerbedBlock;
import com.westerosblocks.block.custom.WCFurnaceBlock;
import com.westerosblocks.block.custom.WCHalfDoorBlock;
import com.westerosblocks.block.custom.WCLadderBlock;
import com.westerosblocks.block.custom.WCLayerBlock;
import com.westerosblocks.block.custom.WCLeavesBlock;
import com.westerosblocks.block.custom.WCLogBlock;
import com.westerosblocks.block.custom.WCMountedBlock;
import com.westerosblocks.block.custom.WCPaneBlock;
import com.westerosblocks.block.custom.WCParticleEmitterBlock;
import com.westerosblocks.block.custom.WCPlantBlock;
import com.westerosblocks.block.custom.WCRailBlock;
import com.westerosblocks.block.custom.WCSandBlock;
import com.westerosblocks.block.custom.WCSlabBlock;
import com.westerosblocks.block.custom.WCSolidBlock;
import com.westerosblocks.block.custom.WCSoulSandBlock;
import com.westerosblocks.block.custom.WCStairBlock;
import com.westerosblocks.block.custom.WCTableBlock;
import com.westerosblocks.block.custom.WCTorchBlock;
import com.westerosblocks.block.custom.WCTrapDoorBlock;
import com.westerosblocks.block.custom.WCVinesBlock;
import com.westerosblocks.block.custom.WCWallBlock;
import com.westerosblocks.block.custom.WCWebBlock;
import com.westerosblocks.data.BlockDefinitionRegistry;
import com.westerosblocks.data.BlockDefinitionV2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ModBlocks {
    private static final Map<String, class_2248> AUTO_REGISTERED_BLOCKS = new HashMap<String, class_2248>();

    private static void registerBlocksFromDefinitions() {
        try {
            BlockDefinitionRegistry registry = BlockDefinitionRegistry.getInstance();
            if (!registry.isInitialized()) {
                WesterosBlocks.LOGGER.warn("BlockDefinitionRegistry not initialized - skipping automatic registration");
                return;
            }
            WesterosBlocks.LOGGER.info("Starting automatic block registration from JSON definitions...");
            int registeredCount = 0;
            int skippedCount = 0;
            boolean isDevelopment = FabricLoader.getInstance().isDevelopmentEnvironment();
            for (BlockDefinitionV2 definition : registry.getAllDefinitions()) {
                try {
                    if (!isDevelopment && "westeros_test_tab".equals(definition.getCreativeTab())) {
                        ++skippedCount;
                        WesterosBlocks.LOGGER.debug("Skipped test block (production): {}", (Object)definition.getBlockName());
                        continue;
                    }
                    class_2248 block = ModBlocks.createBlockFromDefinition(definition);
                    if (block != null) {
                        class_2248 registeredBlock = ModBlocks.registerBlock(definition.getBlockName(), block);
                        AUTO_REGISTERED_BLOCKS.put(definition.getBlockName(), registeredBlock);
                        ++registeredCount;
                        WesterosBlocks.LOGGER.debug("Auto-registered block: {} ({})", (Object)definition.getBlockName(), (Object)definition.getBlockType());
                        continue;
                    }
                    ++skippedCount;
                    WesterosBlocks.LOGGER.warn("Skipped unsupported block type '{}' for block '{}'", (Object)definition.getBlockType(), (Object)definition.getBlockName());
                }
                catch (Exception e) {
                    ++skippedCount;
                    WesterosBlocks.LOGGER.error("Failed to register block '{}': {}", (Object)definition.getBlockName(), (Object)e.getMessage());
                }
            }
            WesterosBlocks.LOGGER.info("Automatic block registration complete: {} registered, {} skipped", (Object)registeredCount, (Object)skippedCount);
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Error during automatic block registration", (Throwable)e);
        }
    }

    private static BlockFactory getFactory(String blockType) {
        return switch (blockType.toLowerCase()) {
            case "solid" -> new WCSolidBlock.Factory();
            case "door" -> new WCDoorBlock.Factory();
            case "halfdoor" -> new WCHalfDoorBlock.Factory();
            case "log" -> new WCLogBlock.Factory();
            case "plant" -> new WCPlantBlock.Factory();
            case "flowerpot" -> new WCFlowerPotBlock.Factory();
            case "web" -> new WCWebBlock.Factory();
            case "slab" -> new WCSlabBlock.Factory();
            case "fire" -> new WCFireBlock.Factory();
            case "ladder" -> new WCLadderBlock.Factory();
            case "vines" -> new WCVinesBlock.Factory();
            case "pane" -> new WCPaneBlock.Factory();
            case "fence" -> new WCFenceBlock.Factory();
            case "fencegate" -> new WCFenceGateBlock.Factory();
            case "trapdoor" -> new WCTrapDoorBlock.Factory();
            case "leaves" -> new WCLeavesBlock.Factory();
            case "bed" -> new WCBedBlock.Factory();
            case "crop" -> new WCCropBlock.Factory();
            case "torch" -> new WCTorchBlock.Factory();
            case "fan" -> new WCFanBlock.Factory();
            case "rail" -> new WCRailBlock.Factory();
            case "furnace" -> new WCFurnaceBlock.Factory();
            case "wall" -> new WCWallBlock.Factory();
            case "stair" -> new WCStairBlock.Factory();
            case "cuboid" -> new WCCuboidBlock.Factory();
            case "cuboid-nsew" -> new WCCuboidNSEWBlock.Factory();
            case "cuboid-nsew-stack" -> new WCCuboidNSEWStackBlock.Factory();
            case "cuboid-ne" -> new WCCuboidNEBlock.Factory();
            case "cuboid-nsewud" -> new WCCuboidNSEWUDBlock.Factory();
            case "cuboid-16way" -> new WCCuboid16WayBlock.Factory();
            case "layer" -> new WCLayerBlock.Factory();
            case "beacon" -> new WCBeaconBlock.Factory();
            case "sand" -> new WCSandBlock.Factory();
            case "soul-sand" -> new WCSoulSandBlock.Factory();
            case "particle" -> new WCParticleEmitterBlock.Factory();
            case "table" -> new WCTableBlock.Factory();
            case "chair" -> new WCChairBlock.Factory();
            case "bench" -> new WCBenchBlock.Factory();
            case "branch" -> new WCBranchBlock.Factory();
            case "arrow-slit" -> new WCArrowSlitBlock.Factory();
            case "flowerbed" -> new WCFlowerbedBlock.Factory();
            case "mounted" -> new WCMountedBlock.Factory();
            default -> null;
        };
    }

    private static class_2248 createBlockFromDefinition(BlockDefinitionV2 definition) {
        String blockType = definition.getBlockType().toLowerCase();
        try {
            BlockFactory factory = ModBlocks.getFactory(blockType);
            if (factory != null) {
                return factory.buildBlockClass(definition);
            }
            WesterosBlocks.LOGGER.warn("No factory found for block type '{}'", (Object)blockType);
            return null;
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Error creating block from definition: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static class_2248 getAutoRegisteredBlock(String blockName) {
        return AUTO_REGISTERED_BLOCKS.get(blockName);
    }

    public static Map<String, class_2248> getAllAutoRegisteredBlocks() {
        return new HashMap<String, class_2248>(AUTO_REGISTERED_BLOCKS);
    }

    private static void registerAutoBlocksToCreativeTabs() {
        try {
            BlockDefinitionRegistry registry = BlockDefinitionRegistry.getInstance();
            if (!registry.isInitialized()) {
                WesterosBlocks.LOGGER.warn("BlockDefinitionRegistry not initialized - skipping creative tab registration");
                return;
            }
            HashMap<String, List> blocksByTab = new HashMap<String, List>();
            for (BlockDefinitionV2 definition : registry.getAllDefinitions()) {
                String creativeTab = definition.getCreativeTab();
                String blockName = definition.getBlockName();
                class_2248 block = AUTO_REGISTERED_BLOCKS.get(blockName);
                if (block == null || creativeTab == null || creativeTab.isEmpty()) continue;
                blocksByTab.computeIfAbsent(creativeTab, k -> new ArrayList()).add(block);
            }
            int totalRegistered = 0;
            for (Map.Entry entry : blocksByTab.entrySet()) {
                String tabName = (String)entry.getKey();
                List blocks = (List)entry.getValue();
                if (blocks.isEmpty()) continue;
                class_2248[] blockArray = blocks.toArray(new class_2248[0]);
                WesterosCreativeModeTabs.addToTab(tabName, blockArray);
                totalRegistered += blocks.size();
                WesterosBlocks.LOGGER.info("Added {} blocks to creative tab '{}'", (Object)blocks.size(), (Object)tabName);
            }
            WesterosBlocks.LOGGER.info("Successfully registered {} auto-blocks to {} creative tabs", (Object)totalRegistered, (Object)blocksByTab.size());
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Error registering auto-blocks to creative tabs", (Throwable)e);
        }
    }

    public static void registerModBlocks() {
        WesterosBlocks.LOGGER.info("Registering Mod Blocks for westerosblocks");
        ModBlocks.registerAutoBlocksToCreativeTabs();
    }

    public static class_2248 registerBlock(String name, class_2248 block) {
        ModBlocks.registerBlockItem(name, block);
        return (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)"westerosblocks", (String)name), (Object)block);
    }

    private static void registerBlockItem(String name, class_2248 block) {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)"westerosblocks", (String)name), (Object)new class_1747(block, new class_1792.class_1793()));
    }

    public static class_2248 registerBlockWithoutItem(String name, class_2248 block) {
        class_2248 registered = (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)"westerosblocks", (String)name), (Object)block);
        AUTO_REGISTERED_BLOCKS.put(name, registered);
        return registered;
    }

    static {
        ModBlocks.registerBlocksFromDefinitions();
    }
}

