/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.WCArrowSlitBlock;
import com.westerosblocks.block.custom.WCBeaconBlock;
import com.westerosblocks.block.custom.WCBedBlock;
import com.westerosblocks.block.custom.WCBenchBlock;
import com.westerosblocks.block.custom.WCBranchBlock;
import com.westerosblocks.block.custom.WCChairBlock;
import com.westerosblocks.block.custom.WCCropBlock;
import com.westerosblocks.block.custom.WCCuboid16WayBlock;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.block.custom.WCCuboidNEBlock;
import com.westerosblocks.block.custom.WCCuboidNSEWBlock;
import com.westerosblocks.block.custom.WCCuboidNSEWStackBlock;
import com.westerosblocks.block.custom.WCCuboidNSEWUDBlock;
import com.westerosblocks.block.custom.WCDoorBlock;
import com.westerosblocks.block.custom.WCFanBlock;
import com.westerosblocks.block.custom.WCFenceBlock;
import com.westerosblocks.block.custom.WCFenceGateBlock;
import com.westerosblocks.block.custom.WCFireBlock;
import com.westerosblocks.block.custom.WCFlowerPotBlock;
import com.westerosblocks.block.custom.WCFlowerbedBlock;
import com.westerosblocks.block.custom.WCFurnaceBlock;
import com.westerosblocks.block.custom.WCHalfDoorBlock;
import com.westerosblocks.block.custom.WCLadderBlock;
import com.westerosblocks.block.custom.WCLayerBlock;
import com.westerosblocks.block.custom.WCLeavesBlock;
import com.westerosblocks.block.custom.WCLogBlock;
import com.westerosblocks.block.custom.WCMountedBlock;
import com.westerosblocks.block.custom.WCPaneBlock;
import com.westerosblocks.block.custom.WCParticleEmitterBlock;
import com.westerosblocks.block.custom.WCPlantBlock;
import com.westerosblocks.block.custom.WCRailBlock;
import com.westerosblocks.block.custom.WCSandBlock;
import com.westerosblocks.block.custom.WCSlabBlock;
import com.westerosblocks.block.custom.WCSolidBlock;
import com.westerosblocks.block.custom.WCSoulSandBlock;
import com.westerosblocks.block.custom.WCStairBlock;
import com.westerosblocks.block.custom.WCTableBlock;
import com.westerosblocks.block.custom.WCTorchBlock;
import com.westerosblocks.block.custom.WCTrapDoorBlock;
import com.westerosblocks.block.custom.WCVinesBlock;
import com.westerosblocks.block.custom.WCWallBlock;
import com.westerosblocks.block.custom.WCWebBlock;
import java.util.HashMap;
import java.util.Map;

public class BlockFactoryRegistry {
    private static final Map<String, BlockFactory> FACTORIES = new HashMap<String, BlockFactory>();

    public static BlockFactory getFactory(String blockType) {
        if (blockType == null || blockType.isEmpty()) {
            return null;
        }
        return FACTORIES.get(blockType.toLowerCase());
    }

    public static void register(String blockType, BlockFactory factory) {
        if (blockType == null || blockType.isEmpty()) {
            throw new IllegalArgumentException("Block type cannot be null or empty");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Factory cannot be null");
        }
        String normalizedType = blockType.toLowerCase();
        if (FACTORIES.containsKey(normalizedType)) {
            WesterosBlocks.LOGGER.warn("Overriding existing factory for block type '{}'", (Object)normalizedType);
        }
        FACTORIES.put(normalizedType, factory);
        WesterosBlocks.LOGGER.debug("Registered factory for block type '{}'", (Object)normalizedType);
    }

    public static boolean hasFactory(String blockType) {
        if (blockType == null || blockType.isEmpty()) {
            return false;
        }
        return FACTORIES.containsKey(blockType.toLowerCase());
    }

    public static Map<String, BlockFactory> getAllFactories() {
        return new HashMap<String, BlockFactory>(FACTORIES);
    }

    public static int getFactoryCount() {
        return FACTORIES.size();
    }

    private BlockFactoryRegistry() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    static {
        BlockFactoryRegistry.register("solid", new WCSolidBlock.Factory());
        BlockFactoryRegistry.register("stair", new WCStairBlock.Factory());
        BlockFactoryRegistry.register("slab", new WCSlabBlock.Factory());
        BlockFactoryRegistry.register("wall", new WCWallBlock.Factory());
        BlockFactoryRegistry.register("fence", new WCFenceBlock.Factory());
        BlockFactoryRegistry.register("fencegate", new WCFenceGateBlock.Factory());
        BlockFactoryRegistry.register("door", new WCDoorBlock.Factory());
        BlockFactoryRegistry.register("halfdoor", new WCHalfDoorBlock.Factory());
        BlockFactoryRegistry.register("trapdoor", new WCTrapDoorBlock.Factory());
        BlockFactoryRegistry.register("log", new WCLogBlock.Factory());
        BlockFactoryRegistry.register("plant", new WCPlantBlock.Factory());
        BlockFactoryRegistry.register("crop", new WCCropBlock.Factory());
        BlockFactoryRegistry.register("leaves", new WCLeavesBlock.Factory());
        BlockFactoryRegistry.register("vines", new WCVinesBlock.Factory());
        BlockFactoryRegistry.register("flowerpot", new WCFlowerPotBlock.Factory());
        BlockFactoryRegistry.register("flowerbed", new WCFlowerbedBlock.Factory());
        BlockFactoryRegistry.register("torch", new WCTorchBlock.Factory());
        BlockFactoryRegistry.register("ladder", new WCLadderBlock.Factory());
        BlockFactoryRegistry.register("fire", new WCFireBlock.Factory());
        BlockFactoryRegistry.register("pane", new WCPaneBlock.Factory());
        BlockFactoryRegistry.register("web", new WCWebBlock.Factory());
        BlockFactoryRegistry.register("fan", new WCFanBlock.Factory());
        BlockFactoryRegistry.register("rail", new WCRailBlock.Factory());
        BlockFactoryRegistry.register("bed", new WCBedBlock.Factory());
        BlockFactoryRegistry.register("table", new WCTableBlock.Factory());
        BlockFactoryRegistry.register("chair", new WCChairBlock.Factory());
        BlockFactoryRegistry.register("bench", new WCBenchBlock.Factory());
        BlockFactoryRegistry.register("branch", new WCBranchBlock.Factory());
        BlockFactoryRegistry.register("furnace", new WCFurnaceBlock.Factory());
        BlockFactoryRegistry.register("beacon", new WCBeaconBlock.Factory());
        BlockFactoryRegistry.register("particle", new WCParticleEmitterBlock.Factory());
        BlockFactoryRegistry.register("sand", new WCSandBlock.Factory());
        BlockFactoryRegistry.register("soul-sand", new WCSoulSandBlock.Factory());
        BlockFactoryRegistry.register("layer", new WCLayerBlock.Factory());
        BlockFactoryRegistry.register("cuboid", new WCCuboidBlock.Factory());
        BlockFactoryRegistry.register("cuboid-ne", new WCCuboidNEBlock.Factory());
        BlockFactoryRegistry.register("cuboid-nsew", new WCCuboidNSEWBlock.Factory());
        BlockFactoryRegistry.register("cuboid-nsewud", new WCCuboidNSEWUDBlock.Factory());
        BlockFactoryRegistry.register("cuboid-16way", new WCCuboid16WayBlock.Factory());
        BlockFactoryRegistry.register("cuboid-nsew-stack", new WCCuboidNSEWStackBlock.Factory());
        BlockFactoryRegistry.register("arrow-slit", new WCArrowSlitBlock.Factory());
        BlockFactoryRegistry.register("mounted", new WCMountedBlock.Factory());
        WesterosBlocks.LOGGER.info("BlockFactoryRegistry initialized with {} block types", (Object)FACTORIES.size());
    }
}

