/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.google.common.collect.ImmutableMap;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinitionV2;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public class WCArrowSlitBlock
extends class_2248 {
    protected BlockDefinitionV2 definition;
    public static final class_2754<ArrowSlitType> TYPE = class_2754.method_11850((String)"type", ArrowSlitType.class);
    public static final class_2753 FACING = class_2741.field_12481;
    private static final class_265 LEFT_WALL = class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0);
    private static final class_265 RIGHT_WALL = class_2248.method_9541((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final class_265 LEFT_SLIT_WALL = class_2248.method_9541((double)3.0, (double)2.0, (double)3.0, (double)6.0, (double)14.0, (double)13.0);
    private static final class_265 RIGHT_SLIT_WALL = class_2248.method_9541((double)10.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    private static final class_265 BOTTOM_BASE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final class_265 TOP_BASE = class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 BOTTOM_LEDGE_LEFT = class_2248.method_9541((double)0.0, (double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0);
    private static final class_265 BOTTOM_LEDGE_RIGHT = class_2248.method_9541((double)13.0, (double)15.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final class_265 TOP_LEDGE_LEFT = class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0);
    private static final class_265 TOP_LEDGE_RIGHT = class_2248.method_9541((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0);
    private final Map<class_2680, class_265> shapeByIndex;

    public WCArrowSlitBlock(class_4970.class_2251 settings, BlockDefinitionV2 def) {
        super(settings);
        this.definition = def;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(TYPE, (Comparable)((Object)ArrowSlitType.SINGLE))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
        this.shapeByIndex = this.makeShapes();
    }

    private Map<class_2680, class_265> makeShapes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ArrowSlitType type : ArrowSlitType.values()) {
            for (class_2350 facing : class_2350.class_2353.field_11062) {
                class_265 shape = this.getShapeForState(type, facing);
                class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657(TYPE, (Comparable)((Object)type))).method_11657((class_2769)FACING, (Comparable)facing);
                builder.put((Object)state, (Object)shape);
            }
        }
        return builder.build();
    }

    private class_265 getShapeForState(ArrowSlitType type, class_2350 facing) {
        return switch (facing) {
            case class_2350.field_11043 -> this.getNorthShape(type);
            case class_2350.field_11035 -> this.getSouthShape(type);
            case class_2350.field_11034 -> this.getEastShape(type);
            case class_2350.field_11039 -> this.getWestShape(type);
            default -> this.getNorthShape(ArrowSlitType.SINGLE);
        };
    }

    private class_265 getNorthShape(ArrowSlitType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), (class_265[])new class_265[]{class_2248.method_9541((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), class_2248.method_9541((double)0.0, (double)4.0, (double)3.0, (double)6.0, (double)12.0, (double)13.0), class_2248.method_9541((double)10.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0), BOTTOM_BASE, TOP_BASE});
            case 1 -> class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), (class_265[])new class_265[]{class_2248.method_9541((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), class_2248.method_9541((double)0.0, (double)1.0, (double)3.0, (double)6.0, (double)12.0, (double)13.0), class_2248.method_9541((double)10.0, (double)1.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0), TOP_BASE, TOP_LEDGE_LEFT, TOP_LEDGE_RIGHT});
            case 2 -> class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), (class_265[])new class_265[]{class_2248.method_9541((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), class_2248.method_9541((double)0.0, (double)4.0, (double)3.0, (double)6.0, (double)15.0, (double)13.0), class_2248.method_9541((double)10.0, (double)4.0, (double)3.0, (double)16.0, (double)15.0, (double)13.0), BOTTOM_BASE, BOTTOM_LEDGE_LEFT, BOTTOM_LEDGE_RIGHT});
            case 3, 4 -> class_259.method_17786((class_265)LEFT_WALL, (class_265[])new class_265[]{RIGHT_WALL, LEFT_SLIT_WALL, RIGHT_SLIT_WALL});
        };
    }

    private class_265 getSouthShape(ArrowSlitType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), (class_265[])new class_265[]{class_2248.method_9541((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), class_2248.method_9541((double)0.0, (double)4.0, (double)3.0, (double)6.0, (double)12.0, (double)13.0), class_2248.method_9541((double)10.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0), BOTTOM_BASE, TOP_BASE});
            case 1 -> class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), (class_265[])new class_265[]{class_2248.method_9541((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), class_2248.method_9541((double)0.0, (double)1.0, (double)3.0, (double)6.0, (double)12.0, (double)13.0), class_2248.method_9541((double)10.0, (double)1.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0), TOP_BASE, TOP_LEDGE_LEFT, TOP_LEDGE_RIGHT});
            case 2 -> class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), (class_265[])new class_265[]{class_2248.method_9541((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), class_2248.method_9541((double)0.0, (double)4.0, (double)3.0, (double)6.0, (double)15.0, (double)13.0), class_2248.method_9541((double)10.0, (double)4.0, (double)3.0, (double)16.0, (double)15.0, (double)13.0), BOTTOM_BASE, BOTTOM_LEDGE_LEFT, BOTTOM_LEDGE_RIGHT});
            case 3, 4 -> class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), (class_265[])new class_265[]{class_2248.method_9541((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), class_2248.method_9541((double)3.0, (double)2.0, (double)3.0, (double)6.0, (double)14.0, (double)13.0), class_2248.method_9541((double)10.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)});
        };
    }

    private class_265 getEastShape(ArrowSlitType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_259.method_17786((class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0), class_2248.method_9541((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)12.0, (double)6.0), class_2248.method_9541((double)3.0, (double)4.0, (double)10.0, (double)13.0, (double)12.0, (double)13.0), BOTTOM_BASE, TOP_BASE});
            case 1 -> class_259.method_17786((class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0), class_2248.method_9541((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)12.0, (double)6.0), class_2248.method_9541((double)3.0, (double)1.0, (double)10.0, (double)13.0, (double)12.0, (double)13.0), TOP_BASE, TOP_LEDGE_LEFT, TOP_LEDGE_RIGHT});
            case 2 -> class_259.method_17786((class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0), class_2248.method_9541((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)15.0, (double)6.0), class_2248.method_9541((double)3.0, (double)4.0, (double)10.0, (double)13.0, (double)15.0, (double)13.0), BOTTOM_BASE, BOTTOM_LEDGE_LEFT, BOTTOM_LEDGE_RIGHT});
            case 3, 4 -> class_259.method_17786((class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0), class_2248.method_9541((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)6.0), class_2248.method_9541((double)3.0, (double)2.0, (double)10.0, (double)13.0, (double)14.0, (double)13.0)});
        };
    }

    private class_265 getWestShape(ArrowSlitType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_259.method_17786((class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0), class_2248.method_9541((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)12.0, (double)6.0), class_2248.method_9541((double)3.0, (double)4.0, (double)10.0, (double)13.0, (double)12.0, (double)13.0), BOTTOM_BASE, TOP_BASE});
            case 1 -> class_259.method_17786((class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0), class_2248.method_9541((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)12.0, (double)6.0), class_2248.method_9541((double)3.0, (double)1.0, (double)10.0, (double)13.0, (double)12.0, (double)13.0), TOP_BASE, TOP_LEDGE_LEFT, TOP_LEDGE_RIGHT});
            case 2 -> class_259.method_17786((class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0), class_2248.method_9541((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)15.0, (double)6.0), class_2248.method_9541((double)3.0, (double)4.0, (double)10.0, (double)13.0, (double)15.0, (double)13.0), BOTTOM_BASE, BOTTOM_LEDGE_LEFT, BOTTOM_LEDGE_RIGHT});
            case 3, 4 -> class_259.method_17786((class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0), class_2248.method_9541((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)6.0), class_2248.method_9541((double)3.0, (double)2.0, (double)10.0, (double)13.0, (double)14.0, (double)13.0)});
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TYPE, FACING});
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11036 || direction == class_2350.field_11033) {
            int middlePosition;
            int blocksAbove = 0;
            class_2338 currentPos = pos.method_10084();
            while (world.method_8320(currentPos).method_27852((class_2248)this)) {
                ++blocksAbove;
                currentPos = currentPos.method_10084();
            }
            int blocksBelow = 0;
            currentPos = pos.method_10074();
            while (world.method_8320(currentPos).method_27852((class_2248)this)) {
                ++blocksBelow;
                currentPos = currentPos.method_10074();
            }
            int stackHeight = blocksAbove + blocksBelow + 1;
            int position = blocksBelow;
            ArrowSlitType newType = stackHeight == 1 ? ArrowSlitType.SINGLE : (position == 0 ? ArrowSlitType.BOTTOM : (position == stackHeight - 1 ? ArrowSlitType.TOP : (stackHeight == 3 ? ArrowSlitType.MIDDLE : (stackHeight == 4 ? ArrowSlitType.MIDDLE_EDGE : (position == (middlePosition = stackHeight / 2) ? ArrowSlitType.MIDDLE : ArrowSlitType.MIDDLE_EDGE)))));
            return (class_2680)state.method_11657(TYPE, (Comparable)((Object)newType));
        }
        return state;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        return super.method_9576(world, pos, state, player);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapeByIndex.get(state);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapeByIndex.get(state);
    }

    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    public static enum ArrowSlitType implements class_3542
    {
        SINGLE("single"),
        TOP("top"),
        BOTTOM("bottom"),
        MIDDLE("middle"),
        MIDDLE_EDGE("middle_edge");

        private final String name;

        private ArrowSlitType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            return new WCArrowSlitBlock(settings, definition);
        }
    }
}

