/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.mojang.serialization.MapCodec;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinitionV2;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class WCBedBlock
extends class_2383 {
    protected BlockDefinitionV2 definition;
    public static final MapCodec<WCBedBlock> CODEC = WCBedBlock.method_54094(WCBedBlock::new);
    public static final class_2754<class_2742> PART = class_2741.field_12483;
    public static final class_2746 OCCUPIED = class_2741.field_12528;
    protected static final class_265 BASE = WCBedBlock.method_9541((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final class_265 LEG_NORTH_WEST = WCBedBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
    protected static final class_265 LEG_SOUTH_WEST = WCBedBlock.method_9541((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
    protected static final class_265 LEG_NORTH_EAST = WCBedBlock.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
    protected static final class_265 LEG_SOUTH_EAST = WCBedBlock.method_9541((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final class_265 NORTH_SHAPE = class_259.method_17786((class_265)BASE, (class_265[])new class_265[]{LEG_NORTH_WEST, LEG_NORTH_EAST});
    protected static final class_265 SOUTH_SHAPE = class_259.method_17786((class_265)BASE, (class_265[])new class_265[]{LEG_SOUTH_WEST, LEG_SOUTH_EAST});
    protected static final class_265 WEST_SHAPE = class_259.method_17786((class_265)BASE, (class_265[])new class_265[]{LEG_NORTH_WEST, LEG_SOUTH_WEST});
    protected static final class_265 EAST_SHAPE = class_259.method_17786((class_265)BASE, (class_265[])new class_265[]{LEG_NORTH_EAST, LEG_SOUTH_EAST});
    private final class_1767 color;
    public final BedType bedType;

    public MapCodec<WCBedBlock> method_53969() {
        return CODEC;
    }

    protected WCBedBlock(class_4970.class_2251 settings) {
        this(settings, null);
    }

    protected WCBedBlock(class_4970.class_2251 settings, BlockDefinitionV2 def) {
        super(settings);
        String type;
        this.definition = def;
        this.color = class_1767.field_7964;
        this.bedType = def != null ? ((type = def.getTypeValue("shape", "normal")).equals("raised") ? BedType.RAISED : (type.equals("hammock") ? BedType.HAMMOCK : BedType.NORMAL)) : BedType.NORMAL;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(PART, (Comparable)class_2742.field_12557)).method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_21466;
        }
        if (state.method_11654(PART) != class_2742.field_12560 && !(state = world.method_8320(pos = pos.method_10093((class_2350)state.method_11654((class_2769)field_11177)))).method_27852((class_2248)this)) {
            return class_1269.field_21466;
        }
        if (!WCBedBlock.canSetSpawn(world)) {
            world.method_8650(pos, false);
            class_2338 blockpos = pos.method_10093(((class_2350)state.method_11654((class_2769)field_11177)).method_10153());
            if (world.method_8320(blockpos).method_27852((class_2248)this)) {
                world.method_8650(blockpos, false);
            }
        } else {
            if (((Boolean)state.method_11654((class_2769)OCCUPIED)).booleanValue()) {
                if (!this.kickVillagerOutOfBed(world, pos)) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"block.minecraft.bed.occupied"), true);
                }
                return class_1269.field_5812;
            }
            player.method_7269(pos).ifLeft(failure -> {
                if (failure != null) {
                    player.method_7353(failure.method_19206(), true);
                }
            });
            return class_1269.field_5812;
        }
        world.method_55117(null, world.method_48963().method_48808(class_243.method_24954((class_2382)pos).method_1031(0.5, 0.5, 0.5)), null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5.0f, true, class_1937.class_7867.field_40889);
        return class_1269.field_5812;
    }

    public static boolean canSetSpawn(class_1937 world) {
        return world.method_8597().comp_648();
    }

    private boolean kickVillagerOutOfBed(class_1937 world, class_2338 pos) {
        class_238 box = new class_238(pos);
        List<class_1646> list = world.method_18467(class_1646.class, box).stream().filter(class_1309::method_6113).toList();
        if (list.isEmpty()) {
            return false;
        }
        list.getFirst().method_18400();
        return true;
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        super.method_9554(world, state, pos, entity, fallDistance * 0.5f);
    }

    public void method_9502(class_1922 world, class_1297 entity) {
        if (entity.method_21750()) {
            super.method_9502(world, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(class_1297 entity) {
        class_243 velocity = entity.method_18798();
        if (velocity.field_1351 < 0.0) {
            double d0 = entity instanceof class_1309 ? 1.0 : 0.8;
            entity.method_18800(velocity.field_1352, -velocity.field_1351 * (double)0.66f * d0, velocity.field_1350);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == WCBedBlock.getNeighbourDirection((class_2742)state.method_11654(PART), (class_2350)state.method_11654((class_2769)field_11177))) {
            return neighborState.method_27852((class_2248)this) && neighborState.method_11654(PART) != state.method_11654(PART) ? (class_2680)state.method_11657((class_2769)OCCUPIED, (Comparable)((Boolean)neighborState.method_11654((class_2769)OCCUPIED))) : class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    private static class_2350 getNeighbourDirection(class_2742 bedPart, class_2350 direction) {
        return bedPart == class_2742.field_12557 ? direction : direction.method_10153();
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 otherPos;
        class_2680 otherState;
        class_2742 bedpart;
        if (!world.method_8608() && player.method_7337() && (bedpart = (class_2742)state.method_11654(PART)) == class_2742.field_12557 && (otherState = world.method_8320(otherPos = pos.method_10093(WCBedBlock.getNeighbourDirection(bedpart, (class_2350)state.method_11654((class_2769)field_11177))))).method_27852((class_2248)this) && otherState.method_11654(PART) == class_2742.field_12560) {
            world.method_8652(otherPos, class_2246.field_10124.method_9564(), 35);
            world.method_8444(player, 2001, otherPos, class_2248.method_9507((class_2680)otherState));
        }
        return super.method_9576(world, pos, state, player);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8042();
        class_2338 blockpos = ctx.method_8037();
        class_2338 blockpos1 = blockpos.method_10093(direction);
        class_1937 world = ctx.method_8045();
        return world.method_8320(blockpos1).method_26166(ctx) && world.method_8621().method_11952(blockpos1) ? (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction) : null;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = WCBedBlock.getConnectedDirection(state).method_10153();
        return switch (direction) {
            case class_2350.field_11043 -> NORTH_SHAPE;
            case class_2350.field_11035 -> SOUTH_SHAPE;
            case class_2350.field_11039 -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }

    public static class_2350 getConnectedDirection(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        return state.method_11654(PART) == class_2742.field_12560 ? direction.method_10153() : direction;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, PART, OCCUPIED});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        if (!world.field_9236) {
            class_2338 headPos = pos.method_10093((class_2350)state.method_11654((class_2769)field_11177));
            world.method_8652(headPos, (class_2680)state.method_11657(PART, (Comparable)class_2742.field_12560), 3);
            world.method_8408(pos, class_2246.field_10124);
            state.method_30101((class_1936)world, pos, 3);
        }
    }

    public class_1767 getColor() {
        return this.color;
    }

    public long method_9535(class_2680 state, class_2338 pos) {
        class_2338 blockpos = pos.method_10079((class_2350)state.method_11654((class_2769)field_11177), state.method_11654(PART) == class_2742.field_12560 ? 0 : 1);
        return blockpos.hashCode();
    }

    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    public static enum BedType {
        NORMAL,
        RAISED,
        HAMMOCK;

    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            return new WCBedBlock(settings, definition);
        }
    }
}

