/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.google.common.collect.ImmutableMap;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.entity.ModEntities;
import com.westerosblocks.utils.ModWoodType;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_4719;
import net.minecraft.class_4970;

public class WCChairBlock
extends class_2248 {
    protected BlockDefinitionV2 definition;
    public static final class_2758 ROTATION = class_2758.method_11867((String)"rotation", (int)0, (int)7);
    private static final class_265 CHAIR_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)18.0, (double)14.0);
    private final Map<class_2680, class_265> shapeByIndex;

    public WCChairBlock(class_4970.class_2251 settings) {
        this(settings, null, "chair", "building_blocks", "oak");
    }

    public WCChairBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, String blockName, String creativeTab, String woodType) {
        this(settings, def, blockName, creativeTab, ModWoodType.getWoodType(woodType));
    }

    public WCChairBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, String blockName, String creativeTab, class_4719 woodType) {
        super(settings);
        this.definition = def;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(0)));
        this.shapeByIndex = this.makeShapes();
    }

    private Map<class_2680, class_265> makeShapes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int rotation = 0; rotation < 8; ++rotation) {
            class_265 shape = CHAIR_SHAPE;
            class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation));
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.method_8608()) {
            class_1297 entity = null;
            List entities = world.method_18023(ModEntities.CHAIR, new class_238(pos), chair -> true);
            entity = entities.isEmpty() ? ModEntities.CHAIR.method_47821((class_3218)world, pos, class_3730.field_16461) : (class_1297)entities.get(0);
            player.method_5804(entity);
        }
        return class_1269.field_5812;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ROTATION});
    }

    public class_2680 method_9605(class_1750 ctx) {
        int rotation = class_3532.method_15357((double)((double)(ctx.method_8044() * 8.0f / 360.0f) + 0.5)) & 7;
        return (class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapeByIndex.get(state);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapeByIndex.get(state);
    }

    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition != null ? definition.makeSettings() : class_4970.class_2251.method_9637();
            String blockName = definition != null ? definition.getBlockName() : "chair";
            String creativeTab = definition != null ? definition.getCreativeTab() : "building_blocks";
            String woodType = definition != null ? definition.getWoodType() : "oak";
            return new WCChairBlock(settings, definition, blockName, creativeTab, woodType);
        }
    }
}

