/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.utils.ModProperties;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class WCCuboid16WayBlock
extends WCCuboidBlock {
    public static final class_2758 ROTATION = class_2741.field_12532;
    private static final int ROTATIONS = 16;

    public WCCuboid16WayBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, boolean doToggleOnUse) {
        super(settings, def, 16, doToggleOnUse);
        int stcnt = def.getStateCount();
        for (int stidx = 0; stidx < stcnt; ++stidx) {
            int idx = stidx * this.modelsPerState;
            List baseCuboids = this.cuboid_by_facing[idx];
            if (baseCuboids == null || baseCuboids.isEmpty()) continue;
            for (int i = 1; i < 16; ++i) {
                int quadrant = i / 4;
                int rotationDegrees = quadrant * 90;
                for (BlockStateRecordV2.CuboidElement cuboid : baseCuboids) {
                    this.cuboid_by_facing[idx + i].add(this.rotateCuboidY(cuboid, rotationDegrees));
                }
            }
        }
        for (int i = 0; i < this.cuboid_by_facing.length; ++i) {
            if (this.SHAPE_BY_INDEX[i] != null) continue;
            this.SHAPE_BY_INDEX[i] = this.computeShapeFromCuboids(this.cuboid_by_facing[i]);
        }
        class_2680 defbs = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        if (this.STATE != null) {
            defbs = (class_2680)defbs.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        this.method_9590(defbs);
    }

    private BlockStateRecordV2.CuboidElement rotateCuboidY(BlockStateRecordV2.CuboidElement cuboid, int degrees) {
        float newZMax;
        float newZMin;
        float newXMax;
        float newXMin;
        float xMin = cuboid.xMin;
        float xMax = cuboid.xMax;
        float yMin = cuboid.yMin;
        float yMax = cuboid.yMax;
        float zMin = cuboid.zMin;
        float zMax = cuboid.zMax;
        switch (degrees % 360) {
            case 0: {
                return cuboid;
            }
            case 90: {
                newXMin = 1.0f - zMax;
                newXMax = 1.0f - zMin;
                newZMin = xMin;
                newZMax = xMax;
                break;
            }
            case 180: {
                newXMin = 1.0f - xMax;
                newXMax = 1.0f - xMin;
                newZMin = 1.0f - zMax;
                newZMax = 1.0f - zMin;
                break;
            }
            case 270: {
                newXMin = zMin;
                newXMax = zMax;
                newZMin = 1.0f - xMax;
                newZMax = 1.0f - xMin;
                break;
            }
            default: {
                return cuboid;
            }
        }
        BlockStateRecordV2.CuboidElement rotated = new BlockStateRecordV2.CuboidElement();
        rotated.xMin = newXMin;
        rotated.xMax = newXMax;
        rotated.yMin = yMin;
        rotated.yMax = yMax;
        rotated.zMin = newZMin;
        rotated.zMax = newZMax;
        rotated.sideTextures = cuboid.sideTextures;
        rotated.sideRotations = cuboid.sideRotations;
        rotated.noTint = cuboid.noTint;
        rotated.shape = cuboid.shape;
        return rotated;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ROTATION});
    }

    @Override
    protected int getIndexFromState(class_2680 state) {
        int off = super.getIndexFromState(state);
        int rotation = (Integer)state.method_11654((class_2769)ROTATION);
        return off + rotation;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        int rotation = class_3532.method_15357((double)((double)(ctx.method_8044() * 16.0f / 360.0f) + 0.5)) & 0xF;
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        if (this.STATE != null) {
            state = (class_2680)state.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        return state;
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1268 hand = player.method_6058();
        if (this.toggleOnUse && player.method_7337() && player.method_5998(hand).method_7960()) {
            if (this.STATE != null && state.method_28498((class_2769)this.STATE)) {
                state = (class_2680)state.method_28493((class_2769)this.STATE);
                world.method_8652(pos, state, 3);
                world.method_8444(player, 1006, pos, 0);
                return class_1269.method_29236((boolean)world.field_9236);
            }
            if (state.method_28498((class_2769)ROTATION)) {
                int currentRotation = (Integer)state.method_11654((class_2769)ROTATION);
                int newRotation = currentRotation + 1 & 0xF;
                state = (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(newRotation));
                world.method_8652(pos, state, 3);
                world.method_8444(player, 1006, pos, 0);
                return class_1269.method_29236((boolean)world.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        int currentRotation = (Integer)state.method_11654((class_2769)ROTATION);
        int rotationSteps = switch (rotation) {
            case class_2470.field_11463 -> 4;
            case class_2470.field_11464 -> 8;
            case class_2470.field_11465 -> 12;
            default -> 0;
        };
        int newRotation = currentRotation + rotationSteps & 0xF;
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(newRotation));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        int rotation = (Integer)state.method_11654((class_2769)ROTATION);
        int mirroredRotation = switch (mirror) {
            case class_2415.field_11301 -> 16 - rotation & 0xF;
            case class_2415.field_11300 -> 32 - rotation & 0xF;
            default -> rotation;
        };
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(mirroredRotation));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            ModProperties.StateProperty stateProperty = definition.buildStateProperty();
            boolean doToggleOnUse = definition.toggleOnUse();
            WCCuboidBlock.tempSTATE = stateProperty;
            return new WCCuboid16WayBlock(settings, definition, doToggleOnUse);
        }
    }
}

