/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.utils.ModProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class WCCuboidBlock
extends class_2248
implements class_3737 {
    protected BlockDefinitionV2 definition;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static ModProperties.StateProperty tempSTATE;
    public ModProperties.StateProperty STATE;
    protected boolean toggleOnUse = false;
    protected int modelsPerState;
    protected class_265[] SHAPE_BY_INDEX;
    protected class_265[] SUPPORT_BY_INDEX;
    protected List<BlockStateRecordV2.CuboidElement>[] cuboid_by_facing;

    public WCCuboidBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, int modelsPerState, boolean doToggleOnUse) {
        super(settings);
        this.definition = def;
        this.modelsPerState = modelsPerState;
        this.toggleOnUse = doToggleOnUse;
        int cnt = def.getStateCount();
        this.cuboid_by_facing = new List[cnt * modelsPerState];
        this.SHAPE_BY_INDEX = new class_265[cnt * modelsPerState];
        this.SUPPORT_BY_INDEX = new class_265[cnt];
        List<BlockDefinitionV2.StateVariantV2> states = def.getStates();
        for (int i = 0; i < cnt; ++i) {
            BlockDefinitionV2.StateVariantV2 state = states.get(i);
            List<BlockStateRecordV2.CuboidElement> cuboids = state.getCuboidList();
            this.cuboid_by_facing[i * modelsPerState] = cuboids != null ? new ArrayList<BlockStateRecordV2.CuboidElement>(cuboids) : new ArrayList();
            for (int j = 1; j < modelsPerState; ++j) {
                this.cuboid_by_facing[i * modelsPerState + j] = new ArrayList<BlockStateRecordV2.CuboidElement>();
            }
            this.SHAPE_BY_INDEX[i * modelsPerState] = cuboids != null && !cuboids.isEmpty() ? this.computeShapeFromCuboids(cuboids) : (state.boundingBox != null ? class_259.method_1081((double)state.boundingBox.xMin, (double)state.boundingBox.yMin, (double)state.boundingBox.zMin, (double)state.boundingBox.xMax, (double)state.boundingBox.yMax, (double)state.boundingBox.zMax) : class_259.method_1077());
            this.SUPPORT_BY_INDEX[i] = state.makeSupportBoxShape(null);
        }
        class_2680 defbs = (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        if (tempSTATE != null) {
            defbs = (class_2680)defbs.method_11657((class_2769)tempSTATE, (Comparable)((Object)WCCuboidBlock.tempSTATE.defValue));
        }
        this.method_9590(defbs);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED});
        if (tempSTATE != null) {
            this.STATE = tempSTATE;
            tempSTATE = null;
            builder.method_11667(new class_2769[]{this.STATE});
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        class_2680 bs = (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        if (this.STATE != null) {
            bs = (class_2680)bs.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        return bs;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1268 hand = player.method_6058();
        if (this.toggleOnUse && this.STATE != null && player.method_7337() && player.method_5998(hand).method_7960() && state.method_28498((class_2769)this.STATE)) {
            state = (class_2680)state.method_28493((class_2769)this.STATE);
            world.method_8652(pos, state, 3);
            world.method_8444(player, 1006, pos, 0);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    protected int getIndexFromState(class_2680 state) {
        if (this.STATE != null) {
            return this.modelsPerState * this.STATE.getIndex((String)((Object)state.method_11654((class_2769)this.STATE)));
        }
        return 0;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.SHAPE_BY_INDEX[this.getIndexFromState(state)];
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.SHAPE_BY_INDEX[this.getIndexFromState(state)];
    }

    public class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return this.SHAPE_BY_INDEX[this.getIndexFromState(state)];
    }

    public class_265 method_25959(class_2680 state, class_1922 world, class_2338 pos) {
        int idx = 0;
        if (this.STATE != null) {
            idx = this.STATE.getIndex((String)((Object)state.method_11654((class_2769)this.STATE)));
        }
        return this.SUPPORT_BY_INDEX[idx];
    }

    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    protected class_265 computeShapeFromCuboids(List<BlockStateRecordV2.CuboidElement> cuboids) {
        if (cuboids == null || cuboids.isEmpty()) {
            return class_259.method_1077();
        }
        class_265 shape = class_259.method_1073();
        for (BlockStateRecordV2.CuboidElement cuboid : cuboids) {
            class_265 cuboidShape = class_259.method_1081((double)cuboid.xMin, (double)cuboid.yMin, (double)cuboid.zMin, (double)cuboid.xMax, (double)cuboid.yMax, (double)cuboid.zMax);
            shape = class_259.method_1084((class_265)shape, (class_265)cuboidShape);
        }
        return shape;
    }

    public List<BlockStateRecordV2.CuboidElement> getModelCuboids(int stateIdx) {
        return this.cuboid_by_facing[this.modelsPerState * stateIdx];
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            ModProperties.StateProperty stateProperty = definition.buildStateProperty();
            boolean doToggleOnUse = definition.toggleOnUse();
            tempSTATE = stateProperty;
            return new WCCuboidBlock(settings, definition, 1, doToggleOnUse);
        }
    }
}

