/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.utils.ModProperties;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4970;

public class WCCuboidNSEWBlock
extends WCCuboidBlock {
    public static final class_2753 FACING = class_2383.field_11177;

    public WCCuboidNSEWBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, boolean doToggleOnUse) {
        super(settings, def, 4, doToggleOnUse);
        int stcnt = def.getStateCount();
        for (int stidx = 0; stidx < stcnt; ++stidx) {
            int off = stidx * this.modelsPerState;
            List baseCuboids = this.cuboid_by_facing[off];
            if (baseCuboids == null || baseCuboids.isEmpty()) continue;
            for (BlockStateRecordV2.CuboidElement cuboid : baseCuboids) {
                this.cuboid_by_facing[off + 1].add(this.rotateCuboidY(cuboid, 90));
                this.cuboid_by_facing[off + 2].add(this.rotateCuboidY(cuboid, 180));
                this.cuboid_by_facing[off + 3].add(this.rotateCuboidY(cuboid, 270));
            }
        }
        for (int i = 0; i < this.cuboid_by_facing.length; ++i) {
            if (this.SHAPE_BY_INDEX[i] != null) continue;
            this.SHAPE_BY_INDEX[i] = this.computeShapeFromCuboids(this.cuboid_by_facing[i]);
        }
        class_2680 defbs = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11034)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        if (this.STATE != null) {
            defbs = (class_2680)defbs.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        this.method_9590(defbs);
    }

    private BlockStateRecordV2.CuboidElement rotateCuboidY(BlockStateRecordV2.CuboidElement cuboid, int degrees) {
        float newZMax;
        float newZMin;
        float newXMax;
        float newXMin;
        float xMin = cuboid.xMin;
        float xMax = cuboid.xMax;
        float yMin = cuboid.yMin;
        float yMax = cuboid.yMax;
        float zMin = cuboid.zMin;
        float zMax = cuboid.zMax;
        switch (degrees % 360) {
            case 90: {
                newXMin = 1.0f - zMax;
                newXMax = 1.0f - zMin;
                newZMin = xMin;
                newZMax = xMax;
                break;
            }
            case 180: {
                newXMin = 1.0f - xMax;
                newXMax = 1.0f - xMin;
                newZMin = 1.0f - zMax;
                newZMax = 1.0f - zMin;
                break;
            }
            case 270: {
                newXMin = zMin;
                newXMax = zMax;
                newZMin = 1.0f - xMax;
                newZMax = 1.0f - xMin;
                break;
            }
            default: {
                return cuboid;
            }
        }
        BlockStateRecordV2.CuboidElement rotated = new BlockStateRecordV2.CuboidElement();
        rotated.xMin = newXMin;
        rotated.xMax = newXMax;
        rotated.yMin = yMin;
        rotated.yMax = yMax;
        rotated.zMin = newZMin;
        rotated.zMax = newZMax;
        rotated.sideTextures = cuboid.sideTextures;
        rotated.sideRotations = cuboid.sideRotations;
        rotated.noTint = cuboid.noTint;
        rotated.shape = cuboid.shape;
        return rotated;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        class_2350[] placementDirections = ctx.method_7718();
        class_2350 facing = class_2350.field_11034;
        for (class_2350 direction : placementDirections) {
            if (direction != class_2350.field_11034 && direction != class_2350.field_11039 && direction != class_2350.field_11043 && direction != class_2350.field_11035) continue;
            facing = direction.method_10153();
            break;
        }
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        if (this.STATE != null) {
            state = (class_2680)state.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        return state;
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Override
    protected int getIndexFromState(class_2680 state) {
        int off = super.getIndexFromState(state);
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11034 -> off;
            case class_2350.field_11035 -> off + 1;
            case class_2350.field_11039 -> off + 2;
            case class_2350.field_11043 -> off + 3;
            default -> off;
        };
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            ModProperties.StateProperty stateProperty = definition.buildStateProperty();
            boolean doToggleOnUse = definition.toggleOnUse();
            WCCuboidBlock.tempSTATE = stateProperty;
            return new WCCuboidNSEWBlock(settings, definition, doToggleOnUse);
        }
    }
}

