/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class WCCuboidNSEWStackBlock
extends WCCuboidBlock
implements class_3737 {
    public static final class_2753 FACING = class_2753.method_11845((String)"facing", (class_2350[])new class_2350[]{class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11043});
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    protected final boolean allowHalfBreak;
    protected final class_265[] SHAPE_BY_INDEX;

    public WCCuboidNSEWStackBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, boolean doAllowHalfBreak) {
        super(settings, def, 8, false);
        this.allowHalfBreak = doAllowHalfBreak;
        this.SHAPE_BY_INDEX = new class_265[8];
        if (def != null && def.getStateCount() >= 2) {
            BlockDefinitionV2.StateVariantV2 bottomElement = def.getStates().get(0);
            BlockDefinitionV2.StateVariantV2 topElement = def.getStates().get(1);
            this.initializeShapesForHalf(bottomElement, 0);
            this.initializeShapesForHalf(topElement, 4);
        } else {
            for (int i = 0; i < 8; ++i) {
                this.SHAPE_BY_INDEX[i] = class_259.method_1077();
            }
        }
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)FACING, (Comparable)class_2350.field_11034));
    }

    private void initializeShapesForHalf(BlockDefinitionV2.StateVariantV2 element, int baseIndex) {
        if (element != null && element.boundingBox != null) {
            BlockStateRecordV2.BoundingBox bbox = element.boundingBox;
            this.SHAPE_BY_INDEX[baseIndex] = this.createRotatedShape(bbox, 0);
            this.SHAPE_BY_INDEX[baseIndex + 1] = this.createRotatedShape(bbox, 90);
            this.SHAPE_BY_INDEX[baseIndex + 2] = this.createRotatedShape(bbox, 180);
            this.SHAPE_BY_INDEX[baseIndex + 3] = this.createRotatedShape(bbox, 270);
        } else {
            for (int i = 0; i < 4; ++i) {
                this.SHAPE_BY_INDEX[baseIndex + i] = class_259.method_1077();
            }
        }
    }

    private class_265 createRotatedShape(BlockStateRecordV2.BoundingBox bbox, int rotationDegrees) {
        double newX2;
        double newZ1;
        double newX1;
        float xMin = bbox.xMin;
        float yMin = bbox.yMin;
        float zMin = bbox.zMin;
        float xMax = bbox.xMax;
        float yMax = bbox.yMax;
        float zMax = bbox.zMax;
        double centerX = 0.5;
        double centerZ = 0.5;
        double x1 = (double)xMin - centerX;
        double z1 = (double)zMin - centerZ;
        double x2 = (double)xMax - centerX;
        double z2 = (double)zMax - centerZ;
        double newZ2 = switch (rotationDegrees) {
            case 0 -> {
                newX1 = x1;
                newZ1 = z1;
                newX2 = x2;
                yield z2;
            }
            case 90 -> {
                newX1 = -z2;
                newZ1 = x1;
                newX2 = -z1;
                yield x2;
            }
            case 180 -> {
                newX1 = -x2;
                newZ1 = -z2;
                newX2 = -x1;
                yield -z1;
            }
            case 270 -> {
                newX1 = z1;
                newZ1 = -x2;
                newX2 = z2;
                yield -x1;
            }
            default -> throw new IllegalArgumentException("Invalid rotation: " + rotationDegrees);
        };
        double finalXMin = Math.min(newX1 += centerX, newX2 += centerX);
        double finalXMax = Math.max(newX1, newX2);
        double finalZMin = Math.min(newZ1 += centerZ, newZ2 += centerZ);
        double finalZMax = Math.max(newZ1, newZ2);
        return class_259.method_1081((double)finalXMin, (double)yMin, (double)finalZMin, (double)finalXMax, (double)yMax, (double)finalZMax);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, HALF});
    }

    @Override
    protected int getIndexFromState(class_2680 state) {
        int topOffset = state.method_11654(HALF) == class_2756.field_12607 ? 0 : 4;
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11035 -> topOffset + 1;
            case class_2350.field_11039 -> topOffset + 2;
            case class_2350.field_11043 -> topOffset + 3;
            default -> topOffset;
        };
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.SHAPE_BY_INDEX[this.getIndexFromState(state)];
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.SHAPE_BY_INDEX[this.getIndexFromState(state)];
    }

    @Override
    public class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return this.SHAPE_BY_INDEX[this.getIndexFromState(state)];
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockpos = ctx.method_8037();
        if (blockpos.method_10264() < ctx.method_8045().method_31600() && ctx.method_8045().method_8320(blockpos.method_10084()).method_26166(ctx)) {
            class_3610 fluidstate = ctx.method_8045().method_8316(ctx.method_8037());
            class_2350[] adirection = ctx.method_7718();
            class_2350 dir = class_2350.field_11034;
            for (class_2350 d : adirection) {
                if (d != class_2350.field_11034 && d != class_2350.field_11039 && d != class_2350.field_11043 && d != class_2350.field_11035) continue;
                dir = d;
                break;
            }
            return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)dir)).method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.method_15767(class_3486.field_15517)));
        }
        return null;
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (this.allowHalfBreak) {
            return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        }
        class_2756 doubleblockhalf = (class_2756)state.method_11654(HALF);
        if (direction.method_10166() != class_2350.class_2351.field_11052 || doubleblockhalf == class_2756.field_12607 != (direction == class_2350.field_11036) || neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) != doubleblockhalf) {
            return doubleblockhalf == class_2756.field_12607 && direction == class_2350.field_11033 && !state.method_26184((class_4538)world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        }
        return class_2246.field_10124.method_9564();
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2338 above = pos.method_10084();
        class_3610 fluidstate = world.method_8316(above);
        world.method_8652(above, (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657(HALF, (Comparable)class_2756.field_12609)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.method_15767(class_3486.field_15517))), 3);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (this.allowHalfBreak || state.method_11654(HALF) != class_2756.field_12609) {
            return super.method_9558(state, world, pos);
        }
        class_2680 blockstate = world.method_8320(pos.method_10074());
        if (state.method_26204() != this) {
            return super.method_9558(state, world, pos);
        }
        return blockstate.method_27852((class_2248)this) && blockstate.method_11654(HALF) == class_2756.field_12607;
    }

    @Override
    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings().method_22488();
            boolean doAllowHalfBreak = definition.isAllowHalfBreak();
            return new WCCuboidNSEWStackBlock(settings, definition, doAllowHalfBreak);
        }
    }
}

