/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.utils.ModProperties;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class WCCuboidNSEWUDBlock
extends WCCuboidBlock
implements class_3737 {
    public static final class_2753 FACING = class_2741.field_12525;

    public WCCuboidNSEWUDBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, boolean doToggleOnUse) {
        super(settings, def, 6, doToggleOnUse);
        int stcnt = def.getStateCount();
        for (int stidx = 0; stidx < stcnt; ++stidx) {
            int off = stidx * this.modelsPerState;
            List baseCuboids = this.cuboid_by_facing[off];
            if (baseCuboids == null || baseCuboids.isEmpty()) continue;
            for (BlockStateRecordV2.CuboidElement cuboid : baseCuboids) {
                this.cuboid_by_facing[off + 1].add(this.rotateCuboidY(cuboid, 90));
                this.cuboid_by_facing[off + 2].add(this.rotateCuboidY(cuboid, 180));
                this.cuboid_by_facing[off + 3].add(this.rotateCuboidY(cuboid, 270));
                this.cuboid_by_facing[off + 4].add(this.rotateCuboidX(cuboid, 270));
                this.cuboid_by_facing[off + 5].add(this.rotateCuboidX(cuboid, 90));
            }
        }
        for (int i = 0; i < this.cuboid_by_facing.length; ++i) {
            if (this.SHAPE_BY_INDEX[i] != null) continue;
            this.SHAPE_BY_INDEX[i] = this.computeShapeFromCuboids(this.cuboid_by_facing[i]);
        }
        class_2680 defbs = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11034);
        if (this.STATE != null) {
            defbs = (class_2680)defbs.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        this.method_9590(defbs);
    }

    private BlockStateRecordV2.CuboidElement rotateCuboidY(BlockStateRecordV2.CuboidElement cuboid, int degrees) {
        float newZMax;
        float newZMin;
        float newXMax;
        float newXMin;
        float xMin = cuboid.xMin;
        float xMax = cuboid.xMax;
        float yMin = cuboid.yMin;
        float yMax = cuboid.yMax;
        float zMin = cuboid.zMin;
        float zMax = cuboid.zMax;
        switch (degrees % 360) {
            case 90: {
                newXMin = 1.0f - zMax;
                newXMax = 1.0f - zMin;
                newZMin = xMin;
                newZMax = xMax;
                break;
            }
            case 180: {
                newXMin = 1.0f - xMax;
                newXMax = 1.0f - xMin;
                newZMin = 1.0f - zMax;
                newZMax = 1.0f - zMin;
                break;
            }
            case 270: {
                newXMin = zMin;
                newXMax = zMax;
                newZMin = 1.0f - xMax;
                newZMax = 1.0f - xMin;
                break;
            }
            default: {
                return cuboid;
            }
        }
        BlockStateRecordV2.CuboidElement rotated = new BlockStateRecordV2.CuboidElement();
        rotated.xMin = newXMin;
        rotated.xMax = newXMax;
        rotated.yMin = yMin;
        rotated.yMax = yMax;
        rotated.zMin = newZMin;
        rotated.zMax = newZMax;
        rotated.sideTextures = cuboid.sideTextures;
        rotated.sideRotations = cuboid.sideRotations;
        rotated.noTint = cuboid.noTint;
        rotated.shape = cuboid.shape;
        return rotated;
    }

    private BlockStateRecordV2.CuboidElement rotateCuboidX(BlockStateRecordV2.CuboidElement cuboid, int degrees) {
        float newZMax;
        float newZMin;
        float newYMax;
        float newYMin;
        float xMin = cuboid.xMin;
        float xMax = cuboid.xMax;
        float yMin = cuboid.yMin;
        float yMax = cuboid.yMax;
        float zMin = cuboid.zMin;
        float zMax = cuboid.zMax;
        switch (degrees % 360) {
            case 90: {
                newYMin = zMin;
                newYMax = zMax;
                newZMin = 1.0f - yMax;
                newZMax = 1.0f - yMin;
                break;
            }
            case 270: {
                newYMin = 1.0f - zMax;
                newYMax = 1.0f - zMin;
                newZMin = yMin;
                newZMax = yMax;
                break;
            }
            default: {
                return cuboid;
            }
        }
        BlockStateRecordV2.CuboidElement rotated = new BlockStateRecordV2.CuboidElement();
        rotated.xMin = xMin;
        rotated.xMax = xMax;
        rotated.yMin = newYMin;
        rotated.yMax = newYMax;
        rotated.zMin = newZMin;
        rotated.zMax = newZMax;
        rotated.sideTextures = cuboid.sideTextures;
        rotated.sideRotations = cuboid.sideRotations;
        rotated.noTint = cuboid.noTint;
        rotated.shape = cuboid.shape;
        return rotated;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        class_2350 dir = ctx.method_7715().method_10153();
        if (ctx.method_8036() == null) {
            dir = ctx.method_8038().method_10153();
        }
        class_2680 bs = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)dir)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        if (this.STATE != null) {
            bs = (class_2680)bs.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        return bs;
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        if (facing == class_2350.field_11036 || facing == class_2350.field_11033) {
            return state;
        }
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503(facing));
    }

    @Override
    protected int getIndexFromState(class_2680 state) {
        int off = super.getIndexFromState(state);
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11034 -> off;
            case class_2350.field_11035 -> off + 1;
            case class_2350.field_11039 -> off + 2;
            case class_2350.field_11043 -> off + 3;
            case class_2350.field_11036 -> off + 4;
            case class_2350.field_11033 -> off + 5;
        };
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            ModProperties.StateProperty stateProperty = definition.buildStateProperty();
            boolean doToggleOnUse = definition.toggleOnUse();
            WCCuboidBlock.tempSTATE = stateProperty;
            return new WCCuboidNSEWUDBlock(settings, definition, doToggleOnUse);
        }
    }
}

