/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinitionV2;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2750;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5431;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class WCHalfDoorBlock
extends class_2248 {
    protected BlockDefinitionV2 definition;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 OPEN = class_2741.field_12537;
    public static final class_2754<class_2750> HINGE = class_2741.field_12520;
    public static final class_2746 POWERED = class_2741.field_12484;
    protected static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final class_265 WEST_SHAPE = class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final boolean locked;
    private final boolean allowUnsupported;

    public WCHalfDoorBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, boolean locked, boolean allowUnsupported) {
        super(settings);
        this.definition = def;
        this.locked = locked;
        this.allowUnsupported = allowUnsupported;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(HINGE, (Comparable)class_2750.field_12588)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, OPEN, HINGE, POWERED});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        boolean closed = (Boolean)state.method_11654((class_2769)OPEN) == false;
        boolean rightHinge = state.method_11654(HINGE) == class_2750.field_12586;
        return switch (direction) {
            case class_2350.field_11034 -> {
                if (closed) {
                    yield EAST_SHAPE;
                }
                if (rightHinge) {
                    yield NORTH_SHAPE;
                }
                yield SOUTH_SHAPE;
            }
            case class_2350.field_11035 -> {
                if (closed) {
                    yield SOUTH_SHAPE;
                }
                if (rightHinge) {
                    yield EAST_SHAPE;
                }
                yield WEST_SHAPE;
            }
            case class_2350.field_11039 -> {
                if (closed) {
                    yield WEST_SHAPE;
                }
                if (rightHinge) {
                    yield SOUTH_SHAPE;
                }
                yield NORTH_SHAPE;
            }
            default -> closed ? NORTH_SHAPE : (rightHinge ? WEST_SHAPE : EAST_SHAPE);
        };
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2338 pos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        boolean powered = world.method_49803(pos);
        return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153())).method_11657(HINGE, (Comparable)this.calculateHinge(ctx))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(powered));
    }

    private class_2750 calculateHinge(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2350 direction = ctx.method_8042();
        class_2350 counterClockwise = direction.method_10160();
        class_2350 clockwise = direction.method_10170();
        class_2338 counterPos = pos.method_10093(counterClockwise);
        class_2338 clockPos = pos.method_10093(clockwise);
        class_2680 counterState = world.method_8320(counterPos);
        class_2680 clockState = world.method_8320(clockPos);
        int sum = (counterState.method_26234((class_1922)world, counterPos) ? -1 : 0) + (clockState.method_26234((class_1922)world, clockPos) ? 1 : 0);
        boolean counterIsDoor = counterState.method_26204() instanceof WCHalfDoorBlock;
        boolean clockIsDoor = clockState.method_26204() instanceof WCHalfDoorBlock;
        if ((!counterIsDoor || clockIsDoor) && sum <= 0) {
            if ((!clockIsDoor || counterIsDoor) && sum >= 0) {
                class_243 hit = ctx.method_17698();
                double x = hit.field_1352 - (double)pos.method_10263();
                double z = hit.field_1350 - (double)pos.method_10260();
                int dirX = direction.method_10148();
                int dirZ = direction.method_10165();
                return !(dirX < 0 && !(z >= 0.5) || dirX > 0 && !(z <= 0.5) || dirZ < 0 && !(x <= 0.5) || dirZ > 0 && !(x >= 0.5)) ? class_2750.field_12588 : class_2750.field_12586;
            }
            return class_2750.field_12588;
        }
        return class_2750.field_12586;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (this.locked) {
            return class_1269.field_5811;
        }
        state = (class_2680)state.method_28493((class_2769)OPEN);
        world.method_8652(pos, state, 10);
        this.playToggleSound(world, pos, (Boolean)state.method_11654((class_2769)OPEN));
        world.method_33596((class_1297)player, (class_6880)((Boolean)state.method_11654((class_2769)OPEN) != false ? class_5712.field_28168 : class_5712.field_28169), pos);
        return class_1269.method_29236((boolean)world.field_9236);
    }

    private void playToggleSound(class_1937 world, class_2338 pos, boolean open) {
        world.method_8396(null, pos, open ? class_3417.field_14664 : class_3417.field_14541, class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.1f + 0.9f);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        boolean powered = world.method_49803(pos);
        if (!state.method_27852(block) && powered != (Boolean)state.method_11654((class_2769)POWERED)) {
            if (powered != (Boolean)state.method_11654((class_2769)OPEN)) {
                this.playToggleSound(world, pos, powered);
                world.method_33596(null, (class_6880)(powered ? class_5712.field_28168 : class_5712.field_28169), pos);
            }
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11033 && !this.method_9558(state, (class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (this.allowUnsupported) {
            return true;
        }
        class_2338 belowPos = pos.method_10074();
        return world.method_8320(belowPos).method_30368((class_1922)world, belowPos, class_2350.field_11036, class_5431.field_25824);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return mirror == class_2415.field_11302 ? state : (class_2680)state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING))).method_28493(HINGE);
    }

    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            boolean locked = definition.isLocked();
            boolean allowUnsupported = definition.isAllowUnsupported();
            return new WCHalfDoorBlock(settings, definition, locked, allowUnsupported);
        }
    }
}

