/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.google.common.collect.ImmutableMap;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinitionV2;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class WCMountedBlock
extends class_2248 {
    protected BlockDefinitionV2 definition;
    private final boolean allowUnsupported;
    public static final class_2753 FACING = class_2741.field_12481;
    private final Map<class_2350, class_265> shapesByFacing;

    public WCMountedBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, Map<class_2350, class_265> shapes, boolean allowUnsupported) {
        super(settings);
        this.definition = def;
        this.allowUnsupported = allowUnsupported;
        this.shapesByFacing = shapes != null ? shapes : WCMountedBlock.createDefaultShapes();
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    private static Map<class_2350, class_265> createDefaultShapes() {
        return ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (Object)class_2350.field_11034, (Object)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = this.method_9564();
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        for (class_2350 direction : ctx.method_7718()) {
            class_2350 opposite;
            if (!direction.method_10166().method_10179() || !(state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)(opposite = direction.method_10153()))).method_26184((class_4538)world, pos)) continue;
            return state;
        }
        return null;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (this.allowUnsupported) {
            return true;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2350 attachmentDir = facing.method_10153();
        class_2338 attachPos = pos.method_10093(attachmentDir);
        class_2680 attachState = world.method_8320(attachPos);
        return attachState.method_26206((class_1922)world, attachPos, facing);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10153() == state.method_11654((class_2769)FACING) && !this.method_9558(state, (class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapesByFacing.get(state.method_11654((class_2769)FACING));
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapesByFacing.get(state.method_11654((class_2769)FACING));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            Map<class_2350, class_265> shapes = Factory.createRotatedShapes(definition);
            boolean allowUnsupported = definition.isAllowUnsupported();
            return new WCMountedBlock(settings, definition, shapes, allowUnsupported);
        }

        private static Map<class_2350, class_265> createRotatedShapes(BlockDefinitionV2 definition) {
            if (!definition.hasBoundingBox()) {
                return WCMountedBlock.createDefaultShapes();
            }
            BlockDefinitionV2.BoundingBox bbox = definition.getBoundingBox();
            double xMin = bbox.getXMin();
            double xMax = bbox.getXMax();
            double yMin = bbox.getYMin();
            double yMax = bbox.getYMax();
            double zMin = bbox.getZMin();
            double zMax = bbox.getZMax();
            return ImmutableMap.of((Object)class_2350.field_11034, (Object)class_2248.method_9541((double)(xMin * 16.0), (double)(yMin * 16.0), (double)(zMin * 16.0), (double)(xMax * 16.0), (double)(yMax * 16.0), (double)(zMax * 16.0)), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)((1.0 - xMax) * 16.0), (double)(yMin * 16.0), (double)(zMin * 16.0), (double)((1.0 - xMin) * 16.0), (double)(yMax * 16.0), (double)(zMax * 16.0)), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)(zMin * 16.0), (double)(yMin * 16.0), (double)(xMin * 16.0), (double)(zMax * 16.0), (double)(yMax * 16.0), (double)(xMax * 16.0)), (Object)class_2350.field_11043, (Object)class_2248.method_9541((double)(zMin * 16.0), (double)(yMin * 16.0), (double)((1.0 - xMax) * 16.0), (double)(zMax * 16.0), (double)(yMax * 16.0), (double)((1.0 - xMin) * 16.0)));
        }
    }
}

