/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.utils.ModProperties;
import java.util.stream.IntStream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2778;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class WCStairBlock
extends class_2248
implements class_3737 {
    protected BlockDefinitionV2 definition;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<class_2760> HALF = class_2741.field_12518;
    public static final class_2754<class_2778> SHAPE = class_2741.field_12503;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 UNCONNECT = class_2746.method_11825((String)"unconnect");
    public static final class_2758 CONNECTSTATE = class_2758.method_11867((String)"connectstate", (int)0, (int)3);
    protected static ModProperties.StateProperty tempSTATE;
    public ModProperties.StateProperty STATE;
    protected static class_2746 tempUNCONNECT;
    protected static class_2758 tempCONNECTSTATE;
    protected boolean toggleOnUse = false;
    public final boolean unconnect;
    public final boolean connectstate;
    public final boolean no_uvlock;
    protected static final class_265 BOTTOM_AABB;
    protected static final class_265 TOP_AABB;
    protected static final class_265 OCTET_NNN;
    protected static final class_265 OCTET_NNP;
    protected static final class_265 OCTET_NPN;
    protected static final class_265 OCTET_NPP;
    protected static final class_265 OCTET_PNN;
    protected static final class_265 OCTET_PNP;
    protected static final class_265 OCTET_PPN;
    protected static final class_265 OCTET_PPP;
    protected static final class_265[] TOP_SHAPES;
    protected static final class_265[] BOTTOM_SHAPES;
    private static final int[] SHAPE_BY_STATE;

    public WCStairBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, boolean doToggleOnUse, boolean doUnconnect, boolean doConnectstate, boolean noUvlock) {
        super(settings);
        this.definition = def;
        this.toggleOnUse = doToggleOnUse;
        this.unconnect = doUnconnect;
        this.connectstate = doConnectstate;
        this.no_uvlock = noUvlock;
        class_2680 defbs = (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(HALF, (Comparable)class_2760.field_12617)).method_11657(SHAPE, (Comparable)class_2778.field_12710)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        if (doUnconnect) {
            defbs = (class_2680)defbs.method_11657((class_2769)UNCONNECT, (Comparable)Boolean.valueOf(false));
        }
        if (doConnectstate) {
            defbs = (class_2680)defbs.method_11657((class_2769)CONNECTSTATE, (Comparable)Integer.valueOf(0));
        }
        if (tempSTATE != null) {
            defbs = (class_2680)defbs.method_11657((class_2769)tempSTATE, (Comparable)((Object)WCStairBlock.tempSTATE.defValue));
        }
        this.method_9590(defbs);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, HALF, SHAPE, WATERLOGGED});
        if (tempUNCONNECT != null) {
            builder.method_11667(new class_2769[]{tempUNCONNECT});
            tempUNCONNECT = null;
        }
        if (tempCONNECTSTATE != null) {
            builder.method_11667(new class_2769[]{tempCONNECTSTATE});
            tempCONNECTSTATE = null;
        }
        if (tempSTATE != null) {
            this.STATE = tempSTATE;
            tempSTATE = null;
            builder.method_11667(new class_2769[]{this.STATE});
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 clickedFace = ctx.method_8038();
        class_2338 pos = ctx.method_8037();
        class_3610 fluidState = ctx.method_8045().method_8316(pos);
        class_2760 half = clickedFace == class_2350.field_11033 || clickedFace != class_2350.field_11036 && ctx.method_17698().field_1351 - (double)pos.method_10264() > 0.5 ? class_2760.field_12619 : class_2760.field_12617;
        class_2680 state = (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657(HALF, (Comparable)half)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        state = (class_2680)state.method_11657(SHAPE, (Comparable)WCStairBlock.getStairShape(state, (class_1922)ctx.method_8045(), pos));
        if (this.STATE != null) {
            state = (class_2680)state.method_11657((class_2769)this.STATE, (Comparable)((Object)this.STATE.defValue));
        }
        return state;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (this.unconnect && ((Boolean)state.method_11654((class_2769)UNCONNECT)).booleanValue()) {
            return state;
        }
        if (direction.method_10166().method_10179()) {
            return (class_2680)state.method_11657(SHAPE, (Comparable)WCStairBlock.getStairShape(state, (class_1922)world, pos));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (state.method_11654(HALF) == class_2760.field_12619 ? TOP_SHAPES : BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(state)]];
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1268 hand = player.method_6058();
        if (this.toggleOnUse && this.STATE != null && player.method_7337() && player.method_5998(hand).method_7960() && state.method_28498((class_2769)this.STATE)) {
            state = (class_2680)state.method_28493((class_2769)this.STATE);
            world.method_8652(pos, state, 3);
            world.method_8444(player, 1006, pos, 0);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    private int getShapeIndex(class_2680 state) {
        return ((class_2778)state.method_11654(SHAPE)).ordinal() * 4 + ((class_2350)state.method_11654((class_2769)FACING)).method_10161();
    }

    private static class_2778 getStairShape(class_2680 state, class_1922 world, class_2338 pos) {
        class_2350 oppositeFacing;
        class_2350 adjacentFacing;
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2680 adjacentState = world.method_8320(pos.method_10093(facing));
        if (WCStairBlock.isStairs(adjacentState) && state.method_11654(HALF) == adjacentState.method_11654(HALF) && (adjacentFacing = (class_2350)adjacentState.method_11654((class_2769)FACING)).method_10166() != facing.method_10166() && WCStairBlock.canTakeShape(state, world, pos, adjacentFacing.method_10153())) {
            if (adjacentFacing == facing.method_10160()) {
                return class_2778.field_12708;
            }
            return class_2778.field_12709;
        }
        class_2680 oppositeState = world.method_8320(pos.method_10093(facing.method_10153()));
        if (WCStairBlock.isStairs(oppositeState) && state.method_11654(HALF) == oppositeState.method_11654(HALF) && (oppositeFacing = (class_2350)oppositeState.method_11654((class_2769)FACING)).method_10166() != facing.method_10166() && WCStairBlock.canTakeShape(state, world, pos, oppositeFacing)) {
            if (oppositeFacing == facing.method_10160()) {
                return class_2778.field_12712;
            }
            return class_2778.field_12713;
        }
        return class_2778.field_12710;
    }

    private static boolean canTakeShape(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        class_2680 adjacentState = world.method_8320(pos.method_10093(direction));
        return !WCStairBlock.isStairs(adjacentState) || adjacentState.method_11654((class_2769)FACING) != state.method_11654((class_2769)FACING) || adjacentState.method_11654(HALF) != state.method_11654(HALF);
    }

    private static boolean isStairs(class_2680 state) {
        return state.method_26204() instanceof WCStairBlock;
    }

    private static class_265[] makeShapes(class_265 base, class_265 octet1, class_265 octet2, class_265 octet3, class_265 octet4) {
        return (class_265[])IntStream.range(0, 16).mapToObj(i -> WCStairBlock.makeStairShape(i, base, octet1, octet2, octet3, octet4)).toArray(class_265[]::new);
    }

    private static class_265 makeStairShape(int index, class_265 base, class_265 octet1, class_265 octet2, class_265 octet3, class_265 octet4) {
        class_265 shape = base;
        if ((index & 1) != 0) {
            shape = class_259.method_1084((class_265)shape, (class_265)octet1);
        }
        if ((index & 2) != 0) {
            shape = class_259.method_1084((class_265)shape, (class_265)octet2);
        }
        if ((index & 4) != 0) {
            shape = class_259.method_1084((class_265)shape, (class_265)octet3);
        }
        if ((index & 8) != 0) {
            shape = class_259.method_1084((class_265)shape, (class_265)octet4);
        }
        return shape;
    }

    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    static {
        BOTTOM_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        TOP_AABB = class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        OCTET_NNN = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
        OCTET_NNP = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
        OCTET_NPN = class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
        OCTET_NPP = class_2248.method_9541((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
        OCTET_PNN = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
        OCTET_PNP = class_2248.method_9541((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
        OCTET_PPN = class_2248.method_9541((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        OCTET_PPP = class_2248.method_9541((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
        TOP_SHAPES = WCStairBlock.makeShapes(TOP_AABB, OCTET_NNN, OCTET_PNN, OCTET_NNP, OCTET_PNP);
        BOTTOM_SHAPES = WCStairBlock.makeShapes(BOTTOM_AABB, OCTET_NPN, OCTET_PPN, OCTET_NPP, OCTET_PPP);
        SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            ModProperties.StateProperty stateProperty = definition.buildStateProperty();
            if (stateProperty != null) {
                tempSTATE = stateProperty;
            }
            boolean doToggleOnUse = definition.toggleOnUse();
            boolean doUnconnect = false;
            boolean doConnectstate = false;
            boolean noUvlock = false;
            String type = definition.getType();
            if (type != null) {
                String[] toks;
                for (String tok : toks = type.split(",")) {
                    String trimmed = tok.trim();
                    if (trimmed.equals("unconnect")) {
                        doUnconnect = true;
                        tempUNCONNECT = UNCONNECT;
                        continue;
                    }
                    if (trimmed.equals("connectstate")) {
                        doConnectstate = true;
                        tempCONNECTSTATE = CONNECTSTATE;
                        continue;
                    }
                    if (!trimmed.equals("no-uvlock")) continue;
                    noUvlock = true;
                }
            }
            return new WCStairBlock(settings, definition, doToggleOnUse, doUnconnect, doConnectstate, noUvlock);
        }
    }
}

