/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.google.common.collect.ImmutableMap;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinitionV2;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public class WCTableBlock
extends class_2248 {
    protected BlockDefinitionV2 definition;
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2754<ConnectionType> CONNECTION = class_2754.method_11850((String)"connection", ConnectionType.class);
    private static final class_265 TABLE_SHAPE_NS = class_2248.method_9541((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)14.0, (double)13.0);
    private static final class_265 TABLE_SHAPE_EW = class_2248.method_9541((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)14.0, (double)15.0);
    private final Map<class_2680, class_265> shapeByIndex;

    public WCTableBlock(class_4970.class_2251 settings, BlockDefinitionV2 def) {
        super(settings);
        this.definition = def;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(CONNECTION, (Comparable)((Object)ConnectionType.SINGLE)));
        this.shapeByIndex = this.makeShapes();
    }

    private Map<class_2680, class_265> makeShapes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            class_265 shape = facing == class_2350.field_11043 || facing == class_2350.field_11035 ? TABLE_SHAPE_NS : TABLE_SHAPE_EW;
            for (ConnectionType connection : ConnectionType.values()) {
                class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657(CONNECTION, (Comparable)((Object)connection));
                builder.put((Object)state, (Object)shape);
            }
        }
        return builder.build();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, CONNECTION});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_8042().method_10153();
        class_2338 pos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        ConnectionType connectionType = this.getConnectionType((class_1922)world, pos, facing);
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657(CONNECTION, (Comparable)((Object)connectionType));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10166().method_10179()) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            class_2350 left = facing.method_10160();
            class_2350 right = facing.method_10170();
            if (direction == left || direction == right) {
                ConnectionType newConnection = this.getConnectionType((class_1922)world, pos, facing);
                return (class_2680)state.method_11657(CONNECTION, (Comparable)((Object)newConnection));
            }
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    private ConnectionType getConnectionType(class_1922 world, class_2338 pos, class_2350 facing) {
        class_2350 left = facing.method_10160();
        class_2350 right = facing.method_10170();
        boolean connectsLeft = this.canConnectTo(world, pos, left, facing);
        boolean connectsRight = this.canConnectTo(world, pos, right, facing);
        if (connectsLeft && connectsRight) {
            return ConnectionType.MIDDLE;
        }
        if (connectsLeft) {
            return ConnectionType.RIGHT;
        }
        if (connectsRight) {
            return ConnectionType.LEFT;
        }
        return ConnectionType.SINGLE;
    }

    private boolean canConnectTo(class_1922 world, class_2338 pos, class_2350 direction, class_2350 thisFacing) {
        class_2338 neighborPos = pos.method_10093(direction);
        class_2680 neighborState = world.method_8320(neighborPos);
        if (!neighborState.method_27852((class_2248)this)) {
            return false;
        }
        class_2350 neighborFacing = (class_2350)neighborState.method_11654((class_2769)FACING);
        return neighborFacing == thisFacing;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapeByIndex.get(state);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapeByIndex.get(state);
    }

    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    public static enum ConnectionType implements class_3542
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle");

        private final String name;

        private ConnectionType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            return new WCTableBlock(settings, definition);
        }
    }
}

