/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.ModBlocks;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.WCWallTorchBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2527;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class WCTorchBlock
extends class_2527 {
    protected BlockDefinitionV2 definition;
    private final boolean allowUnsupported;
    private final boolean noParticle;
    private final class_2248 wallBlock;

    public WCTorchBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, class_2248 wallBlock, boolean allowUnsupported, boolean noParticle) {
        super(WCTorchBlock.getParticle(noParticle), settings);
        this.definition = def;
        this.wallBlock = wallBlock;
        this.allowUnsupported = allowUnsupported;
        this.noParticle = noParticle;
    }

    private static class_2400 getParticle(boolean noParticle) {
        if (noParticle) {
            return null;
        }
        return class_2398.field_11240;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = super.method_9605(ctx);
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        for (class_2350 direction : ctx.method_7718()) {
            class_2350 opposite;
            class_2338 attachPos;
            if (!direction.method_10166().method_10179() || !world.method_8320(attachPos = pos.method_10093(opposite = direction.method_10153())).method_26206((class_1922)world, attachPos, direction)) continue;
            return (class_2680)this.wallBlock.method_9564().method_11657((class_2769)WCWallTorchBlock.FACING, (Comparable)direction);
        }
        return state;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (!this.noParticle) {
            super.method_9496(state, world, pos, random);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (this.allowUnsupported) {
            return true;
        }
        return super.method_9558(state, world, pos);
    }

    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            boolean allowUnsupported = definition.isAllowUnsupported();
            boolean noParticle = definition.isNoParticle();
            class_4970.class_2251 wallSettings = definition.makeSettings();
            WCWallTorchBlock wallBlock = new WCWallTorchBlock(wallSettings, definition, allowUnsupported, noParticle);
            String wallTorchName = "wall_" + definition.getBlockName();
            class_2248 registeredWallBlock = ModBlocks.registerBlockWithoutItem(wallTorchName, (class_2248)wallBlock);
            class_4970.class_2251 floorSettings = definition.makeSettings();
            return new WCTorchBlock(floorSettings, definition, registeredWallBlock, allowUnsupported, noParticle);
        }
    }
}

