/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.utils.ModProperties;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2544;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4778;
import net.minecraft.class_4970;

public class WCWallBlock
extends class_2544
implements class_3737 {
    protected BlockDefinitionV2 definition;
    public static final class_2746 UNCONNECT = class_2746.method_11825((String)"unconnect");
    public static final class_2758 CONNECT_STATE = class_2758.method_11867((String)"connectstate", (int)0, (int)3);
    protected static class_2746 tempUNCONNECT;
    protected static class_2758 tempCONNECT_STATE;
    protected static ModProperties.StateProperty tempSTATE;
    private final boolean hasUnconnect;
    private final boolean hasConnectState;
    private final boolean toggleOnUse;
    private final WallSize wallSize;
    protected ModProperties.StateProperty STATE;
    private static class_265[] normalShapes;
    private static class_265[] shortShapes;
    private static class_265[] collisionShapes;

    protected WCWallBlock(class_4970.class_2251 settings, BlockDefinitionV2 def, boolean unconnect, boolean connectState, String size, boolean toggleOnUse) {
        super(settings);
        this.definition = def;
        this.hasUnconnect = unconnect;
        this.hasConnectState = connectState;
        this.toggleOnUse = toggleOnUse;
        this.wallSize = size != null && size.equals("short") ? WallSize.SHORT : WallSize.NORMAL;
        class_2680 defaultState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11717, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)field_22157, (Comparable)class_4778.field_22178)).method_11657((class_2769)field_22156, (Comparable)class_4778.field_22178)).method_11657((class_2769)field_22158, (Comparable)class_4778.field_22178)).method_11657((class_2769)field_22159, (Comparable)class_4778.field_22178)).method_11657((class_2769)field_22160, (Comparable)Boolean.valueOf(false));
        if (this.hasUnconnect) {
            defaultState = (class_2680)defaultState.method_11657((class_2769)UNCONNECT, (Comparable)Boolean.valueOf(false));
        }
        if (this.hasConnectState) {
            defaultState = (class_2680)defaultState.method_11657((class_2769)CONNECT_STATE, (Comparable)Integer.valueOf(0));
        }
        this.method_9590(defaultState);
        if (normalShapes == null) {
            normalShapes = WCWallBlock.makeShapes(4.0f, 3.0f, 16.0f, 0.0f, 16.0f, 16.0f);
        }
        if (shortShapes == null) {
            shortShapes = WCWallBlock.makeShapes(4.0f, 3.0f, 16.0f, 0.0f, 13.0f, 16.0f);
        }
        if (collisionShapes == null) {
            collisionShapes = WCWallBlock.makeShapes(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        if (tempUNCONNECT != null) {
            builder.method_11667(new class_2769[]{tempUNCONNECT});
            tempUNCONNECT = null;
        }
        if (tempCONNECT_STATE != null) {
            builder.method_11667(new class_2769[]{tempCONNECT_STATE});
            tempCONNECT_STATE = null;
        }
        if (tempSTATE != null) {
            this.STATE = tempSTATE;
            builder.method_11667(new class_2769[]{tempSTATE});
            tempSTATE = null;
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265[] shapes = this.wallSize == WallSize.SHORT ? shortShapes : normalShapes;
        return shapes[WCWallBlock.getShapeIndex(state)];
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return collisionShapes[WCWallBlock.getShapeIndex(state)];
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)field_22160)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (this.hasUnconnect && ((Boolean)state.method_11654((class_2769)UNCONNECT)).booleanValue()) {
            return state;
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (this.toggleOnUse && this.STATE != null && player.method_7337() && player.method_6047().method_7960()) {
            state = (class_2680)state.method_28493((class_2769)this.STATE);
            world.method_8652(pos, state, 3);
            world.method_8444(player, 1006, pos, 0);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (this.toggleOnUse && this.hasConnectState && player.method_7337() && player.method_6047().method_7960()) {
            int currentState = (Integer)state.method_11654((class_2769)CONNECT_STATE);
            int nextState = (currentState + 1) % 4;
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)CONNECT_STATE, (Comparable)Integer.valueOf(nextState)), 3);
            world.method_8444(player, 1006, pos, 0);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)field_22160) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)field_22157, (Comparable)((class_4778)state.method_11654((class_2769)field_22158)))).method_11657((class_2769)field_22156, (Comparable)((class_4778)state.method_11654((class_2769)field_22159)))).method_11657((class_2769)field_22158, (Comparable)((class_4778)state.method_11654((class_2769)field_22157)))).method_11657((class_2769)field_22159, (Comparable)((class_4778)state.method_11654((class_2769)field_22156)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)field_22157, (Comparable)((class_4778)state.method_11654((class_2769)field_22156)))).method_11657((class_2769)field_22156, (Comparable)((class_4778)state.method_11654((class_2769)field_22158)))).method_11657((class_2769)field_22158, (Comparable)((class_4778)state.method_11654((class_2769)field_22159)))).method_11657((class_2769)field_22159, (Comparable)((class_4778)state.method_11654((class_2769)field_22157)));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)field_22157, (Comparable)((class_4778)state.method_11654((class_2769)field_22159)))).method_11657((class_2769)field_22156, (Comparable)((class_4778)state.method_11654((class_2769)field_22157)))).method_11657((class_2769)field_22158, (Comparable)((class_4778)state.method_11654((class_2769)field_22156)))).method_11657((class_2769)field_22159, (Comparable)((class_4778)state.method_11654((class_2769)field_22158)));
            }
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657((class_2769)field_22157, (Comparable)((class_4778)state.method_11654((class_2769)field_22158)))).method_11657((class_2769)field_22158, (Comparable)((class_4778)state.method_11654((class_2769)field_22157)));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657((class_2769)field_22156, (Comparable)((class_4778)state.method_11654((class_2769)field_22159)))).method_11657((class_2769)field_22159, (Comparable)((class_4778)state.method_11654((class_2769)field_22156)));
            }
        }
        return super.method_9569(state, mirror);
    }

    private static int getShapeIndex(class_2680 state) {
        int up = (Boolean)state.method_11654((class_2769)field_11717) != false ? 1 : 0;
        int north = ((class_4778)state.method_11654((class_2769)field_22157)).ordinal();
        int east = ((class_4778)state.method_11654((class_2769)field_22156)).ordinal();
        int south = ((class_4778)state.method_11654((class_2769)field_22158)).ordinal();
        int west = ((class_4778)state.method_11654((class_2769)field_22159)).ordinal();
        return up + east * 2 + west * 6 + north * 18 + south * 54;
    }

    private static class_265[] makeShapes(float postWidth, float sideWidth, float postHeight, float minY, float sideHeight, float tallSideHeight) {
        float halfPost = 8.0f - postWidth;
        float halfPostEnd = 8.0f + postWidth;
        float halfSide = 8.0f - sideWidth;
        float halfSideEnd = 8.0f + sideWidth;
        class_265 postShape = class_2248.method_9541((double)halfPost, (double)0.0, (double)halfPost, (double)halfPostEnd, (double)postHeight, (double)halfPostEnd);
        class_265 northLowShape = class_2248.method_9541((double)halfSide, (double)minY, (double)0.0, (double)halfSideEnd, (double)sideHeight, (double)halfSideEnd);
        class_265 southLowShape = class_2248.method_9541((double)halfSide, (double)minY, (double)halfSide, (double)halfSideEnd, (double)sideHeight, (double)16.0);
        class_265 westLowShape = class_2248.method_9541((double)0.0, (double)minY, (double)halfSide, (double)halfSideEnd, (double)sideHeight, (double)halfSideEnd);
        class_265 eastLowShape = class_2248.method_9541((double)halfSide, (double)minY, (double)halfSide, (double)16.0, (double)sideHeight, (double)halfSideEnd);
        class_265 northTallShape = class_2248.method_9541((double)halfSide, (double)minY, (double)0.0, (double)halfSideEnd, (double)tallSideHeight, (double)halfSideEnd);
        class_265 southTallShape = class_2248.method_9541((double)halfSide, (double)minY, (double)halfSide, (double)halfSideEnd, (double)tallSideHeight, (double)16.0);
        class_265 westTallShape = class_2248.method_9541((double)0.0, (double)minY, (double)halfSide, (double)halfSideEnd, (double)tallSideHeight, (double)halfSideEnd);
        class_265 eastTallShape = class_2248.method_9541((double)halfSide, (double)minY, (double)halfSide, (double)16.0, (double)tallSideHeight, (double)halfSideEnd);
        class_265[] shapes = new class_265[162];
        for (Boolean up : field_11717.method_11898()) {
            for (class_4778 north : field_22157.method_11898()) {
                for (class_4778 east : field_22156.method_11898()) {
                    for (class_4778 south : field_22158.method_11898()) {
                        for (class_4778 west : field_22159.method_11898()) {
                            class_265 shape = class_259.method_1073();
                            shape = WCWallBlock.applyWallShape(shape, east, eastLowShape, eastTallShape);
                            shape = WCWallBlock.applyWallShape(shape, west, westLowShape, westTallShape);
                            shape = WCWallBlock.applyWallShape(shape, north, northLowShape, northTallShape);
                            shape = WCWallBlock.applyWallShape(shape, south, southLowShape, southTallShape);
                            if (up.booleanValue()) {
                                shape = class_259.method_1084((class_265)shape, (class_265)postShape);
                            }
                            int index = (up != false ? 1 : 0) + east.ordinal() * 2 + west.ordinal() * 6 + north.ordinal() * 18 + south.ordinal() * 54;
                            shapes[index] = shape;
                        }
                    }
                }
            }
        }
        return shapes;
    }

    private static class_265 applyWallShape(class_265 base, class_4778 wallShape, class_265 lowShape, class_265 tallShape) {
        if (wallShape == class_4778.field_22180) {
            return class_259.method_1084((class_265)base, (class_265)tallShape);
        }
        if (wallShape == class_4778.field_22179) {
            return class_259.method_1084((class_265)base, (class_265)lowShape);
        }
        return base;
    }

    public BlockDefinitionV2 getDefinition() {
        return this.definition;
    }

    static {
        normalShapes = null;
        shortShapes = null;
        collisionShapes = null;
    }

    public static enum WallSize {
        NORMAL(16.0f),
        SHORT(13.0f);

        public final float height;

        private WallSize(float height) {
            this.height = height;
        }
    }

    public static class Factory
    extends BlockFactory {
        @Override
        public class_2248 buildBlockClass(BlockDefinitionV2 definition) {
            class_4970.class_2251 settings = definition.makeSettings();
            ModProperties.StateProperty stateProperty = definition.buildStateProperty();
            if (stateProperty != null) {
                tempSTATE = stateProperty;
            }
            boolean unconnect = definition.isUnconnect();
            boolean connectState = definition.isConnectState();
            String size = definition.getWallSize();
            boolean toggleOnUse = definition.toggleOnUse();
            if (unconnect) {
                tempUNCONNECT = UNCONNECT;
            }
            if (connectState) {
                tempCONNECT_STATE = CONNECT_STATE;
            }
            return new WCWallBlock(settings, definition, unconnect, connectState, size, toggleOnUse);
        }
    }
}

