/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "westerosblocks.json");
    public boolean dumpWorldPainterCSV = false;
    public boolean exportBlockDefinitions = false;

    public static ModConfig load() {
        if (CONFIG_FILE.exists()) {
            ModConfig modConfig;
            FileReader reader = new FileReader(CONFIG_FILE);
            try {
                modConfig = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("Failed to load config, using defaults: " + e.getMessage());
                }
            }
            reader.close();
            return modConfig;
        }
        ModConfig config = new ModConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }
}

