/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionLoader;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockSetDefinition;
import com.westerosblocks.data.BlockSetDefinitionLoader;
import com.westerosblocks.data.BlockSetExpander;
import com.westerosblocks.data.BlockTagsDefinition;
import com.westerosblocks.data.BlockTagsLoader;
import com.westerosblocks.data.ColorMapDefinition;
import com.westerosblocks.data.ColorMapLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BlockDefinitionRegistry {
    private static BlockDefinitionRegistry instance;
    private final Map<String, BlockDefinitionV2> definitions = new HashMap<String, BlockDefinitionV2>();
    private final Map<String, List<BlockDefinitionV2>> definitionsByType = new HashMap<String, List<BlockDefinitionV2>>();
    private ColorMapDefinition colorMaps;
    private BlockTagsDefinition blockTags;
    private boolean initialized = false;

    private BlockDefinitionRegistry() {
    }

    public static synchronized BlockDefinitionRegistry getInstance() {
        if (instance == null) {
            instance = new BlockDefinitionRegistry();
        }
        return instance;
    }

    public void initialize(String blockDefinitionsPath, String blockSetDefinitionsPath) {
        if (this.initialized) {
            WesterosBlocks.LOGGER.warn("BlockDefinitionRegistry is already initialized. Skipping re-initialization.");
            return;
        }
        BlockDefinitionLoader loader = new BlockDefinitionLoader(blockDefinitionsPath);
        Map<String, BlockDefinitionV2> loadedDefinitions = loader.loadAllDefinitions();
        if (loadedDefinitions.isEmpty()) {
            WesterosBlocks.LOGGER.warn("No individual block definitions were loaded!");
        }
        this.definitions.putAll(loadedDefinitions);
        loader.validateDefinitions(loadedDefinitions);
        if (blockSetDefinitionsPath != null) {
            BlockSetDefinitionLoader setLoader = new BlockSetDefinitionLoader(blockSetDefinitionsPath);
            Map<String, BlockSetDefinition> loadedBlockSets = setLoader.loadAllDefinitions();
            if (!loadedBlockSets.isEmpty()) {
                int expandedCount = 0;
                for (BlockSetDefinition blockSet : loadedBlockSets.values()) {
                    List<BlockDefinitionV2> expandedDefinitions = BlockSetExpander.expand(blockSet);
                    for (BlockDefinitionV2 def : expandedDefinitions) {
                        if (this.definitions.containsKey(def.getBlockName())) {
                            WesterosBlocks.LOGGER.warn("Block set '{}' generated duplicate block name '{}' - skipping", (Object)blockSet.getBaseBlockName(), (Object)def.getBlockName());
                            continue;
                        }
                        this.definitions.put(def.getBlockName(), def);
                        ++expandedCount;
                    }
                }
                WesterosBlocks.LOGGER.info("Expanded block sets into {} additional block definitions", (Object)expandedCount);
                setLoader.validateDefinitions(loadedBlockSets);
            } else {
                WesterosBlocks.LOGGER.warn("No block set definitions were loaded!");
            }
        }
        this.definitionsByType.putAll(loader.groupByType(this.definitions));
        ColorMapLoader colorMapLoader = new ColorMapLoader("definitions/color_maps.json");
        this.colorMaps = colorMapLoader.loadDefinition();
        if (this.colorMaps != null) {
            colorMapLoader.validateDefinition(this.colorMaps);
        }
        BlockTagsLoader blockTagsLoader = new BlockTagsLoader("definitions/block_tags.json");
        this.blockTags = blockTagsLoader.loadDefinition();
        if (this.blockTags != null) {
            blockTagsLoader.validateDefinition(this.blockTags);
        }
        this.initialized = true;
        WesterosBlocks.LOGGER.info("BlockDefinitionRegistry initialized with {} total definitions.", (Object)this.definitions.size());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public BlockDefinitionV2 getDefinition(String blockName) {
        if (!this.initialized) {
            throw new IllegalStateException("BlockDefinitionRegistry not initialized!");
        }
        return this.definitions.get(blockName);
    }

    public List<BlockDefinitionV2> getByType(String blockType) {
        if (!this.initialized) {
            throw new IllegalStateException("BlockDefinitionRegistry not initialized!");
        }
        return this.definitionsByType.getOrDefault(blockType, Collections.emptyList());
    }

    public Collection<BlockDefinitionV2> getAllDefinitions() {
        if (!this.initialized) {
            throw new IllegalStateException("BlockDefinitionRegistry not initialized!");
        }
        return Collections.unmodifiableCollection(this.definitions.values());
    }

    public ColorMapDefinition getColorMaps() {
        if (!this.initialized) {
            throw new IllegalStateException("BlockDefinitionRegistry not initialized!");
        }
        return this.colorMaps;
    }

    public BlockTagsDefinition getBlockTags() {
        if (!this.initialized) {
            throw new IllegalStateException("BlockDefinitionRegistry not initialized!");
        }
        return this.blockTags;
    }

    public int getCount() {
        if (!this.initialized) {
            throw new IllegalStateException("BlockDefinitionRegistry not initialized!");
        }
        return this.definitions.size();
    }

    public Map<String, Integer> getTypeStatistics() {
        if (!this.initialized) {
            throw new IllegalStateException("BlockDefinitionRegistry not initialized!");
        }
        return this.definitionsByType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).size()));
    }

    public void printStatistics() {
        if (!this.initialized) {
            WesterosBlocks.LOGGER.warn("Cannot print statistics - BlockDefinitionRegistry not initialized!");
            return;
        }
        WesterosBlocks.LOGGER.info("=== Block Definition Registry Statistics ===");
        WesterosBlocks.LOGGER.info("Total definitions loaded: {}", (Object)this.getCount());
        WesterosBlocks.LOGGER.info("Block types found: {}", (Object)this.definitionsByType.size());
        for (Map.Entry<String, Integer> entry : this.getTypeStatistics().entrySet()) {
            WesterosBlocks.LOGGER.info("  {}: {} blocks", (Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    public void clear() {
        this.definitions.clear();
        this.definitionsByType.clear();
        this.initialized = false;
        WesterosBlocks.LOGGER.info("BlockDefinitionRegistry cleared");
    }
}

