/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.google.gson.annotations.SerializedName;
import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.BlockFactoryRegistry;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.utils.ModProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;

public class BlockDefinitionV2 {
    @SerializedName(value="blockName")
    private String blockName;
    @SerializedName(value="blockType")
    private String blockType = "solid";
    @SerializedName(value="label")
    private String label;
    @SerializedName(value="creativeTab")
    private String creativeTab;
    @SerializedName(value="customTags")
    private List<String> customTags;
    @SerializedName(value="hardness")
    private float hardness = 0.0f;
    @SerializedName(value="resistance")
    private float resistance = 0.0f;
    @SerializedName(value="strength")
    private Float strength;
    @SerializedName(value="soundGroup")
    private String soundGroup;
    @Deprecated
    @SerializedName(value="material")
    private String material;
    @SerializedName(value="renderLayer")
    private String renderLayer;
    @SerializedName(value="luminance")
    private Integer luminance;
    @Deprecated
    @SerializedName(value="lightOpacity")
    private Integer lightOpacity;
    @SerializedName(value="nonOpaque")
    private Boolean nonOpaque;
    @SerializedName(value="alphaRender")
    private Boolean alphaRender;
    @SerializedName(value="ambientOcclusion")
    private Boolean ambientOcclusion;
    @SerializedName(value="textures")
    private List<String> textures;
    @SerializedName(value="randomTextures")
    private List<RandomTextureVariant> randomTextures;
    @SerializedName(value="overlayTextures")
    private List<String> overlayTextures;
    @SerializedName(value="itemTexture")
    private String itemTexture;
    @SerializedName(value="customItemTexture")
    private Boolean customItemTexture;
    @SerializedName(value="itemTextureIndex")
    private Integer itemTextureIndex;
    @SerializedName(value="colorMult")
    private String colorMult = "#FFFFFF";
    @SerializedName(value="colorMults")
    private List<String> colorMults;
    @SerializedName(value="boundingBox")
    public BoundingBox boundingBox;
    @SerializedName(value="cuboids")
    private List<CuboidElement> cuboids;
    @SerializedName(value="collisionBoxes")
    private List<BoundingBox> collisionBoxes;
    @SerializedName(value="supportBoxes")
    private List<BoundingBox> supportBoxes;
    @SerializedName(value="noCollision")
    private Boolean noCollision;
    @SerializedName(value="harvestLevel")
    private List<HarvestLevel> harvestLevel;
    @SerializedName(value="requiresTool")
    private Boolean requiresTool;
    @SerializedName(value="toggleOnUse")
    private Boolean toggleOnUse;
    @SerializedName(value="locked")
    private Boolean locked;
    @SerializedName(value="allowUnsupported")
    private Boolean allowUnsupported;
    @SerializedName(value="allowHalfBreak")
    private Boolean allowHalfBreak;
    @SerializedName(value="layerSensitive")
    private Boolean layerSensitive;
    @SerializedName(value="hasClimb")
    private Boolean hasClimb;
    @SerializedName(value="hasDown")
    private Boolean hasDown;
    @SerializedName(value="connectTo")
    private String connectTo;
    @SerializedName(value="symmetrical")
    private Boolean symmetrical;
    @SerializedName(value="isCustomModel")
    private Boolean isCustomModel;
    @SerializedName(value="isTinted")
    private Boolean isTinted;
    @SerializedName(value="hasOverlay")
    private Boolean hasOverlay;
    @SerializedName(value="hasBetterFoliage")
    private Boolean hasBetterFoliage;
    @SerializedName(value="betterFoliage")
    private Boolean betterFoliage;
    @SerializedName(value="noDecay")
    private Boolean noDecay;
    @SerializedName(value="hasRotateRandom")
    private Boolean hasRotateRandom;
    @SerializedName(value="rotateRandom")
    private Boolean rotateRandom;
    @SerializedName(value="noParticle")
    private Boolean noParticle;
    @SerializedName(value="alwaysOn")
    private Boolean alwaysOn;
    @SerializedName(value="type")
    private String type = "";
    @SerializedName(value="bedType")
    private String bedType;
    @SerializedName(value="wallSize")
    private String wallSize;
    @SerializedName(value="connectstate")
    private Boolean connectState;
    @SerializedName(value="unconnect")
    private Boolean unconnect;
    @SerializedName(value="woodType")
    private String woodType;
    @SerializedName(value="particle")
    private String particle;
    @SerializedName(value="isLegacyModel")
    private String isLegacyModel;
    @SerializedName(value="states")
    private List<StateVariantV2> states;
    @SerializedName(value="stack")
    private List<StackElement> stack;
    @SerializedName(value="display")
    private DisplaySettings display;
    @SerializedName(value="tooltips")
    private List<String> tooltips;
    private transient boolean didInit = false;
    private transient StatePropertyV2 stateProperty = null;
    private transient Map<String, String> parsedType;
    private static final Map<String, class_2498> SOUND_GROUP_MAP = BlockDefinitionV2.createSoundGroupMap();

    public void doInit() {
        if (this.didInit) {
            return;
        }
        if (this.hasOverlayTextures()) {
            this.nonOpaque = true;
        }
        this.normalizeBaseTextures();
        this.processStates();
        this.processStack();
        this.createStateProperty();
        this.didInit = true;
    }

    private void normalizeBaseTextures() {
        if (this.randomTextures == null && this.textures != null && !this.textures.isEmpty()) {
            this.randomTextures = new ArrayList<RandomTextureVariant>();
            RandomTextureVariant rtv = new RandomTextureVariant();
            rtv.textures = new ArrayList<String>(this.textures);
            rtv.weight = 1;
            this.randomTextures.add(rtv);
        }
    }

    private void processStates() {
        if (this.states == null || this.states.isEmpty()) {
            StateVariantV2 baseState = new StateVariantV2();
            baseState.stateID = "base";
            baseState.textures = this.textures;
            baseState.randomTextures = this.convertRandomTextures(this.randomTextures);
            baseState.overlayTextures = this.overlayTextures;
            baseState.boundingBox = this.convertBoundingBox(this.boundingBox);
            baseState.cuboids = this.convertCuboids(this.cuboids);
            baseState.rotYOffset = 0;
            baseState.isCustomModel = this.isCustomModel;
            baseState.colorMult = this.colorMult;
            baseState.colorMults = this.colorMults;
            baseState.doStateRecordInit();
            this.states = new ArrayList<StateVariantV2>();
            this.states.add(baseState);
        } else {
            for (int i = 0; i < this.states.size(); ++i) {
                StateVariantV2 state = this.states.get(i);
                if (state.stateID == null || state.stateID.isEmpty()) {
                    state.stateID = "state" + i;
                }
                state.doStateRecordInit();
                this.inheritPropertiesToState(state);
                if (!state.hasOverlayTextures()) continue;
                this.nonOpaque = true;
            }
        }
    }

    private void processStack() {
        if (this.stack != null) {
            for (StackElement se : this.stack) {
                se.doStateRecordInit();
            }
        }
    }

    private void inheritPropertiesToState(StateVariantV2 state) {
        if ((state.textures == null || state.textures.isEmpty()) && this.textures != null) {
            state.textures = new ArrayList<String>(this.textures);
        }
        if ((state.randomTextures == null || state.randomTextures.isEmpty()) && this.randomTextures != null) {
            state.randomTextures = this.convertRandomTextures(this.randomTextures);
        }
        if ((state.overlayTextures == null || state.overlayTextures.isEmpty()) && this.overlayTextures != null) {
            state.overlayTextures = new ArrayList<String>(this.overlayTextures);
        }
        if (state.boundingBox == null && this.boundingBox != null) {
            state.boundingBox = this.convertBoundingBox(this.boundingBox);
        }
        if ((state.cuboids == null || state.cuboids.isEmpty()) && this.cuboids != null) {
            state.cuboids = this.convertCuboids(this.cuboids);
        }
        if (state.colorMult.equals("#FFFFFF")) {
            state.colorMult = this.colorMult;
        }
        if (state.colorMults == null && this.colorMults != null) {
            state.colorMults = new ArrayList<String>(this.colorMults);
        }
    }

    private List<BlockStateRecordV2.RandomTextureSet> convertRandomTextures(List<RandomTextureVariant> source) {
        if (source == null) {
            return null;
        }
        ArrayList<BlockStateRecordV2.RandomTextureSet> result = new ArrayList<BlockStateRecordV2.RandomTextureSet>();
        for (RandomTextureVariant rtv : source) {
            BlockStateRecordV2.RandomTextureSet set = new BlockStateRecordV2.RandomTextureSet();
            set.textures = rtv.textures != null ? new ArrayList<String>(rtv.textures) : null;
            set.weight = rtv.weight;
            result.add(set);
        }
        return result;
    }

    private BlockStateRecordV2.BoundingBox convertBoundingBox(BoundingBox source) {
        if (source == null) {
            return null;
        }
        BlockStateRecordV2.BoundingBox bb = new BlockStateRecordV2.BoundingBox();
        bb.xMin = (float)source.xMin;
        bb.xMax = (float)source.xMax;
        bb.yMin = (float)source.yMin;
        bb.yMax = (float)source.yMax;
        bb.zMin = (float)source.zMin;
        bb.zMax = (float)source.zMax;
        return bb;
    }

    private List<BlockStateRecordV2.CuboidElement> convertCuboids(List<CuboidElement> source) {
        if (source == null) {
            return null;
        }
        ArrayList<BlockStateRecordV2.CuboidElement> result = new ArrayList<BlockStateRecordV2.CuboidElement>();
        for (CuboidElement ce : source) {
            BlockStateRecordV2.CuboidElement c = new BlockStateRecordV2.CuboidElement();
            c.xMin = (float)ce.xMin;
            c.xMax = (float)ce.xMax;
            c.yMin = (float)ce.yMin;
            c.yMax = (float)ce.yMax;
            c.zMin = (float)ce.zMin;
            c.zMax = (float)ce.zMax;
            c.sideTextures = ce.sideTextures;
            c.sideRotations = ce.sideRotations;
            c.shape = ce.shape;
            c.noTint = ce.noTint;
            result.add(c);
        }
        return result;
    }

    private void createStateProperty() {
        if (this.states != null && this.states.size() > 1) {
            ArrayList<String> stateIds = new ArrayList<String>();
            for (StateVariantV2 state : this.states) {
                stateIds.add(state.stateID);
            }
            this.stateProperty = new StatePropertyV2(stateIds);
        }
    }

    public class_2248 createBlock() {
        try {
            this.doInit();
        }
        catch (Exception x) {
            throw new RuntimeException("Exception during doInit: blockName=" + this.blockName, x);
        }
        BlockFactory factory = BlockFactoryRegistry.getFactory(this.blockType);
        if (factory == null) {
            throw new IllegalStateException(String.format("Invalid blockType '%s' in block '%s'", this.blockType, this.blockName));
        }
        return factory.buildBlockClass(this);
    }

    public class_2248 registerBlock(class_2248 block) {
        class_2960 id = class_2960.method_60655((String)"westerosblocks", (String)this.blockName);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)block);
        class_1747 itemBlock = new class_1747(block, new class_1792.class_1793());
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)itemBlock);
        return block;
    }

    public class_4970.class_2251 makeSettings() {
        return this.makeSettings(null);
    }

    public class_4970.class_2251 makeSettings(class_2248 copyFrom) {
        class_4970.class_2251 settings = copyFrom != null ? class_4970.class_2251.method_9630((class_4970)copyFrom) : class_4970.class_2251.method_9637();
        if (this.hasStrength()) {
            settings = settings.method_9629(this.strength.floatValue(), this.strength.floatValue());
        } else if (this.hardness != 0.0f || this.resistance != 0.0f) {
            settings = settings.method_9629(this.hardness, this.resistance);
        }
        settings = settings.method_9626(this.getBlockSoundGroup());
        int light = this.getLuminance();
        if (light > 0) {
            settings = settings.method_9631(lum -> this.getLuminance());
        }
        if (this.isNonOpaque()) {
            settings = settings.method_22488();
        }
        if (this.hasNoCollision()) {
            settings = settings.method_9634();
        }
        if (this.isRequiresTool()) {
            settings = settings.method_29292();
        }
        return settings;
    }

    public class_4970.class_2251 makeSettings(class_2248 copyFrom, UnaryOperator<class_4970.class_2251> customizer) {
        class_4970.class_2251 settings = this.makeSettings(copyFrom);
        return (class_4970.class_2251)customizer.apply(settings);
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getMappedType() {
        if (this.parsedType == null) {
            String[] toks;
            this.parsedType = new HashMap<String, String>();
            for (String tok : toks = this.type.split(",")) {
                String[] flds = tok.split(":");
                if (flds.length < 2) continue;
                this.parsedType.put(flds[0], flds[1]);
            }
        }
        return this.parsedType;
    }

    public String getTypeValue(String key, String defval) {
        String v = this.getMappedType().get(key);
        return v != null ? v : defval;
    }

    public String getTypeValue(String key) {
        return this.getTypeValue(key, "");
    }

    public String getBlockName() {
        return this.blockName;
    }

    public String getBlockType() {
        return this.blockType;
    }

    public String getLabel() {
        return this.label;
    }

    public String getCreativeTab() {
        return this.creativeTab;
    }

    public List<String> getCustomTags() {
        return this.customTags != null ? this.customTags : new ArrayList<String>();
    }

    public boolean hasCustomTags() {
        return this.customTags != null && !this.customTags.isEmpty();
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    public Float getStrength() {
        return this.strength;
    }

    public boolean hasStrength() {
        return this.strength != null;
    }

    public String getSoundGroup() {
        return this.soundGroup;
    }

    public String getMaterial() {
        return this.material;
    }

    public boolean hasMaterial() {
        return this.material != null && !this.material.isEmpty();
    }

    public String getRenderLayer() {
        return this.renderLayer;
    }

    public boolean hasRenderLayer() {
        return this.renderLayer != null && !this.renderLayer.isEmpty();
    }

    public int getLuminance() {
        return this.luminance != null ? this.luminance : 0;
    }

    public Integer getLightOpacity() {
        return this.lightOpacity;
    }

    public boolean hasLightOpacity() {
        return this.lightOpacity != null;
    }

    public boolean isNonOpaque() {
        return Boolean.TRUE.equals(this.nonOpaque);
    }

    public boolean isAlphaRender() {
        return Boolean.TRUE.equals(this.alphaRender);
    }

    public boolean hasAmbientOcclusion() {
        return this.ambientOcclusion == null || this.ambientOcclusion != false;
    }

    public List<String> getTextures() {
        return this.textures;
    }

    public String[] getTexturesAsArray() {
        if (this.textures == null || this.textures.isEmpty()) {
            return new String[0];
        }
        return this.textures.toArray(new String[0]);
    }

    public int getTextureCount() {
        return this.textures != null ? this.textures.size() : 0;
    }

    public List<RandomTextureVariant> getRandomTextures() {
        return this.randomTextures;
    }

    public boolean hasRandomTextures() {
        return this.randomTextures != null && !this.randomTextures.isEmpty();
    }

    public List<String> getOverlayTextures() {
        return this.overlayTextures;
    }

    public boolean hasOverlayTextures() {
        return this.overlayTextures != null && !this.overlayTextures.isEmpty();
    }

    public String getItemTexture() {
        return this.itemTexture;
    }

    public boolean hasItemTexture() {
        return this.itemTexture != null && !this.itemTexture.isEmpty();
    }

    public boolean hasCustomItemTexture() {
        return Boolean.TRUE.equals(this.customItemTexture);
    }

    public Integer getItemTextureIndex() {
        return this.itemTextureIndex;
    }

    public boolean hasItemTextureIndex() {
        return this.itemTextureIndex != null;
    }

    public String getColorMult() {
        return this.colorMult;
    }

    public boolean hasColorMult() {
        return this.colorMult != null && !this.colorMult.equals("#FFFFFF");
    }

    public List<String> getColorMults() {
        return this.colorMults;
    }

    public boolean hasColorMults() {
        return this.colorMults != null && !this.colorMults.isEmpty();
    }

    public List<StateVariantV2> getStates() {
        return this.states;
    }

    public boolean hasStates() {
        return this.states != null && !this.states.isEmpty();
    }

    public int getStateCount() {
        return this.hasStates() ? this.states.size() : 0;
    }

    public StatePropertyV2 getStateProperty() {
        return this.stateProperty;
    }

    public ModProperties.StateProperty buildStateProperty() {
        if (this.stateProperty == null) {
            return null;
        }
        return new ModProperties.StateProperty(this.stateProperty.getValues());
    }

    public String getDefaultStateID() {
        return this.stateProperty != null ? this.stateProperty.getDefaultValue() : null;
    }

    public List<StackElement> getStack() {
        return this.stack;
    }

    public List<StackElement> getStackElements() {
        return this.stack;
    }

    public boolean hasStackElements() {
        return this.stack != null && !this.stack.isEmpty();
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public boolean hasBoundingBox() {
        return this.boundingBox != null;
    }

    public List<CuboidElement> getCuboids() {
        return this.cuboids;
    }

    public boolean hasCuboids() {
        return this.cuboids != null && !this.cuboids.isEmpty();
    }

    public List<BoundingBox> getCollisionBoxes() {
        return this.collisionBoxes;
    }

    public boolean hasCollisionBoxes() {
        return this.collisionBoxes != null && !this.collisionBoxes.isEmpty();
    }

    public List<BoundingBox> getSupportBoxes() {
        return this.supportBoxes;
    }

    public boolean hasSupportBoxes() {
        return this.supportBoxes != null && !this.supportBoxes.isEmpty();
    }

    public boolean toggleOnUse() {
        if (Boolean.TRUE.equals(this.toggleOnUse)) {
            return true;
        }
        return this.type != null && this.type.contains("toggleOnUse");
    }

    public boolean isLocked() {
        return Boolean.TRUE.equals(this.locked);
    }

    public boolean isAllowUnsupported() {
        return Boolean.TRUE.equals(this.allowUnsupported);
    }

    public boolean isAllowHalfBreak() {
        return Boolean.TRUE.equals(this.allowHalfBreak);
    }

    public boolean isLayerSensitive() {
        return Boolean.TRUE.equals(this.layerSensitive);
    }

    public boolean hasNoCollision() {
        return Boolean.TRUE.equals(this.noCollision);
    }

    public boolean hasClimb() {
        return Boolean.TRUE.equals(this.hasClimb);
    }

    public boolean hasDown() {
        return Boolean.TRUE.equals(this.hasDown);
    }

    public String getConnectTo() {
        return this.connectTo;
    }

    public boolean isSymmetrical() {
        if (Boolean.TRUE.equals(this.symmetrical)) {
            return true;
        }
        return this.type != null && this.type.contains("symmetrical:true");
    }

    public boolean hasCustomModel() {
        return Boolean.TRUE.equals(this.isCustomModel);
    }

    public boolean isTinted() {
        return Boolean.TRUE.equals(this.isTinted);
    }

    public boolean hasOverlay() {
        return Boolean.TRUE.equals(this.hasOverlay);
    }

    public boolean hasBetterFoliage() {
        return Boolean.TRUE.equals(this.hasBetterFoliage) || Boolean.TRUE.equals(this.betterFoliage);
    }

    public boolean isNoDecay() {
        return Boolean.TRUE.equals(this.noDecay);
    }

    public boolean hasRotateRandom() {
        return Boolean.TRUE.equals(this.hasRotateRandom) || Boolean.TRUE.equals(this.rotateRandom);
    }

    public boolean isNoParticle() {
        return Boolean.TRUE.equals(this.noParticle);
    }

    public boolean isAlwaysOn() {
        return Boolean.TRUE.equals(this.alwaysOn);
    }

    public boolean isConnectState() {
        if (Boolean.TRUE.equals(this.connectState)) {
            return true;
        }
        return this.type != null && this.type.contains("connectstate");
    }

    public boolean isUnconnect() {
        return Boolean.TRUE.equals(this.unconnect);
    }

    public String getBedType() {
        return this.bedType;
    }

    public boolean hasBedType() {
        return this.bedType != null && !this.bedType.isEmpty();
    }

    public String getWallSize() {
        return this.wallSize != null ? this.wallSize : "normal";
    }

    public String getWoodType() {
        if (this.woodType != null && !this.woodType.isEmpty()) {
            return this.woodType;
        }
        if (this.type != null && !this.type.isEmpty()) {
            return this.type;
        }
        return "oak";
    }

    public boolean hasWoodType() {
        return this.woodType != null && !this.woodType.isEmpty();
    }

    public String getParticle() {
        return this.particle != null ? this.particle : "flame";
    }

    public boolean isLegacyModel() {
        return false;
    }

    public boolean isBarsModel() {
        return this.type != null && (this.type.contains("bars-model") || "bars".equals(this.type));
    }

    public boolean isNoClimb() {
        return this.type != null && this.type.contains("no-climb");
    }

    public boolean canGrowDownward() {
        return this.hasDown();
    }

    public boolean isNoInWeb() {
        return this.type != null && this.type.contains("no-in-web");
    }

    public List<HarvestLevel> getHarvestLevel() {
        return this.harvestLevel;
    }

    public boolean isRequiresTool() {
        return Boolean.TRUE.equals(this.requiresTool);
    }

    public DisplaySettings getDisplay() {
        return this.display;
    }

    public boolean hasDisplay() {
        return this.display != null;
    }

    public List<String> getTooltips() {
        return this.tooltips;
    }

    public boolean hasTooltips() {
        return this.tooltips != null && !this.tooltips.isEmpty();
    }

    private static Map<String, class_2498> createSoundGroupMap() {
        HashMap<String, class_2498> map = new HashMap<String, class_2498>();
        map.put("powder", class_2498.field_11526);
        map.put("wood", class_2498.field_11547);
        map.put("gravel", class_2498.field_11529);
        map.put("grass", class_2498.field_11535);
        map.put("stone", class_2498.field_11544);
        map.put("metal", class_2498.field_11533);
        map.put("glass", class_2498.field_11537);
        map.put("cloth", class_2498.field_11543);
        map.put("sand", class_2498.field_11526);
        map.put("snow", class_2498.field_11548);
        map.put("ladder", class_2498.field_11532);
        map.put("anvil", class_2498.field_11531);
        map.put("plant", class_2498.field_17580);
        map.put("wool", class_2498.field_11543);
        map.put("slime", class_2498.field_11545);
        map.put("bamboo", class_2498.field_11542);
        map.put("lantern", class_2498.field_17734);
        map.put("nether_bricks", class_2498.field_22146);
        map.put("netherite", class_2498.field_22150);
        return map;
    }

    public class_2498 getBlockSoundGroup() {
        if (this.soundGroup == null || this.soundGroup.isEmpty()) {
            return class_2498.field_11544;
        }
        return SOUND_GROUP_MAP.getOrDefault(this.soundGroup.toLowerCase(), class_2498.field_11544);
    }

    public class_265 makeCollisionBoxShape() {
        if (this.collisionBoxes == null) {
            return class_259.method_1077();
        }
        class_265 s = class_259.method_1073();
        for (BoundingBox b : this.collisionBoxes) {
            s = class_259.method_1084((class_265)s, (class_265)b.getAABB());
        }
        return s;
    }

    public class_265 makeSupportBoxShape(List<BoundingBox> defaultBoxes) {
        List<BoundingBox> boxes;
        class_265 s = class_259.method_1073();
        List<BoundingBox> list = boxes = this.supportBoxes != null ? this.supportBoxes : defaultBoxes;
        if (boxes != null) {
            for (BoundingBox b : boxes) {
                s = class_259.method_1084((class_265)s, (class_265)b.getAABB());
            }
        }
        return s;
    }

    public String toString() {
        return String.format("BlockDefinitionV2{blockName='%s', blockType='%s', label='%s'}", this.blockName, this.blockType, this.label);
    }

    public static class StatePropertyV2 {
        private final List<String> values;
        private final Map<String, String> valueMap;
        private final String defaultValue;

        public StatePropertyV2(List<String> stateIDs) {
            this.values = new ArrayList<String>(stateIDs);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String id : stateIDs) {
                map.put(id, id);
            }
            this.valueMap = Collections.unmodifiableMap(map);
            this.defaultValue = stateIDs.get(0);
        }

        public List<String> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public int getIndex(String val) {
            int v = this.values.indexOf(val);
            return Math.max(v, 0);
        }
    }

    public static class RandomTextureVariant {
        @SerializedName(value="textures")
        private List<String> textures;
        @SerializedName(value="weight")
        private Integer weight;

        public List<String> getTextures() {
            return this.textures;
        }

        public int getWeight() {
            return this.weight != null ? this.weight : 1;
        }

        public int getTextureCount() {
            return this.textures != null ? this.textures.size() : 0;
        }

        public String getTextureByIndex(int index) {
            if (this.textures == null || this.textures.isEmpty()) {
                return null;
            }
            if (index >= this.textures.size()) {
                index = this.textures.size() - 1;
            }
            return this.textures.get(index);
        }
    }

    public static class StateVariantV2
    extends BlockStateRecordV2 {
    }

    public static class BoundingBox {
        @SerializedName(value="xMin")
        public double xMin;
        @SerializedName(value="xMax")
        public double xMax;
        @SerializedName(value="yMin")
        public double yMin;
        @SerializedName(value="yMax")
        public double yMax;
        @SerializedName(value="zMin")
        public double zMin;
        @SerializedName(value="zMax")
        public double zMax;
        private transient class_265 aabb = null;

        public BoundingBox() {
            this.xMin = 0.0;
            this.yMin = 0.0;
            this.zMin = 0.0;
            this.xMax = 1.0;
            this.yMax = 1.0;
            this.zMax = 1.0;
        }

        public BoundingBox(double x0, double y0, double z0, double x1, double y1, double z1) {
            this.xMin = x0;
            this.xMax = x1;
            this.yMin = y0;
            this.yMax = y1;
            this.zMin = z0;
            this.zMax = z1;
        }

        public class_265 getAABB() {
            if (this.aabb == null) {
                this.aabb = class_259.method_1081((double)this.xMin, (double)this.yMin, (double)this.zMin, (double)this.xMax, (double)this.yMax, (double)this.zMax);
            }
            return this.aabb;
        }

        public double getXMin() {
            return this.xMin;
        }

        public double getXMax() {
            return this.xMax;
        }

        public double getYMin() {
            return this.yMin;
        }

        public double getYMax() {
            return this.yMax;
        }

        public double getZMin() {
            return this.zMin;
        }

        public double getZMax() {
            return this.zMax;
        }
    }

    public static class StackElement
    extends BlockStateRecordV2 {
    }

    public static class CuboidElement {
        @SerializedName(value="xMin")
        public double xMin;
        @SerializedName(value="xMax")
        public double xMax;
        @SerializedName(value="yMin")
        public double yMin;
        @SerializedName(value="yMax")
        public double yMax;
        @SerializedName(value="zMin")
        public double zMin;
        @SerializedName(value="zMax")
        public double zMax;
        @SerializedName(value="sideTextures")
        public int[] sideTextures;
        @SerializedName(value="sideRotations")
        public int[] sideRotations = new int[]{0, 0, 0, 0, 0, 0};
        @SerializedName(value="noTint")
        public boolean[] noTint;
        @SerializedName(value="shape")
        public String shape = "box";

        public CuboidElement() {
            this.xMin = 0.0;
            this.yMin = 0.0;
            this.zMin = 0.0;
            this.xMax = 1.0;
            this.yMax = 1.0;
            this.zMax = 1.0;
        }

        public CuboidElement(double x0, double y0, double z0, double x1, double y1, double z1) {
            this.xMin = x0;
            this.xMax = x1;
            this.yMin = y0;
            this.yMax = y1;
            this.zMin = z0;
            this.zMax = z1;
        }

        public CuboidElement(double x0, double y0, double z0, double x1, double y1, double z1, int[] sideTextures) {
            this(x0, y0, z0, x1, y1, z1);
            this.sideTextures = sideTextures;
        }

        public CuboidElement(double x0, double y0, double z0, double x1, double y1, double z1, int[] sideTextures, boolean[] noTint) {
            this(x0, y0, z0, x1, y1, z1, sideTextures);
            this.noTint = noTint;
        }

        public CuboidElement rotateCuboid(CuboidRotation rot) {
            CuboidElement c = new CuboidElement();
            Vector v0 = new Vector();
            Vector v1 = new Vector();
            v0.x = (float)this.xMin;
            v0.y = (float)this.yMin;
            v0.z = (float)this.zMin;
            v1.x = (float)this.xMax;
            v1.y = (float)this.yMax;
            v1.z = (float)this.zMax;
            v0.rotate(rot.xrot, rot.yrot, rot.zrot);
            v1.rotate(rot.xrot, rot.yrot, rot.zrot);
            c.xMin = Math.min(v0.x, v1.x);
            c.xMax = Math.max(v0.x, v1.x);
            c.yMin = Math.min(v0.y, v1.y);
            c.yMax = Math.max(v0.y, v1.y);
            c.zMin = Math.min(v0.z, v1.z);
            c.zMax = Math.max(v0.z, v1.z);
            if (this.sideTextures != null) {
                c.sideTextures = new int[rot.txtidx.length];
                int cnt = this.sideTextures.length;
                for (int i = 0; i < c.sideTextures.length; ++i) {
                    int newidx = rot.txtidx[i];
                    c.sideTextures[i] = newidx < cnt ? this.sideTextures[newidx] : this.sideTextures[cnt - 1];
                }
            } else {
                c.sideTextures = rot.txtidx;
            }
            c.sideRotations = rot.txtrot;
            c.shape = this.shape;
            return c;
        }

        public double getXMin() {
            return this.xMin;
        }

        public double getXMax() {
            return this.xMax;
        }

        public double getYMin() {
            return this.yMin;
        }

        public double getYMax() {
            return this.yMax;
        }

        public double getZMin() {
            return this.zMin;
        }

        public double getZMax() {
            return this.zMax;
        }

        public int[] getSideTextures() {
            return this.sideTextures;
        }

        public int[] getSideRotations() {
            return this.sideRotations;
        }

        public boolean[] getNoTint() {
            return this.noTint;
        }

        public String getShape() {
            return this.shape;
        }
    }

    public static class DisplaySettings {
        @SerializedName(value="gui")
        private GuiTransform gui;

        public GuiTransform getGui() {
            return this.gui;
        }

        public boolean hasGui() {
            return this.gui != null;
        }
    }

    public static enum CuboidRotation {
        NONE(0, 0, 0, new int[]{0, 1, 2, 3, 4, 5}, new int[]{0, 0, 0, 0, 0, 0}),
        ROTY90(0, 90, 0, new int[]{0, 1, 4, 5, 3, 2}, new int[]{270, 90, 0, 0, 0, 0}),
        ROTY180(0, 180, 0, new int[]{0, 1, 3, 2, 5, 4}, new int[]{180, 180, 0, 0, 0, 0}),
        ROTY270(0, 270, 0, new int[]{0, 1, 5, 4, 2, 3}, new int[]{90, 270, 0, 0, 0, 0}),
        ROTZ90(0, 0, 90, new int[]{5, 4, 2, 3, 0, 1}, new int[]{270, 90, 270, 90, 90, 90}),
        ROTZ270(0, 0, 270, new int[]{4, 5, 2, 3, 1, 0}, new int[]{90, 270, 90, 270, 270, 270});

        final int xrot;
        final int yrot;
        final int zrot;
        final int[] txtidx;
        final int[] txtrot;

        private CuboidRotation(int xr, int yr, int zr, int[] txt_idx, int[] txt_rot) {
            this.xrot = xr;
            this.yrot = yr;
            this.zrot = zr;
            this.txtidx = txt_idx;
            this.txtrot = txt_rot;
        }

        public int getRotX() {
            return this.xrot;
        }

        public int getRotY() {
            return this.yrot;
        }

        public int getRotZ() {
            return this.zrot;
        }

        public int[] getTextureIndices() {
            return this.txtidx;
        }

        public int[] getTextureRotations() {
            return this.txtrot;
        }
    }

    private static class Vector {
        float x;
        float y;
        float z;

        private Vector() {
        }

        void rotate(int xcnt, int ycnt, int zcnt) {
            double xx = this.x - 0.5f;
            double yy = this.y - 0.5f;
            double zz = this.z - 0.5f;
            double rot = Math.toRadians(xcnt);
            double nval = zz * Math.sin(rot) + yy * Math.cos(rot);
            zz = zz * Math.cos(rot) - yy * Math.sin(rot);
            yy = nval;
            rot = Math.toRadians(ycnt);
            nval = xx * Math.cos(rot) - zz * Math.sin(rot);
            zz = xx * Math.sin(rot) + zz * Math.cos(rot);
            xx = nval;
            rot = Math.toRadians(zcnt);
            nval = yy * Math.sin(rot) + xx * Math.cos(rot);
            yy = yy * Math.cos(rot) - xx * Math.sin(rot);
            xx = nval;
            this.x = (float)xx + 0.5f;
            this.y = (float)yy + 0.5f;
            this.z = (float)zz + 0.5f;
            if (this.x > 1.0f) {
                this.x = 1.0f;
            }
            if (this.y > 1.0f) {
                this.y = 1.0f;
            }
            if (this.z > 1.0f) {
                this.z = 1.0f;
            }
            if (this.x < 0.0f) {
                this.x = 0.0f;
            }
            if (this.y < 0.0f) {
                this.y = 0.0f;
            }
            if (this.z < 0.0f) {
                this.z = 0.0f;
            }
        }
    }

    public static class HarvestLevel {
        @SerializedName(value="tool")
        private String tool;
        @SerializedName(value="level")
        private int level;

        public String getTool() {
            return this.tool;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public static class GuiTransform {
        @SerializedName(value="rotation")
        private double[] rotation;
        @SerializedName(value="translation")
        private double[] translation;
        @SerializedName(value="scale")
        private double[] scale;

        public double[] getRotation() {
            return this.rotation;
        }

        public double[] getTranslation() {
            return this.translation;
        }

        public double[] getScale() {
            return this.scale;
        }
    }
}

