/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockSetDefinition;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class BlockSetDefinitionLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String blockSetDefinitionsPath;

    public BlockSetDefinitionLoader(String blockSetDefinitionsPath) {
        this.blockSetDefinitionsPath = blockSetDefinitionsPath;
    }

    public Map<String, BlockSetDefinition> loadAllDefinitions() {
        HashMap<String, BlockSetDefinition> definitions = new HashMap<String, BlockSetDefinition>();
        try {
            this.loadDefinitionsFromResources(definitions);
            WesterosBlocks.LOGGER.info("Successfully loaded {} block set definitions", (Object)definitions.size());
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Failed to load block set definitions from resources", (Throwable)e);
        }
        return definitions;
    }

    private void loadDefinitionsFromResources(Map<String, BlockSetDefinition> definitions) throws Exception {
        ModContainer container = FabricLoader.getInstance().getModContainer("westerosblocks").orElse(null);
        if (container == null) {
            WesterosBlocks.LOGGER.error("Could not find mod container for {}", (Object)"westerosblocks");
            return;
        }
        for (Path rootPath : container.getRootPaths()) {
            String pathWithoutSlash;
            Path dirPath = rootPath.resolve(pathWithoutSlash = this.blockSetDefinitionsPath.startsWith("/") ? this.blockSetDefinitionsPath.substring(1) : this.blockSetDefinitionsPath);
            if (Files.exists(dirPath, new LinkOption[0]) && Files.isDirectory(dirPath, new LinkOption[0])) {
                WesterosBlocks.LOGGER.debug("Loading block set definitions from: {}", (Object)dirPath);
                this.loadDefinitionsRecursively(dirPath, definitions);
                continue;
            }
            WesterosBlocks.LOGGER.debug("Block set definitions directory not found at: {}", (Object)dirPath);
        }
        if (definitions.isEmpty()) {
            WesterosBlocks.LOGGER.warn("No block set definitions were loaded!");
        }
    }

    private void loadDefinitionsRecursively(Path directory, Map<String, BlockSetDefinition> definitions) throws IOException {
        try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(path -> this.loadDefinitionFile((Path)path, definitions));
        }
    }

    private void loadDefinitionFile(Path filePath, Map<String, BlockSetDefinition> definitions) {
        try {
            String content = Files.readString(filePath);
            BlockSetDefinition definition = (BlockSetDefinition)GSON.fromJson(content, BlockSetDefinition.class);
            if (definition == null) {
                WesterosBlocks.LOGGER.warn("Failed to parse block set definition file: {}", (Object)filePath);
                return;
            }
            if (definition.getBaseBlockName() == null || definition.getBaseBlockName().isEmpty()) {
                WesterosBlocks.LOGGER.warn("Block set definition missing baseBlockName in file: {}", (Object)filePath);
                return;
            }
            if (definitions.containsKey(definition.getBaseBlockName())) {
                WesterosBlocks.LOGGER.warn("Duplicate block set definition found for '{}' in file: {}", (Object)definition.getBaseBlockName(), (Object)filePath);
            }
            definitions.put(definition.getBaseBlockName(), definition);
            WesterosBlocks.LOGGER.debug("Loaded block set definition: {} with {} variants", (Object)definition.getBaseBlockName(), (Object)(definition.hasVariants() ? definition.getVariants().size() : 0));
        }
        catch (IOException e) {
            WesterosBlocks.LOGGER.error("Failed to read block set definition file: {}", (Object)filePath, (Object)e);
        }
        catch (JsonSyntaxException e) {
            WesterosBlocks.LOGGER.error("Invalid JSON syntax in block set definition file: {}", (Object)filePath, (Object)e);
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Unexpected error loading block set definition file: {}", (Object)filePath, (Object)e);
        }
    }

    public void validateDefinitions(Map<String, BlockSetDefinition> definitions) {
        int validCount = 0;
        int warningCount = 0;
        for (BlockSetDefinition definition : definitions.values()) {
            boolean isValid = true;
            if (!definition.hasTextures()) {
                WesterosBlocks.LOGGER.warn("Block set '{}' has no textures defined", (Object)definition.getBaseBlockName());
                ++warningCount;
                isValid = false;
            }
            if (definition.getBaseLabel() == null || definition.getBaseLabel().isEmpty()) {
                WesterosBlocks.LOGGER.warn("Block set '{}' has no baseLabel defined", (Object)definition.getBaseBlockName());
                ++warningCount;
                isValid = false;
            }
            if (definition.getHardness() == null) {
                WesterosBlocks.LOGGER.warn("Block set '{}' has no hardness defined", (Object)definition.getBaseBlockName());
                ++warningCount;
                isValid = false;
            }
            if (definition.getSoundGroup() == null || definition.getSoundGroup().isEmpty()) {
                WesterosBlocks.LOGGER.warn("Block set '{}' has no stepSound defined", (Object)definition.getBaseBlockName());
                ++warningCount;
                isValid = false;
            }
            if (!isValid) continue;
            ++validCount;
        }
    }
}

