/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockSetDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlockSetExpander {
    private static final List<String> DEFAULT_VARIANTS = Arrays.asList("solid", "stairs", "slab", "wall", "fence", "hopper");
    private static final List<String> SUPPORTED_VARIANTS = Arrays.asList("solid", "stairs", "slab", "wall", "fence", "hopper", "tip", "carpet", "fence_gate", "half_door", "cover", "hollow_hopper", "log", "directional", "layer", "pane", "sand", "path", "window_frame", "window_frame_mullion", "arrow_slit", "arrow_slit_window", "arrow_slit_ornate", "bench");
    private static final Map<String, String> VARIANT_TYPES = new HashMap<String, String>();
    private static final Map<String, String[]> VARIANT_TEXTURES;

    public static List<BlockDefinitionV2> expand(BlockSetDefinition blockSet) {
        ArrayList<BlockDefinitionV2> definitions = new ArrayList<BlockDefinitionV2>();
        Map<String, String> types = BlockSetExpander.preprocessVariantMap(blockSet.getTypes());
        Map<String, List<String>> altCustomTags = BlockSetExpander.preprocessVariantMap(blockSet.getAltCustomTags());
        Map<String, List<String>> altTextures = BlockSetExpander.preprocessVariantMap(blockSet.getAltTextures());
        List<String> variantsToCreate = blockSet.hasVariants() ? blockSet.getVariants() : DEFAULT_VARIANTS;
        for (String variant : variantsToCreate) {
            if (!SUPPORTED_VARIANTS.contains(variant)) {
                WesterosBlocks.LOGGER.warn("Unsupported variant '{}' in block set '{}'", (Object)variant, (Object)blockSet.getBaseBlockName());
                continue;
            }
            BlockDefinitionV2 definition = BlockSetExpander.createVariantDefinition(blockSet, variant, types, altCustomTags, altTextures);
            if (definition == null) continue;
            definitions.add(definition);
        }
        WesterosBlocks.LOGGER.debug("Expanded block set '{}' into {} variants", (Object)blockSet.getBaseBlockName(), (Object)definitions.size());
        return definitions;
    }

    private static BlockDefinitionV2 createVariantDefinition(BlockSetDefinition blockSet, String variant, Map<String, String> types, Map<String, List<String>> altCustomTags, Map<String, List<String>> altTextures) {
        HashMap<String, Object> defMap = new HashMap<String, Object>();
        String blockName = BlockSetExpander.deriveBlockName(blockSet, variant);
        defMap.put("blockName", blockName);
        String blockType = VARIANT_TYPES.getOrDefault(variant, variant);
        defMap.put("blockType", blockType);
        String label = BlockSetExpander.deriveLabel(blockSet, variant);
        defMap.put("label", label);
        if (blockSet.getHardness() != null) {
            defMap.put("hardness", blockSet.getHardness());
        }
        if (blockSet.getSoundGroup() != null) {
            defMap.put("soundGroup", blockSet.getSoundGroup());
        }
        if (blockSet.getResistance() != null) {
            defMap.put("resistance", blockSet.getResistance());
        }
        if (blockSet.getLightOpacity() != null) {
            defMap.put("lightOpacity", blockSet.getLightOpacity());
        }
        if (blockSet.getHarvestLevel() != null) {
            defMap.put("harvestLevel", blockSet.getHarvestLevel());
        }
        if (blockSet.getCreativeTab() != null) {
            defMap.put("creativeTab", blockSet.getCreativeTab());
        }
        if (blockSet.getAlphaRender() != null) {
            defMap.put("alphaRender", blockSet.getAlphaRender());
        }
        if (blockSet.getAmbientOcclusion() != null) {
            defMap.put("ambientOcclusion", blockSet.getAmbientOcclusion());
        }
        if (blockSet.getNonOpaque() != null) {
            defMap.put("nonOpaque", blockSet.getNonOpaque());
        }
        if (blockSet.getRenderLayer() != null) {
            defMap.put("renderLayer", blockSet.getRenderLayer());
        }
        if (blockSet.getLightValue() != null) {
            defMap.put("luminance", blockSet.getLightValue().intValue());
        }
        if (blockSet.getColorMult() != null) {
            defMap.put("colorMult", blockSet.getColorMult());
        }
        if (altCustomTags != null && altCustomTags.containsKey(variant)) {
            List<String> tags = altCustomTags.get(variant);
            if (!tags.isEmpty()) {
                defMap.put("customTags", tags);
            }
        } else if (blockSet.getCustomTags() != null) {
            defMap.put("customTags", blockSet.getCustomTags());
        }
        if (types != null && types.containsKey(variant)) {
            defMap.put("type", types.get(variant));
        } else {
            String defaultType = BlockSetExpander.getDefaultType(variant);
            if (defaultType != null) {
                defMap.put("type", defaultType);
            }
        }
        List<String> textures = BlockSetExpander.pickVariantTextures(blockSet.getTextures(), altTextures, variant);
        if (textures != null && !textures.isEmpty()) {
            defMap.put("textures", textures);
        }
        if (blockSet.getRandomTextures() != null && !blockSet.getRandomTextures().isEmpty()) {
            ArrayList randomTexturesList = new ArrayList();
            for (BlockSetDefinition.RandomTextureEntry entry : blockSet.getRandomTextures()) {
                Map<String, String> processedMap = BlockSetExpander.preprocessTextureMap(entry.getTextures());
                List<String> variantTextures = BlockSetExpander.getTexturesForVariant(processedMap, variant);
                if (variantTextures == null || variantTextures.isEmpty()) continue;
                HashMap<String, Object> randomTextureMap = new HashMap<String, Object>();
                randomTextureMap.put("textures", variantTextures);
                randomTextureMap.put("weight", entry.getWeight());
                randomTexturesList.add(randomTextureMap);
            }
            if (!randomTexturesList.isEmpty()) {
                defMap.put("randomTextures", randomTexturesList);
            }
        }
        if (blockSet.hasStates()) {
            ArrayList statesList = new ArrayList();
            for (BlockSetDefinition.StateRecord stateRec : blockSet.getStates()) {
                Map<String, String> overlayMap;
                List<String> overlayTextures;
                if (BlockSetExpander.isVariantExcluded(variant, stateRec.getExcludeVariants())) continue;
                HashMap<String, Object> stateMap = new HashMap<String, Object>();
                stateMap.put("stateID", stateRec.getStateID());
                List<String> stateTextures = BlockSetExpander.pickVariantTextures(stateRec.getTextures(), stateRec.getAltTextures(), variant);
                if (stateTextures != null && !stateTextures.isEmpty()) {
                    stateMap.put("textures", stateTextures);
                }
                if (stateRec.getOverlayTextures() != null && !stateRec.getOverlayTextures().isEmpty() && (overlayTextures = BlockSetExpander.getTexturesForVariant(overlayMap = BlockSetExpander.preprocessTextureMap(stateRec.getOverlayTextures()), variant)) != null && !overlayTextures.isEmpty()) {
                    stateMap.put("overlayTextures", overlayTextures);
                }
                if (stateRec.getLightValue() != null) {
                    stateMap.put("luminance", stateRec.getLightValue().intValue());
                }
                if (stateRec.getColorMult() != null) {
                    stateMap.put("colorMult", stateRec.getColorMult());
                }
                statesList.add(stateMap);
            }
            if (statesList.size() >= 2) {
                defMap.put("states", statesList);
                defMap.put("toggleOnUse", true);
            }
        }
        BlockSetExpander.addSpecialGeometry(defMap, variant);
        return BlockSetExpander.convertMapToBlockDefinition(defMap);
    }

    private static String deriveBlockName(BlockSetDefinition blockSet, String variant) {
        if (blockSet.getAltNames() != null && blockSet.getAltNames().containsKey(variant)) {
            return blockSet.getAltNames().get(variant);
        }
        Object suffix = variant.equals("solid") ? "" : "_" + variant;
        return blockSet.getBaseBlockName() + (String)suffix;
    }

    private static String deriveLabel(BlockSetDefinition blockSet, String variant) {
        if (blockSet.getAltLabels() != null && blockSet.getAltLabels().containsKey(variant)) {
            return blockSet.getAltLabels().get(variant);
        }
        if (blockSet.getBaseLabel() != null) {
            String suffixLabel = variant.equals("solid") ? "" : " " + BlockSetExpander.generateLabel(variant);
            return (blockSet.getBaseLabel() + suffixLabel).trim();
        }
        return BlockSetExpander.generateLabel(BlockSetExpander.deriveBlockName(blockSet, variant));
    }

    private static String generateLabel(String name) {
        if (name == null || name.isEmpty() || name.equals("_")) {
            return "";
        }
        String[] words = name.split("_");
        StringBuilder label = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            String wordCap = word.substring(0, 1).toUpperCase() + word.substring(1);
            label.append(wordCap).append(" ");
        }
        return label.toString().trim();
    }

    private static <T> Map<String, T> preprocessVariantMap(Map<String, T> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, T> newMap = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String[] keys;
            String key = entry.getKey();
            T value = entry.getValue();
            if (!key.contains(",")) {
                newMap.put(key, value);
                continue;
            }
            for (String k : keys = key.split(",")) {
                newMap.put(k.trim(), value);
            }
        }
        return newMap;
    }

    private static List<String> pickVariantTextures(Map<String, String> textures, Map<String, List<String>> altTextures, String variant) {
        if (altTextures != null && altTextures.containsKey(variant)) {
            return altTextures.get(variant);
        }
        return BlockSetExpander.getTexturesForVariant(BlockSetExpander.preprocessTextureMap(textures), variant);
    }

    private static Map<String, String> preprocessTextureMap(Map<String, String> textureMap) {
        if (textureMap == null) {
            return null;
        }
        HashMap<String, String> processed = new HashMap<String, String>(textureMap);
        if (processed.containsKey("all")) {
            String allTexture = (String)processed.get("all");
            processed.putIfAbsent("bottom", allTexture);
            processed.putIfAbsent("top", allTexture);
            processed.putIfAbsent("sides", allTexture);
        }
        if (processed.containsKey("sides")) {
            String sidesTexture = (String)processed.get("sides");
            processed.putIfAbsent("west", sidesTexture);
            processed.putIfAbsent("east", sidesTexture);
            processed.putIfAbsent("south", sidesTexture);
            processed.putIfAbsent("north", sidesTexture);
        }
        if (!processed.containsKey("sides") && processed.containsKey("bottom")) {
            processed.put("sides", (String)processed.get("bottom"));
        }
        processed.putIfAbsent("window-topbottom", "transparent");
        if (processed.containsKey("sides") && !processed.containsKey("cover")) {
            processed.put("cover", (String)processed.get("sides"));
        }
        return processed;
    }

    private static List<String> getTexturesForVariant(Map<String, String> textureMap, String variant) {
        String[] requiredKeys;
        if (textureMap == null || !VARIANT_TEXTURES.containsKey(variant)) {
            return null;
        }
        ArrayList<String> textureList = new ArrayList<String>();
        for (String key : requiredKeys = VARIANT_TEXTURES.get(variant)) {
            if (!textureMap.containsKey(key)) continue;
            textureList.add(textureMap.get(key));
        }
        return !textureList.isEmpty() ? textureList : null;
    }

    private static String getDefaultType(String variant) {
        return switch (variant) {
            case "stairs", "wall", "fence", "pane" -> "unconnect:false";
            case "arrow_slit", "arrow_slit_window", "arrow_slit_ornate", "window_frame", "window_frame_mullion" -> "connectstate:true";
            case "cover" -> "allow-unsupported";
            default -> null;
        };
    }

    private static boolean isVariantExcluded(String variant, String excludeVariants) {
        String[] excluded;
        if (excludeVariants == null || excludeVariants.isEmpty()) {
            return false;
        }
        for (String ex : excluded = excludeVariants.split(",")) {
            if (!ex.trim().equals(variant)) continue;
            return true;
        }
        return false;
    }

    private static void addSpecialGeometry(Map<String, Object> defMap, String variant) {
        switch (variant) {
            case "hopper": {
                BlockSetExpander.addHopperGeometry(defMap);
                break;
            }
            case "tip": {
                BlockSetExpander.addTipGeometry(defMap);
                break;
            }
            case "carpet": {
                BlockSetExpander.addCarpetGeometry(defMap);
                break;
            }
            case "half_door": {
                BlockSetExpander.addHalfDoorGeometry(defMap);
                break;
            }
            case "hollow_hopper": {
                BlockSetExpander.addHollowHopperGeometry(defMap);
                break;
            }
            case "directional": {
                BlockSetExpander.addDirectionalGeometry(defMap);
                break;
            }
            case "path": {
                BlockSetExpander.addPathGeometry(defMap);
                break;
            }
            case "arrow_slit": 
            case "arrow_slit_window": 
            case "arrow_slit_ornate": 
            case "window_frame": 
            case "window_frame_mullion": {
                BlockSetExpander.addWindowGeometry(defMap);
            }
        }
    }

    private static void addHopperGeometry(Map<String, Object> defMap) {
        defMap.put("nonOpaque", true);
        defMap.put("lightOpacity", 0);
        ArrayList cuboids = new ArrayList();
        HashMap<String, Object> cuboid1 = new HashMap<String, Object>();
        cuboid1.put("xMin", 0.3755);
        cuboid1.put("yMin", 0.0);
        cuboid1.put("zMin", 0.3755);
        cuboid1.put("xMax", 0.6245);
        cuboid1.put("yMax", 0.275);
        cuboid1.put("zMax", 0.6245);
        cuboid1.put("sideTextures", new int[]{0, 0, 0, 0, 0, 0});
        cuboids.add(cuboid1);
        HashMap<String, Object> cuboid2 = new HashMap<String, Object>();
        cuboid2.put("xMin", 0.25);
        cuboid2.put("yMin", 0.275);
        cuboid2.put("zMin", 0.25);
        cuboid2.put("xMax", 0.75);
        cuboid2.put("yMax", 0.625);
        cuboid2.put("zMax", 0.75);
        cuboid2.put("sideTextures", new int[]{0, 0, 0, 0, 0, 0});
        cuboids.add(cuboid2);
        HashMap<String, Object> cuboid3 = new HashMap<String, Object>();
        cuboid3.put("xMin", 0.0);
        cuboid3.put("yMin", 0.625);
        cuboid3.put("zMin", 0.0);
        cuboid3.put("xMax", 1.0);
        cuboid3.put("yMax", 1.0);
        cuboid3.put("zMax", 1.0);
        cuboid3.put("sideTextures", new int[]{0, 0, 0, 0, 0, 0});
        cuboids.add(cuboid3);
        defMap.put("cuboids", cuboids);
    }

    private static void addTipGeometry(Map<String, Object> defMap) {
        defMap.put("nonOpaque", true);
        defMap.put("lightOpacity", 0);
        ArrayList cuboids = new ArrayList();
        HashMap<String, Object> cuboid1 = new HashMap<String, Object>();
        cuboid1.put("xMin", 0.3755);
        cuboid1.put("yMin", 0.625);
        cuboid1.put("zMin", 0.3755);
        cuboid1.put("xMax", 0.6245);
        cuboid1.put("yMax", 1.0);
        cuboid1.put("zMax", 0.6245);
        cuboid1.put("sideTextures", new int[]{0, 0, 0, 0, 0, 0});
        cuboids.add(cuboid1);
        HashMap<String, Object> cuboid2 = new HashMap<String, Object>();
        cuboid2.put("xMin", 0.25);
        cuboid2.put("yMin", 0.275);
        cuboid2.put("zMin", 0.25);
        cuboid2.put("xMax", 0.75);
        cuboid2.put("yMax", 0.625);
        cuboid2.put("zMax", 0.75);
        cuboid2.put("sideTextures", new int[]{0, 0, 0, 0, 0, 0});
        cuboids.add(cuboid2);
        HashMap<String, Object> cuboid3 = new HashMap<String, Object>();
        cuboid3.put("xMin", 0.0);
        cuboid3.put("yMin", 0.0);
        cuboid3.put("zMin", 0.0);
        cuboid3.put("xMax", 1.0);
        cuboid3.put("yMax", 0.275);
        cuboid3.put("zMax", 1.0);
        cuboid3.put("sideTextures", new int[]{0, 0, 0, 0, 0, 0});
        cuboids.add(cuboid3);
        defMap.put("cuboids", cuboids);
    }

    private static void addCarpetGeometry(Map<String, Object> defMap) {
        defMap.put("nonOpaque", true);
        defMap.put("lightOpacity", 0);
        ArrayList cuboids = new ArrayList();
        HashMap<String, Object> cuboid = new HashMap<String, Object>();
        cuboid.put("xMin", 0.0);
        cuboid.put("yMin", 0.0);
        cuboid.put("zMin", 0.0);
        cuboid.put("xMax", 1.0);
        cuboid.put("yMax", 0.0625);
        cuboid.put("zMax", 1.0);
        cuboid.put("sideTextures", new int[]{0, 0, 0, 0, 0, 0});
        cuboids.add(cuboid);
        defMap.put("cuboids", cuboids);
    }

    private static void addHalfDoorGeometry(Map<String, Object> defMap) {
        HashMap<String, Double> boundingBox = new HashMap<String, Double>();
        boundingBox.put("xMin", 0.0);
        boundingBox.put("yMin", 0.0);
        boundingBox.put("zMin", 0.0);
        boundingBox.put("xMax", 0.1875);
        boundingBox.put("yMax", 1.0);
        boundingBox.put("zMax", 1.0);
        defMap.put("boundingBox", boundingBox);
    }

    private static void addHollowHopperGeometry(Map<String, Object> defMap) {
        defMap.put("nonOpaque", true);
        defMap.put("lightOpacity", 0);
    }

    private static void addDirectionalGeometry(Map<String, Object> defMap) {
    }

    private static void addPathGeometry(Map<String, Object> defMap) {
        defMap.put("nonOpaque", true);
        defMap.put("lightOpacity", 0);
    }

    private static void addWindowGeometry(Map<String, Object> defMap) {
        defMap.put("nonOpaque", true);
        defMap.put("lightOpacity", 0);
        defMap.put("renderLayer", "cutout");
    }

    private static BlockDefinitionV2 convertMapToBlockDefinition(Map<String, Object> defMap) {
        String json;
        Gson gson = new GsonBuilder().create();
        BlockDefinitionV2 definition = (BlockDefinitionV2)gson.fromJson(json = gson.toJson(defMap), BlockDefinitionV2.class);
        if (definition != null) {
            definition.doInit();
        }
        return definition;
    }

    static {
        VARIANT_TYPES.put("stairs", "stair");
        VARIANT_TYPES.put("hopper", "cuboid");
        VARIANT_TYPES.put("tip", "cuboid");
        VARIANT_TYPES.put("carpet", "cuboid");
        VARIANT_TYPES.put("fence_gate", "fencegate");
        VARIANT_TYPES.put("half_door", "cuboid-nsew");
        VARIANT_TYPES.put("cover", "rail");
        VARIANT_TYPES.put("hollow_hopper", "cuboid");
        VARIANT_TYPES.put("directional", "cuboid-nsew");
        VARIANT_TYPES.put("path", "cuboid");
        VARIANT_TYPES.put("window_frame", "solid");
        VARIANT_TYPES.put("window_frame_mullion", "solid");
        VARIANT_TYPES.put("arrow_slit", "solid");
        VARIANT_TYPES.put("arrow_slit_window", "solid");
        VARIANT_TYPES.put("arrow_slit_ornate", "solid");
        VARIANT_TEXTURES = new HashMap<String, String[]>();
        VARIANT_TEXTURES.put("solid", new String[]{"bottom", "top", "west", "east", "south", "north"});
        VARIANT_TEXTURES.put("stairs", new String[]{"bottom", "top", "sides"});
        VARIANT_TEXTURES.put("slab", new String[]{"bottom", "top", "sides"});
        VARIANT_TEXTURES.put("wall", new String[]{"bottom", "top", "sides"});
        VARIANT_TEXTURES.put("fence", new String[]{"bottom", "top", "sides"});
        VARIANT_TEXTURES.put("hopper", new String[]{"sides"});
        VARIANT_TEXTURES.put("tip", new String[]{"sides"});
        VARIANT_TEXTURES.put("carpet", new String[]{"sides"});
        VARIANT_TEXTURES.put("fence_gate", new String[]{"sides"});
        VARIANT_TEXTURES.put("half_door", new String[]{"sides"});
        VARIANT_TEXTURES.put("cover", new String[]{"cover"});
        VARIANT_TEXTURES.put("hollow_hopper", new String[]{"sides"});
        VARIANT_TEXTURES.put("log", new String[]{"bottom", "top", "sides"});
        VARIANT_TEXTURES.put("directional", new String[]{"bottom", "top", "west", "east", "south", "north"});
        VARIANT_TEXTURES.put("layer", new String[]{"sides"});
        VARIANT_TEXTURES.put("pane", new String[]{"sides", "top"});
        VARIANT_TEXTURES.put("sand", new String[]{"bottom", "top", "west", "east", "south", "north"});
        VARIANT_TEXTURES.put("path", new String[]{"sides"});
        VARIANT_TEXTURES.put("window_frame", new String[]{"window-topbottom", "window-topbottom", "window-frame"});
        VARIANT_TEXTURES.put("window_frame_mullion", new String[]{"window-topbottom", "window-topbottom", "window-frame-mullion"});
        VARIANT_TEXTURES.put("arrow_slit", new String[]{"window-topbottom", "window-topbottom", "arrow-slit"});
        VARIANT_TEXTURES.put("arrow_slit_window", new String[]{"window-topbottom", "window-topbottom", "arrow-slit-window"});
        VARIANT_TEXTURES.put("arrow_slit_ornate", new String[]{"window-topbottom", "window-topbottom", "arrow-slit-ornate"});
        VARIANT_TEXTURES.put("bench", new String[]{"sides"});
    }
}

