/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class BlockStateRecordV2 {
    @SerializedName(value="stateID")
    public String stateID = null;
    @SerializedName(value="boundingBox")
    public BoundingBox boundingBox = null;
    @SerializedName(value="cuboids")
    public List<CuboidElement> cuboids = null;
    @SerializedName(value="collisionBoxes")
    public List<BoundingBox> collisionBoxes = null;
    @SerializedName(value="supportBoxes")
    public List<BoundingBox> supportBoxes = null;
    @SerializedName(value="textures")
    public List<String> textures = null;
    @SerializedName(value="randomTextures")
    public List<RandomTextureSet> randomTextures = null;
    @SerializedName(value="overlayTextures")
    public List<String> overlayTextures = null;
    @SerializedName(value="isCustomModel")
    public Boolean isCustomModel = false;
    @SerializedName(value="rotateRandom")
    public boolean rotateRandom = false;
    @SerializedName(value="lightValue")
    public float lightValue = 0.0f;
    @SerializedName(value="colorMult")
    public String colorMult = "#FFFFFF";
    @SerializedName(value="colorMults")
    public List<String> colorMults = null;
    @SerializedName(value="rotYOffset")
    public int rotYOffset = 0;

    public void doStateRecordInit() {
        if (this.randomTextures == null) {
            if (this.textures == null) {
                this.textures = new ArrayList<String>();
            }
            this.randomTextures = new ArrayList<RandomTextureSet>();
            RandomTextureSet set = new RandomTextureSet();
            set.textures = this.textures;
            set.weight = 1;
            this.randomTextures.add(set);
        }
        if (this.boundingBox != null && (this.cuboids == null || this.cuboids.isEmpty())) {
            CuboidElement c = new CuboidElement();
            c.xMin = this.boundingBox.xMin;
            c.xMax = this.boundingBox.xMax;
            c.yMin = this.boundingBox.yMin;
            c.yMax = this.boundingBox.yMax;
            c.zMin = this.boundingBox.zMin;
            c.zMax = this.boundingBox.zMax;
            this.cuboids = Collections.singletonList(c);
        }
        if (this.cuboids != null && !this.cuboids.isEmpty() && this.boundingBox == null) {
            this.boundingBox = new BoundingBox();
            this.boundingBox.zMin = 1.0f;
            this.boundingBox.yMin = 1.0f;
            this.boundingBox.xMin = 1.0f;
            this.boundingBox.zMax = 0.0f;
            this.boundingBox.yMax = 0.0f;
            this.boundingBox.xMax = 0.0f;
            for (BoundingBox boundingBox : this.cuboids) {
                if (boundingBox.xMin < this.boundingBox.xMin) {
                    this.boundingBox.xMin = boundingBox.xMin;
                }
                if (boundingBox.yMin < this.boundingBox.yMin) {
                    this.boundingBox.yMin = boundingBox.yMin;
                }
                if (boundingBox.zMin < this.boundingBox.zMin) {
                    this.boundingBox.zMin = boundingBox.zMin;
                }
                if (boundingBox.xMax > this.boundingBox.xMax) {
                    this.boundingBox.xMax = boundingBox.xMax;
                }
                if (boundingBox.yMax > this.boundingBox.yMax) {
                    this.boundingBox.yMax = boundingBox.yMax;
                }
                if (!(boundingBox.zMax > this.boundingBox.zMax)) continue;
                this.boundingBox.zMax = boundingBox.zMax;
            }
        }
    }

    public String getTextureByIndex(int idx) {
        RandomTextureSet set = this.getRandomTextureSet(0);
        if (set != null) {
            return set.getTextureByIndex(idx);
        }
        return null;
    }

    public String getOverlayTextureByIndex(int idx) {
        if (this.overlayTextures != null && !this.overlayTextures.isEmpty()) {
            int clampedIdx = Math.min(idx, this.overlayTextures.size() - 1);
            return this.overlayTextures.get(clampedIdx);
        }
        return null;
    }

    public int getRandomTextureSetCount() {
        return this.randomTextures != null ? this.randomTextures.size() : 0;
    }

    public RandomTextureSet getRandomTextureSet(int setnum) {
        if (this.randomTextures != null && !this.randomTextures.isEmpty()) {
            if (setnum >= this.randomTextures.size()) {
                setnum = this.randomTextures.size() - 1;
            }
            return this.randomTextures.get(setnum);
        }
        return null;
    }

    public int getTextureCount() {
        RandomTextureSet set = this.getRandomTextureSet(0);
        if (set != null) {
            return set.getTextureCount();
        }
        return 0;
    }

    public List<CuboidElement> getCuboidList() {
        return this.cuboids != null ? this.cuboids : Collections.emptyList();
    }

    public boolean hasCuboids() {
        return this.cuboids != null && !this.cuboids.isEmpty();
    }

    public List<BoundingBox> getCollisionBoxList() {
        return this.collisionBoxes != null ? this.collisionBoxes : Collections.emptyList();
    }

    public class_265 makeSupportBoxShape(List<BoundingBox> def) {
        List<BoundingBox> boxes;
        class_265 s = class_259.method_1073();
        List<BoundingBox> list = boxes = this.supportBoxes != null ? this.supportBoxes : def;
        if (boxes != null) {
            for (BoundingBox b : boxes) {
                s = class_259.method_1084((class_265)s, (class_265)b.getAABB());
            }
        }
        return s;
    }

    public boolean isTinted() {
        return this.colorMult != null && !this.colorMult.equals("#FFFFFF") || this.colorMults != null;
    }

    public boolean isCustomModel() {
        return Boolean.TRUE.equals(this.isCustomModel);
    }

    public boolean hasOverlayTextures() {
        return this.overlayTextures != null && !this.overlayTextures.isEmpty();
    }

    public String getStateID() {
        return this.stateID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockStateRecordV2)) {
            return false;
        }
        BlockStateRecordV2 other = (BlockStateRecordV2)obj;
        if (this.stateID == null) {
            return other.stateID == null;
        }
        return this.stateID.equals(other.stateID);
    }

    public int hashCode() {
        return this.stateID != null ? this.stateID.hashCode() : 0;
    }

    public String toString() {
        return String.format("BlockStateRecordV2{stateID='%s', textures=%d, cuboids=%d}", this.stateID, this.getTextureCount(), this.getCuboidList().size());
    }

    public static class BoundingBox {
        @SerializedName(value="xMin")
        public float xMin = 0.0f;
        @SerializedName(value="xMax")
        public float xMax = 1.0f;
        @SerializedName(value="yMin")
        public float yMin = 0.0f;
        @SerializedName(value="yMax")
        public float yMax = 1.0f;
        @SerializedName(value="zMin")
        public float zMin = 0.0f;
        @SerializedName(value="zMax")
        public float zMax = 1.0f;
        private transient class_265 aabb = null;

        public BoundingBox() {
        }

        public BoundingBox(float x0, float y0, float z0, float x1, float y1, float z1) {
            this.xMin = x0;
            this.xMax = x1;
            this.yMin = y0;
            this.yMax = y1;
            this.zMin = z0;
            this.zMax = z1;
        }

        public class_265 getAABB() {
            if (this.aabb == null) {
                this.aabb = class_259.method_1081((double)this.xMin, (double)this.yMin, (double)this.zMin, (double)this.xMax, (double)this.yMax, (double)this.zMax);
            }
            return this.aabb;
        }
    }

    public static class RandomTextureSet {
        @SerializedName(value="textures")
        public List<String> textures = null;
        @SerializedName(value="weight")
        public Integer weight = null;

        public int getTextureCount() {
            return this.textures != null ? this.textures.size() : 0;
        }

        public String getTextureByIndex(int idx) {
            if (this.textures == null || this.textures.isEmpty()) {
                return null;
            }
            if (idx >= this.textures.size()) {
                idx = this.textures.size() - 1;
            }
            return this.textures.get(idx);
        }

        public int getWeight() {
            return this.weight != null ? this.weight : 1;
        }

        public String[] getTexturesAsArray() {
            if (this.textures == null || this.textures.isEmpty()) {
                return new String[0];
            }
            return this.textures.toArray(new String[0]);
        }
    }

    public static class CuboidElement
    extends BoundingBox {
        @SerializedName(value="sideTextures")
        public int[] sideTextures = null;
        @SerializedName(value="sideRotations")
        public int[] sideRotations = new int[]{0, 0, 0, 0, 0, 0};
        @SerializedName(value="shape")
        public String shape = "box";
        @SerializedName(value="noTint")
        public boolean[] noTint;

        public CuboidElement() {
        }

        public CuboidElement(float x0, float y0, float z0, float x1, float y1, float z1) {
            super(x0, y0, z0, x1, y1, z1);
        }

        public CuboidElement(float x0, float y0, float z0, float x1, float y1, float z1, int[] sideTextures) {
            super(x0, y0, z0, x1, y1, z1);
            this.sideTextures = sideTextures;
        }

        public CuboidElement(float x0, float y0, float z0, float x1, float y1, float z1, int[] sideTextures, boolean[] noTint) {
            super(x0, y0, z0, x1, y1, z1);
            this.sideTextures = sideTextures;
            this.noTint = noTint;
        }
    }
}

