/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.westerosblocks.data.BlockTagEntry;
import java.util.ArrayList;
import java.util.List;

public class BlockTagsDefinition {
    private final List<BlockTagEntry> tags;

    public BlockTagsDefinition(List<BlockTagEntry> tags) {
        this.tags = tags;
    }

    public List<BlockTagEntry> getTags() {
        return this.tags != null ? this.tags : new ArrayList<BlockTagEntry>();
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public int getTagCount() {
        return this.tags != null ? this.tags.size() : 0;
    }

    public int getTotalBlockCount() {
        if (this.tags == null) {
            return 0;
        }
        return this.tags.stream().mapToInt(entry -> entry.hasBlockNames() ? entry.getBlockNames().size() : 0).sum();
    }
}

