/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockTagEntry;
import com.westerosblocks.data.BlockTagsDefinition;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class BlockTagsLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String blockTagsFilePath;

    public BlockTagsLoader(String blockTagsFilePath) {
        this.blockTagsFilePath = blockTagsFilePath;
    }

    public BlockTagsDefinition loadDefinition() {
        WesterosBlocks.LOGGER.info("Loading block tags from: {}", (Object)this.blockTagsFilePath);
        try {
            BlockTagsDefinition definition = this.loadFromResources();
            if (definition != null && definition.hasTags()) {
                WesterosBlocks.LOGGER.info("Successfully loaded {} block tags with {} total blocks", (Object)definition.getTagCount(), (Object)definition.getTotalBlockCount());
                return definition;
            }
            WesterosBlocks.LOGGER.warn("Block tags file found but contains no entries");
            return null;
        }
        catch (IOException e) {
            WesterosBlocks.LOGGER.error("Failed to read block tags file: {}", (Object)this.blockTagsFilePath, (Object)e);
        }
        catch (JsonSyntaxException e) {
            WesterosBlocks.LOGGER.error("Invalid JSON syntax in block tags file: {}", (Object)this.blockTagsFilePath, (Object)e);
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Unexpected error loading block tags", (Throwable)e);
        }
        return null;
    }

    private BlockTagsDefinition loadFromResources() throws IOException {
        ModContainer container = FabricLoader.getInstance().getModContainer("westerosblocks").orElse(null);
        if (container == null) {
            WesterosBlocks.LOGGER.error("Could not find mod container for {}", (Object)"westerosblocks");
            return null;
        }
        for (Path rootPath : container.getRootPaths()) {
            String pathWithoutSlash;
            Path filePath = rootPath.resolve(pathWithoutSlash = this.blockTagsFilePath.startsWith("/") ? this.blockTagsFilePath.substring(1) : this.blockTagsFilePath);
            if (!Files.exists(filePath, new LinkOption[0]) || !Files.isRegularFile(filePath, new LinkOption[0])) continue;
            WesterosBlocks.LOGGER.debug("Found block tags file at: {}", (Object)filePath);
            String content = Files.readString(filePath);
            BlockTagEntry[] entries = (BlockTagEntry[])GSON.fromJson(content, BlockTagEntry[].class);
            if (entries == null || entries.length <= 0) continue;
            List<BlockTagEntry> tagList = Arrays.asList(entries);
            return new BlockTagsDefinition(tagList);
        }
        WesterosBlocks.LOGGER.warn("Block tags file not found at: {}", (Object)this.blockTagsFilePath);
        return null;
    }

    public void validateDefinition(BlockTagsDefinition definition) {
        if (definition == null || !definition.hasTags()) {
            return;
        }
        for (BlockTagEntry entry : definition.getTags()) {
            if (!entry.hasCustomTag()) {
                WesterosBlocks.LOGGER.warn("Block tag entry has no customTag value");
            }
            if (entry.hasBlockNames()) continue;
            WesterosBlocks.LOGGER.warn("Block tag entry '{}' has no block names", (Object)entry.getCustomTag());
        }
    }
}

