/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.ColorMapDefinition;
import com.westerosblocks.data.ColorMapEntry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class ColorMapLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String colorMapsFilePath;

    public ColorMapLoader(String colorMapsFilePath) {
        this.colorMapsFilePath = colorMapsFilePath;
    }

    public ColorMapDefinition loadDefinition() {
        WesterosBlocks.LOGGER.info("Loading color maps from: {}", (Object)this.colorMapsFilePath);
        try {
            ColorMapDefinition definition = this.loadFromResources();
            if (definition != null && definition.hasColorMaps()) {
                WesterosBlocks.LOGGER.info("Successfully loaded {} color maps with {} total blocks", (Object)definition.getColorMapCount(), (Object)definition.getTotalBlockCount());
                return definition;
            }
            WesterosBlocks.LOGGER.warn("Color maps file found but contains no entries");
            return null;
        }
        catch (IOException e) {
            WesterosBlocks.LOGGER.error("Failed to read color maps file: {}", (Object)this.colorMapsFilePath, (Object)e);
        }
        catch (JsonSyntaxException e) {
            WesterosBlocks.LOGGER.error("Invalid JSON syntax in color maps file: {}", (Object)this.colorMapsFilePath, (Object)e);
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Unexpected error loading color maps", (Throwable)e);
        }
        return null;
    }

    private ColorMapDefinition loadFromResources() throws IOException {
        ModContainer container = FabricLoader.getInstance().getModContainer("westerosblocks").orElse(null);
        if (container == null) {
            WesterosBlocks.LOGGER.error("Could not find mod container for {}", (Object)"westerosblocks");
            return null;
        }
        for (Path rootPath : container.getRootPaths()) {
            String pathWithoutSlash;
            Path filePath = rootPath.resolve(pathWithoutSlash = this.colorMapsFilePath.startsWith("/") ? this.colorMapsFilePath.substring(1) : this.colorMapsFilePath);
            if (!Files.exists(filePath, new LinkOption[0]) || !Files.isRegularFile(filePath, new LinkOption[0])) continue;
            WesterosBlocks.LOGGER.debug("Found color maps file at: {}", (Object)filePath);
            String content = Files.readString(filePath);
            return (ColorMapDefinition)GSON.fromJson(content, ColorMapDefinition.class);
        }
        WesterosBlocks.LOGGER.warn("Color maps file not found at: {}", (Object)this.colorMapsFilePath);
        return null;
    }

    public void validateDefinition(ColorMapDefinition definition) {
        if (definition == null || !definition.hasColorMaps()) {
            return;
        }
        for (ColorMapEntry entry : definition.getColorMaps()) {
            if (!entry.hasColorMult()) {
                WesterosBlocks.LOGGER.warn("Color map entry has no colorMult value");
            }
            if (entry.hasBlockNames()) continue;
            WesterosBlocks.LOGGER.warn("Color map entry for '{}' has no block names", (Object)entry.getColorMult());
        }
    }
}

