/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonElement;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCSolidBlock;
import com.westerosblocks.utils.ModProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public abstract class BaseBlockExporter {
    protected static String getBlockName(class_2248 block) {
        String blockString = block.toString();
        if (blockString.contains(":")) {
            return blockString.split(":")[1].replace("}", "");
        }
        return blockString.toLowerCase().replace("block{", "").replace("}", "");
    }

    protected static class_2960 createNestedModelId(class_2248 block, String variant) {
        String blockName = BaseBlockExporter.getBlockName(block);
        String modelPath = "block/" + blockName + "/" + variant;
        return WesterosBlocks.id(modelPath);
    }

    protected static class_2960 createNestedModelId(class_2248 block) {
        return BaseBlockExporter.createNestedModelId(block, BaseBlockExporter.getBlockName(block));
    }

    protected static class_2960 createBlockIdentifier(String texturePath) {
        if (texturePath == null || texturePath.trim().isEmpty()) {
            throw new IllegalArgumentException("Texture path cannot be null or empty");
        }
        if (texturePath.contains(":")) {
            String namespace = texturePath.substring(0, texturePath.indexOf(58));
            String path = texturePath.substring(texturePath.indexOf(58) + 1);
            return class_2960.method_60655((String)namespace, (String)path);
        }
        return WesterosBlocks.id("block/" + texturePath);
    }

    protected static class_2960 createModelId(class_2248 block, String variant) {
        String blockName = BaseBlockExporter.getBlockName(block);
        String modelPath = variant != null && !variant.isEmpty() ? "block/" + blockName + "/" + variant : "block/" + blockName + "/" + blockName;
        return WesterosBlocks.id(modelPath);
    }

    protected static class_2960 createModelId(class_2248 block) {
        return BaseBlockExporter.createModelId(block, null);
    }

    protected static void validateTexturePaths(String[] texturePaths, int minRequired) {
        if (texturePaths == null || texturePaths.length < minRequired) {
            throw new IllegalArgumentException("At least " + minRequired + " texture path(s) required, got " + (texturePaths == null ? 0 : texturePaths.length));
        }
    }

    protected static String[] fillTextureArray(String[] texturePaths) {
        BaseBlockExporter.validateTexturePaths(texturePaths, 1);
        String[] filledTextures = new String[6];
        for (int i = 0; i < 6; ++i) {
            filledTextures[i] = i < texturePaths.length ? texturePaths[i] : texturePaths[texturePaths.length - 1];
        }
        return filledTextures;
    }

    protected static class_4935 createVariant(class_2960 modelId) {
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId);
    }

    protected static class_4935 createVariant(class_2960 modelId, int rotation) {
        class_4936.class_4937 rotationEnum = switch (rotation) {
            case 0 -> class_4936.class_4937.field_22890;
            case 90 -> class_4936.class_4937.field_22891;
            case 180 -> class_4936.class_4937.field_22892;
            case 270 -> class_4936.class_4937.field_22893;
            default -> throw new IllegalArgumentException("Invalid rotation: " + rotation + ". Must be 0, 90, 180, or 270.");
        };
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId).method_25828(class_4936.field_22886, (Object)rotationEnum);
    }

    protected static class_4925 createSimpleBlockState(class_2248 block, class_2960 modelId) {
        return class_4925.method_25770((class_2248)block, (class_4935)BaseBlockExporter.createVariant(modelId));
    }

    protected static class_4942 createTintedModel(boolean tinted, String modelPath, class_4945 ... textureKeys) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String fullPath = tintPath + modelPath;
        return new class_4942(Optional.of(WesterosBlocks.id(fullPath)), Optional.empty(), textureKeys);
    }

    protected static class_2960 uploadModel(class_4942 model, class_2248 block, String variant, class_4944 textureMap, BiConsumer<class_2960, Supplier<JsonElement>> modelCollector) {
        return model.method_25852(BaseBlockExporter.createNestedModelId(block, variant), textureMap, modelCollector);
    }

    protected static class_4935 createWeightedVariant(class_2960 modelId, int rotation, int weight) {
        class_4935 variant = BaseBlockExporter.createVariant(modelId, rotation);
        if (weight > 1) {
            variant = variant.method_25828(class_4936.field_22889, (Object)weight);
        }
        return variant;
    }

    protected static List<class_4935> createWeightedVariants(List<class_2960> modelIds, List<Integer> weights, int rotation) {
        ArrayList<class_4935> variants = new ArrayList<class_4935>();
        for (int i = 0; i < modelIds.size(); ++i) {
            variants.add(BaseBlockExporter.createWeightedVariant(modelIds.get(i), rotation, weights.get(i)));
        }
        return variants;
    }

    protected static int getRotationForDirection(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> 0;
            case class_2350.field_11034 -> 90;
            case class_2350.field_11035 -> 180;
            case class_2350.field_11039 -> 270;
            default -> throw new IllegalArgumentException("Direction must be horizontal: " + String.valueOf(direction));
        };
    }

    protected static void registerSimpleItemModel(class_4910 generator, class_2248 block, class_2960 textureId) {
        class_4944 itemTextureMap = class_4944.method_25895((class_2960)textureId);
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)block.method_8389()), itemTextureMap, generator.field_22831);
    }

    protected static void registerParentedItemModel(class_4910 generator, class_2248 block, class_2960 modelId) {
        generator.method_25623(block, modelId);
    }

    protected static class BlockStateBuilder {
        private final class_2248 block;
        private final ModProperties.StateProperty stateProperty;
        private final Map<String, List<class_4935>> variants = new HashMap<String, List<class_4935>>();

        public BlockStateBuilder(class_2248 block, ModProperties.StateProperty stateProperty) {
            this.block = block;
            this.stateProperty = stateProperty;
        }

        public void addVariant(String cond, class_4935 variant, String stateID) {
            Object key = stateID == null ? cond : cond + (cond.isEmpty() ? "" : ",") + "state=" + stateID;
            this.variants.computeIfAbsent((String)key, k -> new ArrayList()).add(variant);
        }

        public void register(class_4910 generator) {
            if (this.variants.isEmpty()) {
                return;
            }
            boolean hasSymmetrical = this.variants.keySet().stream().anyMatch(k -> k.contains("symmetrical="));
            boolean hasStates = this.variants.keySet().stream().anyMatch(k -> k.contains("state="));
            if (hasSymmetrical && hasStates) {
                this.registerDoubleProperty(generator);
            } else if (hasStates) {
                this.registerStateProperty(generator);
            } else if (hasSymmetrical) {
                this.registerSymmetricalProperty(generator);
            } else {
                this.registerSimple(generator);
            }
        }

        private void registerDoubleProperty(class_4910 generator) {
            class_4926.class_4928 variantMap = class_4926.method_25784((class_2769)WCSolidBlock.SYMMETRICAL, (class_2769)this.stateProperty);
            for (Map.Entry<String, List<class_4935>> entry : this.variants.entrySet()) {
                String key = entry.getKey();
                List<class_4935> variantList = entry.getValue();
                boolean symmetrical = key.contains("symmetrical=true");
                String stateID = this.extractStateID(key);
                if (variantList.size() == 1) {
                    variantMap.method_25797((Comparable)Boolean.valueOf(symmetrical), (Comparable)((Object)stateID), variantList.get(0));
                    continue;
                }
                variantMap.method_25798((Comparable)Boolean.valueOf(symmetrical), (Comparable)((Object)stateID), variantList);
            }
            generator.field_22830.accept(class_4925.method_25769((class_2248)this.block).method_25775((class_4926)variantMap));
        }

        private void registerStateProperty(class_4910 generator) {
            class_4926.class_4927 variantMap = class_4926.method_25783((class_2769)this.stateProperty);
            for (Map.Entry<String, List<class_4935>> entry : this.variants.entrySet()) {
                String key = entry.getKey();
                List<class_4935> variantList = entry.getValue();
                String stateID = this.extractStateID(key);
                if (variantList.size() == 1) {
                    variantMap.method_25793((Comparable)((Object)stateID), variantList.get(0));
                    continue;
                }
                variantMap.method_25794((Comparable)((Object)stateID), variantList);
            }
            generator.field_22830.accept(class_4925.method_25769((class_2248)this.block).method_25775((class_4926)variantMap));
        }

        private void registerSymmetricalProperty(class_4910 generator) {
            ArrayList symTrue = new ArrayList();
            ArrayList symFalse = new ArrayList();
            for (Map.Entry<String, List<class_4935>> entry : this.variants.entrySet()) {
                boolean isSymmetrical = entry.getKey().contains("symmetrical=true");
                if (isSymmetrical) {
                    symTrue.addAll(entry.getValue());
                    continue;
                }
                symFalse.addAll(entry.getValue());
            }
            class_4926.class_4927 variantMap = class_4926.method_25783((class_2769)WCSolidBlock.SYMMETRICAL).method_25794((Comparable)Boolean.valueOf(true), symTrue).method_25794((Comparable)Boolean.valueOf(false), symFalse);
            generator.field_22830.accept(class_4925.method_25769((class_2248)this.block).method_25775((class_4926)variantMap));
        }

        private void registerSimple(class_4910 generator) {
            ArrayList<class_4935> allVariants = new ArrayList<class_4935>();
            for (List<class_4935> variantList : this.variants.values()) {
                allVariants.addAll(variantList);
            }
            generator.field_22830.accept(class_4925.method_25771((class_2248)this.block, (class_4935[])allVariants.toArray(new class_4935[0])));
        }

        private String extractStateID(String key) {
            int stateIndex = key.indexOf("state=");
            if (stateIndex >= 0) {
                String stateValue = key.substring(stateIndex + 6);
                int commaIndex = stateValue.indexOf(44);
                if (commaIndex >= 0) {
                    stateValue = stateValue.substring(0, commaIndex);
                }
                return stateValue;
            }
            return null;
        }
    }

    protected static class ModelRegistry {
        private final List<class_2960> modelIds = new ArrayList<class_2960>();
        private final List<Integer> weights = new ArrayList<Integer>();

        protected ModelRegistry() {
        }

        public void add(class_2960 modelId, int weight) {
            this.modelIds.add(modelId);
            this.weights.add(weight);
        }

        public List<class_2960> getModelIds() {
            return this.modelIds;
        }

        public List<Integer> getWeights() {
            return this.weights;
        }

        public int size() {
            return this.modelIds.size();
        }
    }
}

