/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCBenchBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class BenchBlockExporter
extends BaseBlockExporter {
    public static void registerCustomBenchBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        List<String> textureList = definition.getTextures();
        String texturePath = textureList != null && !textureList.isEmpty() ? textureList.get(0) : "missingno";
        BenchBlockExporter.registerCustomBenchBlock(generator, block, texturePath, texturePath);
    }

    private static void registerCustomBenchBlock(class_4910 generator, class_2248 block, String texturePath, String particleTexture) {
        String blockName = BenchBlockExporter.getBlockName(block);
        class_4944 textureMap = new class_4944().method_25868(ModTextureKey.BENCH, BenchBlockExporter.createBlockIdentifier(texturePath)).method_25868(class_4945.field_23012, BenchBlockExporter.createBlockIdentifier(particleTexture));
        class_4942 singleParent = new class_4942(Optional.of(WesterosBlocks.id("block/bench/wood_bench_1x1")), Optional.empty(), new class_4945[]{ModTextureKey.BENCH, class_4945.field_23012});
        class_4942 leftParent = new class_4942(Optional.of(WesterosBlocks.id("block/bench/wood_bench_edge")), Optional.empty(), new class_4945[]{ModTextureKey.BENCH, class_4945.field_23012});
        class_4942 rightParent = new class_4942(Optional.of(WesterosBlocks.id("block/bench/wood_bench_right")), Optional.empty(), new class_4945[]{ModTextureKey.BENCH, class_4945.field_23012});
        class_4942 middleParent = new class_4942(Optional.of(WesterosBlocks.id("block/bench/wood_bench_middle")), Optional.empty(), new class_4945[]{ModTextureKey.BENCH, class_4945.field_23012});
        class_2960 singleModelId = singleParent.method_25852(BenchBlockExporter.createNestedModelId(block, "single"), textureMap, generator.field_22831);
        class_2960 leftModelId = leftParent.method_25852(BenchBlockExporter.createNestedModelId(block, "left"), textureMap, generator.field_22831);
        class_2960 rightModelId = rightParent.method_25852(BenchBlockExporter.createNestedModelId(block, "right"), textureMap, generator.field_22831);
        class_2960 middleModelId = middleParent.method_25852(BenchBlockExporter.createNestedModelId(block, "middle"), textureMap, generator.field_22831);
        class_4926.class_4928 variantMap = class_4926.method_25784((class_2769)WCBenchBlock.FACING, WCBenchBlock.CONNECTION);
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            int rotation = BenchBlockExporter.getRotationForFacing(facing);
            variantMap.method_25797((Comparable)facing, (Comparable)((Object)WCBenchBlock.ConnectionType.SINGLE), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)singleModelId).method_25828(class_4936.field_22886, (Object)BenchBlockExporter.getRotationEnum(rotation)));
            variantMap.method_25797((Comparable)facing, (Comparable)((Object)WCBenchBlock.ConnectionType.LEFT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftModelId).method_25828(class_4936.field_22886, (Object)BenchBlockExporter.getRotationEnum(rotation)));
            variantMap.method_25797((Comparable)facing, (Comparable)((Object)WCBenchBlock.ConnectionType.RIGHT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightModelId).method_25828(class_4936.field_22886, (Object)BenchBlockExporter.getRotationEnum(rotation)));
            variantMap.method_25797((Comparable)facing, (Comparable)((Object)WCBenchBlock.ConnectionType.MIDDLE), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)middleModelId).method_25828(class_4936.field_22886, (Object)BenchBlockExporter.getRotationEnum(rotation)));
        }
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variantMap));
        BenchBlockExporter.registerParentedItemModel(generator, block, singleModelId);
    }

    private static int getRotationForFacing(class_2350 facing) {
        return switch (facing) {
            case class_2350.field_11043 -> 180;
            case class_2350.field_11035 -> 0;
            case class_2350.field_11039 -> 90;
            case class_2350.field_11034 -> 270;
            default -> 0;
        };
    }

    private static class_4936.class_4937 getRotationEnum(int degrees) {
        return switch (degrees) {
            case 0 -> class_4936.class_4937.field_22890;
            case 90 -> class_4936.class_4937.field_22891;
            case 180 -> class_4936.class_4937.field_22892;
            case 270 -> class_4936.class_4937.field_22893;
            default -> class_4936.class_4937.field_22890;
        };
    }
}

