/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import com.westerosblocks.utils.ModProperties;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;

public class CropBlockExporter
extends BaseBlockExporter {
    public static void registerCustomCropBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        boolean layerSensitive = definition.isLayerSensitive();
        boolean rotateRandom = definition.hasRotateRandom();
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Crop block definition states should never be null/empty for block: " + CropBlockExporter.getBlockName(block));
        }
        CropBlockExporter.generateBlockState(generator, block, definition, states, layerSensitive, rotateRandom);
        for (BlockDefinitionV2.StateVariantV2 state : states) {
            if (state.isCustomModel()) continue;
            String stateID = state.getStateID();
            String baseName = stateID == null ? "base" : stateID;
            int layerCount = layerSensitive ? 8 : 1;
            for (int layer = 8; layer >= (layerSensitive ? 1 : 8); --layer) {
                Object layerSuffix = layer != 8 ? "_layer" + layer : "";
                String modelName = baseName + (String)layerSuffix;
                for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                    CropBlockExporter.generateCropModel(generator, block, modelName, state, setIdx, tinted, layer, layerSensitive);
                }
            }
        }
        BlockDefinitionV2.StateVariantV2 firstState = states.get(0);
        String firstName = firstState.getStateID() == null ? "base" : firstState.getStateID();
        class_2960 itemModelId = CropBlockExporter.createItemModelId(block, CropBlockExporter.getModelName(firstName, 0));
        CropBlockExporter.registerParentedItemModel(generator, block, itemModelId);
    }

    private static void generateBlockState(class_4910 generator, final class_2248 block, BlockDefinitionV2 definition, final List<BlockDefinitionV2.StateVariantV2> states, final boolean layerSensitive, boolean rotateRandom) {
        final int rotationCount = rotateRandom ? 4 : 1;
        generator.field_22830.accept(new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                String[] stringArray;
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                if (layerSensitive) {
                    String[] stringArray2 = new String[8];
                    stringArray2[0] = "layers=8";
                    stringArray2[1] = "layers=1";
                    stringArray2[2] = "layers=2";
                    stringArray2[3] = "layers=3";
                    stringArray2[4] = "layers=4";
                    stringArray2[5] = "layers=5";
                    stringArray2[6] = "layers=6";
                    stringArray = stringArray2;
                    stringArray2[7] = "layers=7";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "";
                }
                String[] layerConds = stringArray;
                boolean hasStateProperty = CropBlockExporter.hasStateProperty(block);
                for (String layerCond : layerConds) {
                    for (int stateIdx = 0; stateIdx < states.size(); ++stateIdx) {
                        BlockDefinitionV2.StateVariantV2 state = (BlockDefinitionV2.StateVariantV2)states.get(stateIdx);
                        String stateID = state.getStateID();
                        String baseName = stateID == null ? "base" : stateID;
                        Object modelName = baseName;
                        if (layerSensitive && !layerCond.isEmpty() && !layerCond.equals("layers=8")) {
                            int layerNum = Integer.parseInt(layerCond.substring(layerCond.indexOf(61) + 1));
                            modelName = baseName + "_layer" + layerNum;
                        }
                        for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                            BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                            if (set == null || set.getTextureCount() == 0) continue;
                            for (int rot = 0; rot < rotationCount; ++rot) {
                                String variantKey = CropBlockExporter.buildVariantKey(layerCond, stateID, hasStateProperty);
                                class_2960 modelId = state.isCustomModel() ? CropBlockExporter.createCustomModelId(block, CropBlockExporter.getModelName((String)modelName, setIdx)) : CropBlockExporter.createGeneratedModelId(block, CropBlockExporter.getModelName((String)modelName, setIdx));
                                JsonObject variant = new JsonObject();
                                variant.addProperty("model", modelId.toString());
                                if (set.getWeight() > 1) {
                                    variant.addProperty("weight", (Number)set.getWeight());
                                }
                                if (rot > 0) {
                                    variant.addProperty("y", (Number)(90 * rot));
                                }
                                CropBlockExporter.addVariantToKey(variants, variantKey, variant);
                            }
                        }
                    }
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        });
    }

    private static void generateCropModel(class_4910 generator, class_2248 block, String modelName, BlockDefinitionV2.StateVariantV2 state, int setIdx, boolean tinted, int layer, boolean layerSensitive) {
        BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
        if (set == null || set.getTextureCount() == 0) {
            return;
        }
        String fullModelName = CropBlockExporter.getModelName(modelName, setIdx);
        class_2960 modelId = CropBlockExporter.createGeneratedModelId(block, fullModelName);
        String parentBase = tinted ? "westerosblocks:block/tinted/crop" : "westerosblocks:block/untinted/crop";
        String layerSuffix = layerSensitive && layer != 8 ? "_layer" + layer : "";
        String parent = parentBase + layerSuffix;
        JsonObject modelJson = new JsonObject();
        modelJson.addProperty("parent", parent);
        JsonObject texturesJson = new JsonObject();
        texturesJson.addProperty("crop", "westerosblocks:block/" + set.getTextureByIndex(0));
        modelJson.add("textures", (JsonElement)texturesJson);
        generator.field_22831.accept(modelId, () -> modelJson);
    }

    private static String buildVariantKey(String layerCond, String stateID, boolean hasStateProperty) {
        if (layerCond.isEmpty()) {
            if (stateID != null && hasStateProperty) {
                return "state=" + stateID;
            }
            return "";
        }
        if (stateID != null && hasStateProperty) {
            return layerCond + ",state=" + stateID;
        }
        return layerCond;
    }

    private static void addVariantToKey(JsonObject variants, String key, JsonObject variant) {
        if (variants.has(key)) {
            JsonElement existing = variants.get(key);
            if (existing.isJsonArray()) {
                existing.getAsJsonArray().add((JsonElement)variant);
            } else {
                JsonArray array = new JsonArray();
                array.add(existing);
                array.add((JsonElement)variant);
                variants.add(key, (JsonElement)array);
            }
        } else {
            variants.add(key, (JsonElement)variant);
        }
    }

    private static boolean hasStateProperty(class_2248 block) {
        for (class_2769 property : block.method_9595().method_11659()) {
            if (!(property instanceof ModProperties.StateProperty) || !"state".equals(property.method_11899())) continue;
            return true;
        }
        return false;
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = CropBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/custom/" + blockName + "/" + variant);
    }

    private static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = CropBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/" + blockName + "/" + variant);
    }

    private static class_2960 createItemModelId(class_2248 block, String variant) {
        String blockName = CropBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/" + blockName + "/" + variant);
    }

    private static String getModelName(String baseName, int setIdx) {
        return baseName + "_v" + (setIdx + 1);
    }
}

