/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import com.westerosblocks.utils.ModProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class CrossBlockExporter
extends BaseBlockExporter {
    public static void registerCustomCrossBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        boolean isTinted = definition.hasColorMult();
        boolean isLayerSensitive = definition.isLayerSensitive();
        int rotationCount = definition.hasRotateRandom() ? 4 : 1;
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            return;
        }
        CrossBlockExporter.generateBlockState(generator, block, states, isLayerSensitive, rotationCount);
        String firstTexture = CrossBlockExporter.generateModels(generator, block, states, isLayerSensitive, isTinted);
        if (firstTexture != null) {
            class_2960 textureId = CrossBlockExporter.createBlockIdentifier(firstTexture);
            class_4944 itemTextures = new class_4944().method_25868(class_4945.field_23006, textureId);
            class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)block.method_8389()), itemTextures, generator.field_22831);
        }
    }

    private static void generateBlockState(class_4910 generator, class_2248 block, List<BlockDefinitionV2.StateVariantV2> states, boolean isLayerSensitive, int rotationCount) {
        boolean useStateMap;
        int[] nArray;
        if (isLayerSensitive) {
            int[] nArray2 = new int[8];
            nArray2[0] = 8;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray2[5] = 5;
            nArray2[6] = 6;
            nArray = nArray2;
            nArray2[7] = 7;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        int[] layerConds = nArray;
        boolean bl = useStateMap = states.size() > 1 && states.stream().allMatch(s -> s.getStateID() != null) && CrossBlockExporter.hasStateProperty(block);
        if (useStateMap && !isLayerSensitive) {
            ModProperties.StateProperty stateProperty = CrossBlockExporter.getStateProperty(block);
            class_4926.class_4927 stateMap = class_4926.method_25783((class_2769)stateProperty);
            for (BlockDefinitionV2.StateVariantV2 state : states) {
                String stateID = state.getStateID() == null ? "base" : state.getStateID();
                ArrayList<class_4935> variants = new ArrayList<class_4935>();
                for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                    BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                    if (set == null) continue;
                    int weight = set.getWeight();
                    class_2960 modelId = CrossBlockExporter.createNestedModelId(block, CrossBlockExporter.getModelName(stateID, setIdx));
                    for (int rot = 0; rot < rotationCount; ++rot) {
                        class_4935 variant = CrossBlockExporter.createWeightedVariant(modelId, rot * 90, weight);
                        variants.add(variant);
                    }
                }
                stateMap.method_25794((Comparable)((Object)stateID), variants);
            }
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)stateMap));
        } else if (isLayerSensitive) {
            class_4926.class_4927 layerMap = class_4926.method_25783((class_2769)class_2741.field_12536);
            for (int layerIdx = 0; layerIdx < layerConds.length; ++layerIdx) {
                int layerValue = layerConds[layerIdx];
                ArrayList<class_4935> variants = new ArrayList<class_4935>();
                for (BlockDefinitionV2.StateVariantV2 state : states) {
                    Object id;
                    String stateID = state.getStateID();
                    Object object = id = stateID == null ? "base" : stateID;
                    if (layerIdx > 0) {
                        id = (String)id + "_layer" + layerIdx;
                    }
                    for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                        BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                        if (set == null) continue;
                        int weight = set.getWeight();
                        class_2960 modelId = CrossBlockExporter.createNestedModelId(block, CrossBlockExporter.getModelName((String)id, setIdx));
                        for (int rot = 0; rot < rotationCount; ++rot) {
                            class_4935 variant = CrossBlockExporter.createWeightedVariant(modelId, rot * 90, weight);
                            variants.add(variant);
                        }
                    }
                }
                layerMap.method_25794((Comparable)Integer.valueOf(layerValue), variants);
            }
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)layerMap));
        } else {
            ArrayList<class_4935> variants = new ArrayList<class_4935>();
            for (BlockDefinitionV2.StateVariantV2 state : states) {
                String stateID = state.getStateID();
                String id = stateID == null ? "base" : stateID;
                for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                    BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                    if (set == null) continue;
                    int weight = set.getWeight();
                    class_2960 modelId = CrossBlockExporter.createNestedModelId(block, CrossBlockExporter.getModelName(id, setIdx));
                    for (int rot = 0; rot < rotationCount; ++rot) {
                        class_4935 variant = CrossBlockExporter.createWeightedVariant(modelId, rot * 90, weight);
                        variants.add(variant);
                    }
                }
            }
            generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0])));
        }
    }

    private static String generateModels(class_4910 generator, class_2248 block, List<BlockDefinitionV2.StateVariantV2> states, boolean isLayerSensitive, boolean isTinted) {
        int[] nArray;
        String blockName = CrossBlockExporter.getBlockName(block);
        if (isLayerSensitive) {
            int[] nArray2 = new int[8];
            nArray2[0] = 8;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray2[5] = 5;
            nArray2[6] = 6;
            nArray = nArray2;
            nArray2[7] = 7;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        int[] layerConds = nArray;
        String firstTexture = null;
        for (int layerIdx = 0; layerIdx < layerConds.length; ++layerIdx) {
            for (BlockDefinitionV2.StateVariantV2 state : states) {
                Object id;
                if (state.isCustomModel()) continue;
                String stateID = state.getStateID();
                Object object = id = stateID == null ? "base" : stateID;
                if (layerIdx > 0) {
                    id = (String)id + "_layer" + layerIdx;
                }
                for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                    String texturePath;
                    BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                    if (set == null || (texturePath = set.getTextureByIndex(0)) == null) continue;
                    if (firstTexture == null) {
                        firstTexture = texturePath;
                    }
                    Object parentPath = layerIdx > 0 ? (isTinted ? "block/tinted/cross_layer" + layerIdx : "block/untinted/cross_layer" + layerIdx) : (isTinted ? "block/tinted/cross" : "block/untinted/cross");
                    class_2960 modelId = CrossBlockExporter.createNestedModelId(block, CrossBlockExporter.getModelName((String)id, setIdx));
                    class_2960 textureId = CrossBlockExporter.createBlockIdentifier(texturePath);
                    class_4944 textureMap = new class_4944().method_25868(class_4945.field_23025, textureId);
                    class_4942 model = new class_4942(Optional.of(WesterosBlocks.id((String)parentPath)), Optional.empty(), new class_4945[]{class_4945.field_23025});
                    model.method_25852(modelId, textureMap, generator.field_22831);
                }
            }
        }
        return firstTexture;
    }

    private static String getModelName(String id, int setIdx) {
        return id + "_v" + (setIdx + 1);
    }

    private static boolean hasStateProperty(class_2248 block) {
        for (class_2769 property : block.method_9595().method_11659()) {
            if (!property.method_11899().equals("state")) continue;
            return true;
        }
        return false;
    }

    private static ModProperties.StateProperty getStateProperty(class_2248 block) {
        for (class_2769 property : block.method_9595().method_11659()) {
            if (!(property instanceof ModProperties.StateProperty)) continue;
            ModProperties.StateProperty stateProperty = (ModProperties.StateProperty)property;
            return stateProperty;
        }
        return null;
    }
}

