/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.datagen.custom.CuboidBlockExporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;

public class Cuboid16WayBlockExporter
extends CuboidBlockExporter {
    private static final String[] MODEL_SUFFIXES = new String[]{"", "_rotn22", "_rotn45", "_rot22"};
    private static final Float[] MODEL_ROTATIONS = new Float[]{null, Float.valueOf(-22.5f), Float.valueOf(-45.0f), Float.valueOf(22.5f)};

    public static void registerCustomCuboid16WayBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        boolean hasMultipleStates;
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + Cuboid16WayBlockExporter.getBlockName(block));
        }
        boolean bl = hasMultipleStates = definition.getStateCount() > 1;
        if (definition.hasCustomModel() && !hasMultipleStates) {
            Cuboid16WayBlockExporter.registerCustomModelCuboid16WayBlock(generator, block, definition);
            return;
        }
        HashMap<String, Map<String, List<ModelSet16Way>>> stateRotationModelSets = new HashMap<String, Map<String, List<ModelSet16Way>>>();
        class_2960 firstModel = null;
        for (BlockDefinitionV2.StateVariantV2 state : states) {
            String stateId = state.getStateID();
            if (stateId == null) {
                stateId = "base";
            }
            HashMap rotationModelSets = new HashMap();
            int textureSetCount = state.getRandomTextureSetCount();
            if (textureSetCount == 0) {
                if (!state.isCustomModel()) continue;
                textureSetCount = 1;
            }
            for (int rotIdx = 0; rotIdx < MODEL_SUFFIXES.length; ++rotIdx) {
                ArrayList<ModelSet16Way> modelSets = new ArrayList<ModelSet16Way>();
                for (int setIdx = 0; setIdx < textureSetCount; ++setIdx) {
                    class_2960 modelId;
                    String variantName = (hasMultipleStates ? stateId : "base") + MODEL_SUFFIXES[rotIdx] + "_v" + (setIdx + 1);
                    int weight = 1;
                    if (state.isCustomModel()) {
                        modelId = Cuboid16WayBlockExporter.createCustomModelId(block, variantName);
                        set = state.getRandomTextureSet(setIdx);
                        if (set != null) {
                            weight = set.getWeight();
                        }
                    } else {
                        set = state.getRandomTextureSet(setIdx);
                        if (set == null || set.getTextureCount() == 0) continue;
                        String[] textures = new String[set.getTextureCount()];
                        for (int i = 0; i < set.getTextureCount(); ++i) {
                            textures[i] = set.getTextureByIndex(i);
                        }
                        List<String> textureList = Arrays.asList(textures);
                        modelId = CuboidBlockExporter.createCuboidModel(generator, block, definition, textureList, setIdx, variantName, MODEL_ROTATIONS[rotIdx]);
                        weight = set.getWeight();
                    }
                    modelSets.add(new ModelSet16Way(modelId, weight));
                    if (firstModel != null) continue;
                    firstModel = modelId;
                }
                if (modelSets.isEmpty()) continue;
                rotationModelSets.put(MODEL_SUFFIXES[rotIdx], modelSets);
            }
            if (rotationModelSets.isEmpty()) continue;
            stateRotationModelSets.put(stateId, rotationModelSets);
        }
        if (stateRotationModelSets.isEmpty()) {
            Cuboid16WayBlockExporter.registerFallbackCuboid16WayBlock(generator, block, definition);
            return;
        }
        if (hasMultipleStates) {
            generator.field_22830.accept(Cuboid16WayBlockExporter.createCuboid16WayBlockStateWithStates(block, stateRotationModelSets));
        } else {
            Map rotationModelSets = (Map)stateRotationModelSets.values().iterator().next();
            generator.field_22830.accept(Cuboid16WayBlockExporter.createCuboid16WayBlockStateWithRandomTextures(block, rotationModelSets, definition));
        }
        if (firstModel != null) {
            Cuboid16WayBlockExporter.registerParentedItemModel(generator, block, firstModel);
        }
    }

    private static void registerCustomModelCuboid16WayBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        HashMap<String, List<ModelSet16Way>> rotationModelSets = new HashMap<String, List<ModelSet16Way>>();
        for (int i = 0; i < MODEL_SUFFIXES.length; ++i) {
            class_2960 modelId = Cuboid16WayBlockExporter.createCustomModelId(block, "base" + MODEL_SUFFIXES[i] + "_v1");
            rotationModelSets.put(MODEL_SUFFIXES[i], List.of(new ModelSet16Way(modelId, 1)));
        }
        generator.field_22830.accept(Cuboid16WayBlockExporter.createCuboid16WayBlockStateWithRandomTextures(block, rotationModelSets, definition));
        Cuboid16WayBlockExporter.registerParentedItemModel(generator, block, ((ModelSet16Way)((List)rotationModelSets.get((Object)"")).get((int)0)).model);
    }

    private static void registerFallbackCuboid16WayBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        List<String> fallbackTextures = List.of("missing");
        HashMap<String, List<ModelSet16Way>> rotationModelSets = new HashMap<String, List<ModelSet16Way>>();
        for (int i = 0; i < MODEL_SUFFIXES.length; ++i) {
            String modelName = "base" + MODEL_SUFFIXES[i] + "_v1";
            class_2960 modelId = CuboidBlockExporter.createCuboidModel(generator, block, definition, fallbackTextures, 0, modelName, MODEL_ROTATIONS[i]);
            rotationModelSets.put(MODEL_SUFFIXES[i], List.of(new ModelSet16Way(modelId, 1)));
        }
        generator.field_22830.accept(Cuboid16WayBlockExporter.createCuboid16WayBlockStateWithRandomTextures(block, rotationModelSets, definition));
        Cuboid16WayBlockExporter.registerParentedItemModel(generator, block, ((ModelSet16Way)((List)rotationModelSets.get((Object)"")).get((int)0)).model);
    }

    private static class_4917 createCuboid16WayBlockStateWithRandomTextures(final class_2248 block, final Map<String, List<ModelSet16Way>> rotationModelSets, BlockDefinitionV2 definition) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (int rotation = 0; rotation < 16; ++rotation) {
                    String variantKey = "rotation=" + rotation;
                    int modelIndex = rotation % 4;
                    List modelSets = (List)rotationModelSets.get(MODEL_SUFFIXES[modelIndex]);
                    int yRotation = 90 * (rotation / 4) % 360;
                    if (modelSets.size() == 1) {
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", ((ModelSet16Way)modelSets.get((int)0)).model.toString());
                        if (yRotation > 0) {
                            variant.addProperty("y", (Number)yRotation);
                        }
                        variants.add(variantKey, (JsonElement)variant);
                        continue;
                    }
                    JsonArray variantArray = new JsonArray();
                    for (ModelSet16Way modelSet : modelSets) {
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", modelSet.model.toString());
                        if (yRotation > 0) {
                            variant.addProperty("y", (Number)yRotation);
                        }
                        if (modelSet.weight > 1) {
                            variant.addProperty("weight", (Number)modelSet.weight);
                        }
                        variantArray.add((JsonElement)variant);
                    }
                    variants.add(variantKey, (JsonElement)variantArray);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createCuboid16WayBlockStateWithStates(final class_2248 block, final Map<String, Map<String, List<ModelSet16Way>>> stateRotationModelSets) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (Map.Entry stateEntry : stateRotationModelSets.entrySet()) {
                    String stateId = (String)stateEntry.getKey();
                    Map rotationModelSets = (Map)stateEntry.getValue();
                    for (int rotation = 0; rotation < 16; ++rotation) {
                        String variantKey = "rotation=" + rotation + ",state=" + stateId;
                        int modelIndex = rotation % 4;
                        List modelSets = (List)rotationModelSets.get(MODEL_SUFFIXES[modelIndex]);
                        int yRotation = 90 * (rotation / 4) % 360;
                        if (modelSets == null || modelSets.isEmpty()) continue;
                        if (modelSets.size() == 1) {
                            JsonObject variant = new JsonObject();
                            variant.addProperty("model", ((ModelSet16Way)modelSets.get((int)0)).model.toString());
                            if (yRotation > 0) {
                                variant.addProperty("y", (Number)yRotation);
                            }
                            variants.add(variantKey, (JsonElement)variant);
                            continue;
                        }
                        JsonArray variantArray = new JsonArray();
                        for (ModelSet16Way modelSet : modelSets) {
                            JsonObject variant = new JsonObject();
                            variant.addProperty("model", modelSet.model.toString());
                            if (yRotation > 0) {
                                variant.addProperty("y", (Number)yRotation);
                            }
                            if (modelSet.weight > 1) {
                                variant.addProperty("weight", (Number)modelSet.weight);
                            }
                            variantArray.add((JsonElement)variant);
                        }
                        variants.add(variantKey, (JsonElement)variantArray);
                    }
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class ModelSet16Way {
        final class_2960 model;
        final int weight;

        ModelSet16Way(class_2960 model, int weight) {
            this.model = model;
            this.weight = weight;
        }
    }
}

