/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import com.westerosblocks.utils.ModProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class CuboidBlockExporter
extends BaseBlockExporter {
    private static final int[] STANDARD_TEXTURE_INDICES = new int[]{0, 1, 2, 3, 4, 5};
    private static final boolean[] NO_TINT_ALL = new boolean[]{false, false, false, false, false, false};

    public static void registerCustomCuboidBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        boolean hasMultipleStates;
        boolean isTinted = definition.isTinted();
        int rotationCount = definition.hasRotateRandom() ? 4 : 1;
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        boolean bl = hasMultipleStates = definition.getStateCount() > 1;
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + CuboidBlockExporter.getBlockName(block));
        }
        CuboidBlockExporter.generateBlockState(generator, block, definition, states, hasMultipleStates, rotationCount);
        class_2960 firstModel = CuboidBlockExporter.generateModels(generator, block, definition, states, hasMultipleStates, isTinted, rotationCount);
        if (firstModel != null) {
            CuboidBlockExporter.registerParentedItemModel(generator, block, firstModel);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void generateBlockState(class_4910 generator, class_2248 block, BlockDefinitionV2 definition, List<BlockDefinitionV2.StateVariantV2> states, boolean hasMultipleStates, int rotationCount) {
        class_2960 modelId;
        HashMap<Object, List<Object>> stateModelIds = new HashMap<Object, List<Object>>();
        for (BlockDefinitionV2.StateVariantV2 state : states) {
            Object stateId = state.getStateID();
            if (stateId == null) {
                stateId = "base";
            }
            ArrayList<class_2960> arrayList = new ArrayList<class_2960>();
            int textureSetCount = state.getRandomTextureSetCount();
            if (textureSetCount == 0) {
                if (!state.isCustomModel()) continue;
                textureSetCount = 1;
            }
            for (int setIdx = 0; setIdx < textureSetCount; ++setIdx) {
                Object statePrefix = hasMultipleStates ? stateId : "base";
                String variantName = CuboidBlockExporter.getModelName((String)statePrefix, setIdx);
                modelId = state.isCustomModel() ? CuboidBlockExporter.createCustomModelId(block, variantName) : CuboidBlockExporter.createNestedModelId(block, variantName);
                arrayList.add(modelId);
            }
            if (arrayList.isEmpty()) continue;
            stateModelIds.put(stateId, arrayList);
        }
        if (stateModelIds.isEmpty()) {
            String variantName = CuboidBlockExporter.getModelName("base", 0);
            class_2960 modelId2 = CuboidBlockExporter.createNestedModelId(block, variantName);
            stateModelIds.put("base", List.of(modelId2));
        }
        if (hasMultipleStates && CuboidBlockExporter.hasStateProperty(block)) {
            ModProperties.StateProperty stateProperty = CuboidBlockExporter.getStateProperty(block);
            class_4926.class_4927 stateMap = class_4926.method_25783((class_2769)stateProperty);
            for (Map.Entry entry : stateModelIds.entrySet()) {
                String stateId = (String)entry.getKey();
                List modelIds = (List)entry.getValue();
                ArrayList<class_4935> variants = new ArrayList<class_4935>();
                for (int i = 0; i < modelIds.size(); ++i) {
                    BlockStateRecordV2.RandomTextureSet rtv;
                    modelId = (class_2960)modelIds.get(i);
                    BlockDefinitionV2.StateVariantV2 state = CuboidBlockExporter.findStateById(states, stateId);
                    int weight = 1;
                    if (state != null && i < state.getRandomTextureSetCount() && (rtv = state.getRandomTextureSet(i)) != null) {
                        weight = rtv.getWeight();
                    }
                    for (int rot = 0; rot < rotationCount; ++rot) {
                        class_4935 variant = CuboidBlockExporter.createWeightedVariant(modelId, rot * 90, weight);
                        variants.add(variant);
                    }
                }
                stateMap.method_25794((Comparable)((Object)stateId), variants);
            }
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)stateMap));
        } else {
            void var10_14;
            List modelIds = (List)stateModelIds.values().iterator().next();
            ArrayList<class_4935> variants = new ArrayList<class_4935>();
            BlockDefinitionV2.StateVariantV2 state = states.get(0);
            boolean bl = false;
            while (var10_14 < modelIds.size()) {
                BlockStateRecordV2.RandomTextureSet rtv;
                class_2960 modelId3 = (class_2960)modelIds.get((int)var10_14);
                int weight = 1;
                if (var10_14 < state.getRandomTextureSetCount() && (rtv = state.getRandomTextureSet((int)var10_14)) != null) {
                    weight = rtv.getWeight();
                }
                for (int rot = 0; rot < rotationCount; ++rot) {
                    class_4935 variant = CuboidBlockExporter.createWeightedVariant(modelId3, rot * 90, weight);
                    variants.add(variant);
                }
                ++var10_14;
            }
            generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0])));
        }
    }

    private static class_2960 generateModels(class_4910 generator, class_2248 block, BlockDefinitionV2 definition, List<BlockDefinitionV2.StateVariantV2> states, boolean hasMultipleStates, boolean isTinted, int rotationCount) {
        class_2960 firstModel = null;
        for (BlockDefinitionV2.StateVariantV2 state : states) {
            String statePrefix;
            String stateId;
            if (state.isCustomModel()) {
                stateId = state.getStateID() != null ? state.getStateID() : "base";
                String string = statePrefix = hasMultipleStates ? stateId : "base";
                if (firstModel != null) continue;
                firstModel = CuboidBlockExporter.createCustomModelId(block, CuboidBlockExporter.getModelName(statePrefix, 0));
                continue;
            }
            stateId = state.getStateID();
            if (stateId == null) {
                stateId = "base";
            }
            statePrefix = hasMultipleStates ? stateId : "base";
            for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                class_2960 modelId;
                BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                if (set == null || set.getTextureCount() == 0) continue;
                String[] textures = new String[set.getTextureCount()];
                for (int i = 0; i < set.getTextureCount(); ++i) {
                    textures[i] = set.getTextureByIndex(i);
                }
                List<String> textureList = Arrays.asList(textures);
                String variantName = CuboidBlockExporter.getModelName(statePrefix, setIdx);
                if (CuboidBlockExporter.hasCuboids(definition) || state.hasCuboids()) {
                    Float rotation = null;
                    if (state.rotYOffset != 0) {
                        rotation = Float.valueOf(state.rotYOffset);
                    }
                    modelId = CuboidBlockExporter.createCuboidModel(generator, block, definition, textureList, setIdx, variantName, rotation);
                } else {
                    class_4944 textureMap = CuboidBlockExporter.createCuboidTextureMap(textureList);
                    modelId = textureList.size() == 1 ? class_4943.field_22972.method_25852(CuboidBlockExporter.createGeneratedModelId(block, variantName), textureMap, generator.field_22831) : class_4943.field_22942.method_25852(CuboidBlockExporter.createGeneratedModelId(block, variantName), textureMap, generator.field_22831);
                }
                if (firstModel != null) continue;
                firstModel = modelId;
            }
        }
        return firstModel;
    }

    protected Map<String, List<class_2960>> generateModelsReturnMap(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        boolean isTinted = definition.isTinted();
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        boolean hasMultipleStates = definition.getStateCount() > 1;
        HashMap<String, List<class_2960>> stateModelMap = new HashMap<String, List<class_2960>>();
        for (BlockDefinitionV2.StateVariantV2 state : states) {
            String stateId = state.getStateID();
            if (stateId == null) {
                stateId = "base";
            }
            String statePrefix = hasMultipleStates ? stateId : "base";
            ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
            int textureSetCount = state.getRandomTextureSetCount();
            if (textureSetCount == 0) {
                if (!state.isCustomModel()) continue;
                textureSetCount = 1;
            }
            for (int setIdx = 0; setIdx < textureSetCount; ++setIdx) {
                class_2960 modelId;
                String variantName = CuboidBlockExporter.getModelName(statePrefix, setIdx);
                if (state.isCustomModel()) {
                    modelId = CuboidBlockExporter.createCustomModelId(block, variantName);
                } else {
                    BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                    if (set == null || set.getTextureCount() == 0) continue;
                    String[] textures = new String[set.getTextureCount()];
                    for (int i = 0; i < set.getTextureCount(); ++i) {
                        textures[i] = set.getTextureByIndex(i);
                    }
                    List<String> textureList = Arrays.asList(textures);
                    if (CuboidBlockExporter.hasCuboids(definition) || state.hasCuboids()) {
                        Float rotation = null;
                        if (state.rotYOffset != 0) {
                            rotation = Float.valueOf(state.rotYOffset);
                        }
                        modelId = CuboidBlockExporter.createCuboidModel(generator, block, definition, textureList, setIdx, variantName, rotation);
                    } else {
                        class_4944 textureMap = CuboidBlockExporter.createCuboidTextureMap(textureList);
                        modelId = textureList.size() == 1 ? class_4943.field_22972.method_25852(CuboidBlockExporter.createGeneratedModelId(block, variantName), textureMap, generator.field_22831) : class_4943.field_22942.method_25852(CuboidBlockExporter.createGeneratedModelId(block, variantName), textureMap, generator.field_22831);
                    }
                }
                modelIds.add(modelId);
            }
            if (modelIds.isEmpty()) continue;
            stateModelMap.put(stateId, modelIds);
        }
        return stateModelMap;
    }

    private static String getModelName(String stateId, int setIdx) {
        return stateId + "_v" + (setIdx + 1);
    }

    private static BlockDefinitionV2.StateVariantV2 findStateById(List<BlockDefinitionV2.StateVariantV2> states, String stateId) {
        for (BlockDefinitionV2.StateVariantV2 state : states) {
            if (!stateId.equals(state.getStateID())) continue;
            return state;
        }
        return null;
    }

    private static boolean hasStateProperty(class_2248 block) {
        for (class_2769 property : block.method_9595().method_11659()) {
            if (!property.method_11899().equals("state")) continue;
            return true;
        }
        return false;
    }

    private static ModProperties.StateProperty getStateProperty(class_2248 block) {
        for (class_2769 property : block.method_9595().method_11659()) {
            if (!(property instanceof ModProperties.StateProperty)) continue;
            ModProperties.StateProperty stateProperty = (ModProperties.StateProperty)property;
            return stateProperty;
        }
        return null;
    }

    static class_2960 createCuboidModel(class_4910 generator, class_2248 block, BlockDefinitionV2 definition, List<String> textures, int stateIndex, String variant) {
        return CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, stateIndex, variant, null);
    }

    static class_2960 createCuboidModel(class_4910 generator, class_2248 block, BlockDefinitionV2 definition, List<String> textures, int stateIndex, String variant, Float rotation) {
        class_4944 textureMap = CuboidBlockExporter.createCustomCuboidTextureMap(textures);
        class_2960 modelId = CuboidBlockExporter.createGeneratedModelId(block, variant);
        class_4942 cuboidModel = CuboidBlockExporter.createCuboidModelFromDefinition(definition, textures, stateIndex, rotation);
        cuboidModel.method_25852(modelId, textureMap, generator.field_22831);
        return modelId;
    }

    public static class_2960 createNestedModelId(class_2248 block, String variant) {
        return CuboidBlockExporter.createGeneratedModelId(block, variant);
    }

    public static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = CuboidBlockExporter.getBlockName(block);
        String modelPath = "block/" + blockName + "/" + variant;
        return WesterosBlocks.id(modelPath);
    }

    public static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = CuboidBlockExporter.getBlockName(block);
        String modelPath = "block/custom/" + blockName + "/" + variant;
        return WesterosBlocks.id(modelPath);
    }

    private static class_4942 createCuboidModelFromDefinition(final BlockDefinitionV2 definition, List<String> textures, int stateIndex, final Float rotation) {
        int requiredTextures = Math.max(6, textures.size());
        ArrayList<class_4945> textureKeys = new ArrayList<class_4945>();
        textureKeys.add(class_4945.field_23012);
        for (int i = 0; i < requiredTextures; ++i) {
            textureKeys.add(ModTextureKey.getTextureNKey(i));
        }
        return new class_4942(Optional.empty(), Optional.empty(), textureKeys.toArray(new class_4945[0])){

            public JsonObject method_48524(class_2960 id, Map<class_4945, class_2960> textures) {
                JsonObject json = super.method_48524(id, textures);
                json.addProperty("parent", "block/block");
                JsonArray elements = new JsonArray();
                List<BlockDefinitionV2.CuboidElement> cuboids = definition.getCuboids();
                if (cuboids != null && !cuboids.isEmpty()) {
                    for (BlockDefinitionV2.CuboidElement cuboid : cuboids) {
                        if ("crossed".equals(cuboid.getShape())) {
                            json.addProperty("ambientocclusion", Boolean.valueOf(false));
                            JsonObject element1 = CuboidBlockExporter.createCrossedElement(cuboid, true, definition.isTinted());
                            if (rotation != null) {
                                CuboidBlockExporter.addRotation(element1, rotation.floatValue());
                            }
                            elements.add((JsonElement)element1);
                            JsonObject element2 = CuboidBlockExporter.createCrossedElement(cuboid, false, definition.isTinted());
                            if (rotation != null) {
                                CuboidBlockExporter.addRotation(element2, rotation.floatValue());
                            }
                            elements.add((JsonElement)element2);
                            continue;
                        }
                        JsonObject element = new JsonObject();
                        CuboidBlockExporter.addCuboidElement(element, cuboid, definition.isTinted());
                        if (rotation != null) {
                            CuboidBlockExporter.addRotation(element, rotation.floatValue());
                        }
                        elements.add((JsonElement)element);
                    }
                } else if (definition.boundingBox != null) {
                    BlockDefinitionV2.BoundingBox bbox = definition.boundingBox;
                    JsonObject element = new JsonObject();
                    CuboidBlockExporter.addBoundingBoxElement(element, bbox, definition.isTinted());
                    if (rotation != null) {
                        CuboidBlockExporter.addRotation(element, rotation.floatValue());
                    }
                    elements.add((JsonElement)element);
                }
                json.add("elements", (JsonElement)elements);
                return json;
            }
        };
    }

    private static void addRotation(JsonObject element, float angle) {
        JsonObject rotation = new JsonObject();
        JsonArray origin = new JsonArray();
        origin.add((Number)8.0);
        origin.add((Number)8.0);
        origin.add((Number)8.0);
        rotation.add("origin", (JsonElement)origin);
        rotation.addProperty("axis", "y");
        rotation.addProperty("angle", (Number)Float.valueOf(angle));
        rotation.addProperty("rescale", Boolean.valueOf(false));
        element.add("rotation", (JsonElement)rotation);
    }

    private static JsonObject createCrossedElement(BlockDefinitionV2.CuboidElement cuboid, boolean firstDiagonal, boolean isTinted) {
        JsonObject element = new JsonObject();
        JsonArray from = new JsonArray();
        if (firstDiagonal) {
            from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMin())));
            from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMin())));
            from.add((Number)8.0);
        } else {
            from.add((Number)8.0);
            from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMin())));
            from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMin())));
        }
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        if (firstDiagonal) {
            to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMax())));
            to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMax())));
            to.add((Number)8.0);
        } else {
            to.add((Number)8.0);
            to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMax())));
            to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMax())));
        }
        element.add("to", (JsonElement)to);
        element.addProperty("shade", Boolean.valueOf(false));
        JsonObject faces = new JsonObject();
        if (firstDiagonal) {
            CuboidBlockExporter.addCrossedFace(faces, "north", isTinted);
            CuboidBlockExporter.addCrossedFace(faces, "south", isTinted);
        } else {
            CuboidBlockExporter.addCrossedFace(faces, "east", isTinted);
            CuboidBlockExporter.addCrossedFace(faces, "west", isTinted);
        }
        element.add("faces", (JsonElement)faces);
        return element;
    }

    private static void addCrossedFace(JsonObject faces, String direction, boolean isTinted) {
        JsonObject face = new JsonObject();
        JsonArray uv = new JsonArray();
        uv.add((Number)0.0);
        uv.add((Number)0.0);
        uv.add((Number)16.0);
        uv.add((Number)16.0);
        face.add("uv", (JsonElement)uv);
        face.addProperty("texture", "#txt0");
        if (isTinted) {
            face.addProperty("tintindex", (Number)0);
        }
        faces.add(direction, (JsonElement)face);
    }

    private static void addCuboidElement(JsonObject element, BlockDefinitionV2.CuboidElement cuboid, boolean isTinted) {
        JsonArray from = new JsonArray();
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMin())));
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMin())));
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMin())));
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMax())));
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMax())));
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMax())));
        element.add("to", (JsonElement)to);
        JsonObject faces = new JsonObject();
        CuboidBlockExporter.addCuboidFaces(faces, cuboid, isTinted);
        element.add("faces", (JsonElement)faces);
    }

    private static void addBoundingBoxElement(JsonObject element, BlockDefinitionV2.BoundingBox bbox, boolean isTinted) {
        JsonArray from = new JsonArray();
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMin())));
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getYMin())));
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMin())));
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMax())));
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getYMax())));
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMax())));
        element.add("to", (JsonElement)to);
        JsonObject faces = new JsonObject();
        CuboidBlockExporter.addBoundingBoxFaces(faces, bbox, isTinted);
        element.add("faces", (JsonElement)faces);
    }

    private static void addCuboidFaces(JsonObject faces, BlockDefinitionV2.CuboidElement cuboid, boolean isTinted) {
        int[] nArray;
        boolean[] noTint;
        int[] sidetxt = cuboid.getSideTextures() != null ? cuboid.getSideTextures() : STANDARD_TEXTURE_INDICES;
        boolean[] blArray = noTint = cuboid.getNoTint() != null ? cuboid.getNoTint() : NO_TINT_ALL;
        if (cuboid.getSideRotations() != null) {
            nArray = cuboid.getSideRotations();
        } else {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray2[4] = 0;
            nArray = nArray2;
            nArray2[5] = 0;
        }
        int[] siderot = nArray;
        CuboidBlockExporter.addFace(faces, "down", 0, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addFace(faces, "up", 1, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addFace(faces, "north", 2, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addFace(faces, "south", 3, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addFace(faces, "west", 4, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addFace(faces, "east", 5, cuboid, sidetxt, noTint, siderot, isTinted);
    }

    private static void addBoundingBoxFaces(JsonObject faces, BlockDefinitionV2.BoundingBox bbox, boolean isTinted) {
        int[] sidetxt = STANDARD_TEXTURE_INDICES;
        boolean[] noTint = NO_TINT_ALL;
        int[] siderot = new int[]{0, 0, 0, 0, 0, 0};
        CuboidBlockExporter.addBoundingBoxFace(faces, "down", 0, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addBoundingBoxFace(faces, "up", 1, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addBoundingBoxFace(faces, "north", 2, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addBoundingBoxFace(faces, "south", 3, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addBoundingBoxFace(faces, "west", 4, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addBoundingBoxFace(faces, "east", 5, bbox, sidetxt, noTint, siderot, isTinted);
    }

    private static void addFace(JsonObject faces, String face, int index, BlockDefinitionV2.CuboidElement cuboid, int[] sidetxt, boolean[] noTint, int[] siderot, boolean isTinted) {
        String cullface;
        JsonObject faceObj = new JsonObject();
        JsonArray uv = new JsonArray();
        CuboidBlockExporter.calculateUVs(face, cuboid, uv);
        faceObj.add("uv", (JsonElement)uv);
        faceObj.addProperty("texture", "#txt" + sidetxt[index]);
        if (siderot[index] != 0) {
            faceObj.addProperty("rotation", (Number)siderot[index]);
        }
        if (isTinted && !noTint[index]) {
            faceObj.addProperty("tintindex", (Number)0);
        }
        if ((cullface = CuboidBlockExporter.getCullface(face, cuboid)) != null) {
            faceObj.addProperty("cullface", cullface);
        }
        faces.add(face, (JsonElement)faceObj);
    }

    private static void addBoundingBoxFace(JsonObject faces, String face, int index, BlockDefinitionV2.BoundingBox bbox, int[] sidetxt, boolean[] noTint, int[] siderot, boolean isTinted) {
        String cullface;
        JsonObject faceObj = new JsonObject();
        JsonArray uv = new JsonArray();
        CuboidBlockExporter.calculateBoundingBoxUVs(face, bbox, uv);
        faceObj.add("uv", (JsonElement)uv);
        faceObj.addProperty("texture", "#txt" + sidetxt[index]);
        if (siderot[index] != 0) {
            faceObj.addProperty("rotation", (Number)siderot[index]);
        }
        if (isTinted && !noTint[index]) {
            faceObj.addProperty("tintindex", (Number)0);
        }
        if ((cullface = CuboidBlockExporter.getBoundingBoxCullface(face, bbox)) != null) {
            faceObj.addProperty("cullface", cullface);
        }
        faces.add(face, (JsonElement)faceObj);
    }

    private static void calculateUVs(String face, BlockDefinitionV2.CuboidElement cuboid, JsonArray uv) {
        switch (face) {
            case "down": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getZMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getZMin())));
                break;
            }
            case "up": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMin())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMax())));
                break;
            }
            case "north": {
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMin())));
                break;
            }
            case "south": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMin())));
                break;
            }
            case "west": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMin())));
                break;
            }
            case "east": {
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMin())));
            }
        }
    }

    private static float getClamped(double v) {
        float f = (float)(16.0 * v);
        if (f < -16.0f) {
            f = -16.0f;
        }
        if (f > 32.0f) {
            f = 32.0f;
        }
        return f;
    }

    private static String getCullface(String face, BlockDefinitionV2.CuboidElement cuboid) {
        return switch (face) {
            case "down" -> {
                if (cuboid.getYMin() <= 0.0) {
                    yield "down";
                }
                yield null;
            }
            case "up" -> {
                if (cuboid.getYMax() >= 1.0) {
                    yield "up";
                }
                yield null;
            }
            case "north" -> {
                if (cuboid.getZMin() <= 0.0) {
                    yield "north";
                }
                yield null;
            }
            case "south" -> {
                if (cuboid.getZMax() >= 1.0) {
                    yield "south";
                }
                yield null;
            }
            case "west" -> {
                if (cuboid.getXMin() <= 0.0) {
                    yield "west";
                }
                yield null;
            }
            case "east" -> {
                if (cuboid.getXMax() >= 1.0) {
                    yield "east";
                }
                yield null;
            }
            default -> null;
        };
    }

    private static void calculateBoundingBoxUVs(String face, BlockDefinitionV2.BoundingBox bbox, JsonArray uv) {
        switch (face) {
            case "down": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getZMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getZMin())));
                break;
            }
            case "up": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMin())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMax())));
                break;
            }
            case "north": {
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMin())));
                break;
            }
            case "south": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMin())));
                break;
            }
            case "west": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMin())));
                break;
            }
            case "east": {
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMin())));
            }
        }
    }

    private static String getBoundingBoxCullface(String face, BlockDefinitionV2.BoundingBox bbox) {
        return switch (face) {
            case "down" -> {
                if (bbox.getYMin() <= 0.0) {
                    yield "down";
                }
                yield null;
            }
            case "up" -> {
                if (bbox.getYMax() >= 1.0) {
                    yield "up";
                }
                yield null;
            }
            case "north" -> {
                if (bbox.getZMin() <= 0.0) {
                    yield "north";
                }
                yield null;
            }
            case "south" -> {
                if (bbox.getZMax() >= 1.0) {
                    yield "south";
                }
                yield null;
            }
            case "west" -> {
                if (bbox.getXMin() <= 0.0) {
                    yield "west";
                }
                yield null;
            }
            case "east" -> {
                if (bbox.getXMax() >= 1.0) {
                    yield "east";
                }
                yield null;
            }
            default -> null;
        };
    }

    public static class_4944 createCuboidTextureMap(List<String> textures) {
        class_4944 textureMap = new class_4944();
        if (textures == null || textures.isEmpty()) {
            String fallbackTexture = "missing";
            class_2960 fallbackId = CuboidBlockExporter.createBlockIdentifier(fallbackTexture);
            textureMap.method_25868(class_4945.field_23024, fallbackId);
            textureMap.method_25868(class_4945.field_23023, fallbackId);
            textureMap.method_25868(class_4945.field_23019, fallbackId);
            textureMap.method_25868(class_4945.field_23020, fallbackId);
            textureMap.method_25868(class_4945.field_23022, fallbackId);
            textureMap.method_25868(class_4945.field_23021, fallbackId);
            textureMap.method_25868(class_4945.field_23012, fallbackId);
            textureMap.method_25868(class_4945.field_23010, fallbackId);
            return textureMap;
        }
        int textureCount = textures.size();
        if (textureCount == 1) {
            class_2960 textureId = CuboidBlockExporter.createBlockIdentifier(textures.get(0));
            textureMap.method_25868(class_4945.field_23010, textureId);
            textureMap.method_25868(class_4945.field_23012, textureId);
        }
        class_4945[] faceKeys = new class_4945[]{class_4945.field_23024, class_4945.field_23023, class_4945.field_23019, class_4945.field_23020, class_4945.field_23022, class_4945.field_23021};
        for (int i = 0; i < 6; ++i) {
            String texture = i < textureCount ? textures.get(i) : textures.get(textureCount - 1);
            textureMap.method_25868(faceKeys[i], CuboidBlockExporter.createBlockIdentifier(texture));
        }
        textureMap.method_25868(class_4945.field_23012, CuboidBlockExporter.createBlockIdentifier(textures.get(0)));
        return textureMap;
    }

    private static class_4944 createCustomCuboidTextureMap(List<String> textures) {
        class_4944 textureMap = new class_4944();
        int textureCount = textures.size();
        int requiredTextures = Math.max(6, textureCount);
        for (int i = 0; i < requiredTextures; ++i) {
            String texture = i < textureCount ? textures.get(i) : textures.get(textureCount - 1);
            textureMap.method_25868(ModTextureKey.getTextureNKey(i), CuboidBlockExporter.createBlockIdentifier(texture));
        }
        textureMap.method_25868(class_4945.field_23012, CuboidBlockExporter.createBlockIdentifier(textures.get(0)));
        return textureMap;
    }

    public static boolean hasCuboids(BlockDefinitionV2 definition) {
        return definition.getCuboids() != null && !definition.getCuboids().isEmpty() || definition.boundingBox != null;
    }
}

